package android.support.v4.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import defpackage.d;
import defpackage.d4;
import defpackage.e;
import defpackage.j;
import defpackage.kc;
import defpackage.t6;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/* loaded from: classes.dex */
public final class MediaBrowserCompat {
    public static final boolean b = Log.isLoggable("MediaBrowserCompat", 3);
    public final e a;

    /* loaded from: classes.dex */
    public static class CustomActionResultReceiver extends ResultReceiver {
        public final String e;
        public final Bundle f;
        public final c g;

        @Override // android.support.v4.os.ResultReceiver
        public void a(int i, Bundle bundle) {
            if (this.g == null) {
                return;
            }
            MediaSessionCompat.a(bundle);
            if (i == -1) {
                this.g.a(this.e, this.f, bundle);
                return;
            }
            if (i == 0) {
                this.g.c(this.e, this.f, bundle);
                return;
            }
            if (i != 1) {
                Log.w("MediaBrowserCompat", "Unknown result code: " + i + " (extras=" + this.f + ", resultData=" + bundle + ")");
                return;
            }
            this.g.b(this.e, this.f, bundle);
        }
    }

    /* loaded from: classes.dex */
    public static class ItemReceiver extends ResultReceiver {
        public final String e;
        public final d f;

        @Override // android.support.v4.os.ResultReceiver
        public void a(int i, Bundle bundle) {
            MediaSessionCompat.a(bundle);
            if (i == 0 && bundle != null && bundle.containsKey("media_item")) {
                Parcelable parcelable = bundle.getParcelable("media_item");
                if (parcelable != null && !(parcelable instanceof MediaItem)) {
                    this.f.a(this.e);
                    return;
                } else {
                    this.f.a((MediaItem) parcelable);
                    return;
                }
            }
            this.f.a(this.e);
        }
    }

    /* loaded from: classes.dex */
    public static class SearchResultReceiver extends ResultReceiver {
        public final String e;
        public final Bundle f;
        public final k g;

        @Override // android.support.v4.os.ResultReceiver
        public void a(int i, Bundle bundle) {
            MediaSessionCompat.a(bundle);
            if (i == 0 && bundle != null && bundle.containsKey("search_results")) {
                Parcelable[] parcelableArray = bundle.getParcelableArray("search_results");
                ArrayList arrayList = null;
                if (parcelableArray != null) {
                    arrayList = new ArrayList();
                    for (Parcelable parcelable : parcelableArray) {
                        arrayList.add((MediaItem) parcelable);
                    }
                }
                this.g.a(this.e, this.f, arrayList);
                return;
            }
            this.g.a(this.e, this.f);
        }
    }

    /* loaded from: classes.dex */
    public static class a extends Handler {
        public final WeakReference<j> a;
        public WeakReference<Messenger> b;

        public a(j jVar) {
            this.a = new WeakReference<>(jVar);
        }

        public void a(Messenger messenger) {
            this.b = new WeakReference<>(messenger);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            WeakReference<Messenger> weakReference = this.b;
            if (weakReference == null || weakReference.get() == null || this.a.get() == null) {
                return;
            }
            Bundle data = message.getData();
            MediaSessionCompat.a(data);
            j jVar = this.a.get();
            Messenger messenger = this.b.get();
            try {
                int i = message.what;
                if (i == 1) {
                    Bundle bundle = data.getBundle("data_root_hints");
                    MediaSessionCompat.a(bundle);
                    jVar.a(messenger, data.getString("data_media_item_id"), (MediaSessionCompat.Token) data.getParcelable("data_media_session_token"), bundle);
                } else if (i == 2) {
                    jVar.a(messenger);
                } else if (i != 3) {
                    Log.w("MediaBrowserCompat", "Unhandled message: " + message + "\n  Client version: 1\n  Service version: " + message.arg1);
                } else {
                    Bundle bundle2 = data.getBundle("data_options");
                    MediaSessionCompat.a(bundle2);
                    Bundle bundle3 = data.getBundle("data_notify_children_changed_options");
                    MediaSessionCompat.a(bundle3);
                    jVar.a(messenger, data.getString("data_media_item_id"), data.getParcelableArrayList("data_media_item_list"), bundle2, bundle3);
                }
            } catch (BadParcelableException unused) {
                Log.e("MediaBrowserCompat", "Could not unparcel the data.");
                if (message.what == 1) {
                    jVar.a(messenger);
                }
            }
        }
    }

    /* loaded from: classes.dex */
    public static class b {
        public final Object a;
        public a b;

        /* loaded from: classes.dex */
        public interface a {
            void g();

            void h();

            void i();
        }

        /* renamed from: android.support.v4.media.MediaBrowserCompat$b$b, reason: collision with other inner class name */
        /* loaded from: classes.dex */
        public class C0001b implements d.a {
            public C0001b() {
            }

            @Override // d.a
            public void g() {
                a aVar = b.this.b;
                if (aVar != null) {
                    aVar.g();
                }
                b.this.a();
            }

            @Override // d.a
            public void h() {
                a aVar = b.this.b;
                if (aVar != null) {
                    aVar.h();
                }
                b.this.b();
            }

            @Override // d.a
            public void i() {
                a aVar = b.this.b;
                if (aVar != null) {
                    aVar.i();
                }
                b.this.c();
            }
        }

        public b() {
            if (Build.VERSION.SDK_INT >= 21) {
                this.a = defpackage.d.a((d.a) new C0001b());
            } else {
                this.a = null;
            }
        }

        public void a() {
            throw null;
        }

        public void a(a aVar) {
            this.b = aVar;
        }

        public void b() {
            throw null;
        }

        public void c() {
            throw null;
        }
    }

    /* loaded from: classes.dex */
    public static abstract class c {
        public abstract void a(String str, Bundle bundle, Bundle bundle2);

        public abstract void b(String str, Bundle bundle, Bundle bundle2);

        public abstract void c(String str, Bundle bundle, Bundle bundle2);
    }

    /* loaded from: classes.dex */
    public static abstract class d {
        public abstract void a(MediaItem mediaItem);

        public abstract void a(String str);
    }

    /* loaded from: classes.dex */
    public interface e {
        MediaSessionCompat.Token a();

        void b();

        void c();
    }

    /* loaded from: classes.dex */
    public static class g extends f {
        public g(Context context, ComponentName componentName, b bVar, Bundle bundle) {
            super(context, componentName, bVar, bundle);
        }
    }

    /* loaded from: classes.dex */
    public static class h extends g {
        public h(Context context, ComponentName componentName, b bVar, Bundle bundle) {
            super(context, componentName, bVar, bundle);
        }
    }

    /* loaded from: classes.dex */
    public interface j {
        void a(Messenger messenger);

        void a(Messenger messenger, String str, MediaSessionCompat.Token token, Bundle bundle);

        void a(Messenger messenger, String str, List list, Bundle bundle, Bundle bundle2);
    }

    /* loaded from: classes.dex */
    public static abstract class k {
        public abstract void a(String str, Bundle bundle);

        public abstract void a(String str, Bundle bundle, List<MediaItem> list);
    }

    /* loaded from: classes.dex */
    public static class m {
        public final List<n> a = new ArrayList();
        public final List<Bundle> b = new ArrayList();

        public List<n> a() {
            return this.a;
        }

        public List<Bundle> b() {
            return this.b;
        }

        public n a(Bundle bundle) {
            for (int i = 0; i < this.b.size(); i++) {
                if (kc.a(this.b.get(i), bundle)) {
                    return this.a.get(i);
                }
            }
            return null;
        }
    }

    public MediaBrowserCompat(Context context, ComponentName componentName, b bVar, Bundle bundle) {
        int i2 = Build.VERSION.SDK_INT;
        if (i2 >= 26) {
            this.a = new h(context, componentName, bVar, bundle);
            return;
        }
        if (i2 >= 23) {
            this.a = new g(context, componentName, bVar, bundle);
        } else if (i2 >= 21) {
            this.a = new f(context, componentName, bVar, bundle);
        } else {
            this.a = new i(context, componentName, bVar, bundle);
        }
    }

    public void a() {
        this.a.c();
    }

    public void b() {
        this.a.b();
    }

    public MediaSessionCompat.Token c() {
        return this.a.a();
    }

    /* loaded from: classes.dex */
    public static class i implements e, j {
        public final Context a;
        public final ComponentName b;
        public final b c;
        public final Bundle d;
        public final a e = new a(this);
        public final d4<String, m> f = new d4<>();
        public int g = 1;
        public c h;
        public l i;
        public Messenger j;
        public String k;
        public MediaSessionCompat.Token l;

        /* loaded from: classes.dex */
        public class a implements Runnable {
            public a() {
            }

            @Override // java.lang.Runnable
            public void run() {
                i iVar = i.this;
                if (iVar.g == 0) {
                    return;
                }
                iVar.g = 2;
                if (MediaBrowserCompat.b && iVar.h != null) {
                    throw new RuntimeException("mServiceConnection should be null. Instead it is " + i.this.h);
                }
                i iVar2 = i.this;
                if (iVar2.i == null) {
                    if (iVar2.j == null) {
                        Intent intent = new Intent("android.media.browse.MediaBrowserService");
                        intent.setComponent(i.this.b);
                        i iVar3 = i.this;
                        iVar3.h = new c();
                        boolean z = false;
                        try {
                            z = i.this.a.bindService(intent, i.this.h, 1);
                        } catch (Exception unused) {
                            Log.e("MediaBrowserCompat", "Failed binding to service " + i.this.b);
                        }
                        if (!z) {
                            i.this.e();
                            i.this.c.b();
                        }
                        if (MediaBrowserCompat.b) {
                            Log.d("MediaBrowserCompat", "connect...");
                            i.this.d();
                            return;
                        }
                        return;
                    }
                    throw new RuntimeException("mCallbacksMessenger should be null. Instead it is " + i.this.j);
                }
                throw new RuntimeException("mServiceBinderWrapper should be null. Instead it is " + i.this.i);
            }
        }

        /* loaded from: classes.dex */
        public class b implements Runnable {
            public b() {
            }

            @Override // java.lang.Runnable
            public void run() {
                i iVar = i.this;
                Messenger messenger = iVar.j;
                if (messenger != null) {
                    try {
                        iVar.i.a(messenger);
                    } catch (RemoteException unused) {
                        Log.w("MediaBrowserCompat", "RemoteException during connect for " + i.this.b);
                    }
                }
                i iVar2 = i.this;
                int i = iVar2.g;
                iVar2.e();
                if (i != 0) {
                    i.this.g = i;
                }
                if (MediaBrowserCompat.b) {
                    Log.d("MediaBrowserCompat", "disconnect...");
                    i.this.d();
                }
            }
        }

        public i(Context context, ComponentName componentName, b bVar, Bundle bundle) {
            if (context == null) {
                throw new IllegalArgumentException("context must not be null");
            }
            if (componentName == null) {
                throw new IllegalArgumentException("service component must not be null");
            }
            if (bVar != null) {
                this.a = context;
                this.b = componentName;
                this.c = bVar;
                this.d = bundle == null ? null : new Bundle(bundle);
                return;
            }
            throw new IllegalArgumentException("connection callback must not be null");
        }

        @Override // android.support.v4.media.MediaBrowserCompat.e
        public MediaSessionCompat.Token a() {
            if (f()) {
                return this.l;
            }
            throw new IllegalStateException("getSessionToken() called while not connected(state=" + this.g + ")");
        }

        @Override // android.support.v4.media.MediaBrowserCompat.e
        public void b() {
            this.g = 0;
            this.e.post(new b());
        }

        @Override // android.support.v4.media.MediaBrowserCompat.e
        public void c() {
            int i = this.g;
            if (i != 0 && i != 1) {
                throw new IllegalStateException("connect() called while neigther disconnecting nor disconnected (state=" + a(this.g) + ")");
            }
            this.g = 2;
            this.e.post(new a());
        }

        public void d() {
            Log.d("MediaBrowserCompat", "MediaBrowserCompat...");
            Log.d("MediaBrowserCompat", "  mServiceComponent=" + this.b);
            Log.d("MediaBrowserCompat", "  mCallback=" + this.c);
            Log.d("MediaBrowserCompat", "  mRootHints=" + this.d);
            Log.d("MediaBrowserCompat", "  mState=" + a(this.g));
            Log.d("MediaBrowserCompat", "  mServiceConnection=" + this.h);
            Log.d("MediaBrowserCompat", "  mServiceBinderWrapper=" + this.i);
            Log.d("MediaBrowserCompat", "  mCallbacksMessenger=" + this.j);
            Log.d("MediaBrowserCompat", "  mRootId=" + this.k);
            Log.d("MediaBrowserCompat", "  mMediaSessionToken=" + this.l);
        }

        public void e() {
            c cVar = this.h;
            if (cVar != null) {
                this.a.unbindService(cVar);
            }
            this.g = 1;
            this.h = null;
            this.i = null;
            this.j = null;
            this.e.a(null);
            this.k = null;
            this.l = null;
        }

        public boolean f() {
            return this.g == 3;
        }

        /* loaded from: classes.dex */
        public class c implements ServiceConnection {

            /* loaded from: classes.dex */
            public class a implements Runnable {
                public final /* synthetic */ ComponentName a;
                public final /* synthetic */ IBinder c;

                public a(ComponentName componentName, IBinder iBinder) {
                    this.a = componentName;
                    this.c = iBinder;
                }

                @Override // java.lang.Runnable
                public void run() {
                    if (MediaBrowserCompat.b) {
                        Log.d("MediaBrowserCompat", "MediaServiceConnection.onServiceConnected name=" + this.a + " binder=" + this.c);
                        i.this.d();
                    }
                    if (c.this.a("onServiceConnected")) {
                        i iVar = i.this;
                        iVar.i = new l(this.c, iVar.d);
                        i.this.j = new Messenger(i.this.e);
                        i iVar2 = i.this;
                        iVar2.e.a(iVar2.j);
                        i.this.g = 2;
                        try {
                            if (MediaBrowserCompat.b) {
                                Log.d("MediaBrowserCompat", "ServiceCallbacks.onConnect...");
                                i.this.d();
                            }
                            i.this.i.a(i.this.a, i.this.j);
                        } catch (RemoteException unused) {
                            Log.w("MediaBrowserCompat", "RemoteException during connect for " + i.this.b);
                            if (MediaBrowserCompat.b) {
                                Log.d("MediaBrowserCompat", "ServiceCallbacks.onConnect...");
                                i.this.d();
                            }
                        }
                    }
                }
            }

            /* loaded from: classes.dex */
            public class b implements Runnable {
                public final /* synthetic */ ComponentName a;

                public b(ComponentName componentName) {
                    this.a = componentName;
                }

                @Override // java.lang.Runnable
                public void run() {
                    if (MediaBrowserCompat.b) {
                        Log.d("MediaBrowserCompat", "MediaServiceConnection.onServiceDisconnected name=" + this.a + " this=" + this + " mServiceConnection=" + i.this.h);
                        i.this.d();
                    }
                    if (c.this.a("onServiceDisconnected")) {
                        i iVar = i.this;
                        iVar.i = null;
                        iVar.j = null;
                        iVar.e.a(null);
                        i iVar2 = i.this;
                        iVar2.g = 4;
                        iVar2.c.c();
                    }
                }
            }

            public c() {
            }

            public final void a(Runnable runnable) {
                if (Thread.currentThread() == i.this.e.getLooper().getThread()) {
                    runnable.run();
                } else {
                    i.this.e.post(runnable);
                }
            }

            @Override // android.content.ServiceConnection
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                a(new a(componentName, iBinder));
            }

            @Override // android.content.ServiceConnection
            public void onServiceDisconnected(ComponentName componentName) {
                a(new b(componentName));
            }

            public boolean a(String str) {
                int i;
                i iVar = i.this;
                if (iVar.h == this && (i = iVar.g) != 0 && i != 1) {
                    return true;
                }
                int i2 = i.this.g;
                if (i2 == 0 || i2 == 1) {
                    return false;
                }
                Log.i("MediaBrowserCompat", str + " for " + i.this.b + " with mServiceConnection=" + i.this.h + " this=" + this);
                return false;
            }
        }

        @Override // android.support.v4.media.MediaBrowserCompat.j
        public void a(Messenger messenger, String str, MediaSessionCompat.Token token, Bundle bundle) {
            if (a(messenger, "onConnect")) {
                if (this.g != 2) {
                    Log.w("MediaBrowserCompat", "onConnect from service while mState=" + a(this.g) + "... ignoring");
                    return;
                }
                this.k = str;
                this.l = token;
                this.g = 3;
                if (MediaBrowserCompat.b) {
                    Log.d("MediaBrowserCompat", "ServiceCallbacks.onConnect...");
                    d();
                }
                this.c.a();
                try {
                    for (Map.Entry<String, m> entry : this.f.entrySet()) {
                        String key = entry.getKey();
                        m value = entry.getValue();
                        List<n> a2 = value.a();
                        List<Bundle> b2 = value.b();
                        for (int i = 0; i < a2.size(); i++) {
                            this.i.a(key, a2.get(i).b, b2.get(i), this.j);
                        }
                    }
                } catch (RemoteException unused) {
                    Log.d("MediaBrowserCompat", "addSubscription failed with RemoteException.");
                }
            }
        }

        @Override // android.support.v4.media.MediaBrowserCompat.j
        public void a(Messenger messenger) {
            Log.e("MediaBrowserCompat", "onConnectFailed for " + this.b);
            if (a(messenger, "onConnectFailed")) {
                if (this.g != 2) {
                    Log.w("MediaBrowserCompat", "onConnect from service while mState=" + a(this.g) + "... ignoring");
                    return;
                }
                e();
                this.c.b();
            }
        }

        @Override // android.support.v4.media.MediaBrowserCompat.j
        public void a(Messenger messenger, String str, List list, Bundle bundle, Bundle bundle2) {
            if (a(messenger, "onLoadChildren")) {
                if (MediaBrowserCompat.b) {
                    Log.d("MediaBrowserCompat", "onLoadChildren for " + this.b + " id=" + str);
                }
                m mVar = this.f.get(str);
                if (mVar == null) {
                    if (MediaBrowserCompat.b) {
                        Log.d("MediaBrowserCompat", "onLoadChildren for id that isn't subscribed id=" + str);
                        return;
                    }
                    return;
                }
                n a2 = mVar.a(bundle);
                if (a2 != null) {
                    if (bundle == null) {
                        if (list == null) {
                            a2.a(str);
                            return;
                        } else {
                            a2.a(str, (List<MediaItem>) list);
                            return;
                        }
                    }
                    if (list == null) {
                        a2.a(str, bundle);
                    } else {
                        a2.a(str, list, bundle);
                    }
                }
            }
        }

        public static String a(int i) {
            if (i == 0) {
                return "CONNECT_STATE_DISCONNECTING";
            }
            if (i == 1) {
                return "CONNECT_STATE_DISCONNECTED";
            }
            if (i == 2) {
                return "CONNECT_STATE_CONNECTING";
            }
            if (i == 3) {
                return "CONNECT_STATE_CONNECTED";
            }
            if (i == 4) {
                return "CONNECT_STATE_SUSPENDED";
            }
            return "UNKNOWN/" + i;
        }

        public final boolean a(Messenger messenger, String str) {
            int i;
            if (this.j == messenger && (i = this.g) != 0 && i != 1) {
                return true;
            }
            int i2 = this.g;
            if (i2 == 0 || i2 == 1) {
                return false;
            }
            Log.i("MediaBrowserCompat", str + " for " + this.b + " with mCallbacksMessenger=" + this.j + " this=" + this);
            return false;
        }
    }

    /* loaded from: classes.dex */
    public static abstract class n {
        public final Object a;
        public final IBinder b = new Binder();
        public WeakReference<m> c;

        public n() {
            int i = Build.VERSION.SDK_INT;
            if (i >= 26) {
                this.a = defpackage.e.a(new b());
            } else if (i >= 21) {
                this.a = defpackage.d.a((d.InterfaceC0061d) new a());
            }
        }

        public void a(String str) {
        }

        public void a(String str, Bundle bundle) {
        }

        public void a(String str, List<MediaItem> list) {
        }

        public void a(String str, List<MediaItem> list, Bundle bundle) {
        }

        /* loaded from: classes.dex */
        public class b extends a implements e.a {
            public b() {
                super();
            }

            @Override // e.a
            public void a(String str, List<?> list, Bundle bundle) {
                n.this.a(str, MediaItem.a(list), bundle);
            }

            @Override // e.a
            public void a(String str, Bundle bundle) {
                n.this.a(str, bundle);
            }
        }

        /* loaded from: classes.dex */
        public class a implements d.InterfaceC0061d {
            public a() {
            }

            @Override // defpackage.d.InterfaceC0061d
            public void a(String str, List<?> list) {
                WeakReference<m> weakReference = n.this.c;
                m mVar = weakReference == null ? null : weakReference.get();
                if (mVar == null) {
                    n.this.a(str, MediaItem.a(list));
                    return;
                }
                List<MediaItem> a = MediaItem.a(list);
                List<n> a2 = mVar.a();
                List<Bundle> b = mVar.b();
                for (int i = 0; i < a2.size(); i++) {
                    Bundle bundle = b.get(i);
                    if (bundle == null) {
                        n.this.a(str, a);
                    } else {
                        n.this.a(str, a(a, bundle), bundle);
                    }
                }
            }

            @Override // defpackage.d.InterfaceC0061d
            public void a(String str) {
                n.this.a(str);
            }

            public List<MediaItem> a(List<MediaItem> list, Bundle bundle) {
                if (list == null) {
                    return null;
                }
                int i = bundle.getInt("android.media.browse.extra.PAGE", -1);
                int i2 = bundle.getInt("android.media.browse.extra.PAGE_SIZE", -1);
                if (i == -1 && i2 == -1) {
                    return list;
                }
                int i3 = i2 * i;
                int i4 = i3 + i2;
                if (i >= 0 && i2 >= 1 && i3 < list.size()) {
                    if (i4 > list.size()) {
                        i4 = list.size();
                    }
                    return list.subList(i3, i4);
                }
                return Collections.emptyList();
            }
        }
    }

    /* loaded from: classes.dex */
    public static class l {
        public Messenger a;
        public Bundle b;

        public l(IBinder iBinder, Bundle bundle) {
            this.a = new Messenger(iBinder);
            this.b = bundle;
        }

        public void a(Context context, Messenger messenger) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putString("data_package_name", context.getPackageName());
            bundle.putBundle("data_root_hints", this.b);
            a(1, bundle, messenger);
        }

        public void b(Context context, Messenger messenger) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putString("data_package_name", context.getPackageName());
            bundle.putBundle("data_root_hints", this.b);
            a(6, bundle, messenger);
        }

        public void a(Messenger messenger) throws RemoteException {
            a(2, null, messenger);
        }

        public void b(Messenger messenger) throws RemoteException {
            a(7, null, messenger);
        }

        public void a(String str, IBinder iBinder, Bundle bundle, Messenger messenger) throws RemoteException {
            Bundle bundle2 = new Bundle();
            bundle2.putString("data_media_item_id", str);
            t6.a(bundle2, "data_callback_token", iBinder);
            bundle2.putBundle("data_options", bundle);
            a(3, bundle2, messenger);
        }

        public final void a(int i, Bundle bundle, Messenger messenger) throws RemoteException {
            Message obtain = Message.obtain();
            obtain.what = i;
            obtain.arg1 = 1;
            obtain.setData(bundle);
            obtain.replyTo = messenger;
            this.a.send(obtain);
        }
    }

    /* loaded from: classes.dex */
    public static class MediaItem implements Parcelable {
        public static final Parcelable.Creator<MediaItem> CREATOR = new a();
        public final int a;
        public final MediaDescriptionCompat c;

        /* loaded from: classes.dex */
        public static class a implements Parcelable.Creator<MediaItem> {
            /* JADX WARN: Can't rename method to resolve collision */
            @Override // android.os.Parcelable.Creator
            public MediaItem createFromParcel(Parcel parcel) {
                return new MediaItem(parcel);
            }

            /* JADX WARN: Can't rename method to resolve collision */
            @Override // android.os.Parcelable.Creator
            public MediaItem[] newArray(int i) {
                return new MediaItem[i];
            }
        }

        public MediaItem(MediaDescriptionCompat mediaDescriptionCompat, int i) {
            if (mediaDescriptionCompat != null) {
                if (!TextUtils.isEmpty(mediaDescriptionCompat.o())) {
                    this.a = i;
                    this.c = mediaDescriptionCompat;
                    return;
                }
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            throw new IllegalArgumentException("description cannot be null");
        }

        public static MediaItem a(Object obj) {
            if (obj == null || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            return new MediaItem(MediaDescriptionCompat.a(d.c.a(obj)), d.c.b(obj));
        }

        @Override // android.os.Parcelable
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "MediaItem{mFlags=" + this.a + ", mDescription=" + this.c + '}';
        }

        @Override // android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.a);
            this.c.writeToParcel(parcel, i);
        }

        public static List<MediaItem> a(List<?> list) {
            if (list == null || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            ArrayList arrayList = new ArrayList(list.size());
            Iterator<?> it = list.iterator();
            while (it.hasNext()) {
                arrayList.add(a(it.next()));
            }
            return arrayList;
        }

        public MediaItem(Parcel parcel) {
            this.a = parcel.readInt();
            this.c = MediaDescriptionCompat.CREATOR.createFromParcel(parcel);
        }
    }

    /* loaded from: classes.dex */
    public static class f implements e, j, b.a {
        public final Context a;
        public final Object b;
        public final Bundle c;
        public final a d = new a(this);
        public final d4<String, m> e = new d4<>();
        public l f;
        public Messenger g;
        public MediaSessionCompat.Token h;

        public f(Context context, ComponentName componentName, b bVar, Bundle bundle) {
            this.a = context;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            this.c = bundle2;
            bundle2.putInt("extra_client_version", 1);
            bVar.a(this);
            this.b = defpackage.d.a(context, componentName, bVar.a, this.c);
        }

        @Override // android.support.v4.media.MediaBrowserCompat.e
        public MediaSessionCompat.Token a() {
            if (this.h == null) {
                this.h = MediaSessionCompat.Token.a(defpackage.d.d(this.b));
            }
            return this.h;
        }

        @Override // android.support.v4.media.MediaBrowserCompat.j
        public void a(Messenger messenger) {
        }

        @Override // android.support.v4.media.MediaBrowserCompat.j
        public void a(Messenger messenger, String str, MediaSessionCompat.Token token, Bundle bundle) {
        }

        @Override // android.support.v4.media.MediaBrowserCompat.e
        public void b() {
            Messenger messenger;
            l lVar = this.f;
            if (lVar != null && (messenger = this.g) != null) {
                try {
                    lVar.b(messenger);
                } catch (RemoteException unused) {
                    Log.i("MediaBrowserCompat", "Remote error unregistering client messenger.");
                }
            }
            defpackage.d.b(this.b);
        }

        @Override // android.support.v4.media.MediaBrowserCompat.e
        public void c() {
            defpackage.d.a(this.b);
        }

        @Override // android.support.v4.media.MediaBrowserCompat.b.a
        public void g() {
            Bundle c = defpackage.d.c(this.b);
            if (c == null) {
                return;
            }
            c.getInt("extra_service_version", 0);
            IBinder a = t6.a(c, "extra_messenger");
            if (a != null) {
                this.f = new l(a, this.c);
                Messenger messenger = new Messenger(this.d);
                this.g = messenger;
                this.d.a(messenger);
                try {
                    this.f.b(this.a, this.g);
                } catch (RemoteException unused) {
                    Log.i("MediaBrowserCompat", "Remote error registering client messenger.");
                }
            }
            defpackage.j a2 = j.a.a(t6.a(c, "extra_session_binder"));
            if (a2 != null) {
                this.h = MediaSessionCompat.Token.a(defpackage.d.d(this.b), a2);
            }
        }

        @Override // android.support.v4.media.MediaBrowserCompat.b.a
        public void h() {
        }

        @Override // android.support.v4.media.MediaBrowserCompat.b.a
        public void i() {
            this.f = null;
            this.g = null;
            this.h = null;
            this.d.a(null);
        }

        @Override // android.support.v4.media.MediaBrowserCompat.j
        public void a(Messenger messenger, String str, List list, Bundle bundle, Bundle bundle2) {
            if (this.g != messenger) {
                return;
            }
            m mVar = this.e.get(str);
            if (mVar == null) {
                if (MediaBrowserCompat.b) {
                    Log.d("MediaBrowserCompat", "onLoadChildren for id that isn't subscribed id=" + str);
                    return;
                }
                return;
            }
            n a = mVar.a(bundle);
            if (a != null) {
                if (bundle == null) {
                    if (list == null) {
                        a.a(str);
                        return;
                    } else {
                        a.a(str, (List<MediaItem>) list);
                        return;
                    }
                }
                if (list == null) {
                    a.a(str, bundle);
                } else {
                    a.a(str, list, bundle);
                }
            }
        }
    }
}
