package android.support.v4.media.session;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.util.Log;
import android.view.KeyEvent;
import defpackage.i;
import defpackage.j;
import defpackage.k;
import defpackage.t6;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/* loaded from: classes.dex */
public final class MediaControllerCompat {
    public final b a;

    /* loaded from: classes.dex */
    public static class MediaControllerImplApi21 implements b {
        public final Object a;
        public final Object b = new Object();
        public final List<a> c = new ArrayList();
        public HashMap<a, a> d = new HashMap<>();
        public final MediaSessionCompat.Token e;

        /* loaded from: classes.dex */
        public static class ExtraBinderRequestResultReceiver extends ResultReceiver {
            public WeakReference<MediaControllerImplApi21> a;

            public ExtraBinderRequestResultReceiver(MediaControllerImplApi21 mediaControllerImplApi21) {
                super(null);
                this.a = new WeakReference<>(mediaControllerImplApi21);
            }

            @Override // android.os.ResultReceiver
            public void onReceiveResult(int i, Bundle bundle) {
                MediaControllerImplApi21 mediaControllerImplApi21 = this.a.get();
                if (mediaControllerImplApi21 == null || bundle == null) {
                    return;
                }
                synchronized (mediaControllerImplApi21.b) {
                    mediaControllerImplApi21.e.a(j.a.a(t6.a(bundle, "android.support.v4.media.session.EXTRA_BINDER")));
                    mediaControllerImplApi21.e.a(bundle.getBundle("android.support.v4.media.session.SESSION_TOKEN2_BUNDLE"));
                    mediaControllerImplApi21.a();
                }
            }
        }

        /* loaded from: classes.dex */
        public static class a extends a.c {
            public a(a aVar) {
                super(aVar);
            }

            @Override // android.support.v4.media.session.MediaControllerCompat.a.c, defpackage.i
            public void a(MediaMetadataCompat mediaMetadataCompat) throws RemoteException {
                throw new AssertionError();
            }

            @Override // android.support.v4.media.session.MediaControllerCompat.a.c, defpackage.i
            public void b(Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            @Override // android.support.v4.media.session.MediaControllerCompat.a.c, defpackage.i
            public void h() throws RemoteException {
                throw new AssertionError();
            }

            @Override // android.support.v4.media.session.MediaControllerCompat.a.c, defpackage.i
            public void a(List<MediaSessionCompat.QueueItem> list) throws RemoteException {
                throw new AssertionError();
            }

            @Override // android.support.v4.media.session.MediaControllerCompat.a.c, defpackage.i
            public void a(CharSequence charSequence) throws RemoteException {
                throw new AssertionError();
            }

            @Override // android.support.v4.media.session.MediaControllerCompat.a.c, defpackage.i
            public void a(ParcelableVolumeInfo parcelableVolumeInfo) throws RemoteException {
                throw new AssertionError();
            }
        }

        public MediaControllerImplApi21(Context context, MediaSessionCompat.Token token) throws RemoteException {
            this.e = token;
            Object a2 = k.a(context, token.o());
            this.a = a2;
            if (a2 != null) {
                if (this.e.n() == null) {
                    b();
                    return;
                }
                return;
            }
            throw new RemoteException();
        }

        @Override // android.support.v4.media.session.MediaControllerCompat.b
        public boolean a(KeyEvent keyEvent) {
            return k.a(this.a, keyEvent);
        }

        public final void b() {
            a("android.support.v4.media.session.command.GET_EXTRA_BINDER", null, new ExtraBinderRequestResultReceiver(this));
        }

        public void a(String str, Bundle bundle, ResultReceiver resultReceiver) {
            k.a(this.a, str, bundle, resultReceiver);
        }

        public void a() {
            if (this.e.n() == null) {
                return;
            }
            for (a aVar : this.c) {
                a aVar2 = new a(aVar);
                this.d.put(aVar, aVar2);
                aVar.c = aVar2;
                try {
                    this.e.n().a(aVar2);
                    aVar.a(13, null, null);
                } catch (RemoteException e) {
                    Log.e("MediaControllerCompat", "Dead object in registerCallback.", e);
                }
            }
            this.c.clear();
        }
    }

    /* loaded from: classes.dex */
    public static abstract class a implements IBinder.DeathRecipient {
        public final Object a;
        public HandlerC0002a b;
        public i c;

        /* renamed from: android.support.v4.media.session.MediaControllerCompat$a$a, reason: collision with other inner class name */
        /* loaded from: classes.dex */
        public class HandlerC0002a extends Handler {
        }

        public a() {
            if (Build.VERSION.SDK_INT >= 21) {
                this.a = k.a(new b(this));
            } else {
                this.c = new c(this);
            }
        }

        public void a() {
        }

        public void a(int i, Object obj, Bundle bundle) {
            HandlerC0002a handlerC0002a = this.b;
            if (handlerC0002a != null) {
                Message obtainMessage = handlerC0002a.obtainMessage(i, obj);
                obtainMessage.setData(bundle);
                obtainMessage.sendToTarget();
            }
        }

        public void a(Bundle bundle) {
        }

        public void a(MediaMetadataCompat mediaMetadataCompat) {
        }

        public void a(f fVar) {
        }

        public void a(PlaybackStateCompat playbackStateCompat) {
        }

        public void a(CharSequence charSequence) {
        }

        public void a(String str, Bundle bundle) {
        }

        public void a(List<MediaSessionCompat.QueueItem> list) {
        }

        @Override // android.os.IBinder.DeathRecipient
        public void binderDied() {
            a(8, null, null);
        }

        /* loaded from: classes.dex */
        public static class c extends i.a {
            public final WeakReference<a> a;

            public c(a aVar) {
                this.a = new WeakReference<>(aVar);
            }

            @Override // defpackage.i
            public void a(PlaybackStateCompat playbackStateCompat) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(2, playbackStateCompat, null);
                }
            }

            @Override // defpackage.i
            public void a(boolean z) throws RemoteException {
            }

            public void b(Bundle bundle) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(7, bundle, null);
                }
            }

            @Override // defpackage.i
            public void c(String str, Bundle bundle) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(1, str, bundle);
                }
            }

            @Override // defpackage.i
            public void e(int i) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(12, Integer.valueOf(i), null);
                }
            }

            public void h() throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(8, null, null);
                }
            }

            @Override // defpackage.i
            public void v() throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(13, null, null);
                }
            }

            public void a(MediaMetadataCompat mediaMetadataCompat) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(3, mediaMetadataCompat, null);
                }
            }

            @Override // defpackage.i
            public void c(boolean z) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(11, Boolean.valueOf(z), null);
                }
            }

            public void a(List<MediaSessionCompat.QueueItem> list) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(5, list, null);
                }
            }

            @Override // defpackage.i
            public void c(int i) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(9, Integer.valueOf(i), null);
                }
            }

            public void a(CharSequence charSequence) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(6, charSequence, null);
                }
            }

            public void a(ParcelableVolumeInfo parcelableVolumeInfo) throws RemoteException {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(4, parcelableVolumeInfo != null ? new f(parcelableVolumeInfo.a, parcelableVolumeInfo.c, parcelableVolumeInfo.d, parcelableVolumeInfo.e, parcelableVolumeInfo.f) : null, null);
                }
            }
        }

        /* loaded from: classes.dex */
        public static class b implements k.a {
            public final WeakReference<a> a;

            public b(a aVar) {
                this.a = new WeakReference<>(aVar);
            }

            @Override // k.a
            public void a(String str, Bundle bundle) {
                a aVar = this.a.get();
                if (aVar != null) {
                    if (aVar.c == null || Build.VERSION.SDK_INT >= 23) {
                        aVar.a(str, bundle);
                    }
                }
            }

            @Override // k.a
            public void b(Object obj) {
                a aVar = this.a.get();
                if (aVar == null || aVar.c != null) {
                    return;
                }
                aVar.a(PlaybackStateCompat.a(obj));
            }

            @Override // k.a
            public void h() {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a();
                }
            }

            @Override // k.a
            public void a(Object obj) {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(MediaMetadataCompat.a(obj));
                }
            }

            @Override // k.a
            public void b(Bundle bundle) {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(bundle);
                }
            }

            @Override // k.a
            public void a(List<?> list) {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(MediaSessionCompat.QueueItem.a(list));
                }
            }

            @Override // k.a
            public void a(CharSequence charSequence) {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(charSequence);
                }
            }

            @Override // k.a
            public void a(int i, int i2, int i3, int i4, int i5) {
                a aVar = this.a.get();
                if (aVar != null) {
                    aVar.a(new f(i, i2, i3, i4, i5));
                }
            }
        }
    }

    /* loaded from: classes.dex */
    public interface b {
        boolean a(KeyEvent keyEvent);
    }

    /* loaded from: classes.dex */
    public static class c extends MediaControllerImplApi21 {
        public c(Context context, MediaSessionCompat.Token token) throws RemoteException {
            super(context, token);
        }
    }

    /* loaded from: classes.dex */
    public static class d extends c {
        public d(Context context, MediaSessionCompat.Token token) throws RemoteException {
            super(context, token);
        }
    }

    /* loaded from: classes.dex */
    public static class e implements b {
        public j a;

        public e(MediaSessionCompat.Token token) {
            this.a = j.a.a((IBinder) token.o());
        }

        @Override // android.support.v4.media.session.MediaControllerCompat.b
        public boolean a(KeyEvent keyEvent) {
            if (keyEvent != null) {
                try {
                    this.a.a(keyEvent);
                    return false;
                } catch (RemoteException e) {
                    Log.e("MediaControllerCompat", "Dead object in dispatchMediaButtonEvent.", e);
                    return false;
                }
            }
            throw new IllegalArgumentException("event may not be null.");
        }
    }

    /* loaded from: classes.dex */
    public static final class f {
        public f(int i, int i2, int i3, int i4, int i5) {
        }
    }

    public MediaControllerCompat(Context context, MediaSessionCompat.Token token) throws RemoteException {
        new HashSet();
        if (token != null) {
            int i = Build.VERSION.SDK_INT;
            if (i >= 24) {
                this.a = new d(context, token);
                return;
            }
            if (i >= 23) {
                this.a = new c(context, token);
                return;
            } else if (i >= 21) {
                this.a = new MediaControllerImplApi21(context, token);
                return;
            } else {
                this.a = new e(token);
                return;
            }
        }
        throw new IllegalArgumentException("sessionToken must not be null");
    }

    public boolean a(KeyEvent keyEvent) {
        if (keyEvent != null) {
            return this.a.a(keyEvent);
        }
        throw new IllegalArgumentException("KeyEvent may not be null");
    }
}
