package androidx.appcompat.app;

import android.R;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextThemeWrapper;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.appcompat.widget.ActionBarContextView;
import androidx.appcompat.widget.ContentFrameLayout;
import com.autonavi.indoor.pdr.ErrorCode;
import defpackage.a0;
import defpackage.a1;
import defpackage.a3;
import defpackage.b0;
import defpackage.b9;
import defpackage.c0;
import defpackage.c1;
import defpackage.c9;
import defpackage.e0;
import defpackage.e2;
import defpackage.e7;
import defpackage.f0;
import defpackage.g0;
import defpackage.h0;
import defpackage.h1;
import defpackage.i0;
import defpackage.j0;
import defpackage.j1;
import defpackage.j4;
import defpackage.l0;
import defpackage.m0;
import defpackage.m7;
import defpackage.n0;
import defpackage.n9;
import defpackage.p1;
import defpackage.q1;
import defpackage.q3;
import defpackage.q9;
import defpackage.qb;
import defpackage.tb;
import defpackage.u;
import defpackage.u8;
import defpackage.u9;
import defpackage.v0;
import defpackage.v3;
import defpackage.v6;
import defpackage.v9;
import defpackage.w2;
import defpackage.w3;
import defpackage.w9;
import defpackage.x;
import defpackage.x0;
import defpackage.y;
import defpackage.y9;
import defpackage.z0;
import java.lang.Thread;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

/* loaded from: classes.dex */
public class AppCompatDelegateImpl extends g0 implements j1.a, LayoutInflater.Factory2 {
    public static final j4<String, Integer> b0 = new j4<>();
    public static final boolean c0;
    public static final int[] d0;
    public static final boolean e0;
    public static final boolean f0;
    public static boolean g0;
    public boolean A;
    public boolean B;
    public boolean C;
    public boolean D;
    public boolean E;
    public boolean F;
    public boolean G;
    public PanelFeatureState[] H;
    public PanelFeatureState I;
    public boolean J;
    public boolean K;
    public boolean L;
    public boolean M;
    public boolean N;
    public int O;
    public int P;
    public boolean Q;
    public boolean R;
    public l S;
    public l T;
    public boolean U;
    public int V;
    public final Runnable W;
    public boolean X;
    public Rect Y;
    public Rect Z;
    public i0 a0;
    public final Object e;
    public final Context f;
    public Window g;
    public j h;
    public final f0 i;
    public c0 j;
    public MenuInflater k;
    public CharSequence l;
    public w2 m;
    public h n;
    public s o;
    public v0 p;
    public ActionBarContextView q;
    public PopupWindow r;
    public Runnable s;
    public u9 t;
    public boolean u;
    public boolean v;
    public ViewGroup w;
    public TextView x;
    public View y;
    public boolean z;

    /* loaded from: classes.dex */
    public class a implements Thread.UncaughtExceptionHandler {
        public final /* synthetic */ Thread.UncaughtExceptionHandler a;

        public a(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.a = uncaughtExceptionHandler;
        }

        public final boolean a(Throwable th) {
            String message;
            if (!(th instanceof Resources.NotFoundException) || (message = th.getMessage()) == null) {
                return false;
            }
            return message.contains("drawable") || message.contains("Drawable");
        }

        @Override // java.lang.Thread.UncaughtExceptionHandler
        public void uncaughtException(Thread thread, Throwable th) {
            if (a(th)) {
                Resources.NotFoundException notFoundException = new Resources.NotFoundException(th.getMessage() + ". If the resource you are trying to use is a vector resource, you may be referencing it in an unsupported way. See AppCompatDelegate.setCompatVectorFromResourcesEnabled() for more info.");
                notFoundException.initCause(th.getCause());
                notFoundException.setStackTrace(th.getStackTrace());
                this.a.uncaughtException(thread, notFoundException);
                return;
            }
            this.a.uncaughtException(thread, th);
        }
    }

    /* loaded from: classes.dex */
    public class b implements Runnable {
        public b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            if ((appCompatDelegateImpl.V & 1) != 0) {
                appCompatDelegateImpl.f(0);
            }
            AppCompatDelegateImpl appCompatDelegateImpl2 = AppCompatDelegateImpl.this;
            if ((appCompatDelegateImpl2.V & ErrorCode.SENSOR_GYRO_TIMESTAMP_ERROR) != 0) {
                appCompatDelegateImpl2.f(108);
            }
            AppCompatDelegateImpl appCompatDelegateImpl3 = AppCompatDelegateImpl.this;
            appCompatDelegateImpl3.U = false;
            appCompatDelegateImpl3.V = 0;
        }
    }

    /* loaded from: classes.dex */
    public class c implements n9 {
        public c() {
        }

        @Override // defpackage.n9
        public y9 a(View view, y9 y9Var) {
            int i = y9Var.i();
            int a = AppCompatDelegateImpl.this.a(y9Var, (Rect) null);
            if (i != a) {
                y9Var = y9Var.b(y9Var.g(), a, y9Var.h(), y9Var.f());
            }
            return q9.b(view, y9Var);
        }
    }

    /* loaded from: classes.dex */
    public class d implements a3.a {
        public d() {
        }

        @Override // a3.a
        public void a(Rect rect) {
            rect.top = AppCompatDelegateImpl.this.a((y9) null, rect);
        }
    }

    /* loaded from: classes.dex */
    public class e implements ContentFrameLayout.a {
        public e() {
        }

        @Override // androidx.appcompat.widget.ContentFrameLayout.a
        public void a() {
        }

        @Override // androidx.appcompat.widget.ContentFrameLayout.a
        public void onDetachedFromWindow() {
            AppCompatDelegateImpl.this.p();
        }
    }

    /* loaded from: classes.dex */
    public class f implements Runnable {

        /* loaded from: classes.dex */
        public class a extends w9 {
            public a() {
            }

            @Override // defpackage.v9
            public void b(View view) {
                AppCompatDelegateImpl.this.q.setAlpha(1.0f);
                AppCompatDelegateImpl.this.t.a((v9) null);
                AppCompatDelegateImpl.this.t = null;
            }

            @Override // defpackage.w9, defpackage.v9
            public void c(View view) {
                AppCompatDelegateImpl.this.q.setVisibility(0);
            }
        }

        public f() {
        }

        @Override // java.lang.Runnable
        public void run() {
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            appCompatDelegateImpl.r.showAtLocation(appCompatDelegateImpl.q, 55, 0, 0);
            AppCompatDelegateImpl.this.q();
            if (AppCompatDelegateImpl.this.B()) {
                AppCompatDelegateImpl.this.q.setAlpha(0.0f);
                AppCompatDelegateImpl appCompatDelegateImpl2 = AppCompatDelegateImpl.this;
                u9 a2 = q9.a(appCompatDelegateImpl2.q);
                a2.a(1.0f);
                appCompatDelegateImpl2.t = a2;
                AppCompatDelegateImpl.this.t.a(new a());
                return;
            }
            AppCompatDelegateImpl.this.q.setAlpha(1.0f);
            AppCompatDelegateImpl.this.q.setVisibility(0);
        }
    }

    /* loaded from: classes.dex */
    public class g extends w9 {
        public g() {
        }

        @Override // defpackage.v9
        public void b(View view) {
            AppCompatDelegateImpl.this.q.setAlpha(1.0f);
            AppCompatDelegateImpl.this.t.a((v9) null);
            AppCompatDelegateImpl.this.t = null;
        }

        @Override // defpackage.w9, defpackage.v9
        public void c(View view) {
            AppCompatDelegateImpl.this.q.setVisibility(0);
            AppCompatDelegateImpl.this.q.sendAccessibilityEvent(32);
            if (AppCompatDelegateImpl.this.q.getParent() instanceof View) {
                q9.u((View) AppCompatDelegateImpl.this.q.getParent());
            }
        }
    }

    /* loaded from: classes.dex */
    public class k extends l {
        public final PowerManager c;

        public k(Context context) {
            super();
            this.c = (PowerManager) context.getApplicationContext().getSystemService("power");
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.l
        public IntentFilter b() {
            if (Build.VERSION.SDK_INT < 21) {
                return null;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
            return intentFilter;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.l
        public int c() {
            return (Build.VERSION.SDK_INT < 21 || !this.c.isPowerSaveMode()) ? 1 : 2;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.l
        public void d() {
            AppCompatDelegateImpl.this.k();
        }
    }

    /* loaded from: classes.dex */
    public abstract class l {
        public BroadcastReceiver a;

        /* loaded from: classes.dex */
        public class a extends BroadcastReceiver {
            public a() {
            }

            @Override // android.content.BroadcastReceiver
            public void onReceive(Context context, Intent intent) {
                l.this.d();
            }
        }

        public l() {
        }

        public void a() {
            BroadcastReceiver broadcastReceiver = this.a;
            if (broadcastReceiver != null) {
                try {
                    AppCompatDelegateImpl.this.f.unregisterReceiver(broadcastReceiver);
                } catch (IllegalArgumentException unused) {
                }
                this.a = null;
            }
        }

        public abstract IntentFilter b();

        public abstract int c();

        public abstract void d();

        public void e() {
            a();
            IntentFilter b = b();
            if (b == null || b.countActions() == 0) {
                return;
            }
            if (this.a == null) {
                this.a = new a();
            }
            AppCompatDelegateImpl.this.f.registerReceiver(this.a, b);
        }
    }

    /* loaded from: classes.dex */
    public class m extends l {
        public final l0 c;

        public m(l0 l0Var) {
            super();
            this.c = l0Var;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.l
        public IntentFilter b() {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            intentFilter.addAction("android.intent.action.TIME_TICK");
            return intentFilter;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.l
        public int c() {
            return this.c.b() ? 2 : 1;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.l
        public void d() {
            AppCompatDelegateImpl.this.k();
        }
    }

    /* loaded from: classes.dex */
    public static class n {
        public static void a(Configuration configuration, Configuration configuration2, Configuration configuration3) {
            int i = configuration.densityDpi;
            int i2 = configuration2.densityDpi;
            if (i != i2) {
                configuration3.densityDpi = i2;
            }
        }
    }

    /* loaded from: classes.dex */
    public static class o {
        public static void a(Configuration configuration, Configuration configuration2, Configuration configuration3) {
            LocaleList locales = configuration.getLocales();
            LocaleList locales2 = configuration2.getLocales();
            if (locales.equals(locales2)) {
                return;
            }
            configuration3.setLocales(locales2);
            configuration3.locale = configuration2.locale;
        }
    }

    /* loaded from: classes.dex */
    public static class p {
        public static void a(Configuration configuration, Configuration configuration2, Configuration configuration3) {
            int i = configuration.colorMode & 3;
            int i2 = configuration2.colorMode;
            if (i != (i2 & 3)) {
                configuration3.colorMode |= i2 & 3;
            }
            int i3 = configuration.colorMode & 12;
            int i4 = configuration2.colorMode;
            if (i3 != (i4 & 12)) {
                configuration3.colorMode |= i4 & 12;
            }
        }
    }

    /* loaded from: classes.dex */
    public static class q {
        public static void a(ContextThemeWrapper contextThemeWrapper, Configuration configuration) {
            contextThemeWrapper.applyOverrideConfiguration(configuration);
        }
    }

    /* loaded from: classes.dex */
    public class r extends ContentFrameLayout {
        public r(Context context) {
            super(context);
        }

        public final boolean a(int i, int i2) {
            return i < -5 || i2 < -5 || i > getWidth() + 5 || i2 > getHeight() + 5;
        }

        @Override // android.view.ViewGroup, android.view.View
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return AppCompatDelegateImpl.this.a(keyEvent) || super.dispatchKeyEvent(keyEvent);
        }

        @Override // android.view.ViewGroup
        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (motionEvent.getAction() == 0 && a((int) motionEvent.getX(), (int) motionEvent.getY())) {
                AppCompatDelegateImpl.this.e(0);
                return true;
            }
            return super.onInterceptTouchEvent(motionEvent);
        }

        @Override // android.view.View
        public void setBackgroundResource(int i) {
            setBackgroundDrawable(n0.c(getContext(), i));
        }
    }

    static {
        c0 = Build.VERSION.SDK_INT < 21;
        d0 = new int[]{R.attr.windowBackground};
        e0 = !"robolectric".equals(Build.FINGERPRINT);
        f0 = Build.VERSION.SDK_INT >= 17;
        if (!c0 || g0) {
            return;
        }
        Thread.setDefaultUncaughtExceptionHandler(new a(Thread.getDefaultUncaughtExceptionHandler()));
        g0 = true;
    }

    public AppCompatDelegateImpl(Activity activity, f0 f0Var) {
        this(activity, null, f0Var, activity);
    }

    public final c0 A() {
        return this.j;
    }

    public final boolean B() {
        ViewGroup viewGroup;
        return this.v && (viewGroup = this.w) != null && q9.r(viewGroup);
    }

    public final void C() {
        if (this.v) {
            throw new AndroidRuntimeException("Window feature must be requested before adding content");
        }
    }

    public final e0 D() {
        for (Context context = this.f; context != null; context = ((ContextWrapper) context).getBaseContext()) {
            if (context instanceof e0) {
                return (e0) context;
            }
            if (!(context instanceof ContextWrapper)) {
                break;
            }
        }
        return null;
    }

    @Override // defpackage.g0
    public void a(Bundle bundle) {
        this.K = true;
        a(false);
        s();
        Object obj = this.e;
        if (obj instanceof Activity) {
            String str = null;
            try {
                str = v6.b((Activity) obj);
            } catch (IllegalArgumentException unused) {
            }
            if (str != null) {
                c0 A = A();
                if (A == null) {
                    this.X = true;
                } else {
                    A.c(true);
                }
            }
            g0.a(this);
        }
        this.L = true;
    }

    public void a(ViewGroup viewGroup) {
    }

    @Override // defpackage.g0
    public Context b(Context context) {
        this.K = true;
        int a2 = a(context, m());
        if (f0 && (context instanceof ContextThemeWrapper)) {
            try {
                q.a((ContextThemeWrapper) context, a(context, a2, (Configuration) null));
                return context;
            } catch (IllegalStateException unused) {
            }
        }
        if (context instanceof x0) {
            try {
                ((x0) context).a(a(context, a2, (Configuration) null));
                return context;
            } catch (IllegalStateException unused2) {
            }
        }
        if (!e0) {
            super.b(context);
            return context;
        }
        try {
            Configuration configuration = context.getPackageManager().getResourcesForApplication(context.getApplicationInfo()).getConfiguration();
            Configuration configuration2 = context.getResources().getConfiguration();
            Configuration a3 = a(context, a2, configuration.equals(configuration2) ? null : a(configuration, configuration2));
            x0 x0Var = new x0(context, a0.Theme_AppCompat_Empty);
            x0Var.a(a3);
            boolean z = false;
            try {
                z = context.getTheme() != null;
            } catch (NullPointerException unused3) {
            }
            if (z) {
                m7.d.a(x0Var.getTheme());
            }
            super.b(x0Var);
            return x0Var;
        } catch (PackageManager.NameNotFoundException e2) {
            throw new RuntimeException("Application failed to obtain resources from itself", e2);
        }
    }

    @Override // defpackage.g0
    public c0 c() {
        w();
        return this.j;
    }

    @Override // defpackage.g0
    public void c(Bundle bundle) {
    }

    @Override // defpackage.g0
    public void d(int i2) {
        this.P = i2;
    }

    @Override // defpackage.g0
    public void e() {
        c0 c2 = c();
        if (c2 == null || !c2.i()) {
            g(0);
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:16:0x005b  */
    @Override // defpackage.g0
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public void f() {
        /*
            r3 = this;
            java.lang.Object r0 = r3.e
            boolean r0 = r0 instanceof android.app.Activity
            if (r0 == 0) goto L9
            defpackage.g0.b(r3)
        L9:
            boolean r0 = r3.U
            if (r0 == 0) goto L18
            android.view.Window r0 = r3.g
            android.view.View r0 = r0.getDecorView()
            java.lang.Runnable r1 = r3.W
            r0.removeCallbacks(r1)
        L18:
            r0 = 0
            r3.M = r0
            r0 = 1
            r3.N = r0
            int r0 = r3.O
            r1 = -100
            if (r0 == r1) goto L48
            java.lang.Object r0 = r3.e
            boolean r1 = r0 instanceof android.app.Activity
            if (r1 == 0) goto L48
            android.app.Activity r0 = (android.app.Activity) r0
            boolean r0 = r0.isChangingConfigurations()
            if (r0 == 0) goto L48
            j4<java.lang.String, java.lang.Integer> r0 = androidx.appcompat.app.AppCompatDelegateImpl.b0
            java.lang.Object r1 = r3.e
            java.lang.Class r1 = r1.getClass()
            java.lang.String r1 = r1.getName()
            int r2 = r3.O
            java.lang.Integer r2 = java.lang.Integer.valueOf(r2)
            r0.put(r1, r2)
            goto L57
        L48:
            j4<java.lang.String, java.lang.Integer> r0 = androidx.appcompat.app.AppCompatDelegateImpl.b0
            java.lang.Object r1 = r3.e
            java.lang.Class r1 = r1.getClass()
            java.lang.String r1 = r1.getName()
            r0.remove(r1)
        L57:
            c0 r0 = r3.j
            if (r0 == 0) goto L5e
            r0.j()
        L5e:
            r3.n()
            return
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.appcompat.app.AppCompatDelegateImpl.f():void");
    }

    @Override // defpackage.g0
    public void g() {
        c0 c2 = c();
        if (c2 != null) {
            c2.d(true);
        }
    }

    @Override // defpackage.g0
    public void h() {
        this.M = true;
        k();
    }

    @Override // defpackage.g0
    public void i() {
        this.M = false;
        c0 c2 = c();
        if (c2 != null) {
            c2.d(false);
        }
    }

    public final int j(int i2) {
        if (i2 == 8) {
            Log.i("AppCompatDelegate", "You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR id when requesting this feature.");
            return 108;
        }
        if (i2 != 9) {
            return i2;
        }
        Log.i("AppCompatDelegate", "You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR_OVERLAY id when requesting this feature.");
        return 109;
    }

    public boolean k() {
        return a(true);
    }

    public final void l() {
        ContentFrameLayout contentFrameLayout = (ContentFrameLayout) this.w.findViewById(R.id.content);
        View decorView = this.g.getDecorView();
        contentFrameLayout.a(decorView.getPaddingLeft(), decorView.getPaddingTop(), decorView.getPaddingRight(), decorView.getPaddingBottom());
        TypedArray obtainStyledAttributes = this.f.obtainStyledAttributes(b0.AppCompatTheme);
        obtainStyledAttributes.getValue(b0.AppCompatTheme_windowMinWidthMajor, contentFrameLayout.getMinWidthMajor());
        obtainStyledAttributes.getValue(b0.AppCompatTheme_windowMinWidthMinor, contentFrameLayout.getMinWidthMinor());
        if (obtainStyledAttributes.hasValue(b0.AppCompatTheme_windowFixedWidthMajor)) {
            obtainStyledAttributes.getValue(b0.AppCompatTheme_windowFixedWidthMajor, contentFrameLayout.getFixedWidthMajor());
        }
        if (obtainStyledAttributes.hasValue(b0.AppCompatTheme_windowFixedWidthMinor)) {
            obtainStyledAttributes.getValue(b0.AppCompatTheme_windowFixedWidthMinor, contentFrameLayout.getFixedWidthMinor());
        }
        if (obtainStyledAttributes.hasValue(b0.AppCompatTheme_windowFixedHeightMajor)) {
            obtainStyledAttributes.getValue(b0.AppCompatTheme_windowFixedHeightMajor, contentFrameLayout.getFixedHeightMajor());
        }
        if (obtainStyledAttributes.hasValue(b0.AppCompatTheme_windowFixedHeightMinor)) {
            obtainStyledAttributes.getValue(b0.AppCompatTheme_windowFixedHeightMinor, contentFrameLayout.getFixedHeightMinor());
        }
        obtainStyledAttributes.recycle();
        contentFrameLayout.requestLayout();
    }

    public final int m() {
        int i2 = this.O;
        return i2 != -100 ? i2 : g0.j();
    }

    public final void n() {
        l lVar = this.S;
        if (lVar != null) {
            lVar.a();
        }
        l lVar2 = this.T;
        if (lVar2 != null) {
            lVar2.a();
        }
    }

    public final ViewGroup o() {
        ViewGroup viewGroup;
        Context context;
        TypedArray obtainStyledAttributes = this.f.obtainStyledAttributes(b0.AppCompatTheme);
        if (obtainStyledAttributes.hasValue(b0.AppCompatTheme_windowActionBar)) {
            if (obtainStyledAttributes.getBoolean(b0.AppCompatTheme_windowNoTitle, false)) {
                b(1);
            } else if (obtainStyledAttributes.getBoolean(b0.AppCompatTheme_windowActionBar, false)) {
                b(108);
            }
            if (obtainStyledAttributes.getBoolean(b0.AppCompatTheme_windowActionBarOverlay, false)) {
                b(109);
            }
            if (obtainStyledAttributes.getBoolean(b0.AppCompatTheme_windowActionModeOverlay, false)) {
                b(10);
            }
            this.E = obtainStyledAttributes.getBoolean(b0.AppCompatTheme_android_windowIsFloating, false);
            obtainStyledAttributes.recycle();
            s();
            this.g.getDecorView();
            LayoutInflater from = LayoutInflater.from(this.f);
            if (!this.F) {
                if (this.E) {
                    viewGroup = (ViewGroup) from.inflate(y.abc_dialog_title_material, (ViewGroup) null);
                    this.C = false;
                    this.B = false;
                } else if (this.B) {
                    TypedValue typedValue = new TypedValue();
                    this.f.getTheme().resolveAttribute(defpackage.s.actionBarTheme, typedValue, true);
                    if (typedValue.resourceId != 0) {
                        context = new x0(this.f, typedValue.resourceId);
                    } else {
                        context = this.f;
                    }
                    viewGroup = (ViewGroup) LayoutInflater.from(context).inflate(y.abc_screen_toolbar, (ViewGroup) null);
                    w2 w2Var = (w2) viewGroup.findViewById(x.decor_content_parent);
                    this.m = w2Var;
                    w2Var.setWindowCallback(v());
                    if (this.C) {
                        this.m.a(109);
                    }
                    if (this.z) {
                        this.m.a(2);
                    }
                    if (this.A) {
                        this.m.a(5);
                    }
                } else {
                    viewGroup = null;
                }
            } else {
                viewGroup = this.D ? (ViewGroup) from.inflate(y.abc_screen_simple_overlay_action_mode, (ViewGroup) null) : (ViewGroup) from.inflate(y.abc_screen_simple, (ViewGroup) null);
            }
            if (viewGroup != null) {
                if (Build.VERSION.SDK_INT >= 21) {
                    q9.a(viewGroup, new c());
                } else if (viewGroup instanceof a3) {
                    ((a3) viewGroup).setOnFitSystemWindowsListener(new d());
                }
                if (this.m == null) {
                    this.x = (TextView) viewGroup.findViewById(x.title);
                }
                w3.b(viewGroup);
                ContentFrameLayout contentFrameLayout = (ContentFrameLayout) viewGroup.findViewById(x.action_bar_activity_content);
                ViewGroup viewGroup2 = (ViewGroup) this.g.findViewById(R.id.content);
                if (viewGroup2 != null) {
                    while (viewGroup2.getChildCount() > 0) {
                        View childAt = viewGroup2.getChildAt(0);
                        viewGroup2.removeViewAt(0);
                        contentFrameLayout.addView(childAt);
                    }
                    viewGroup2.setId(-1);
                    contentFrameLayout.setId(R.id.content);
                    if (viewGroup2 instanceof FrameLayout) {
                        ((FrameLayout) viewGroup2).setForeground(null);
                    }
                }
                this.g.setContentView(viewGroup);
                contentFrameLayout.setAttachListener(new e());
                return viewGroup;
            }
            throw new IllegalArgumentException("AppCompat does not support the current theme features: { windowActionBar: " + this.B + ", windowActionBarOverlay: " + this.C + ", android:windowIsFloating: " + this.E + ", windowActionModeOverlay: " + this.D + ", windowNoTitle: " + this.F + " }");
        }
        obtainStyledAttributes.recycle();
        throw new IllegalStateException("You need to use a Theme.AppCompat theme (or descendant) with this activity.");
    }

    @Override // android.view.LayoutInflater.Factory2
    public final View onCreateView(View view, String str, Context context, AttributeSet attributeSet) {
        return a(view, str, context, attributeSet);
    }

    public void p() {
        j1 j1Var;
        w2 w2Var = this.m;
        if (w2Var != null) {
            w2Var.g();
        }
        if (this.r != null) {
            this.g.getDecorView().removeCallbacks(this.s);
            if (this.r.isShowing()) {
                try {
                    this.r.dismiss();
                } catch (IllegalArgumentException unused) {
                }
            }
            this.r = null;
        }
        q();
        PanelFeatureState a2 = a(0, false);
        if (a2 == null || (j1Var = a2.j) == null) {
            return;
        }
        j1Var.close();
    }

    public void q() {
        u9 u9Var = this.t;
        if (u9Var != null) {
            u9Var.a();
        }
    }

    public final void r() {
        if (this.v) {
            return;
        }
        this.w = o();
        CharSequence u = u();
        if (!TextUtils.isEmpty(u)) {
            w2 w2Var = this.m;
            if (w2Var != null) {
                w2Var.setWindowTitle(u);
            } else if (A() != null) {
                A().a(u);
            } else {
                TextView textView = this.x;
                if (textView != null) {
                    textView.setText(u);
                }
            }
        }
        l();
        a(this.w);
        this.v = true;
        PanelFeatureState a2 = a(0, false);
        if (this.N) {
            return;
        }
        if (a2 == null || a2.j == null) {
            g(108);
        }
    }

    public final void s() {
        if (this.g == null) {
            Object obj = this.e;
            if (obj instanceof Activity) {
                a(((Activity) obj).getWindow());
            }
        }
        if (this.g == null) {
            throw new IllegalStateException("We have not been given a Window");
        }
    }

    public final Context t() {
        c0 c2 = c();
        Context h2 = c2 != null ? c2.h() : null;
        return h2 == null ? this.f : h2;
    }

    public final CharSequence u() {
        Object obj = this.e;
        if (obj instanceof Activity) {
            return ((Activity) obj).getTitle();
        }
        return this.l;
    }

    public final Window.Callback v() {
        return this.g.getCallback();
    }

    public final void w() {
        r();
        if (this.B && this.j == null) {
            Object obj = this.e;
            if (obj instanceof Activity) {
                this.j = new m0((Activity) this.e, this.C);
            } else if (obj instanceof Dialog) {
                this.j = new m0((Dialog) this.e);
            }
            c0 c0Var = this.j;
            if (c0Var != null) {
                c0Var.c(this.X);
            }
        }
    }

    public final boolean x() {
        int i2;
        if (!this.R && (this.e instanceof Activity)) {
            PackageManager packageManager = this.f.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            try {
                if (Build.VERSION.SDK_INT >= 29) {
                    i2 = 269221888;
                } else {
                    i2 = Build.VERSION.SDK_INT >= 24 ? 786432 : 0;
                }
                ActivityInfo activityInfo = packageManager.getActivityInfo(new ComponentName(this.f, this.e.getClass()), i2);
                this.Q = (activityInfo == null || (activityInfo.configChanges & 512) == 0) ? false : true;
            } catch (PackageManager.NameNotFoundException e2) {
                Log.d("AppCompatDelegate", "Exception while getting ActivityInfo", e2);
                this.Q = false;
            }
        }
        this.R = true;
        return this.Q;
    }

    public boolean y() {
        return this.u;
    }

    public boolean z() {
        v0 v0Var = this.p;
        if (v0Var != null) {
            v0Var.a();
            return true;
        }
        c0 c2 = c();
        return c2 != null && c2.f();
    }

    /* loaded from: classes.dex */
    public final class h implements p1.a {
        public h() {
        }

        @Override // p1.a
        public boolean a(j1 j1Var) {
            Window.Callback v = AppCompatDelegateImpl.this.v();
            if (v == null) {
                return true;
            }
            v.onMenuOpened(108, j1Var);
            return true;
        }

        @Override // p1.a
        public void a(j1 j1Var, boolean z) {
            AppCompatDelegateImpl.this.b(j1Var);
        }
    }

    /* loaded from: classes.dex */
    public class i implements v0.a {
        public v0.a a;

        /* loaded from: classes.dex */
        public class a extends w9 {
            public a() {
            }

            @Override // defpackage.v9
            public void b(View view) {
                AppCompatDelegateImpl.this.q.setVisibility(8);
                AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
                PopupWindow popupWindow = appCompatDelegateImpl.r;
                if (popupWindow != null) {
                    popupWindow.dismiss();
                } else if (appCompatDelegateImpl.q.getParent() instanceof View) {
                    q9.u((View) AppCompatDelegateImpl.this.q.getParent());
                }
                AppCompatDelegateImpl.this.q.removeAllViews();
                AppCompatDelegateImpl.this.t.a((v9) null);
                AppCompatDelegateImpl appCompatDelegateImpl2 = AppCompatDelegateImpl.this;
                appCompatDelegateImpl2.t = null;
                q9.u(appCompatDelegateImpl2.w);
            }
        }

        public i(v0.a aVar) {
            this.a = aVar;
        }

        @Override // v0.a
        public boolean a(v0 v0Var, Menu menu) {
            q9.u(AppCompatDelegateImpl.this.w);
            return this.a.a(v0Var, menu);
        }

        @Override // v0.a
        public boolean b(v0 v0Var, Menu menu) {
            return this.a.b(v0Var, menu);
        }

        @Override // v0.a
        public boolean a(v0 v0Var, MenuItem menuItem) {
            return this.a.a(v0Var, menuItem);
        }

        @Override // v0.a
        public void a(v0 v0Var) {
            this.a.a(v0Var);
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            if (appCompatDelegateImpl.r != null) {
                appCompatDelegateImpl.g.getDecorView().removeCallbacks(AppCompatDelegateImpl.this.s);
            }
            AppCompatDelegateImpl appCompatDelegateImpl2 = AppCompatDelegateImpl.this;
            if (appCompatDelegateImpl2.q != null) {
                appCompatDelegateImpl2.q();
                AppCompatDelegateImpl appCompatDelegateImpl3 = AppCompatDelegateImpl.this;
                u9 a2 = q9.a(appCompatDelegateImpl3.q);
                a2.a(0.0f);
                appCompatDelegateImpl3.t = a2;
                AppCompatDelegateImpl.this.t.a(new a());
            }
            AppCompatDelegateImpl appCompatDelegateImpl4 = AppCompatDelegateImpl.this;
            f0 f0Var = appCompatDelegateImpl4.i;
            if (f0Var != null) {
                f0Var.b(appCompatDelegateImpl4.p);
            }
            AppCompatDelegateImpl appCompatDelegateImpl5 = AppCompatDelegateImpl.this;
            appCompatDelegateImpl5.p = null;
            q9.u(appCompatDelegateImpl5.w);
        }
    }

    public AppCompatDelegateImpl(Dialog dialog, f0 f0Var) {
        this(dialog.getContext(), dialog.getWindow(), f0Var, dialog);
    }

    public boolean d(int i2, KeyEvent keyEvent) {
        if (i2 == 4) {
            boolean z = this.J;
            this.J = false;
            PanelFeatureState a2 = a(0, false);
            if (a2 != null && a2.o) {
                if (!z) {
                    a(a2, true);
                }
                return true;
            }
            if (z()) {
                return true;
            }
        } else if (i2 == 82) {
            e(0, keyEvent);
            return true;
        }
        return false;
    }

    @Override // android.view.LayoutInflater.Factory
    public View onCreateView(String str, Context context, AttributeSet attributeSet) {
        return onCreateView(null, str, context, attributeSet);
    }

    /* loaded from: classes.dex */
    public static final class PanelFeatureState {
        public int a;
        public int b;
        public int c;
        public int d;
        public int e;
        public int f;
        public ViewGroup g;
        public View h;
        public View i;
        public j1 j;
        public h1 k;
        public Context l;
        public boolean m;
        public boolean n;
        public boolean o;
        public boolean p;
        public boolean q = false;
        public boolean r;
        public Bundle s;

        @SuppressLint({"BanParcelableUsage"})
        /* loaded from: classes.dex */
        public static class SavedState implements Parcelable {
            public static final Parcelable.Creator<SavedState> CREATOR = new a();
            public int a;
            public boolean c;
            public Bundle d;

            /* loaded from: classes.dex */
            public class a implements Parcelable.ClassLoaderCreator<SavedState> {
                @Override // android.os.Parcelable.Creator
                public SavedState[] newArray(int i) {
                    return new SavedState[i];
                }

                /* JADX WARN: Can't rename method to resolve collision */
                @Override // android.os.Parcelable.ClassLoaderCreator
                public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                    return SavedState.a(parcel, classLoader);
                }

                @Override // android.os.Parcelable.Creator
                public SavedState createFromParcel(Parcel parcel) {
                    return SavedState.a(parcel, null);
                }
            }

            public static SavedState a(Parcel parcel, ClassLoader classLoader) {
                SavedState savedState = new SavedState();
                savedState.a = parcel.readInt();
                boolean z = parcel.readInt() == 1;
                savedState.c = z;
                if (z) {
                    savedState.d = parcel.readBundle(classLoader);
                }
                return savedState;
            }

            @Override // android.os.Parcelable
            public int describeContents() {
                return 0;
            }

            @Override // android.os.Parcelable
            public void writeToParcel(Parcel parcel, int i) {
                parcel.writeInt(this.a);
                parcel.writeInt(this.c ? 1 : 0);
                if (this.c) {
                    parcel.writeBundle(this.d);
                }
            }
        }

        public PanelFeatureState(int i) {
            this.a = i;
        }

        public boolean a() {
            if (this.h == null) {
                return false;
            }
            return this.i != null || this.k.a().getCount() > 0;
        }

        public void a(Context context) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme newTheme = context.getResources().newTheme();
            newTheme.setTo(context.getTheme());
            newTheme.resolveAttribute(defpackage.s.actionBarPopupTheme, typedValue, true);
            int i = typedValue.resourceId;
            if (i != 0) {
                newTheme.applyStyle(i, true);
            }
            newTheme.resolveAttribute(defpackage.s.panelMenuListTheme, typedValue, true);
            int i2 = typedValue.resourceId;
            if (i2 != 0) {
                newTheme.applyStyle(i2, true);
            } else {
                newTheme.applyStyle(a0.Theme_AppCompat_CompactMenu, true);
            }
            x0 x0Var = new x0(context, 0);
            x0Var.getTheme().setTo(newTheme);
            this.l = x0Var;
            TypedArray obtainStyledAttributes = x0Var.obtainStyledAttributes(b0.AppCompatTheme);
            this.b = obtainStyledAttributes.getResourceId(b0.AppCompatTheme_panelBackground, 0);
            this.f = obtainStyledAttributes.getResourceId(b0.AppCompatTheme_android_windowAnimationStyle, 0);
            obtainStyledAttributes.recycle();
        }

        public void a(j1 j1Var) {
            h1 h1Var;
            j1 j1Var2 = this.j;
            if (j1Var == j1Var2) {
                return;
            }
            if (j1Var2 != null) {
                j1Var2.b(this.k);
            }
            this.j = j1Var;
            if (j1Var == null || (h1Var = this.k) == null) {
                return;
            }
            j1Var.a(h1Var);
        }

        public q1 a(p1.a aVar) {
            if (this.j == null) {
                return null;
            }
            if (this.k == null) {
                h1 h1Var = new h1(this.l, y.abc_list_menu_item_layout);
                this.k = h1Var;
                h1Var.a(aVar);
                this.j.a(this.k);
            }
            return this.k.a(this.g);
        }
    }

    public AppCompatDelegateImpl(Context context, Window window, f0 f0Var, Object obj) {
        Integer num;
        e0 D;
        this.t = null;
        this.u = true;
        this.O = -100;
        this.W = new b();
        this.f = context;
        this.i = f0Var;
        this.e = obj;
        if (this.O == -100 && (obj instanceof Dialog) && (D = D()) != null) {
            this.O = D.k().a();
        }
        if (this.O == -100 && (num = b0.get(this.e.getClass().getName())) != null) {
            this.O = num.intValue();
            b0.remove(this.e.getClass().getName());
        }
        if (window != null) {
            a(window);
        }
        e2.c();
    }

    @Override // defpackage.g0
    public void c(int i2) {
        r();
        ViewGroup viewGroup = (ViewGroup) this.w.findViewById(R.id.content);
        viewGroup.removeAllViews();
        LayoutInflater.from(this.f).inflate(i2, viewGroup);
        this.h.a().onContentChanged();
    }

    public final void g(int i2) {
        this.V = (1 << i2) | this.V;
        if (this.U) {
            return;
        }
        q9.a(this.g.getDecorView(), this.W);
        this.U = true;
    }

    public void h(int i2) {
        c0 c2;
        if (i2 != 108 || (c2 = c()) == null) {
            return;
        }
        c2.b(true);
    }

    /* loaded from: classes.dex */
    public class j extends c1 {
        public j(Window.Callback callback) {
            super(callback);
        }

        public final ActionMode a(ActionMode.Callback callback) {
            z0.a aVar = new z0.a(AppCompatDelegateImpl.this.f, callback);
            v0 a = AppCompatDelegateImpl.this.a(aVar);
            if (a != null) {
                return aVar.b(a);
            }
            return null;
        }

        @Override // defpackage.c1, android.view.Window.Callback
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return AppCompatDelegateImpl.this.a(keyEvent) || super.dispatchKeyEvent(keyEvent);
        }

        @Override // defpackage.c1, android.view.Window.Callback
        public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
            return super.dispatchKeyShortcutEvent(keyEvent) || AppCompatDelegateImpl.this.c(keyEvent.getKeyCode(), keyEvent);
        }

        @Override // android.view.Window.Callback
        public void onContentChanged() {
        }

        @Override // defpackage.c1, android.view.Window.Callback
        public boolean onCreatePanelMenu(int i, Menu menu) {
            if (i != 0 || (menu instanceof j1)) {
                return super.onCreatePanelMenu(i, menu);
            }
            return false;
        }

        @Override // defpackage.c1, android.view.Window.Callback
        public boolean onMenuOpened(int i, Menu menu) {
            super.onMenuOpened(i, menu);
            AppCompatDelegateImpl.this.h(i);
            return true;
        }

        @Override // defpackage.c1, android.view.Window.Callback
        public void onPanelClosed(int i, Menu menu) {
            super.onPanelClosed(i, menu);
            AppCompatDelegateImpl.this.i(i);
        }

        @Override // defpackage.c1, android.view.Window.Callback
        public boolean onPreparePanel(int i, View view, Menu menu) {
            j1 j1Var = menu instanceof j1 ? (j1) menu : null;
            if (i == 0 && j1Var == null) {
                return false;
            }
            if (j1Var != null) {
                j1Var.d(true);
            }
            boolean onPreparePanel = super.onPreparePanel(i, view, menu);
            if (j1Var != null) {
                j1Var.d(false);
            }
            return onPreparePanel;
        }

        @Override // defpackage.c1, android.view.Window.Callback
        public void onProvideKeyboardShortcuts(List<KeyboardShortcutGroup> list, Menu menu, int i) {
            j1 j1Var;
            PanelFeatureState a = AppCompatDelegateImpl.this.a(0, true);
            if (a != null && (j1Var = a.j) != null) {
                super.onProvideKeyboardShortcuts(list, j1Var, i);
            } else {
                super.onProvideKeyboardShortcuts(list, menu, i);
            }
        }

        @Override // defpackage.c1, android.view.Window.Callback
        public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
            if (Build.VERSION.SDK_INT >= 23) {
                return null;
            }
            if (AppCompatDelegateImpl.this.y()) {
                return a(callback);
            }
            return super.onWindowStartingActionMode(callback);
        }

        @Override // defpackage.c1, android.view.Window.Callback
        public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int i) {
            if (AppCompatDelegateImpl.this.y() && i == 0) {
                return a(callback);
            }
            return super.onWindowStartingActionMode(callback, i);
        }
    }

    public void e(int i2) {
        a(a(i2, true), true);
    }

    public void i(int i2) {
        if (i2 == 108) {
            c0 c2 = c();
            if (c2 != null) {
                c2.b(false);
                return;
            }
            return;
        }
        if (i2 == 0) {
            PanelFeatureState a2 = a(i2, true);
            if (a2.o) {
                a(a2, false);
            }
        }
    }

    /* loaded from: classes.dex */
    public final class s implements p1.a {
        public s() {
        }

        @Override // p1.a
        public void a(j1 j1Var, boolean z) {
            j1 m = j1Var.m();
            boolean z2 = m != j1Var;
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            if (z2) {
                j1Var = m;
            }
            PanelFeatureState a = appCompatDelegateImpl.a((Menu) j1Var);
            if (a != null) {
                if (z2) {
                    AppCompatDelegateImpl.this.a(a.a, a, m);
                    AppCompatDelegateImpl.this.a(a, true);
                } else {
                    AppCompatDelegateImpl.this.a(a, z);
                }
            }
        }

        @Override // p1.a
        public boolean a(j1 j1Var) {
            Window.Callback v;
            if (j1Var != j1Var.m()) {
                return true;
            }
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            if (!appCompatDelegateImpl.B || (v = appCompatDelegateImpl.v()) == null || AppCompatDelegateImpl.this.N) {
                return true;
            }
            v.onMenuOpened(108, j1Var);
            return true;
        }
    }

    public final boolean e(int i2, KeyEvent keyEvent) {
        boolean z;
        w2 w2Var;
        if (this.p != null) {
            return false;
        }
        boolean z2 = true;
        PanelFeatureState a2 = a(i2, true);
        if (i2 == 0 && (w2Var = this.m) != null && w2Var.f() && !ViewConfiguration.get(this.f).hasPermanentMenuKey()) {
            if (!this.m.a()) {
                if (!this.N && b(a2, keyEvent)) {
                    z2 = this.m.e();
                }
                z2 = false;
            } else {
                z2 = this.m.d();
            }
        } else if (!a2.o && !a2.n) {
            if (a2.m) {
                if (a2.r) {
                    a2.m = false;
                    z = b(a2, keyEvent);
                } else {
                    z = true;
                }
                if (z) {
                    a(a2, keyEvent);
                }
            }
            z2 = false;
        } else {
            boolean z3 = a2.o;
            a(a2, true);
            z2 = z3;
        }
        if (z2) {
            AudioManager audioManager = (AudioManager) this.f.getApplicationContext().getSystemService("audio");
            if (audioManager != null) {
                audioManager.playSoundEffect(0);
            } else {
                Log.w("AppCompatDelegate", "Couldn't get audio manager");
            }
        }
        return z2;
    }

    public boolean c(int i2, KeyEvent keyEvent) {
        c0 c2 = c();
        if (c2 != null && c2.a(i2, keyEvent)) {
            return true;
        }
        PanelFeatureState panelFeatureState = this.I;
        if (panelFeatureState != null && a(panelFeatureState, keyEvent.getKeyCode(), keyEvent, 1)) {
            PanelFeatureState panelFeatureState2 = this.I;
            if (panelFeatureState2 != null) {
                panelFeatureState2.n = true;
            }
            return true;
        }
        if (this.I == null) {
            PanelFeatureState a2 = a(0, true);
            b(a2, keyEvent);
            boolean a3 = a(a2, keyEvent.getKeyCode(), keyEvent, 1);
            a2.m = false;
            if (a3) {
                return true;
            }
        }
        return false;
    }

    @Override // defpackage.g0
    public void d() {
        LayoutInflater from = LayoutInflater.from(this.f);
        if (from.getFactory() == null) {
            c9.b(from, this);
        } else {
            if (from.getFactory2() instanceof AppCompatDelegateImpl) {
                return;
            }
            Log.i("AppCompatDelegate", "The Activity's LayoutInflater already has a Factory installed so we can not install AppCompat's");
        }
    }

    @Override // defpackage.g0
    public <T extends View> T a(int i2) {
        r();
        return (T) this.g.findViewById(i2);
    }

    @Override // defpackage.g0
    public void a(Configuration configuration) {
        c0 c2;
        if (this.B && this.v && (c2 = c()) != null) {
            c2.a(configuration);
        }
        e2.b().a(this.f);
        a(false);
    }

    public final l d(Context context) {
        if (this.S == null) {
            this.S = new m(l0.a(context));
        }
        return this.S;
    }

    public void f(int i2) {
        PanelFeatureState a2;
        PanelFeatureState a3 = a(i2, true);
        if (a3.j != null) {
            Bundle bundle = new Bundle();
            a3.j.b(bundle);
            if (bundle.size() > 0) {
                a3.s = bundle;
            }
            a3.j.s();
            a3.j.clear();
        }
        a3.r = true;
        a3.q = true;
        if ((i2 != 108 && i2 != 0) || this.m == null || (a2 = a(0, false)) == null) {
            return;
        }
        a2.m = false;
        b(a2, (KeyEvent) null);
    }

    @Override // defpackage.g0
    public void a(View view) {
        r();
        ViewGroup viewGroup = (ViewGroup) this.w.findViewById(R.id.content);
        viewGroup.removeAllViews();
        viewGroup.addView(view);
        this.h.a().onContentChanged();
    }

    public final boolean c(PanelFeatureState panelFeatureState) {
        Context context = this.f;
        int i2 = panelFeatureState.a;
        if ((i2 == 0 || i2 == 108) && this.m != null) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = context.getTheme();
            theme.resolveAttribute(defpackage.s.actionBarTheme, typedValue, true);
            Resources.Theme theme2 = null;
            if (typedValue.resourceId != 0) {
                theme2 = context.getResources().newTheme();
                theme2.setTo(theme);
                theme2.applyStyle(typedValue.resourceId, true);
                theme2.resolveAttribute(defpackage.s.actionBarWidgetTheme, typedValue, true);
            } else {
                theme.resolveAttribute(defpackage.s.actionBarWidgetTheme, typedValue, true);
            }
            if (typedValue.resourceId != 0) {
                if (theme2 == null) {
                    theme2 = context.getResources().newTheme();
                    theme2.setTo(theme);
                }
                theme2.applyStyle(typedValue.resourceId, true);
            }
            if (theme2 != null) {
                x0 x0Var = new x0(context, 0);
                x0Var.getTheme().setTo(theme2);
                context = x0Var;
            }
        }
        j1 j1Var = new j1(context);
        j1Var.a(this);
        panelFeatureState.a(j1Var);
        return true;
    }

    @Override // defpackage.g0
    public void a(View view, ViewGroup.LayoutParams layoutParams) {
        r();
        ((ViewGroup) this.w.findViewById(R.id.content)).addView(view, layoutParams);
        this.h.a().onContentChanged();
    }

    @Override // defpackage.g0
    public void b(Bundle bundle) {
        r();
    }

    @Override // defpackage.g0
    public MenuInflater b() {
        if (this.k == null) {
            w();
            c0 c0Var = this.j;
            this.k = new a1(c0Var != null ? c0Var.h() : this.f);
        }
        return this.k;
    }

    public final void a(Window window) {
        if (this.g == null) {
            Window.Callback callback = window.getCallback();
            if (!(callback instanceof j)) {
                j jVar = new j(callback);
                this.h = jVar;
                window.setCallback(jVar);
                q3 a2 = q3.a(this.f, (AttributeSet) null, d0);
                Drawable c2 = a2.c(0);
                if (c2 != null) {
                    window.setBackgroundDrawable(c2);
                }
                a2.b();
                this.g = window;
                return;
            }
            throw new IllegalStateException("AppCompat has already installed itself into the Window");
        }
        throw new IllegalStateException("AppCompat has already installed itself into the Window");
    }

    @Override // defpackage.g0
    public void b(View view, ViewGroup.LayoutParams layoutParams) {
        r();
        ViewGroup viewGroup = (ViewGroup) this.w.findViewById(R.id.content);
        viewGroup.removeAllViews();
        viewGroup.addView(view, layoutParams);
        this.h.a().onContentChanged();
    }

    @Override // defpackage.g0
    public boolean b(int i2) {
        int j2 = j(i2);
        if (this.F && j2 == 108) {
            return false;
        }
        if (this.B && j2 == 1) {
            this.B = false;
        }
        if (j2 == 1) {
            C();
            this.F = true;
            return true;
        }
        if (j2 == 2) {
            C();
            this.z = true;
            return true;
        }
        if (j2 == 5) {
            C();
            this.A = true;
            return true;
        }
        if (j2 == 10) {
            C();
            this.D = true;
            return true;
        }
        if (j2 == 108) {
            C();
            this.B = true;
            return true;
        }
        if (j2 != 109) {
            return this.g.requestFeature(j2);
        }
        C();
        this.C = true;
        return true;
    }

    @Override // defpackage.g0
    public final void a(CharSequence charSequence) {
        this.l = charSequence;
        w2 w2Var = this.m;
        if (w2Var != null) {
            w2Var.setWindowTitle(charSequence);
            return;
        }
        if (A() != null) {
            A().a(charSequence);
            return;
        }
        TextView textView = this.x;
        if (textView != null) {
            textView.setText(charSequence);
        }
    }

    public final l c(Context context) {
        if (this.T == null) {
            this.T = new k(context);
        }
        return this.T;
    }

    @Override // j1.a
    public boolean a(j1 j1Var, MenuItem menuItem) {
        PanelFeatureState a2;
        Window.Callback v = v();
        if (v == null || this.N || (a2 = a((Menu) j1Var.m())) == null) {
            return false;
        }
        return v.onMenuItemSelected(a2.a, menuItem);
    }

    @Override // j1.a
    public void a(j1 j1Var) {
        b(true);
    }

    public v0 a(v0.a aVar) {
        f0 f0Var;
        if (aVar != null) {
            v0 v0Var = this.p;
            if (v0Var != null) {
                v0Var.a();
            }
            i iVar = new i(aVar);
            c0 c2 = c();
            if (c2 != null) {
                v0 a2 = c2.a(iVar);
                this.p = a2;
                if (a2 != null && (f0Var = this.i) != null) {
                    f0Var.a(a2);
                }
            }
            if (this.p == null) {
                this.p = b(iVar);
            }
            return this.p;
        }
        throw new IllegalArgumentException("ActionMode callback can not be null.");
    }

    /* JADX WARN: Removed duplicated region for block: B:14:0x0025  */
    /* JADX WARN: Removed duplicated region for block: B:23:0x0029  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public defpackage.v0 b(v0.a r8) {
        /*
            Method dump skipped, instructions count: 367
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.appcompat.app.AppCompatDelegateImpl.b(v0$a):v0");
    }

    public boolean a(KeyEvent keyEvent) {
        View decorView;
        Object obj = this.e;
        if (((obj instanceof b9.a) || (obj instanceof h0)) && (decorView = this.g.getDecorView()) != null && b9.a(decorView, keyEvent)) {
            return true;
        }
        if (keyEvent.getKeyCode() == 82 && this.h.a().dispatchKeyEvent(keyEvent)) {
            return true;
        }
        int keyCode = keyEvent.getKeyCode();
        return keyEvent.getAction() == 0 ? a(keyCode, keyEvent) : d(keyCode, keyEvent);
    }

    public boolean a(int i2, KeyEvent keyEvent) {
        if (i2 == 4) {
            this.J = (keyEvent.getFlags() & 128) != 0;
        } else if (i2 == 82) {
            b(0, keyEvent);
            return true;
        }
        return false;
    }

    /* JADX WARN: Multi-variable type inference failed */
    public View a(View view, String str, Context context, AttributeSet attributeSet) {
        boolean z;
        boolean z2 = false;
        if (this.a0 == null) {
            String string = this.f.obtainStyledAttributes(b0.AppCompatTheme).getString(b0.AppCompatTheme_viewInflaterClass);
            if (string == null) {
                this.a0 = new i0();
            } else {
                try {
                    this.a0 = (i0) Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } catch (Throwable th) {
                    Log.i("AppCompatDelegate", "Failed to instantiate custom view inflater " + string + ". Falling back to default.", th);
                    this.a0 = new i0();
                }
            }
        }
        if (c0) {
            if (attributeSet instanceof XmlPullParser) {
                if (((XmlPullParser) attributeSet).getDepth() > 1) {
                    z2 = true;
                }
            } else {
                z2 = a((ViewParent) view);
            }
            z = z2;
        } else {
            z = false;
        }
        return this.a0.a(view, str, context, attributeSet, z, c0, true, v3.b());
    }

    public final boolean a(ViewParent viewParent) {
        if (viewParent == null) {
            return false;
        }
        View decorView = this.g.getDecorView();
        while (viewParent != null) {
            if (viewParent == decorView || !(viewParent instanceof View) || q9.q((View) viewParent)) {
                return false;
            }
            viewParent = viewParent.getParent();
        }
        return true;
    }

    public final void a(PanelFeatureState panelFeatureState, KeyEvent keyEvent) {
        int i2;
        ViewGroup.LayoutParams layoutParams;
        if (panelFeatureState.o || this.N) {
            return;
        }
        if (panelFeatureState.a == 0) {
            if ((this.f.getResources().getConfiguration().screenLayout & 15) == 4) {
                return;
            }
        }
        Window.Callback v = v();
        if (v != null && !v.onMenuOpened(panelFeatureState.a, panelFeatureState.j)) {
            a(panelFeatureState, true);
            return;
        }
        WindowManager windowManager = (WindowManager) this.f.getSystemService("window");
        if (windowManager != null && b(panelFeatureState, keyEvent)) {
            if (panelFeatureState.g != null && !panelFeatureState.q) {
                View view = panelFeatureState.i;
                if (view != null && (layoutParams = view.getLayoutParams()) != null && layoutParams.width == -1) {
                    i2 = -1;
                    panelFeatureState.n = false;
                    WindowManager.LayoutParams layoutParams2 = new WindowManager.LayoutParams(i2, -2, panelFeatureState.d, panelFeatureState.e, 1002, 8519680, -3);
                    layoutParams2.gravity = panelFeatureState.c;
                    layoutParams2.windowAnimations = panelFeatureState.f;
                    windowManager.addView(panelFeatureState.g, layoutParams2);
                    panelFeatureState.o = true;
                }
            } else {
                ViewGroup viewGroup = panelFeatureState.g;
                if (viewGroup == null) {
                    if (!b(panelFeatureState) || panelFeatureState.g == null) {
                        return;
                    }
                } else if (panelFeatureState.q && viewGroup.getChildCount() > 0) {
                    panelFeatureState.g.removeAllViews();
                }
                if (a(panelFeatureState) && panelFeatureState.a()) {
                    ViewGroup.LayoutParams layoutParams3 = panelFeatureState.h.getLayoutParams();
                    if (layoutParams3 == null) {
                        layoutParams3 = new ViewGroup.LayoutParams(-2, -2);
                    }
                    panelFeatureState.g.setBackgroundResource(panelFeatureState.b);
                    ViewParent parent = panelFeatureState.h.getParent();
                    if (parent instanceof ViewGroup) {
                        ((ViewGroup) parent).removeView(panelFeatureState.h);
                    }
                    panelFeatureState.g.addView(panelFeatureState.h, layoutParams3);
                    if (!panelFeatureState.h.hasFocus()) {
                        panelFeatureState.h.requestFocus();
                    }
                } else {
                    panelFeatureState.q = true;
                    return;
                }
            }
            i2 = -2;
            panelFeatureState.n = false;
            WindowManager.LayoutParams layoutParams22 = new WindowManager.LayoutParams(i2, -2, panelFeatureState.d, panelFeatureState.e, 1002, 8519680, -3);
            layoutParams22.gravity = panelFeatureState.c;
            layoutParams22.windowAnimations = panelFeatureState.f;
            windowManager.addView(panelFeatureState.g, layoutParams22);
            panelFeatureState.o = true;
        }
    }

    public final boolean b(PanelFeatureState panelFeatureState) {
        panelFeatureState.a(t());
        panelFeatureState.g = new r(panelFeatureState.l);
        panelFeatureState.c = 81;
        return true;
    }

    public final void b(boolean z) {
        w2 w2Var = this.m;
        if (w2Var != null && w2Var.f() && (!ViewConfiguration.get(this.f).hasPermanentMenuKey() || this.m.c())) {
            Window.Callback v = v();
            if (this.m.a() && z) {
                this.m.d();
                if (this.N) {
                    return;
                }
                v.onPanelClosed(108, a(0, true).j);
                return;
            }
            if (v == null || this.N) {
                return;
            }
            if (this.U && (this.V & 1) != 0) {
                this.g.getDecorView().removeCallbacks(this.W);
                this.W.run();
            }
            PanelFeatureState a2 = a(0, true);
            j1 j1Var = a2.j;
            if (j1Var == null || a2.r || !v.onPreparePanel(0, a2.i, j1Var)) {
                return;
            }
            v.onMenuOpened(108, a2.j);
            this.m.e();
            return;
        }
        PanelFeatureState a3 = a(0, true);
        a3.q = true;
        a(a3, false);
        a(a3, (KeyEvent) null);
    }

    public final boolean a(PanelFeatureState panelFeatureState) {
        View view = panelFeatureState.i;
        if (view != null) {
            panelFeatureState.h = view;
            return true;
        }
        if (panelFeatureState.j == null) {
            return false;
        }
        if (this.o == null) {
            this.o = new s();
        }
        View view2 = (View) panelFeatureState.a(this.o);
        panelFeatureState.h = view2;
        return view2 != null;
    }

    public void a(PanelFeatureState panelFeatureState, boolean z) {
        ViewGroup viewGroup;
        w2 w2Var;
        if (z && panelFeatureState.a == 0 && (w2Var = this.m) != null && w2Var.a()) {
            b(panelFeatureState.j);
            return;
        }
        WindowManager windowManager = (WindowManager) this.f.getSystemService("window");
        if (windowManager != null && panelFeatureState.o && (viewGroup = panelFeatureState.g) != null) {
            windowManager.removeView(viewGroup);
            if (z) {
                a(panelFeatureState.a, panelFeatureState, (Menu) null);
            }
        }
        panelFeatureState.m = false;
        panelFeatureState.n = false;
        panelFeatureState.o = false;
        panelFeatureState.h = null;
        panelFeatureState.q = true;
        if (this.I == panelFeatureState) {
            this.I = null;
        }
    }

    public final boolean b(PanelFeatureState panelFeatureState, KeyEvent keyEvent) {
        w2 w2Var;
        w2 w2Var2;
        w2 w2Var3;
        if (this.N) {
            return false;
        }
        if (panelFeatureState.m) {
            return true;
        }
        PanelFeatureState panelFeatureState2 = this.I;
        if (panelFeatureState2 != null && panelFeatureState2 != panelFeatureState) {
            a(panelFeatureState2, false);
        }
        Window.Callback v = v();
        if (v != null) {
            panelFeatureState.i = v.onCreatePanelView(panelFeatureState.a);
        }
        int i2 = panelFeatureState.a;
        boolean z = i2 == 0 || i2 == 108;
        if (z && (w2Var3 = this.m) != null) {
            w2Var3.b();
        }
        if (panelFeatureState.i == null) {
            if (z) {
                A();
            }
            if (panelFeatureState.j == null || panelFeatureState.r) {
                if (panelFeatureState.j == null && (!c(panelFeatureState) || panelFeatureState.j == null)) {
                    return false;
                }
                if (z && this.m != null) {
                    if (this.n == null) {
                        this.n = new h();
                    }
                    this.m.a(panelFeatureState.j, this.n);
                }
                panelFeatureState.j.s();
                if (!v.onCreatePanelMenu(panelFeatureState.a, panelFeatureState.j)) {
                    panelFeatureState.a((j1) null);
                    if (z && (w2Var = this.m) != null) {
                        w2Var.a(null, this.n);
                    }
                    return false;
                }
                panelFeatureState.r = false;
            }
            panelFeatureState.j.s();
            Bundle bundle = panelFeatureState.s;
            if (bundle != null) {
                panelFeatureState.j.a(bundle);
                panelFeatureState.s = null;
            }
            if (!v.onPreparePanel(0, panelFeatureState.i, panelFeatureState.j)) {
                if (z && (w2Var2 = this.m) != null) {
                    w2Var2.a(null, this.n);
                }
                panelFeatureState.j.r();
                return false;
            }
            boolean z2 = KeyCharacterMap.load(keyEvent != null ? keyEvent.getDeviceId() : -1).getKeyboardType() != 1;
            panelFeatureState.p = z2;
            panelFeatureState.j.setQwertyMode(z2);
            panelFeatureState.j.r();
        }
        panelFeatureState.m = true;
        panelFeatureState.n = false;
        this.I = panelFeatureState;
        return true;
    }

    public void a(int i2, PanelFeatureState panelFeatureState, Menu menu) {
        if (menu == null) {
            if (panelFeatureState == null && i2 >= 0) {
                PanelFeatureState[] panelFeatureStateArr = this.H;
                if (i2 < panelFeatureStateArr.length) {
                    panelFeatureState = panelFeatureStateArr[i2];
                }
            }
            if (panelFeatureState != null) {
                menu = panelFeatureState.j;
            }
        }
        if ((panelFeatureState == null || panelFeatureState.o) && !this.N) {
            this.h.a().onPanelClosed(i2, menu);
        }
    }

    public PanelFeatureState a(Menu menu) {
        PanelFeatureState[] panelFeatureStateArr = this.H;
        int length = panelFeatureStateArr != null ? panelFeatureStateArr.length : 0;
        for (int i2 = 0; i2 < length; i2++) {
            PanelFeatureState panelFeatureState = panelFeatureStateArr[i2];
            if (panelFeatureState != null && panelFeatureState.j == menu) {
                return panelFeatureState;
            }
        }
        return null;
    }

    public PanelFeatureState a(int i2, boolean z) {
        PanelFeatureState[] panelFeatureStateArr = this.H;
        if (panelFeatureStateArr == null || panelFeatureStateArr.length <= i2) {
            PanelFeatureState[] panelFeatureStateArr2 = new PanelFeatureState[i2 + 1];
            if (panelFeatureStateArr != null) {
                System.arraycopy(panelFeatureStateArr, 0, panelFeatureStateArr2, 0, panelFeatureStateArr.length);
            }
            this.H = panelFeatureStateArr2;
            panelFeatureStateArr = panelFeatureStateArr2;
        }
        PanelFeatureState panelFeatureState = panelFeatureStateArr[i2];
        if (panelFeatureState != null) {
            return panelFeatureState;
        }
        PanelFeatureState panelFeatureState2 = new PanelFeatureState(i2);
        panelFeatureStateArr[i2] = panelFeatureState2;
        return panelFeatureState2;
    }

    public final boolean a(PanelFeatureState panelFeatureState, int i2, KeyEvent keyEvent, int i3) {
        j1 j1Var;
        boolean z = false;
        if (keyEvent.isSystem()) {
            return false;
        }
        if ((panelFeatureState.m || b(panelFeatureState, keyEvent)) && (j1Var = panelFeatureState.j) != null) {
            z = j1Var.performShortcut(i2, keyEvent, i3);
        }
        if (z && (i3 & 1) == 0 && this.m == null) {
            a(panelFeatureState, true);
        }
        return z;
    }

    public final int a(y9 y9Var, Rect rect) {
        int i2;
        boolean z;
        boolean z2;
        if (y9Var != null) {
            i2 = y9Var.i();
        } else {
            i2 = rect != null ? rect.top : 0;
        }
        ActionBarContextView actionBarContextView = this.q;
        if (actionBarContextView == null || !(actionBarContextView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
            z = false;
        } else {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.q.getLayoutParams();
            if (this.q.isShown()) {
                if (this.Y == null) {
                    this.Y = new Rect();
                    this.Z = new Rect();
                }
                Rect rect2 = this.Y;
                Rect rect3 = this.Z;
                if (y9Var == null) {
                    rect2.set(rect);
                } else {
                    rect2.set(y9Var.g(), y9Var.i(), y9Var.h(), y9Var.f());
                }
                w3.a(this.w, rect2, rect3);
                int i3 = rect2.top;
                int i4 = rect2.left;
                int i5 = rect2.right;
                y9 k2 = q9.k(this.w);
                int g2 = k2 == null ? 0 : k2.g();
                int h2 = k2 == null ? 0 : k2.h();
                if (marginLayoutParams.topMargin == i3 && marginLayoutParams.leftMargin == i4 && marginLayoutParams.rightMargin == i5) {
                    z2 = false;
                } else {
                    marginLayoutParams.topMargin = i3;
                    marginLayoutParams.leftMargin = i4;
                    marginLayoutParams.rightMargin = i5;
                    z2 = true;
                }
                if (i3 > 0 && this.y == null) {
                    View view = new View(this.f);
                    this.y = view;
                    view.setVisibility(8);
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, marginLayoutParams.topMargin, 51);
                    layoutParams.leftMargin = g2;
                    layoutParams.rightMargin = h2;
                    this.w.addView(this.y, -1, layoutParams);
                } else {
                    View view2 = this.y;
                    if (view2 != null) {
                        ViewGroup.MarginLayoutParams marginLayoutParams2 = (ViewGroup.MarginLayoutParams) view2.getLayoutParams();
                        if (marginLayoutParams2.height != marginLayoutParams.topMargin || marginLayoutParams2.leftMargin != g2 || marginLayoutParams2.rightMargin != h2) {
                            marginLayoutParams2.height = marginLayoutParams.topMargin;
                            marginLayoutParams2.leftMargin = g2;
                            marginLayoutParams2.rightMargin = h2;
                            this.y.setLayoutParams(marginLayoutParams2);
                        }
                    }
                }
                r5 = this.y != null;
                if (r5 && this.y.getVisibility() != 0) {
                    b(this.y);
                }
                if (!this.D && r5) {
                    i2 = 0;
                }
                z = r5;
                r5 = z2;
            } else if (marginLayoutParams.topMargin != 0) {
                marginLayoutParams.topMargin = 0;
                z = false;
            } else {
                z = false;
                r5 = false;
            }
            if (r5) {
                this.q.setLayoutParams(marginLayoutParams);
            }
        }
        View view3 = this.y;
        if (view3 != null) {
            view3.setVisibility(z ? 0 : 8);
        }
        return i2;
    }

    public void b(j1 j1Var) {
        if (this.G) {
            return;
        }
        this.G = true;
        this.m.g();
        Window.Callback v = v();
        if (v != null && !this.N) {
            v.onPanelClosed(108, j1Var);
        }
        this.G = false;
    }

    public final boolean b(int i2, KeyEvent keyEvent) {
        if (keyEvent.getRepeatCount() != 0) {
            return false;
        }
        PanelFeatureState a2 = a(i2, true);
        if (a2.o) {
            return false;
        }
        return b(a2, keyEvent);
    }

    public final void b(View view) {
        int a2;
        if ((q9.n(view) & ErrorCode.SENSOR_MAGNETIC_TIMESTAMP_ERROR) != 0) {
            a2 = e7.a(this.f, u.abc_decor_view_status_guard_light);
        } else {
            a2 = e7.a(this.f, u.abc_decor_view_status_guard);
        }
        view.setBackgroundColor(a2);
    }

    /* JADX WARN: Removed duplicated region for block: B:20:0x0053  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public final boolean b(int r7, boolean r8) {
        /*
            r6 = this;
            android.content.Context r0 = r6.f
            r1 = 0
            android.content.res.Configuration r0 = r6.a(r0, r7, r1)
            boolean r2 = r6.x()
            android.content.Context r3 = r6.f
            android.content.res.Resources r3 = r3.getResources()
            android.content.res.Configuration r3 = r3.getConfiguration()
            int r3 = r3.uiMode
            r3 = r3 & 48
            int r0 = r0.uiMode
            r0 = r0 & 48
            r4 = 1
            if (r3 == r0) goto L47
            if (r8 == 0) goto L47
            if (r2 != 0) goto L47
            boolean r8 = r6.K
            if (r8 == 0) goto L47
            boolean r8 = androidx.appcompat.app.AppCompatDelegateImpl.e0
            if (r8 != 0) goto L30
            boolean r8 = r6.L
            if (r8 == 0) goto L47
        L30:
            java.lang.Object r8 = r6.e
            boolean r5 = r8 instanceof android.app.Activity
            if (r5 == 0) goto L47
            android.app.Activity r8 = (android.app.Activity) r8
            boolean r8 = r8.isChild()
            if (r8 != 0) goto L47
            java.lang.Object r8 = r6.e
            android.app.Activity r8 = (android.app.Activity) r8
            defpackage.q6.b(r8)
            r8 = 1
            goto L48
        L47:
            r8 = 0
        L48:
            if (r8 != 0) goto L50
            if (r3 == r0) goto L50
            r6.a(r0, r2, r1)
            goto L51
        L50:
            r4 = r8
        L51:
            if (r4 == 0) goto L5e
            java.lang.Object r8 = r6.e
            boolean r0 = r8 instanceof defpackage.e0
            if (r0 == 0) goto L5e
            e0 r8 = (defpackage.e0) r8
            r8.c(r7)
        L5e:
            return r4
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.appcompat.app.AppCompatDelegateImpl.b(int, boolean):boolean");
    }

    public final boolean a(boolean z) {
        if (this.N) {
            return false;
        }
        int m2 = m();
        boolean b2 = b(a(this.f, m2), z);
        if (m2 == 0) {
            d(this.f).e();
        } else {
            l lVar = this.S;
            if (lVar != null) {
                lVar.a();
            }
        }
        if (m2 == 3) {
            c(this.f).e();
        } else {
            l lVar2 = this.T;
            if (lVar2 != null) {
                lVar2.a();
            }
        }
        return b2;
    }

    @Override // defpackage.g0
    public int a() {
        return this.O;
    }

    public int a(Context context, int i2) {
        if (i2 == -100) {
            return -1;
        }
        if (i2 != -1) {
            if (i2 == 0) {
                if (Build.VERSION.SDK_INT < 23 || ((UiModeManager) context.getApplicationContext().getSystemService(UiModeManager.class)).getNightMode() != 0) {
                    return d(context).c();
                }
                return -1;
            }
            if (i2 != 1 && i2 != 2) {
                if (i2 == 3) {
                    return c(context).c();
                }
                throw new IllegalStateException("Unknown value set for night mode. Please use one of the MODE_NIGHT values from AppCompatDelegate.");
            }
        }
        return i2;
    }

    public final Configuration a(Context context, int i2, Configuration configuration) {
        int i3;
        if (i2 != 1) {
            i3 = i2 != 2 ? context.getApplicationContext().getResources().getConfiguration().uiMode & 48 : 32;
        } else {
            i3 = 16;
        }
        Configuration configuration2 = new Configuration();
        configuration2.fontScale = 0.0f;
        if (configuration != null) {
            configuration2.setTo(configuration);
        }
        configuration2.uiMode = i3 | (configuration2.uiMode & (-49));
        return configuration2;
    }

    /* JADX WARN: Multi-variable type inference failed */
    public final void a(int i2, boolean z, Configuration configuration) {
        Resources resources = this.f.getResources();
        Configuration configuration2 = new Configuration(resources.getConfiguration());
        if (configuration != null) {
            configuration2.updateFrom(configuration);
        }
        configuration2.uiMode = i2 | (resources.getConfiguration().uiMode & (-49));
        resources.updateConfiguration(configuration2, null);
        if (Build.VERSION.SDK_INT < 26) {
            j0.a(resources);
        }
        int i3 = this.P;
        if (i3 != 0) {
            this.f.setTheme(i3);
            if (Build.VERSION.SDK_INT >= 23) {
                this.f.getTheme().applyStyle(this.P, true);
            }
        }
        if (z) {
            Object obj = this.e;
            if (obj instanceof Activity) {
                Activity activity = (Activity) obj;
                if (activity instanceof tb) {
                    if (((tb) activity).a().a().a(qb.b.STARTED)) {
                        activity.onConfigurationChanged(configuration2);
                    }
                } else if (this.M) {
                    activity.onConfigurationChanged(configuration2);
                }
            }
        }
    }

    public static Configuration a(Configuration configuration, Configuration configuration2) {
        Configuration configuration3 = new Configuration();
        configuration3.fontScale = 0.0f;
        if (configuration2 != null && configuration.diff(configuration2) != 0) {
            float f2 = configuration.fontScale;
            float f3 = configuration2.fontScale;
            if (f2 != f3) {
                configuration3.fontScale = f3;
            }
            int i2 = configuration.mcc;
            int i3 = configuration2.mcc;
            if (i2 != i3) {
                configuration3.mcc = i3;
            }
            int i4 = configuration.mnc;
            int i5 = configuration2.mnc;
            if (i4 != i5) {
                configuration3.mnc = i5;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                o.a(configuration, configuration2, configuration3);
            } else if (!u8.a(configuration.locale, configuration2.locale)) {
                configuration3.locale = configuration2.locale;
            }
            int i6 = configuration.touchscreen;
            int i7 = configuration2.touchscreen;
            if (i6 != i7) {
                configuration3.touchscreen = i7;
            }
            int i8 = configuration.keyboard;
            int i9 = configuration2.keyboard;
            if (i8 != i9) {
                configuration3.keyboard = i9;
            }
            int i10 = configuration.keyboardHidden;
            int i11 = configuration2.keyboardHidden;
            if (i10 != i11) {
                configuration3.keyboardHidden = i11;
            }
            int i12 = configuration.navigation;
            int i13 = configuration2.navigation;
            if (i12 != i13) {
                configuration3.navigation = i13;
            }
            int i14 = configuration.navigationHidden;
            int i15 = configuration2.navigationHidden;
            if (i14 != i15) {
                configuration3.navigationHidden = i15;
            }
            int i16 = configuration.orientation;
            int i17 = configuration2.orientation;
            if (i16 != i17) {
                configuration3.orientation = i17;
            }
            int i18 = configuration.screenLayout & 15;
            int i19 = configuration2.screenLayout;
            if (i18 != (i19 & 15)) {
                configuration3.screenLayout |= i19 & 15;
            }
            int i20 = configuration.screenLayout & 192;
            int i21 = configuration2.screenLayout;
            if (i20 != (i21 & 192)) {
                configuration3.screenLayout |= i21 & 192;
            }
            int i22 = configuration.screenLayout & 48;
            int i23 = configuration2.screenLayout;
            if (i22 != (i23 & 48)) {
                configuration3.screenLayout |= i23 & 48;
            }
            int i24 = configuration.screenLayout & 768;
            int i25 = configuration2.screenLayout;
            if (i24 != (i25 & 768)) {
                configuration3.screenLayout |= i25 & 768;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                p.a(configuration, configuration2, configuration3);
            }
            int i26 = configuration.uiMode & 15;
            int i27 = configuration2.uiMode;
            if (i26 != (i27 & 15)) {
                configuration3.uiMode |= i27 & 15;
            }
            int i28 = configuration.uiMode & 48;
            int i29 = configuration2.uiMode;
            if (i28 != (i29 & 48)) {
                configuration3.uiMode |= i29 & 48;
            }
            int i30 = configuration.screenWidthDp;
            int i31 = configuration2.screenWidthDp;
            if (i30 != i31) {
                configuration3.screenWidthDp = i31;
            }
            int i32 = configuration.screenHeightDp;
            int i33 = configuration2.screenHeightDp;
            if (i32 != i33) {
                configuration3.screenHeightDp = i33;
            }
            int i34 = configuration.smallestScreenWidthDp;
            int i35 = configuration2.smallestScreenWidthDp;
            if (i34 != i35) {
                configuration3.smallestScreenWidthDp = i35;
            }
            if (Build.VERSION.SDK_INT >= 17) {
                n.a(configuration, configuration2, configuration3);
            }
        }
        return configuration3;
    }
}
