package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.ActionMenuView;
import defpackage.b0;
import defpackage.b3;
import defpackage.j1;
import defpackage.l1;
import defpackage.q1;
import defpackage.s1;
import defpackage.s3;
import defpackage.t2;

/* loaded from: classes.dex */
public class ActionMenuItemView extends t2 implements q1.a, View.OnClickListener, ActionMenuView.a {
    public l1 f;
    public CharSequence g;
    public Drawable h;
    public j1.b i;
    public b3 j;
    public b k;
    public boolean l;
    public boolean m;
    public int n;
    public int o;
    public int p;

    /* loaded from: classes.dex */
    public class a extends b3 {
        public a() {
            super(ActionMenuItemView.this);
        }

        @Override // defpackage.b3
        public s1 b() {
            b bVar = ActionMenuItemView.this.k;
            if (bVar != null) {
                return bVar.a();
            }
            return null;
        }

        @Override // defpackage.b3
        public boolean c() {
            s1 b;
            ActionMenuItemView actionMenuItemView = ActionMenuItemView.this;
            j1.b bVar = actionMenuItemView.i;
            return bVar != null && bVar.a(actionMenuItemView.f) && (b = b()) != null && b.a();
        }
    }

    /* loaded from: classes.dex */
    public static abstract class b {
        public abstract s1 a();
    }

    public ActionMenuItemView(Context context) {
        this(context, null);
    }

    @Override // q1.a
    public void a(l1 l1Var, int i) {
        this.f = l1Var;
        setIcon(l1Var.getIcon());
        setTitle(l1Var.a(this));
        setId(l1Var.getItemId());
        setVisibility(l1Var.isVisible() ? 0 : 8);
        setEnabled(l1Var.isEnabled());
        if (l1Var.hasSubMenu() && this.j == null) {
            this.j = new a();
        }
    }

    @Override // q1.a
    public boolean a() {
        return true;
    }

    @Override // androidx.appcompat.widget.ActionMenuView.a
    public boolean b() {
        return e();
    }

    @Override // androidx.appcompat.widget.ActionMenuView.a
    public boolean c() {
        return e() && this.f.getIcon() == null;
    }

    public boolean e() {
        return !TextUtils.isEmpty(getText());
    }

    public final boolean f() {
        Configuration configuration = getContext().getResources().getConfiguration();
        int i = configuration.screenWidthDp;
        return i >= 480 || (i >= 640 && configuration.screenHeightDp >= 480) || configuration.orientation == 2;
    }

    public final void g() {
        boolean z = true;
        boolean z2 = !TextUtils.isEmpty(this.g);
        if (this.h != null && (!this.f.n() || (!this.l && !this.m))) {
            z = false;
        }
        boolean z3 = z2 & z;
        setText(z3 ? this.g : null);
        CharSequence contentDescription = this.f.getContentDescription();
        if (TextUtils.isEmpty(contentDescription)) {
            setContentDescription(z3 ? null : this.f.getTitle());
        } else {
            setContentDescription(contentDescription);
        }
        CharSequence tooltipText = this.f.getTooltipText();
        if (TextUtils.isEmpty(tooltipText)) {
            s3.a(this, z3 ? null : this.f.getTitle());
        } else {
            s3.a(this, tooltipText);
        }
    }

    @Override // q1.a
    public l1 getItemData() {
        return this.f;
    }

    @Override // android.view.View.OnClickListener
    public void onClick(View view) {
        j1.b bVar = this.i;
        if (bVar != null) {
            bVar.a(this.f);
        }
    }

    @Override // android.widget.TextView, android.view.View
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.l = f();
        g();
    }

    @Override // defpackage.t2, android.widget.TextView, android.view.View
    public void onMeasure(int i, int i2) {
        int i3;
        int i4;
        boolean e = e();
        if (e && (i4 = this.o) >= 0) {
            super.setPadding(i4, getPaddingTop(), getPaddingRight(), getPaddingBottom());
        }
        super.onMeasure(i, i2);
        int mode = View.MeasureSpec.getMode(i);
        int size = View.MeasureSpec.getSize(i);
        int measuredWidth = getMeasuredWidth();
        if (mode == Integer.MIN_VALUE) {
            i3 = Math.min(size, this.n);
        } else {
            i3 = this.n;
        }
        if (mode != 1073741824 && this.n > 0 && measuredWidth < i3) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec(i3, 1073741824), i2);
        }
        if (e || this.h == null) {
            return;
        }
        super.setPadding((getMeasuredWidth() - this.h.getBounds().width()) / 2, getPaddingTop(), getPaddingRight(), getPaddingBottom());
    }

    @Override // android.widget.TextView, android.view.View
    public void onRestoreInstanceState(Parcelable parcelable) {
        super.onRestoreInstanceState(null);
    }

    @Override // android.widget.TextView, android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        b3 b3Var;
        if (this.f.hasSubMenu() && (b3Var = this.j) != null && b3Var.onTouch(this, motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setCheckable(boolean z) {
    }

    public void setChecked(boolean z) {
    }

    public void setExpandedFormat(boolean z) {
        if (this.m != z) {
            this.m = z;
            l1 l1Var = this.f;
            if (l1Var != null) {
                l1Var.b();
            }
        }
    }

    public void setIcon(Drawable drawable) {
        this.h = drawable;
        if (drawable != null) {
            int intrinsicWidth = drawable.getIntrinsicWidth();
            int intrinsicHeight = drawable.getIntrinsicHeight();
            int i = this.p;
            if (intrinsicWidth > i) {
                intrinsicHeight = (int) (intrinsicHeight * (i / intrinsicWidth));
                intrinsicWidth = i;
            }
            int i2 = this.p;
            if (intrinsicHeight > i2) {
                intrinsicWidth = (int) (intrinsicWidth * (i2 / intrinsicHeight));
                intrinsicHeight = i2;
            }
            drawable.setBounds(0, 0, intrinsicWidth, intrinsicHeight);
        }
        setCompoundDrawables(drawable, null, null, null);
        g();
    }

    public void setItemInvoker(j1.b bVar) {
        this.i = bVar;
    }

    @Override // android.widget.TextView, android.view.View
    public void setPadding(int i, int i2, int i3, int i4) {
        this.o = i;
        super.setPadding(i, i2, i3, i4);
    }

    public void setPopupCallback(b bVar) {
        this.k = bVar;
    }

    public void setTitle(CharSequence charSequence) {
        this.g = charSequence;
        g();
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        Resources resources = context.getResources();
        this.l = f();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, b0.ActionMenuItemView, i, 0);
        this.n = obtainStyledAttributes.getDimensionPixelSize(b0.ActionMenuItemView_android_minWidth, 0);
        obtainStyledAttributes.recycle();
        this.p = (int) ((resources.getDisplayMetrics().density * 32.0f) + 0.5f);
        setOnClickListener(this);
        this.o = -1;
        setSaveEnabled(false);
    }
}
