package androidx.appcompat.view.menu;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import defpackage.b0;
import defpackage.l1;
import defpackage.q1;
import defpackage.q3;
import defpackage.q9;
import defpackage.s;
import defpackage.x;
import defpackage.y;

/* loaded from: classes.dex */
public class ListMenuItemView extends LinearLayout implements q1.a, AbsListView.SelectionBoundsAdjuster {
    public l1 a;
    public ImageView c;
    public RadioButton d;
    public TextView e;
    public CheckBox f;
    public TextView g;
    public ImageView h;
    public ImageView i;
    public LinearLayout j;
    public Drawable k;
    public int l;
    public Context m;
    public boolean n;
    public Drawable o;
    public boolean p;
    public LayoutInflater q;
    public boolean r;

    public ListMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, s.listMenuViewStyle);
    }

    private LayoutInflater getInflater() {
        if (this.q == null) {
            this.q = LayoutInflater.from(getContext());
        }
        return this.q;
    }

    private void setSubMenuArrowVisible(boolean z) {
        ImageView imageView = this.h;
        if (imageView != null) {
            imageView.setVisibility(z ? 0 : 8);
        }
    }

    @Override // q1.a
    public void a(l1 l1Var, int i) {
        this.a = l1Var;
        setVisibility(l1Var.isVisible() ? 0 : 8);
        setTitle(l1Var.a(this));
        setCheckable(l1Var.isCheckable());
        a(l1Var.m(), l1Var.d());
        setIcon(l1Var.getIcon());
        setEnabled(l1Var.isEnabled());
        setSubMenuArrowVisible(l1Var.hasSubMenu());
        setContentDescription(l1Var.getContentDescription());
    }

    @Override // q1.a
    public boolean a() {
        return false;
    }

    @Override // android.widget.AbsListView.SelectionBoundsAdjuster
    public void adjustListItemSelectionBounds(Rect rect) {
        ImageView imageView = this.i;
        if (imageView == null || imageView.getVisibility() != 0) {
            return;
        }
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) this.i.getLayoutParams();
        rect.top += this.i.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
    }

    public final void b() {
        CheckBox checkBox = (CheckBox) getInflater().inflate(y.abc_list_menu_item_checkbox, (ViewGroup) this, false);
        this.f = checkBox;
        a(checkBox);
    }

    public final void c() {
        ImageView imageView = (ImageView) getInflater().inflate(y.abc_list_menu_item_icon, (ViewGroup) this, false);
        this.c = imageView;
        a(imageView, 0);
    }

    public final void d() {
        RadioButton radioButton = (RadioButton) getInflater().inflate(y.abc_list_menu_item_radio, (ViewGroup) this, false);
        this.d = radioButton;
        a(radioButton);
    }

    @Override // q1.a
    public l1 getItemData() {
        return this.a;
    }

    @Override // android.view.View
    public void onFinishInflate() {
        super.onFinishInflate();
        q9.a(this, this.k);
        TextView textView = (TextView) findViewById(x.title);
        this.e = textView;
        int i = this.l;
        if (i != -1) {
            textView.setTextAppearance(this.m, i);
        }
        this.g = (TextView) findViewById(x.shortcut);
        ImageView imageView = (ImageView) findViewById(x.submenuarrow);
        this.h = imageView;
        if (imageView != null) {
            imageView.setImageDrawable(this.o);
        }
        this.i = (ImageView) findViewById(x.group_divider);
        this.j = (LinearLayout) findViewById(x.content);
    }

    @Override // android.widget.LinearLayout, android.view.View
    public void onMeasure(int i, int i2) {
        if (this.c != null && this.n) {
            ViewGroup.LayoutParams layoutParams = getLayoutParams();
            LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams) this.c.getLayoutParams();
            int i3 = layoutParams.height;
            if (i3 > 0 && layoutParams2.width <= 0) {
                layoutParams2.width = i3;
            }
        }
        super.onMeasure(i, i2);
    }

    public void setCheckable(boolean z) {
        CompoundButton compoundButton;
        CompoundButton compoundButton2;
        if (!z && this.d == null && this.f == null) {
            return;
        }
        if (this.a.i()) {
            if (this.d == null) {
                d();
            }
            compoundButton = this.d;
            compoundButton2 = this.f;
        } else {
            if (this.f == null) {
                b();
            }
            compoundButton = this.f;
            compoundButton2 = this.d;
        }
        if (z) {
            compoundButton.setChecked(this.a.isChecked());
            if (compoundButton.getVisibility() != 0) {
                compoundButton.setVisibility(0);
            }
            if (compoundButton2 == null || compoundButton2.getVisibility() == 8) {
                return;
            }
            compoundButton2.setVisibility(8);
            return;
        }
        CheckBox checkBox = this.f;
        if (checkBox != null) {
            checkBox.setVisibility(8);
        }
        RadioButton radioButton = this.d;
        if (radioButton != null) {
            radioButton.setVisibility(8);
        }
    }

    public void setChecked(boolean z) {
        CompoundButton compoundButton;
        if (this.a.i()) {
            if (this.d == null) {
                d();
            }
            compoundButton = this.d;
        } else {
            if (this.f == null) {
                b();
            }
            compoundButton = this.f;
        }
        compoundButton.setChecked(z);
    }

    public void setForceShowIcon(boolean z) {
        this.r = z;
        this.n = z;
    }

    public void setGroupDividerEnabled(boolean z) {
        ImageView imageView = this.i;
        if (imageView != null) {
            imageView.setVisibility((this.p || !z) ? 8 : 0);
        }
    }

    public void setIcon(Drawable drawable) {
        boolean z = this.a.l() || this.r;
        if (z || this.n) {
            if (this.c == null && drawable == null && !this.n) {
                return;
            }
            if (this.c == null) {
                c();
            }
            if (drawable == null && !this.n) {
                this.c.setVisibility(8);
                return;
            }
            ImageView imageView = this.c;
            if (!z) {
                drawable = null;
            }
            imageView.setImageDrawable(drawable);
            if (this.c.getVisibility() != 0) {
                this.c.setVisibility(0);
            }
        }
    }

    public void setTitle(CharSequence charSequence) {
        if (charSequence != null) {
            this.e.setText(charSequence);
            if (this.e.getVisibility() != 0) {
                this.e.setVisibility(0);
                return;
            }
            return;
        }
        if (this.e.getVisibility() != 8) {
            this.e.setVisibility(8);
        }
    }

    public ListMenuItemView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet);
        q3 a = q3.a(getContext(), attributeSet, b0.MenuView, i, 0);
        this.k = a.b(b0.MenuView_android_itemBackground);
        this.l = a.g(b0.MenuView_android_itemTextAppearance, -1);
        this.n = a.a(b0.MenuView_preserveIconSpacing, false);
        this.m = context;
        this.o = a.b(b0.MenuView_subMenuArrow);
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(null, new int[]{R.attr.divider}, s.dropDownListViewStyle, 0);
        this.p = obtainStyledAttributes.hasValue(0);
        a.b();
        obtainStyledAttributes.recycle();
    }

    public final void a(View view) {
        a(view, -1);
    }

    public final void a(View view, int i) {
        LinearLayout linearLayout = this.j;
        if (linearLayout != null) {
            linearLayout.addView(view, i);
        } else {
            addView(view, i);
        }
    }

    public void a(boolean z, char c) {
        int i = (z && this.a.m()) ? 0 : 8;
        if (i == 0) {
            this.g.setText(this.a.e());
        }
        if (this.g.getVisibility() != i) {
            this.g.setVisibility(i);
        }
    }
}
