package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseBooleanArray;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.widget.ActionMenuView;
import defpackage.b3;
import defpackage.e1;
import defpackage.j1;
import defpackage.j2;
import defpackage.l1;
import defpackage.o1;
import defpackage.p1;
import defpackage.q1;
import defpackage.s;
import defpackage.s1;
import defpackage.s3;
import defpackage.u0;
import defpackage.u1;
import defpackage.y;
import defpackage.y8;
import defpackage.z7;
import java.util.ArrayList;

/* loaded from: classes.dex */
public class ActionMenuPresenter extends e1 implements y8.a {
    public b A;
    public final f B;
    public int C;
    public d j;
    public Drawable k;
    public boolean l;
    public boolean m;
    public boolean n;
    public int o;
    public int p;
    public int q;
    public boolean r;
    public boolean s;
    public boolean t;
    public boolean u;
    public int v;
    public final SparseBooleanArray w;
    public e x;
    public a y;
    public c z;

    @SuppressLint({"BanParcelableUsage"})
    /* loaded from: classes.dex */
    public static class SavedState implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new a();
        public int a;

        /* loaded from: classes.dex */
        public class a implements Parcelable.Creator<SavedState> {
            /* JADX WARN: Can't rename method to resolve collision */
            @Override // android.os.Parcelable.Creator
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            /* JADX WARN: Can't rename method to resolve collision */
            @Override // android.os.Parcelable.Creator
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState() {
        }

        @Override // android.os.Parcelable
        public int describeContents() {
            return 0;
        }

        @Override // android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.a);
        }

        public SavedState(Parcel parcel) {
            this.a = parcel.readInt();
        }
    }

    /* loaded from: classes.dex */
    public class a extends o1 {
        public a(Context context, u1 u1Var, View view) {
            super(context, u1Var, view, false, s.actionOverflowMenuStyle);
            if (!((l1) u1Var.getItem()).h()) {
                View view2 = ActionMenuPresenter.this.j;
                a(view2 == null ? (View) ActionMenuPresenter.this.i : view2);
            }
            a(ActionMenuPresenter.this.B);
        }

        @Override // defpackage.o1
        public void e() {
            ActionMenuPresenter actionMenuPresenter = ActionMenuPresenter.this;
            actionMenuPresenter.y = null;
            actionMenuPresenter.C = 0;
            super.e();
        }
    }

    /* loaded from: classes.dex */
    public class b extends ActionMenuItemView.b {
        public b() {
        }

        @Override // androidx.appcompat.view.menu.ActionMenuItemView.b
        public s1 a() {
            a aVar = ActionMenuPresenter.this.y;
            if (aVar != null) {
                return aVar.c();
            }
            return null;
        }
    }

    /* loaded from: classes.dex */
    public class c implements Runnable {
        public e a;

        public c(e eVar) {
            this.a = eVar;
        }

        @Override // java.lang.Runnable
        public void run() {
            if (ActionMenuPresenter.this.d != null) {
                ActionMenuPresenter.this.d.a();
            }
            View view = (View) ActionMenuPresenter.this.i;
            if (view != null && view.getWindowToken() != null && this.a.g()) {
                ActionMenuPresenter.this.x = this.a;
            }
            ActionMenuPresenter.this.z = null;
        }
    }

    /* loaded from: classes.dex */
    public class d extends j2 implements ActionMenuView.a {

        /* loaded from: classes.dex */
        public class a extends b3 {
            public a(View view, ActionMenuPresenter actionMenuPresenter) {
                super(view);
            }

            @Override // defpackage.b3
            public s1 b() {
                e eVar = ActionMenuPresenter.this.x;
                if (eVar == null) {
                    return null;
                }
                return eVar.c();
            }

            @Override // defpackage.b3
            public boolean c() {
                ActionMenuPresenter.this.i();
                return true;
            }

            @Override // defpackage.b3
            public boolean d() {
                ActionMenuPresenter actionMenuPresenter = ActionMenuPresenter.this;
                if (actionMenuPresenter.z != null) {
                    return false;
                }
                actionMenuPresenter.e();
                return true;
            }
        }

        public d(Context context) {
            super(context, null, s.actionOverflowButtonStyle);
            setClickable(true);
            setFocusable(true);
            setVisibility(0);
            setEnabled(true);
            s3.a(this, getContentDescription());
            setOnTouchListener(new a(this, ActionMenuPresenter.this));
        }

        @Override // androidx.appcompat.widget.ActionMenuView.a
        public boolean b() {
            return false;
        }

        @Override // androidx.appcompat.widget.ActionMenuView.a
        public boolean c() {
            return false;
        }

        @Override // android.view.View
        public boolean performClick() {
            if (super.performClick()) {
                return true;
            }
            playSoundEffect(0);
            ActionMenuPresenter.this.i();
            return true;
        }

        @Override // android.widget.ImageView
        public boolean setFrame(int i, int i2, int i3, int i4) {
            boolean frame = super.setFrame(i, i2, i3, i4);
            Drawable drawable = getDrawable();
            Drawable background = getBackground();
            if (drawable != null && background != null) {
                int width = getWidth();
                int height = getHeight();
                int max = Math.max(width, height) / 2;
                int paddingLeft = (width + (getPaddingLeft() - getPaddingRight())) / 2;
                int paddingTop = (height + (getPaddingTop() - getPaddingBottom())) / 2;
                z7.a(background, paddingLeft - max, paddingTop - max, paddingLeft + max, paddingTop + max);
            }
            return frame;
        }
    }

    /* loaded from: classes.dex */
    public class e extends o1 {
        public e(Context context, j1 j1Var, View view, boolean z) {
            super(context, j1Var, view, z, s.actionOverflowMenuStyle);
            a(8388613);
            a(ActionMenuPresenter.this.B);
        }

        @Override // defpackage.o1
        public void e() {
            if (ActionMenuPresenter.this.d != null) {
                ActionMenuPresenter.this.d.close();
            }
            ActionMenuPresenter.this.x = null;
            super.e();
        }
    }

    public ActionMenuPresenter(Context context) {
        super(context, y.abc_action_menu_layout, y.abc_action_menu_item_layout);
        this.w = new SparseBooleanArray();
        this.B = new f();
    }

    public boolean h() {
        e eVar = this.x;
        return eVar != null && eVar.d();
    }

    public boolean i() {
        j1 j1Var;
        if (!this.m || h() || (j1Var = this.d) == null || this.i == null || this.z != null || j1Var.j().isEmpty()) {
            return false;
        }
        c cVar = new c(new e(this.c, this.d, this.j, true));
        this.z = cVar;
        ((View) this.i).post(cVar);
        return true;
    }

    @Override // defpackage.e1, defpackage.p1
    public void a(Context context, j1 j1Var) {
        super.a(context, j1Var);
        Resources resources = context.getResources();
        u0 a2 = u0.a(context);
        if (!this.n) {
            this.m = a2.g();
        }
        if (!this.t) {
            this.o = a2.b();
        }
        if (!this.r) {
            this.q = a2.c();
        }
        int i = this.o;
        if (this.m) {
            if (this.j == null) {
                d dVar = new d(this.a);
                this.j = dVar;
                if (this.l) {
                    dVar.setImageDrawable(this.k);
                    this.k = null;
                    this.l = false;
                }
                int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
                this.j.measure(makeMeasureSpec, makeMeasureSpec);
            }
            i -= this.j.getMeasuredWidth();
        } else {
            this.j = null;
        }
        this.p = i;
        this.v = (int) (resources.getDisplayMetrics().density * 56.0f);
    }

    public void b(boolean z) {
        this.u = z;
    }

    public void c(boolean z) {
        this.m = z;
        this.n = true;
    }

    public Drawable d() {
        d dVar = this.j;
        if (dVar != null) {
            return dVar.getDrawable();
        }
        if (this.l) {
            return this.k;
        }
        return null;
    }

    public boolean e() {
        Object obj;
        c cVar = this.z;
        if (cVar != null && (obj = this.i) != null) {
            ((View) obj).removeCallbacks(cVar);
            this.z = null;
            return true;
        }
        e eVar = this.x;
        if (eVar == null) {
            return false;
        }
        eVar.b();
        return true;
    }

    public boolean f() {
        a aVar = this.y;
        if (aVar == null) {
            return false;
        }
        aVar.b();
        return true;
    }

    public boolean g() {
        return this.z != null || h();
    }

    @Override // defpackage.e1
    public q1 b(ViewGroup viewGroup) {
        q1 q1Var = this.i;
        q1 b2 = super.b(viewGroup);
        if (q1Var != b2) {
            ((ActionMenuView) b2).setPresenter(this);
        }
        return b2;
    }

    /* loaded from: classes.dex */
    public class f implements p1.a {
        public f() {
        }

        @Override // p1.a
        public boolean a(j1 j1Var) {
            if (j1Var == ActionMenuPresenter.this.d) {
                return false;
            }
            ActionMenuPresenter.this.C = ((u1) j1Var).getItem().getItemId();
            p1.a a = ActionMenuPresenter.this.a();
            if (a != null) {
                return a.a(j1Var);
            }
            return false;
        }

        @Override // p1.a
        public void a(j1 j1Var, boolean z) {
            if (j1Var instanceof u1) {
                j1Var.m().a(false);
            }
            p1.a a = ActionMenuPresenter.this.a();
            if (a != null) {
                a.a(j1Var, z);
            }
        }
    }

    public boolean c() {
        return e() | f();
    }

    @Override // defpackage.p1
    public boolean b() {
        ArrayList<l1> arrayList;
        int i;
        int i2;
        int i3;
        int i4;
        ActionMenuPresenter actionMenuPresenter = this;
        j1 j1Var = actionMenuPresenter.d;
        View view = null;
        int i5 = 0;
        if (j1Var != null) {
            arrayList = j1Var.n();
            i = arrayList.size();
        } else {
            arrayList = null;
            i = 0;
        }
        int i6 = actionMenuPresenter.q;
        int i7 = actionMenuPresenter.p;
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        ViewGroup viewGroup = (ViewGroup) actionMenuPresenter.i;
        boolean z = false;
        int i8 = 0;
        int i9 = 0;
        for (int i10 = 0; i10 < i; i10++) {
            l1 l1Var = arrayList.get(i10);
            if (l1Var.k()) {
                i8++;
            } else if (l1Var.j()) {
                i9++;
            } else {
                z = true;
            }
            if (actionMenuPresenter.u && l1Var.isActionViewExpanded()) {
                i6 = 0;
            }
        }
        if (actionMenuPresenter.m && (z || i9 + i8 > i6)) {
            i6--;
        }
        int i11 = i6 - i8;
        SparseBooleanArray sparseBooleanArray = actionMenuPresenter.w;
        sparseBooleanArray.clear();
        if (actionMenuPresenter.s) {
            int i12 = actionMenuPresenter.v;
            i3 = i7 / i12;
            i2 = i12 + ((i7 % i12) / i3);
        } else {
            i2 = 0;
            i3 = 0;
        }
        int i13 = 0;
        int i14 = 0;
        while (i13 < i) {
            l1 l1Var2 = arrayList.get(i13);
            if (l1Var2.k()) {
                View a2 = actionMenuPresenter.a(l1Var2, view, viewGroup);
                if (actionMenuPresenter.s) {
                    i3 -= ActionMenuView.b(a2, i2, i3, makeMeasureSpec, i5);
                } else {
                    a2.measure(makeMeasureSpec, makeMeasureSpec);
                }
                int measuredWidth = a2.getMeasuredWidth();
                i7 -= measuredWidth;
                if (i14 == 0) {
                    i14 = measuredWidth;
                }
                int groupId = l1Var2.getGroupId();
                if (groupId != 0) {
                    sparseBooleanArray.put(groupId, true);
                }
                l1Var2.d(true);
                i4 = i;
            } else if (l1Var2.j()) {
                int groupId2 = l1Var2.getGroupId();
                boolean z2 = sparseBooleanArray.get(groupId2);
                boolean z3 = (i11 > 0 || z2) && i7 > 0 && (!actionMenuPresenter.s || i3 > 0);
                boolean z4 = z3;
                i4 = i;
                if (z3) {
                    View a3 = actionMenuPresenter.a(l1Var2, null, viewGroup);
                    if (actionMenuPresenter.s) {
                        int b2 = ActionMenuView.b(a3, i2, i3, makeMeasureSpec, 0);
                        i3 -= b2;
                        if (b2 == 0) {
                            z4 = false;
                        }
                    } else {
                        a3.measure(makeMeasureSpec, makeMeasureSpec);
                    }
                    boolean z5 = z4;
                    int measuredWidth2 = a3.getMeasuredWidth();
                    i7 -= measuredWidth2;
                    if (i14 == 0) {
                        i14 = measuredWidth2;
                    }
                    z3 = z5 & (!actionMenuPresenter.s ? i7 + i14 <= 0 : i7 < 0);
                }
                if (z3 && groupId2 != 0) {
                    sparseBooleanArray.put(groupId2, true);
                } else if (z2) {
                    sparseBooleanArray.put(groupId2, false);
                    for (int i15 = 0; i15 < i13; i15++) {
                        l1 l1Var3 = arrayList.get(i15);
                        if (l1Var3.getGroupId() == groupId2) {
                            if (l1Var3.h()) {
                                i11++;
                            }
                            l1Var3.d(false);
                        }
                    }
                }
                if (z3) {
                    i11--;
                }
                l1Var2.d(z3);
            } else {
                i4 = i;
                l1Var2.d(false);
                i13++;
                i = i4;
                view = null;
                i5 = 0;
                actionMenuPresenter = this;
            }
            i13++;
            i = i4;
            view = null;
            i5 = 0;
            actionMenuPresenter = this;
        }
        return true;
    }

    public void a(Configuration configuration) {
        if (!this.r) {
            this.q = u0.a(this.c).c();
        }
        j1 j1Var = this.d;
        if (j1Var != null) {
            j1Var.c(true);
        }
    }

    public void a(Drawable drawable) {
        d dVar = this.j;
        if (dVar != null) {
            dVar.setImageDrawable(drawable);
        } else {
            this.l = true;
            this.k = drawable;
        }
    }

    @Override // defpackage.e1
    public View a(l1 l1Var, View view, ViewGroup viewGroup) {
        View actionView = l1Var.getActionView();
        if (actionView == null || l1Var.f()) {
            actionView = super.a(l1Var, view, viewGroup);
        }
        actionView.setVisibility(l1Var.isActionViewExpanded() ? 8 : 0);
        ActionMenuView actionMenuView = (ActionMenuView) viewGroup;
        ViewGroup.LayoutParams layoutParams = actionView.getLayoutParams();
        if (!actionMenuView.checkLayoutParams(layoutParams)) {
            actionView.setLayoutParams(actionMenuView.generateLayoutParams(layoutParams));
        }
        return actionView;
    }

    @Override // defpackage.e1
    public void a(l1 l1Var, q1.a aVar) {
        aVar.a(l1Var, 0);
        ActionMenuItemView actionMenuItemView = (ActionMenuItemView) aVar;
        actionMenuItemView.setItemInvoker((ActionMenuView) this.i);
        if (this.A == null) {
            this.A = new b();
        }
        actionMenuItemView.setPopupCallback(this.A);
    }

    @Override // defpackage.e1
    public boolean a(int i, l1 l1Var) {
        return l1Var.h();
    }

    @Override // defpackage.e1, defpackage.p1
    public void a(boolean z) {
        super.a(z);
        ((View) this.i).requestLayout();
        j1 j1Var = this.d;
        boolean z2 = false;
        if (j1Var != null) {
            ArrayList<l1> c2 = j1Var.c();
            int size = c2.size();
            for (int i = 0; i < size; i++) {
                y8 a2 = c2.get(i).a();
                if (a2 != null) {
                    a2.a(this);
                }
            }
        }
        j1 j1Var2 = this.d;
        ArrayList<l1> j = j1Var2 != null ? j1Var2.j() : null;
        if (this.m && j != null) {
            int size2 = j.size();
            if (size2 == 1) {
                z2 = !j.get(0).isActionViewExpanded();
            } else if (size2 > 0) {
                z2 = true;
            }
        }
        if (z2) {
            if (this.j == null) {
                this.j = new d(this.a);
            }
            ViewGroup viewGroup = (ViewGroup) this.j.getParent();
            if (viewGroup != this.i) {
                if (viewGroup != null) {
                    viewGroup.removeView(this.j);
                }
                ActionMenuView actionMenuView = (ActionMenuView) this.i;
                actionMenuView.addView(this.j, actionMenuView.d());
            }
        } else {
            d dVar = this.j;
            if (dVar != null) {
                Object parent = dVar.getParent();
                Object obj = this.i;
                if (parent == obj) {
                    ((ViewGroup) obj).removeView(this.j);
                }
            }
        }
        ((ActionMenuView) this.i).setOverflowReserved(this.m);
    }

    @Override // defpackage.e1
    public boolean a(ViewGroup viewGroup, int i) {
        if (viewGroup.getChildAt(i) == this.j) {
            return false;
        }
        return super.a(viewGroup, i);
    }

    @Override // defpackage.e1, defpackage.p1
    public boolean a(u1 u1Var) {
        boolean z = false;
        if (!u1Var.hasVisibleItems()) {
            return false;
        }
        u1 u1Var2 = u1Var;
        while (u1Var2.t() != this.d) {
            u1Var2 = (u1) u1Var2.t();
        }
        View a2 = a(u1Var2.getItem());
        if (a2 == null) {
            return false;
        }
        u1Var.getItem().getItemId();
        int size = u1Var.size();
        int i = 0;
        while (true) {
            if (i >= size) {
                break;
            }
            MenuItem item = u1Var.getItem(i);
            if (item.isVisible() && item.getIcon() != null) {
                z = true;
                break;
            }
            i++;
        }
        a aVar = new a(this.c, u1Var, a2);
        this.y = aVar;
        aVar.a(z);
        this.y.f();
        super.a(u1Var);
        return true;
    }

    /* JADX WARN: Multi-variable type inference failed */
    public final View a(MenuItem menuItem) {
        ViewGroup viewGroup = (ViewGroup) this.i;
        if (viewGroup == null) {
            return null;
        }
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = viewGroup.getChildAt(i);
            if ((childAt instanceof q1.a) && ((q1.a) childAt).getItemData() == menuItem) {
                return childAt;
            }
        }
        return null;
    }

    @Override // defpackage.e1, defpackage.p1
    public void a(j1 j1Var, boolean z) {
        c();
        super.a(j1Var, z);
    }

    public void a(ActionMenuView actionMenuView) {
        this.i = actionMenuView;
        actionMenuView.a(this.d);
    }
}
