package androidx.media;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import defpackage.d4;
import defpackage.kc;
import defpackage.lc;
import defpackage.mc;
import defpackage.nc;
import defpackage.oc;
import defpackage.t6;
import defpackage.v8;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/* loaded from: classes.dex */
public abstract class MediaBrowserServiceCompat extends Service {
    public static final boolean g = Log.isLoggable("MBServiceCompat", 3);
    public g a;
    public f d;
    public MediaSessionCompat.Token f;
    public final d4<IBinder, f> c = new d4<>();
    public final q e = new q();

    /* loaded from: classes.dex */
    public class a extends m<List<MediaBrowserCompat.MediaItem>> {
        public final /* synthetic */ f f;
        public final /* synthetic */ String g;
        public final /* synthetic */ Bundle h;
        public final /* synthetic */ Bundle i;

        /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
        public a(Object obj, f fVar, String str, Bundle bundle, Bundle bundle2) {
            super(obj);
            this.f = fVar;
            this.g = str;
            this.h = bundle;
            this.i = bundle2;
        }

        @Override // androidx.media.MediaBrowserServiceCompat.m
        public void a(List<MediaBrowserCompat.MediaItem> list) {
            if (MediaBrowserServiceCompat.this.c.get(this.f.b.asBinder()) != this.f) {
                if (MediaBrowserServiceCompat.g) {
                    Log.d("MBServiceCompat", "Not sending onLoadChildren result for connection that has been disconnected. pkg=" + this.f.a + " id=" + this.g);
                    return;
                }
                return;
            }
            if ((a() & 1) != 0) {
                list = MediaBrowserServiceCompat.this.a(list, this.h);
            }
            try {
                this.f.b.a(this.g, list, this.h, this.i);
            } catch (RemoteException unused) {
                Log.w("MBServiceCompat", "Calling onLoadChildren() failed for id=" + this.g + " package=" + this.f.a);
            }
        }
    }

    /* loaded from: classes.dex */
    public class b extends m<MediaBrowserCompat.MediaItem> {
        public final /* synthetic */ ResultReceiver f;

        /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
        public b(MediaBrowserServiceCompat mediaBrowserServiceCompat, Object obj, ResultReceiver resultReceiver) {
            super(obj);
            this.f = resultReceiver;
        }

        @Override // androidx.media.MediaBrowserServiceCompat.m
        public void a(MediaBrowserCompat.MediaItem mediaItem) {
            if ((a() & 2) != 0) {
                this.f.b(-1, null);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putParcelable("media_item", mediaItem);
            this.f.b(0, bundle);
        }
    }

    /* loaded from: classes.dex */
    public class c extends m<List<MediaBrowserCompat.MediaItem>> {
        public final /* synthetic */ ResultReceiver f;

        /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
        public c(MediaBrowserServiceCompat mediaBrowserServiceCompat, Object obj, ResultReceiver resultReceiver) {
            super(obj);
            this.f = resultReceiver;
        }

        @Override // androidx.media.MediaBrowserServiceCompat.m
        public void a(List<MediaBrowserCompat.MediaItem> list) {
            if ((a() & 4) == 0 && list != null) {
                Bundle bundle = new Bundle();
                bundle.putParcelableArray("search_results", (Parcelable[]) list.toArray(new MediaBrowserCompat.MediaItem[0]));
                this.f.b(0, bundle);
                return;
            }
            this.f.b(-1, null);
        }
    }

    /* loaded from: classes.dex */
    public class d extends m<Bundle> {
        public final /* synthetic */ ResultReceiver f;

        /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
        public d(MediaBrowserServiceCompat mediaBrowserServiceCompat, Object obj, ResultReceiver resultReceiver) {
            super(obj);
            this.f = resultReceiver;
        }

        @Override // androidx.media.MediaBrowserServiceCompat.m
        /* renamed from: c, reason: merged with bridge method [inline-methods] */
        public void a(Bundle bundle) {
            this.f.b(0, bundle);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // androidx.media.MediaBrowserServiceCompat.m
        public void a(Bundle bundle) {
            this.f.b(-1, bundle);
        }
    }

    /* loaded from: classes.dex */
    public static final class e {
        public Bundle a() {
            throw null;
        }

        public String b() {
            throw null;
        }
    }

    /* loaded from: classes.dex */
    public class f implements IBinder.DeathRecipient {
        public final String a;
        public final o b;
        public final HashMap<String, List<v8<IBinder, Bundle>>> c = new HashMap<>();
        public e d;

        /* loaded from: classes.dex */
        public class a implements Runnable {
            public a() {
            }

            @Override // java.lang.Runnable
            public void run() {
                f fVar = f.this;
                MediaBrowserServiceCompat.this.c.remove(fVar.b.asBinder());
            }
        }

        public f(String str, int i, int i2, Bundle bundle, o oVar) {
            this.a = str;
            new oc(str, i, i2);
            this.b = oVar;
        }

        @Override // android.os.IBinder.DeathRecipient
        public void binderDied() {
            MediaBrowserServiceCompat.this.e.post(new a());
        }
    }

    /* loaded from: classes.dex */
    public interface g {
        IBinder a(Intent intent);

        void a();
    }

    /* loaded from: classes.dex */
    public class i extends h implements mc.b {

        /* loaded from: classes.dex */
        public class a extends m<MediaBrowserCompat.MediaItem> {
            public final /* synthetic */ lc.c f;

            /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
            public a(i iVar, Object obj, lc.c cVar) {
                super(obj);
                this.f = cVar;
            }

            @Override // androidx.media.MediaBrowserServiceCompat.m
            public void a(MediaBrowserCompat.MediaItem mediaItem) {
                if (mediaItem == null) {
                    this.f.a((lc.c) null);
                    return;
                }
                Parcel obtain = Parcel.obtain();
                mediaItem.writeToParcel(obtain, 0);
                this.f.a((lc.c) obtain);
            }
        }

        public i() {
            super();
        }

        @Override // androidx.media.MediaBrowserServiceCompat.h, androidx.media.MediaBrowserServiceCompat.g
        public void a() {
            Object a2 = mc.a(MediaBrowserServiceCompat.this, this);
            this.b = a2;
            lc.a(a2);
        }

        @Override // mc.b
        public void b(String str, lc.c<Parcel> cVar) {
            MediaBrowserServiceCompat.this.b(str, new a(this, str, cVar));
        }
    }

    /* loaded from: classes.dex */
    public class k extends j {
        public k(MediaBrowserServiceCompat mediaBrowserServiceCompat) {
            super();
        }
    }

    /* loaded from: classes.dex */
    public class l implements g {
        public Messenger a;

        public l() {
        }

        @Override // androidx.media.MediaBrowserServiceCompat.g
        public void a() {
            this.a = new Messenger(MediaBrowserServiceCompat.this.e);
        }

        @Override // androidx.media.MediaBrowserServiceCompat.g
        public IBinder a(Intent intent) {
            if ("android.media.browse.MediaBrowserService".equals(intent.getAction())) {
                return this.a.getBinder();
            }
            return null;
        }
    }

    /* loaded from: classes.dex */
    public static class m<T> {
        public final Object a;
        public boolean b;
        public boolean c;
        public boolean d;
        public int e;

        public m(Object obj) {
            this.a = obj;
        }

        public void a(int i) {
            this.e = i;
        }

        public void a(T t) {
            throw null;
        }

        public void b(T t) {
            if (!this.c && !this.d) {
                this.c = true;
                a((m<T>) t);
            } else {
                throw new IllegalStateException("sendResult() called when either sendResult() or sendError() had already been called for: " + this.a);
            }
        }

        public int a() {
            return this.e;
        }

        public void a(Bundle bundle) {
            throw new UnsupportedOperationException("It is not supported to send an error for " + this.a);
        }

        public void b(Bundle bundle) {
            if (!this.c && !this.d) {
                this.d = true;
                a(bundle);
            } else {
                throw new IllegalStateException("sendError() called when either sendResult() or sendError() had already been called for: " + this.a);
            }
        }

        public boolean b() {
            return this.b || this.c || this.d;
        }
    }

    /* loaded from: classes.dex */
    public class n {

        /* loaded from: classes.dex */
        public class a implements Runnable {
            public final /* synthetic */ o a;
            public final /* synthetic */ String c;
            public final /* synthetic */ int d;
            public final /* synthetic */ int e;
            public final /* synthetic */ Bundle f;

            public a(o oVar, String str, int i, int i2, Bundle bundle) {
                this.a = oVar;
                this.c = str;
                this.d = i;
                this.e = i2;
                this.f = bundle;
            }

            @Override // java.lang.Runnable
            public void run() {
                IBinder asBinder = this.a.asBinder();
                MediaBrowserServiceCompat.this.c.remove(asBinder);
                f fVar = new f(this.c, this.d, this.e, this.f, this.a);
                MediaBrowserServiceCompat mediaBrowserServiceCompat = MediaBrowserServiceCompat.this;
                mediaBrowserServiceCompat.d = fVar;
                e a = mediaBrowserServiceCompat.a(this.c, this.e, this.f);
                fVar.d = a;
                MediaBrowserServiceCompat mediaBrowserServiceCompat2 = MediaBrowserServiceCompat.this;
                mediaBrowserServiceCompat2.d = null;
                if (a == null) {
                    Log.i("MBServiceCompat", "No root for client " + this.c + " from service " + a.class.getName());
                    try {
                        this.a.a();
                        return;
                    } catch (RemoteException unused) {
                        Log.w("MBServiceCompat", "Calling onConnectFailed() failed. Ignoring. pkg=" + this.c);
                        return;
                    }
                }
                try {
                    mediaBrowserServiceCompat2.c.put(asBinder, fVar);
                    asBinder.linkToDeath(fVar, 0);
                    if (MediaBrowserServiceCompat.this.f == null) {
                        return;
                    }
                    fVar.d.b();
                    throw null;
                } catch (RemoteException unused2) {
                    Log.w("MBServiceCompat", "Calling onConnect() failed. Dropping client. pkg=" + this.c);
                    MediaBrowserServiceCompat.this.c.remove(asBinder);
                }
            }
        }

        /* loaded from: classes.dex */
        public class b implements Runnable {
            public final /* synthetic */ o a;

            public b(o oVar) {
                this.a = oVar;
            }

            @Override // java.lang.Runnable
            public void run() {
                f remove = MediaBrowserServiceCompat.this.c.remove(this.a.asBinder());
                if (remove != null) {
                    remove.b.asBinder().unlinkToDeath(remove, 0);
                }
            }
        }

        /* loaded from: classes.dex */
        public class c implements Runnable {
            public final /* synthetic */ o a;
            public final /* synthetic */ String c;
            public final /* synthetic */ IBinder d;
            public final /* synthetic */ Bundle e;

            public c(o oVar, String str, IBinder iBinder, Bundle bundle) {
                this.a = oVar;
                this.c = str;
                this.d = iBinder;
                this.e = bundle;
            }

            @Override // java.lang.Runnable
            public void run() {
                f fVar = MediaBrowserServiceCompat.this.c.get(this.a.asBinder());
                if (fVar == null) {
                    Log.w("MBServiceCompat", "addSubscription for callback that isn't registered id=" + this.c);
                    return;
                }
                MediaBrowserServiceCompat.this.a(this.c, fVar, this.d, this.e);
            }
        }

        /* loaded from: classes.dex */
        public class d implements Runnable {
            public final /* synthetic */ o a;
            public final /* synthetic */ String c;
            public final /* synthetic */ IBinder d;

            public d(o oVar, String str, IBinder iBinder) {
                this.a = oVar;
                this.c = str;
                this.d = iBinder;
            }

            @Override // java.lang.Runnable
            public void run() {
                f fVar = MediaBrowserServiceCompat.this.c.get(this.a.asBinder());
                if (fVar == null) {
                    Log.w("MBServiceCompat", "removeSubscription for callback that isn't registered id=" + this.c);
                    return;
                }
                if (MediaBrowserServiceCompat.this.a(this.c, fVar, this.d)) {
                    return;
                }
                Log.w("MBServiceCompat", "removeSubscription called for " + this.c + " which is not subscribed");
            }
        }

        /* loaded from: classes.dex */
        public class e implements Runnable {
            public final /* synthetic */ o a;
            public final /* synthetic */ String c;
            public final /* synthetic */ ResultReceiver d;

            public e(o oVar, String str, ResultReceiver resultReceiver) {
                this.a = oVar;
                this.c = str;
                this.d = resultReceiver;
            }

            @Override // java.lang.Runnable
            public void run() {
                f fVar = MediaBrowserServiceCompat.this.c.get(this.a.asBinder());
                if (fVar == null) {
                    Log.w("MBServiceCompat", "getMediaItem for callback that isn't registered id=" + this.c);
                    return;
                }
                MediaBrowserServiceCompat.this.a(this.c, fVar, this.d);
            }
        }

        /* loaded from: classes.dex */
        public class f implements Runnable {
            public final /* synthetic */ o a;
            public final /* synthetic */ String c;
            public final /* synthetic */ int d;
            public final /* synthetic */ int e;
            public final /* synthetic */ Bundle f;

            public f(o oVar, String str, int i, int i2, Bundle bundle) {
                this.a = oVar;
                this.c = str;
                this.d = i;
                this.e = i2;
                this.f = bundle;
            }

            @Override // java.lang.Runnable
            public void run() {
                IBinder asBinder = this.a.asBinder();
                MediaBrowserServiceCompat.this.c.remove(asBinder);
                f fVar = new f(this.c, this.d, this.e, this.f, this.a);
                MediaBrowserServiceCompat.this.c.put(asBinder, fVar);
                try {
                    asBinder.linkToDeath(fVar, 0);
                } catch (RemoteException unused) {
                    Log.w("MBServiceCompat", "IBinder is already dead.");
                }
            }
        }

        /* loaded from: classes.dex */
        public class g implements Runnable {
            public final /* synthetic */ o a;

            public g(o oVar) {
                this.a = oVar;
            }

            @Override // java.lang.Runnable
            public void run() {
                IBinder asBinder = this.a.asBinder();
                f remove = MediaBrowserServiceCompat.this.c.remove(asBinder);
                if (remove != null) {
                    asBinder.unlinkToDeath(remove, 0);
                }
            }
        }

        /* loaded from: classes.dex */
        public class h implements Runnable {
            public final /* synthetic */ o a;
            public final /* synthetic */ String c;
            public final /* synthetic */ Bundle d;
            public final /* synthetic */ ResultReceiver e;

            public h(o oVar, String str, Bundle bundle, ResultReceiver resultReceiver) {
                this.a = oVar;
                this.c = str;
                this.d = bundle;
                this.e = resultReceiver;
            }

            @Override // java.lang.Runnable
            public void run() {
                f fVar = MediaBrowserServiceCompat.this.c.get(this.a.asBinder());
                if (fVar == null) {
                    Log.w("MBServiceCompat", "search for callback that isn't registered query=" + this.c);
                    return;
                }
                MediaBrowserServiceCompat.this.b(this.c, this.d, fVar, this.e);
            }
        }

        /* loaded from: classes.dex */
        public class i implements Runnable {
            public final /* synthetic */ o a;
            public final /* synthetic */ String c;
            public final /* synthetic */ Bundle d;
            public final /* synthetic */ ResultReceiver e;

            public i(o oVar, String str, Bundle bundle, ResultReceiver resultReceiver) {
                this.a = oVar;
                this.c = str;
                this.d = bundle;
                this.e = resultReceiver;
            }

            @Override // java.lang.Runnable
            public void run() {
                f fVar = MediaBrowserServiceCompat.this.c.get(this.a.asBinder());
                if (fVar == null) {
                    Log.w("MBServiceCompat", "sendCustomAction for callback that isn't registered action=" + this.c + ", extras=" + this.d);
                    return;
                }
                MediaBrowserServiceCompat.this.a(this.c, this.d, fVar, this.e);
            }
        }

        public n() {
        }

        public void a(String str, int i2, int i3, Bundle bundle, o oVar) {
            if (MediaBrowserServiceCompat.this.a(str, i3)) {
                MediaBrowserServiceCompat.this.e.a(new a(oVar, str, i2, i3, bundle));
                return;
            }
            throw new IllegalArgumentException("Package/uid mismatch: uid=" + i3 + " package=" + str);
        }

        public void b(o oVar) {
            MediaBrowserServiceCompat.this.e.a(new g(oVar));
        }

        public void b(String str, Bundle bundle, ResultReceiver resultReceiver, o oVar) {
            if (TextUtils.isEmpty(str) || resultReceiver == null) {
                return;
            }
            MediaBrowserServiceCompat.this.e.a(new i(oVar, str, bundle, resultReceiver));
        }

        public void a(o oVar) {
            MediaBrowserServiceCompat.this.e.a(new b(oVar));
        }

        public void a(String str, IBinder iBinder, Bundle bundle, o oVar) {
            MediaBrowserServiceCompat.this.e.a(new c(oVar, str, iBinder, bundle));
        }

        public void a(String str, IBinder iBinder, o oVar) {
            MediaBrowserServiceCompat.this.e.a(new d(oVar, str, iBinder));
        }

        public void a(String str, ResultReceiver resultReceiver, o oVar) {
            if (TextUtils.isEmpty(str) || resultReceiver == null) {
                return;
            }
            MediaBrowserServiceCompat.this.e.a(new e(oVar, str, resultReceiver));
        }

        public void a(o oVar, String str, int i2, int i3, Bundle bundle) {
            MediaBrowserServiceCompat.this.e.a(new f(oVar, str, i2, i3, bundle));
        }

        public void a(String str, Bundle bundle, ResultReceiver resultReceiver, o oVar) {
            if (TextUtils.isEmpty(str) || resultReceiver == null) {
                return;
            }
            MediaBrowserServiceCompat.this.e.a(new h(oVar, str, bundle, resultReceiver));
        }
    }

    /* loaded from: classes.dex */
    public interface o {
        void a() throws RemoteException;

        void a(String str, List<MediaBrowserCompat.MediaItem> list, Bundle bundle, Bundle bundle2) throws RemoteException;

        IBinder asBinder();
    }

    /* loaded from: classes.dex */
    public static class p implements o {
        public final Messenger a;

        public p(Messenger messenger) {
            this.a = messenger;
        }

        @Override // androidx.media.MediaBrowserServiceCompat.o
        public void a() throws RemoteException {
            a(2, null);
        }

        @Override // androidx.media.MediaBrowserServiceCompat.o
        public IBinder asBinder() {
            return this.a.getBinder();
        }

        @Override // androidx.media.MediaBrowserServiceCompat.o
        public void a(String str, List<MediaBrowserCompat.MediaItem> list, Bundle bundle, Bundle bundle2) throws RemoteException {
            Bundle bundle3 = new Bundle();
            bundle3.putString("data_media_item_id", str);
            bundle3.putBundle("data_options", bundle);
            bundle3.putBundle("data_notify_children_changed_options", bundle2);
            if (list != null) {
                bundle3.putParcelableArrayList("data_media_item_list", list instanceof ArrayList ? (ArrayList) list : new ArrayList<>(list));
            }
            a(3, bundle3);
        }

        public final void a(int i, Bundle bundle) throws RemoteException {
            Message obtain = Message.obtain();
            obtain.what = i;
            obtain.arg1 = 2;
            obtain.setData(bundle);
            this.a.send(obtain);
        }
    }

    /* loaded from: classes.dex */
    public final class q extends Handler {
        public final n a;

        public q() {
            this.a = new n();
        }

        public void a(Runnable runnable) {
            if (Thread.currentThread() == getLooper().getThread()) {
                runnable.run();
            } else {
                post(runnable);
            }
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            Bundle data = message.getData();
            switch (message.what) {
                case 1:
                    Bundle bundle = data.getBundle("data_root_hints");
                    MediaSessionCompat.a(bundle);
                    this.a.a(data.getString("data_package_name"), data.getInt("data_calling_pid"), data.getInt("data_calling_uid"), bundle, new p(message.replyTo));
                    return;
                case 2:
                    this.a.a(new p(message.replyTo));
                    return;
                case 3:
                    Bundle bundle2 = data.getBundle("data_options");
                    MediaSessionCompat.a(bundle2);
                    this.a.a(data.getString("data_media_item_id"), t6.a(data, "data_callback_token"), bundle2, new p(message.replyTo));
                    return;
                case 4:
                    this.a.a(data.getString("data_media_item_id"), t6.a(data, "data_callback_token"), new p(message.replyTo));
                    return;
                case 5:
                    this.a.a(data.getString("data_media_item_id"), (ResultReceiver) data.getParcelable("data_result_receiver"), new p(message.replyTo));
                    return;
                case 6:
                    Bundle bundle3 = data.getBundle("data_root_hints");
                    MediaSessionCompat.a(bundle3);
                    this.a.a(new p(message.replyTo), data.getString("data_package_name"), data.getInt("data_calling_pid"), data.getInt("data_calling_uid"), bundle3);
                    return;
                case 7:
                    this.a.b(new p(message.replyTo));
                    return;
                case 8:
                    Bundle bundle4 = data.getBundle("data_search_extras");
                    MediaSessionCompat.a(bundle4);
                    this.a.a(data.getString("data_search_query"), bundle4, (ResultReceiver) data.getParcelable("data_result_receiver"), new p(message.replyTo));
                    return;
                case 9:
                    Bundle bundle5 = data.getBundle("data_custom_action_extras");
                    MediaSessionCompat.a(bundle5);
                    this.a.b(data.getString("data_custom_action"), bundle5, (ResultReceiver) data.getParcelable("data_result_receiver"), new p(message.replyTo));
                    return;
                default:
                    Log.w("MBServiceCompat", "Unhandled message: " + message + "\n  Service version: 2\n  Client version: " + message.arg1);
                    return;
            }
        }

        @Override // android.os.Handler
        public boolean sendMessageAtTime(Message message, long j) {
            Bundle data = message.getData();
            data.setClassLoader(MediaBrowserCompat.class.getClassLoader());
            data.putInt("data_calling_uid", Binder.getCallingUid());
            data.putInt("data_calling_pid", Binder.getCallingPid());
            return super.sendMessageAtTime(message, j);
        }
    }

    public abstract e a(String str, int i2, Bundle bundle);

    public void a(String str) {
    }

    public void a(String str, Bundle bundle) {
    }

    public abstract void a(String str, m<List<MediaBrowserCompat.MediaItem>> mVar);

    public void a(String str, m<List<MediaBrowserCompat.MediaItem>> mVar, Bundle bundle) {
        mVar.a(1);
        a(str, mVar);
    }

    public void b(String str, m<MediaBrowserCompat.MediaItem> mVar) {
        mVar.a(2);
        mVar.b((m<MediaBrowserCompat.MediaItem>) null);
    }

    @Override // android.app.Service
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] strArr) {
    }

    @Override // android.app.Service
    public IBinder onBind(Intent intent) {
        return this.a.a(intent);
    }

    @Override // android.app.Service
    public void onCreate() {
        super.onCreate();
        int i2 = Build.VERSION.SDK_INT;
        if (i2 >= 28) {
            this.a = new k(this);
        } else if (i2 >= 26) {
            this.a = new j();
        } else if (i2 >= 23) {
            this.a = new i();
        } else if (i2 >= 21) {
            this.a = new h();
        } else {
            this.a = new l();
        }
        this.a.a();
    }

    /* loaded from: classes.dex */
    public class h implements g, lc.d {
        public final List<Bundle> a = new ArrayList();
        public Object b;
        public Messenger c;

        /* loaded from: classes.dex */
        public class a extends m<List<MediaBrowserCompat.MediaItem>> {
            public final /* synthetic */ lc.c f;

            /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
            public a(h hVar, Object obj, lc.c cVar) {
                super(obj);
                this.f = cVar;
            }

            @Override // androidx.media.MediaBrowserServiceCompat.m
            public void a(List<MediaBrowserCompat.MediaItem> list) {
                ArrayList arrayList;
                if (list != null) {
                    arrayList = new ArrayList();
                    for (MediaBrowserCompat.MediaItem mediaItem : list) {
                        Parcel obtain = Parcel.obtain();
                        mediaItem.writeToParcel(obtain, 0);
                        arrayList.add(obtain);
                    }
                } else {
                    arrayList = null;
                }
                this.f.a((lc.c) arrayList);
            }
        }

        public h() {
        }

        @Override // androidx.media.MediaBrowserServiceCompat.g
        public void a() {
            Object a2 = lc.a(MediaBrowserServiceCompat.this, this);
            this.b = a2;
            lc.a(a2);
        }

        @Override // androidx.media.MediaBrowserServiceCompat.g
        public IBinder a(Intent intent) {
            return lc.a(this.b, intent);
        }

        @Override // lc.d
        public lc.a a(String str, int i, Bundle bundle) {
            Bundle bundle2;
            if (bundle == null || bundle.getInt("extra_client_version", 0) == 0) {
                bundle2 = null;
            } else {
                bundle.remove("extra_client_version");
                this.c = new Messenger(MediaBrowserServiceCompat.this.e);
                bundle2 = new Bundle();
                bundle2.putInt("extra_service_version", 2);
                t6.a(bundle2, "extra_messenger", this.c.getBinder());
                MediaSessionCompat.Token token = MediaBrowserServiceCompat.this.f;
                if (token != null) {
                    defpackage.j n = token.n();
                    t6.a(bundle2, "extra_session_binder", n == null ? null : n.asBinder());
                } else {
                    this.a.add(bundle2);
                }
            }
            MediaBrowserServiceCompat mediaBrowserServiceCompat = MediaBrowserServiceCompat.this;
            mediaBrowserServiceCompat.d = new f(str, -1, i, bundle, null);
            e a2 = MediaBrowserServiceCompat.this.a(str, i, bundle);
            MediaBrowserServiceCompat.this.d = null;
            if (a2 == null) {
                return null;
            }
            if (bundle2 == null) {
                a2.a();
                throw null;
            }
            a2.a();
            throw null;
        }

        @Override // lc.d
        public void a(String str, lc.c<List<Parcel>> cVar) {
            MediaBrowserServiceCompat.this.a(str, new a(this, str, cVar));
        }
    }

    /* loaded from: classes.dex */
    public class j extends i implements nc.c {

        /* loaded from: classes.dex */
        public class a extends m<List<MediaBrowserCompat.MediaItem>> {
            public final /* synthetic */ nc.b f;

            /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
            public a(j jVar, Object obj, nc.b bVar) {
                super(obj);
                this.f = bVar;
            }

            @Override // androidx.media.MediaBrowserServiceCompat.m
            public void a(List<MediaBrowserCompat.MediaItem> list) {
                ArrayList arrayList;
                if (list != null) {
                    arrayList = new ArrayList();
                    for (MediaBrowserCompat.MediaItem mediaItem : list) {
                        Parcel obtain = Parcel.obtain();
                        mediaItem.writeToParcel(obtain, 0);
                        arrayList.add(obtain);
                    }
                } else {
                    arrayList = null;
                }
                this.f.a(arrayList, a());
            }
        }

        public j() {
            super();
        }

        @Override // androidx.media.MediaBrowserServiceCompat.i, androidx.media.MediaBrowserServiceCompat.h, androidx.media.MediaBrowserServiceCompat.g
        public void a() {
            Object a2 = nc.a(MediaBrowserServiceCompat.this, this);
            this.b = a2;
            lc.a(a2);
        }

        @Override // nc.c
        public void a(String str, nc.b bVar, Bundle bundle) {
            MediaBrowserServiceCompat.this.a(str, new a(this, str, bVar), bundle);
        }
    }

    public void a(String str, Bundle bundle, m<Bundle> mVar) {
        mVar.b((Bundle) null);
    }

    public void b(String str, Bundle bundle, m<List<MediaBrowserCompat.MediaItem>> mVar) {
        mVar.a(4);
        mVar.b((m<List<MediaBrowserCompat.MediaItem>>) null);
    }

    public boolean a(String str, int i2) {
        if (str == null) {
            return false;
        }
        for (String str2 : getPackageManager().getPackagesForUid(i2)) {
            if (str2.equals(str)) {
                return true;
            }
        }
        return false;
    }

    public void b(String str, Bundle bundle, f fVar, ResultReceiver resultReceiver) {
        c cVar = new c(this, str, resultReceiver);
        b(str, bundle, cVar);
        if (cVar.b()) {
            return;
        }
        throw new IllegalStateException("onSearch must call detach() or sendResult() before returning for query=" + str);
    }

    public void a(String str, f fVar, IBinder iBinder, Bundle bundle) {
        List<v8<IBinder, Bundle>> list = fVar.c.get(str);
        if (list == null) {
            list = new ArrayList<>();
        }
        for (v8<IBinder, Bundle> v8Var : list) {
            if (iBinder == v8Var.a && kc.a(bundle, v8Var.b)) {
                return;
            }
        }
        list.add(new v8<>(iBinder, bundle));
        fVar.c.put(str, list);
        a(str, fVar, bundle, (Bundle) null);
        a(str, bundle);
    }

    public boolean a(String str, f fVar, IBinder iBinder) {
        boolean z = false;
        try {
            if (iBinder == null) {
                return fVar.c.remove(str) != null;
            }
            List<v8<IBinder, Bundle>> list = fVar.c.get(str);
            if (list != null) {
                Iterator<v8<IBinder, Bundle>> it = list.iterator();
                while (it.hasNext()) {
                    if (iBinder == it.next().a) {
                        it.remove();
                        z = true;
                    }
                }
                if (list.size() == 0) {
                    fVar.c.remove(str);
                }
            }
            return z;
        } finally {
            a(str);
        }
    }

    public void a(String str, f fVar, Bundle bundle, Bundle bundle2) {
        a aVar = new a(str, fVar, str, bundle, bundle2);
        if (bundle == null) {
            a(str, aVar);
        } else {
            a(str, aVar, bundle);
        }
        if (aVar.b()) {
            return;
        }
        throw new IllegalStateException("onLoadChildren must call detach() or sendResult() before returning for package=" + fVar.a + " id=" + str);
    }

    public List<MediaBrowserCompat.MediaItem> a(List<MediaBrowserCompat.MediaItem> list, Bundle bundle) {
        if (list == null) {
            return null;
        }
        int i2 = bundle.getInt("android.media.browse.extra.PAGE", -1);
        int i3 = bundle.getInt("android.media.browse.extra.PAGE_SIZE", -1);
        if (i2 == -1 && i3 == -1) {
            return list;
        }
        int i4 = i3 * i2;
        int i5 = i4 + i3;
        if (i2 >= 0 && i3 >= 1 && i4 < list.size()) {
            if (i5 > list.size()) {
                i5 = list.size();
            }
            return list.subList(i4, i5);
        }
        return Collections.emptyList();
    }

    public void a(String str, f fVar, ResultReceiver resultReceiver) {
        b bVar = new b(this, str, resultReceiver);
        b(str, bVar);
        if (bVar.b()) {
            return;
        }
        throw new IllegalStateException("onLoadItem must call detach() or sendResult() before returning for id=" + str);
    }

    public void a(String str, Bundle bundle, f fVar, ResultReceiver resultReceiver) {
        d dVar = new d(this, str, resultReceiver);
        a(str, bundle, dVar);
        if (dVar.b()) {
            return;
        }
        throw new IllegalStateException("onCustomAction must call detach() or sendResult() or sendError() before returning for action=" + str + " extras=" + bundle);
    }
}
