package com;

import android.app.Activity;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import com.alibaba.wireless.security.SecExceptionCode;
import com.autonavi.amapauto.adapter.internal.widget.AutoSimilarWidgetService;
import com.autonavi.amapauto.jni.config.AndroidAdapterConfiger;
import com.autonavi.amapauto.jni.config.AudioConfigData;
import com.autonavi.amapauto.jni.protocol.AndroidProtocolExe;
import com.autonavi.amapauto.jni.protocol.data.CarLocationInfo;
import com.autonavi.amapauto.jni.protocol.data.LocationInfo;
import com.autonavi.amapauto.location.model.LocSignData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.widget.jni.AndroidWidgetMap;
import com.autonavi.amapauto.widget.jni.MapBound;
import com.autonavi.extscreen.dto.PresentationConfig;
import com.autonavi.indoor.pdr.ErrorCode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class AutoHelper {
    public static final boolean DEBUG_LOG = true;
    public static final boolean DEBUG_UPDATE_SURFACE_LOG = false;
    public static final boolean FEATURE_GESTURE_BACK = true;
    public static final boolean FEATURE_SUPPORT_AUDIO_CHANNEL = false;
    public static final String SilenPath = null;
    private static final String TAG = "AutoHelper";
    public static final long TimeUpdateDelay = 166;
    public static final long TimeUpdateDelayForWidget = 333;
    public static final long TimeUpdateIgnoreForWidget = 1800;
    public static final boolean USE_OEM = true;
    public static String appName = "Amap";
    public static boolean ignoreUpdateImageFlag;
    public static long ignoreUpdateImageTime;
    public static boolean muteStatusChecked;
    public static boolean muteStatusCheckedFromMain;
    public static Handler updateHandler;
    public static WeakReference<Activity> activityContext = new WeakReference<>(null);
    public static WeakReference<Context> applicationContext = new WeakReference<>(null);
    public static int recoveredMapMode = -1;
    public static long recoveredMapModeTime = 0;
    public static long applicationRuntime = System.currentTimeMillis();
    public static final Object updateLockObject = new Object();
    public static boolean isUpdating = false;
    public static WeakReference<Surface> surface1001Reference = new WeakReference<>(null);
    public static WeakReference<Surface> surface1002Reference = new WeakReference<>(null);
    public static WeakReference<SurfaceView> mapSurfaceViewReference = new WeakReference<>(null);
    public static WeakReference<SurfaceView> uiSurfaceView = new WeakReference<>(null);
    public static int lastMode1001 = 2;
    public static int lastMode1002 = 2;
    public static int lastMode1003 = 2;
    public static long lastUpdateBitmapTime = 0;
    public static long lastUpdateWidgetBitmapTime = 0;
    public static long timeMapSurfaceDestroyed = 0;
    public static long timeWidgetSurfaceAdded = 0;
    public static MapBound mapBound = null;
    public static boolean isNightMode = false;
    private static boolean firstAdd = true;
    private static boolean backToLauncher = false;
    private static float[] mGravity = new float[3];
    private static final LocationInfo locationInfo = new LocationInfo();
    private static double lastAltitude = -1.0d;
    private static float lastGPSBearing = 0.0f;

    public static void comment() {
    }

    public static void comment(String str) {
    }

    public static void onRemoveSurface(Surface surface) {
    }

    public static int onSwitchIcon(int i) {
        if (i == 65) {
            return 4;
        }
        if (i == 66) {
            return 5;
        }
        return i;
    }

    public static void output() {
        File dataDirectory = applicationContext.get().getFilesDir();
        AssetManager assetManager = applicationContext.get().getAssets();
        try {
            File file = new File(dataDirectory, "silen.m4a");
            SilenPath = applicationContext.get().getFilesDir() + "/silen.m4a";
            if (!file.exists()) {
                InputStream inputStream = assetManager.open("silen.m4a");
                OutputStream outputStream = new FileOutputStream(file);
                byte[] buffer = new byte[ErrorCode.SENSOR_ACC_TIMESTAMP_ERROR];
                while (true) {
                    int length = inputStream.read(buffer);
                    if (length > 0) {
                        outputStream.write(buffer, 0, length);
                    } else {
                        inputStream.close();
                        outputStream.close();
                        return;
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Surface getSurface1003() {
        return AutoSimilarWidgetService.h;
    }

    public static void e(String str) {
        e(str, null);
    }

    public static void e(String str, String str2) {
        e(str, str2, new Object[0]);
    }

    public static void e(String str, String str2, Object... objArr) {
        e(str, str2, null, null, objArr);
    }

    public static void e(String str, String str2, String str3, Object... objArr) {
        e(str, str2, str3, null, objArr);
    }

    public static void e(String str, String str2, Throwable th, Object... objArr) {
        e(str, str2, null, th, objArr);
    }

    public static void e(String str, String str2, String str3, Throwable th, Object... objArr) {
        AutoUtils.e(str, str2, str3, th, objArr);
    }

    public static int onGetStreamType(AudioConfigData audioConfigData) {
        audioConfigData.isUserHighVersionAudioApi = true;
        audioConfigData.ttsDelayBeforePlay = SecExceptionCode.SEC_ERROR_STA_ENC;
        audioConfigData.ttsDelayAfterPlay = SecExceptionCode.SEC_ERROR_STA_ENC;
        audioConfigData.audioChannel = AutoUtils.autoSetting.audioChannel;
        audioConfigData.isNeedContinueTtsAfterFocusLoss = false;
        audioConfigData.isPlayWarningSoundNeedRequestFocus = true;
        audioConfigData.audioMode = 3;
        return AutoUtils.autoSetting.audioChannel;
    }

    public static void onReceiveIntent(Intent intent) {
        if (intent != null && intent.getIntExtra(StandardProtocolKey.KEY_TYPE, -1) == 10120) {
            int intExtra = intent.getIntExtra(StandardProtocolKey.EXTRA_EXTERNAL_MAP_LEVEL, 0);
            if (intExtra == -3) {
                AndroidWidgetMap.zoomOut();
            } else if (intExtra == -2) {
                AndroidWidgetMap.zoomIn();
            } else {
                int intExtra2 = intent.getIntExtra(StandardProtocolKey.EXTRA_EXTERNAL_ENGINE_ID, -1);
                int intExtra3 = intent.getIntExtra(StandardProtocolKey.EXTRA_EXTERNAL_FULL_VIEW, -1);
                int intExtra4 = intent.getIntExtra(StandardProtocolKey.EXTRA_EXTERNAL_MAP_MODE, -1);
                if (System.currentTimeMillis() - applicationRuntime < 180000 && recoveredMapModeTime == 0) {
                    recoveredMapModeTime = System.currentTimeMillis();
                } else if (intExtra2 == 1001 && intExtra3 == 0) {
                    recoveredMapMode = -1;
                    if (intExtra4 == 2) {
                        recoveredMapMode = 1;
                    } else if (intExtra4 == 1) {
                        recoveredMapMode = 0;
                    } else if (intExtra4 == 0) {
                        recoveredMapMode = 2;
                    }
                    if (recoveredMapMode != -1) {
                        if (mapSurfaceViewReference.get() == null) {
                            openMapOperation("androidauto://mapOpera?sourceApplication=Auto&switchView=" + recoveredMapMode);
                            recoveredMapModeTime = System.currentTimeMillis();
                        } else {
                            AndroidProtocolExe.doOperaMap(5020, 2, recoveredMapMode, 0);
                        }
                    }
                }
            }
        }
        onSurfaceViewUpdate();
    }

    private static void openMapOperation(String str) {
        Intent intent = new Intent();
        intent.setData(Uri.parse(str));
        intent.setFlags(268435456);
        applicationContext.get().startActivity(intent);
    }

    public static boolean onTouchEvent(View view, MotionEvent motionEvent) {
        return AutoUtils.onTouchEvent(view, motionEvent);
    }

    public static boolean isAdayo() {
        return Build.BRAND.equalsIgnoreCase("Adayo");
    }

    public static boolean isAPTIV() {
        return Build.BRAND.equalsIgnoreCase("APTIV");
    }

    public static boolean isMobile() {
        return (isAdayo() || !isAPTIV()) ? true : true;
    }

    public static int onNativeGetIntValue(int i) {
        if (i == 3006) {
            return 3;
        }
        return AndroidAdapterConfiger.nativeGetIntValue(i);
    }

    public static void createExternalScreen(PresentationConfig presentationConfig) {
        checkConfig(presentationConfig);
    }

    public static void checkConfig(PresentationConfig presentationConfig) {
        AutoUtils.checkConfig(presentationConfig);
    }

    public static void createExternalScreenHelper() {
        AutoUtils.createExternalScreenHelper();
    }

    public static boolean onGetStringValue(String str) {
        return "isNeedSwitchNewIconID".equals(str) || "isNeedFrontMemory".equals(str);
    }

    /* JADX WARN: Type inference failed for: r4v3, types: [com.AutoHelper$1] */
    public static void onMapSurfaceCreated(SurfaceView surfaceView) {
        if (surfaceView.getClass().getSimpleName().contains("MapSurfaceViewEx")) {
            mapSurfaceViewReference = new WeakReference<>(surfaceView);
            if (recoveredMapMode == -1 || System.currentTimeMillis() - recoveredMapModeTime >= 3000) {
                return;
            }
            new Thread() { // from class: com.AutoHelper.1
                @Override // java.lang.Thread, java.lang.Runnable
                public void run() {
                    super.run();
                    try {
                        Thread.sleep(250L);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    AndroidProtocolExe.doOperaMap(5020, 2, AutoHelper.recoveredMapMode, 0);
                }
            }.start();
        }
    }

    public static void onMapSurfaceDestroyed(SurfaceView surfaceView) {
        if (surfaceView.getClass().getSimpleName().contains("MapSurfaceViewEx")) {
            mapSurfaceViewReference.clear();
            timeMapSurfaceDestroyed = System.currentTimeMillis();
        }
    }

    public static void onSendStatus(int i, int i2, int i3) {
        if (i2 == 1001) {
            lastMode1001 = i3;
        } else if (i2 == 1002) {
            lastMode1002 = i3;
        } else if (i2 == 1003) {
            lastMode1003 = i3;
        }
        if (i > 1) {
            notifyStatus(0, i2);
        }
    }

    public static void notifyStatus(final int i, final int i2) {
        new Thread(new Runnable() { // from class: com.AutoHelper$$ExternalSyntheticLambda1
            @Override // java.lang.Runnable
            public final void run() {
                AutoHelper.lambda$notifyStatus$0(i2, i);
            }
        }).start();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static /* synthetic */ void lambda$notifyStatus$0(int i, int i2) {
        int i3;
        try {
            Thread.sleep(600L);
            if (i == 1001) {
                i3 = lastMode1001;
            } else {
                i3 = i == 1002 ? lastMode1002 : lastMode1003;
            }
            AndroidProtocolExe.sendExScreenStatus(i2, i, i3);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void onSurfaceViewCreated(final int i, final SurfaceView surfaceView) {
        final ViewGroup viewGroup = (ViewGroup) surfaceView.getParent();
        viewGroup.post(new Runnable() { // from class: com.AutoHelper$$ExternalSyntheticLambda2
            @Override // java.lang.Runnable
            public final void run() {
                AutoHelper.lambda$onSurfaceViewCreated$1(surfaceView, viewGroup, i);
            }
        });
        notifyStatus(0, i);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static /* synthetic */ void lambda$onSurfaceViewCreated$1(SurfaceView surfaceView, ViewGroup viewGroup, final int i) {
        final SurfaceView surfaceView2 = new SurfaceView(surfaceView.getContext());
        viewGroup.addView(surfaceView2, 1, new ViewGroup.LayoutParams(-1, -1));
        surfaceView2.getHolder().addCallback(new SurfaceHolder.Callback() { // from class: com.AutoHelper.2
            @Override // android.view.SurfaceHolder.Callback
            public void surfaceChanged(SurfaceHolder surfaceHolder, int i2, int i3, int i4) {
            }

            /* JADX WARN: Type inference failed for: r2v5, types: [com.AutoHelper$2$1] */
            @Override // android.view.SurfaceHolder.Callback
            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                int i2 = i;
                if (i2 == 1001) {
                    AutoHelper.surface1001Reference = new WeakReference<>(surfaceView2.getHolder().getSurface());
                } else if (i2 == 1002) {
                    AutoHelper.surface1002Reference = new WeakReference<>(surfaceView2.getHolder().getSurface());
                }
                AutoHelper.notifyStatus(0, i);
                if (AutoHelper.isAPTIV()) {
                    new Thread() { // from class: com.AutoHelper.2.1
                        @Override // java.lang.Thread, java.lang.Runnable
                        public void run() {
                            try {
                                sleep(3000L);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            AutoHelper.notifyStatus(0, i);
                        }
                    }.start();
                }
            }

            @Override // android.view.SurfaceHolder.Callback
            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                int i2 = i;
                if (i2 == 1001) {
                    AutoHelper.surface1001Reference.clear();
                } else if (i2 == 1002) {
                    AutoHelper.surface1002Reference.clear();
                }
            }
        });
    }

    public static void drawBitMap(int i, Surface surface, Bitmap bitmap) {
        if (surface == null || !surface.isValid() || bitmap.getWidth() <= 0 || bitmap.getHeight() <= 0) {
            return;
        }
        Paint paint = new Paint();
        Canvas lockHardwareCanvas = surface.lockHardwareCanvas();
        Matrix matrix = new Matrix();
        float max = Math.max(lockHardwareCanvas.getWidth() / bitmap.getWidth(), Math.max(320, lockHardwareCanvas.getHeight()) / bitmap.getHeight());
        matrix.postScale(max, max);
        int i2 = 0;
        if (mapBound.left != mapBound.width / 2) {
            int i3 = mapBound.left;
            if (mapBound.width != bitmap.getWidth()) {
                i3 -= (mapBound.width / 2) - (bitmap.getWidth() / 2);
            }
            int width = (int) (bitmap.getWidth() * max);
            int i4 = (int) (i3 * max);
            if ((lockHardwareCanvas.getWidth() / 2) + i4 > width) {
                i2 = (width / 2) - (lockHardwareCanvas.getWidth() / 2);
            } else if (i4 - (lockHardwareCanvas.getWidth() / 2) < 0) {
                i2 = ((-width) / 2) + (lockHardwareCanvas.getWidth() / 2);
            } else {
                i2 = i4 - (width / 2);
            }
        }
        matrix.postTranslate((int) ((lockHardwareCanvas.getWidth() / 2) - (i2 + ((bitmap.getWidth() * max) / 2.0f))), (int) ((lockHardwareCanvas.getHeight() / 2) - ((max * bitmap.getHeight()) / 2.0f)));
        lockHardwareCanvas.drawBitmap(bitmap, matrix, paint);
        surface.unlockCanvasAndPost(lockHardwareCanvas);
    }

    public static void updateSurface(Bitmap bitmap, boolean z) {
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        Object obj = updateLockObject;
        synchronized (obj) {
            if (isUpdating) {
                return;
            }
            isUpdating = true;
            mapBound = AndroidWidgetMap.getMapBound();
            drawBitMap(1001, surface1001Reference.get(), bitmap);
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - lastUpdateWidgetBitmapTime > 333) {
                drawBitMap(1002, surface1002Reference.get(), bitmap);
                lastUpdateWidgetBitmapTime = currentTimeMillis;
                if (!z && mapSurfaceViewReference.get() == null && currentTimeMillis - timeMapSurfaceDestroyed > TimeUpdateIgnoreForWidget && currentTimeMillis - timeWidgetSurfaceAdded > TimeUpdateIgnoreForWidget) {
                    drawBitMap(1003, getSurface1003(), bitmap);
                }
            }
            bitmap.recycle();
            synchronized (obj) {
                isUpdating = false;
            }
        }
    }

    public static void onSurfaceViewUpdate() {
        SurfaceView surfaceView;
        if (isUpdating) {
            return;
        }
        if ((!ignoreUpdateImageFlag || System.currentTimeMillis() - ignoreUpdateImageTime >= 500) && (surfaceView = mapSurfaceViewReference.get()) != null && surfaceView.getHolder().getSurface().isValid()) {
            long currentTimeMillis = System.currentTimeMillis();
            if (lastUpdateBitmapTime > currentTimeMillis - 166) {
                return;
            }
            lastUpdateBitmapTime = currentTimeMillis;
            try {
                if (updateHandler == null) {
                    updateHandler = new Handler();
                }
                final Bitmap createBitmap = Bitmap.createBitmap(surfaceView.getWidth(), surfaceView.getHeight(), Bitmap.Config.ARGB_8888);
                PixelCopy.request(surfaceView, createBitmap, new PixelCopy.OnPixelCopyFinishedListener() { // from class: com.AutoHelper$$ExternalSyntheticLambda0
                    @Override // android.view.PixelCopy.OnPixelCopyFinishedListener
                    public final void onPixelCopyFinished(int i) {
                        AutoHelper.lambda$onSurfaceViewUpdate$2(createBitmap, i);
                    }
                }, updateHandler);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static /* synthetic */ void lambda$onSurfaceViewUpdate$2(Bitmap bitmap, int i) {
        if (i == 0) {
            updateSurface(bitmap, true);
        } else {
            bitmap.recycle();
        }
    }

    /* JADX WARN: Type inference failed for: r0v0, types: [com.AutoHelper$3] */
    public static void checkMuteStatus(final Context context, final int i) {
        if (context != null) {
            if (i == 0) {
                AutoUtils.setMuteStatus(context, false);
            } else {
                new Thread() { // from class: com.AutoHelper.3
                    @Override // java.lang.Thread, java.lang.Runnable
                    public void run() {
                        try {
                            sleep(i);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        AutoUtils.setMuteStatus(context, false);
                    }
                }.start();
            }
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    public static boolean isFullScreen() {
        return (AutoUtils.autoSetting.showStatusBar ? 1 : 0) ^ 6;
    }

    /* JADX WARN: Type inference failed for: r6v5, types: [com.AutoHelper$4] */
    public static void enterImmersiveMode(final Window window, boolean z) {
        isNightMode = z;
        View decorView = window.getDecorView();
        int i = ErrorCode.SENSOR_MAGNETIC_TIMESTAMP_ERROR;
        int i2 = (!z ? 8192 : 0) | 5634;
        if (AutoUtils.autoSetting.showNavi || isFullScreen()) {
            if (isFullScreen() && AutoUtils.autoSetting.showNavi) {
                i2 = 5124;
            } else if (AutoUtils.autoSetting.showNavi) {
                if (z) {
                    i = 0;
                }
                i2 = i | 5120;
            } else {
                i2 = 5638;
            }
        }
        window.addFlags(67108864);
        window.addFlags(256);
        window.addFlags(512);
        window.setStatusBarColor(0);
        decorView.setSystemUiVisibility(i2);
        if (backToLauncher) {
            backToLauncher = false;
            new Thread() { // from class: com.AutoHelper.4
                @Override // java.lang.Thread, java.lang.Runnable
                public void run() {
                    try {
                        sleep(AutoUtils.autoSetting.hideDelay * 1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    AutoUtils.startLauncher(window.getContext());
                }
            }.start();
        }
    }

    public static void onLoadUISurface(SurfaceView surfaceView, boolean z) {
        if (surfaceView == null) {
            return;
        }
        uiSurfaceView = new WeakReference<>(surfaceView);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) surfaceView.getLayoutParams();
        layoutParams.topMargin = isFullScreen() ? 0 : AutoUtils.dp2px(surfaceView.getContext(), 64.0f);
        surfaceView.setLayoutParams(layoutParams);
        if (AutoUtils.autoSetting.showNavi || z) {
            View view = (View) surfaceView.getParent();
            view.setPadding(!AutoUtils.autoSetting.showNavi ? 0 : AutoUtils.dp2px(surfaceView.getContext(), 100.0f), 0, 0, 0);
            view.setBackgroundColor(-16777216);
        }
    }

    public static void onLoadUISurface(SurfaceView surfaceView) {
        onLoadUISurface(surfaceView, false);
    }

    public static void onAddBitMap(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        if (!muteStatusChecked) {
            muteStatusChecked = true;
            checkMuteStatus(applicationContext.get(), SecExceptionCode.SEC_ERROR_ORANGE);
        }
        if (mapSurfaceViewReference.get() != null || isUpdating) {
            bitmap.recycle();
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (lastUpdateBitmapTime > currentTimeMillis - 166) {
            return;
        }
        lastUpdateBitmapTime = currentTimeMillis;
        updateSurface(bitmap, false);
    }

    public static void onActivityCreated(Activity activity) {
        Intent intent;
        Bundle extras;
        activityContext = new WeakReference<>(activity);
        applicationContext = new WeakReference<>(activity.getApplicationContext());
        if (!muteStatusCheckedFromMain) {
            AutoUtils.initAutoSettings(activity);
            muteStatusCheckedFromMain = true;
            initSensor(activity.getApplicationContext());
            checkMuteStatus(activity, 1800);
            notifyAllStatus(SecExceptionCode.SEC_ERROR_ORANGE);
            if (AutoUtils.autoSetting.autoHide && AutoUtils.autoSetting.autoStart && (extras = (intent = activity.getIntent()).getExtras()) != null && !intent.getBooleanExtra("auto_start", true)) {
                extras.remove("auto_start");
                backToLauncher = true;
            }
        }
        output();
    }

    /* JADX WARN: Type inference failed for: r0v0, types: [com.AutoHelper$5] */
    public static void notifyAllStatus(final int i) {
        new Thread() { // from class: com.AutoHelper.5
            @Override // java.lang.Thread, java.lang.Runnable
            public void run() {
                try {
                    Thread.sleep(i);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                AutoHelper.notifyStatus(0, 1003);
                AutoHelper.isAPTIV();
                AutoHelper.notifyStatus(0, 1002);
                AutoHelper.notifyStatus(0, 1001);
            }
        }.start();
    }

    /* JADX WARN: Type inference failed for: r5v6, types: [com.AutoHelper$6] */
    public static void onAddSurface(final Service service, Surface surface) {
        applicationContext = new WeakReference<>(service.getApplicationContext());
        if (timeWidgetSurfaceAdded == 0) {
            AutoUtils.initAutoSettings(service);
            if (AutoUtils.autoSetting.autoStart) {
                new Thread() { // from class: com.AutoHelper.6
                    @Override // java.lang.Thread, java.lang.Runnable
                    public void run() {
                        try {
                            sleep(AutoUtils.autoSetting.startDelay * 1000);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Intent intent = new Intent();
                        Bundle bundle = new Bundle();
                        bundle.putBoolean("auto_start", false);
                        intent.putExtras(bundle);
                        intent.setFlags(268435456);
                        intent.setComponent(new ComponentName("com.autonavi.amapauto", "com.autonavi.auto.remote.fill.UsbFillActivity"));
                        service.getApplicationContext().startActivity(intent);
                    }
                }.start();
            }
        }
        timeWidgetSurfaceAdded = System.currentTimeMillis();
        if (firstAdd) {
            firstAdd = false;
            notifyAllStatus(SecExceptionCode.SEC_ERROR_ORANGE);
        }
        notifyStatus(0, 1003);
    }

    public static void onGPS(LocSignData locSignData) {
        if (locSignData.gnss.course != 0.0f && Math.abs(lastGPSBearing - locSignData.gnss.course) > 1.5f) {
            float f = locSignData.gnss.course;
            lastGPSBearing = f;
            LocationInfo locationInfo2 = locationInfo;
            locationInfo2.bearing = f;
            locationInfo2.time = System.currentTimeMillis();
            locationInfo2.accuracy = locSignData.gnss.accuracy;
            locationInfo2.speed = locSignData.gnss.speed;
            locationInfo2.alt = locSignData.gnss.alt;
            locationInfo2.lon = locSignData.gnss.lon;
            locationInfo2.lat = locSignData.gnss.lat;
            locationInfo2.provider = locSignData.gnss.sourType == 0 ? "gps" : "network";
            AndroidProtocolExe.sendLocationInfo(locationInfo2);
        }
        if (isAPTIV()) {
            LocationInfo locationInfo3 = locationInfo;
            if (locationInfo3.alt == 0.0d || locationInfo3.alt == -1.0d || Math.abs(((int) lastAltitude) - ((int) locationInfo3.alt)) < 1) {
                return;
            }
            lastAltitude = locationInfo3.alt;
            Intent intent = new Intent("AUTONAVI_STANDARD_BROADCAST_SEND");
            intent.putExtra(StandardProtocolKey.KEY_TYPE, 10090);
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put(StandardProtocolKey.ALTITUDE, lastAltitude);
                intent.putExtra(StandardProtocolKey.EXTRA_LOCATION_INFO, jSONObject.toString());
                applicationContext.get().sendBroadcast(intent);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void initSensor(Context context) {
        synchronized (AutoHelper.class) {
            if (isAdayo()) {
                return;
            }
            SensorManager sensorManager = (SensorManager) context.getSystemService("sensor");
            int[] iArr = {9};
            for (int i = 0; i < 1; i++) {
                sensorManager.registerListener(new SensorEventListener() { // from class: com.AutoHelper.7
                    final float[] orientation = new float[3];
                    private final float[] RVALUE = new float[9];
                    private double lastRoll = 0.0d;
                    private double lastSlope = 0.0d;

                    @Override // android.hardware.SensorEventListener
                    public void onAccuracyChanged(Sensor sensor, int i2) {
                    }

                    @Override // android.hardware.SensorEventListener
                    public void onSensorChanged(SensorEvent sensorEvent) {
                        if (sensorEvent.sensor.getType() == 9) {
                            float[] unused = AutoHelper.mGravity = sensorEvent.values;
                            if (AutoHelper.mGravity.length < 3) {
                                return;
                            }
                            double degrees = Math.toDegrees(Math.asin(AutoHelper.mGravity[1] / Math.sqrt((AutoHelper.mGravity[1] * AutoHelper.mGravity[1]) + (AutoHelper.mGravity[2] * AutoHelper.mGravity[2]))));
                            double d = -Math.toDegrees(Math.asin(AutoHelper.mGravity[0] / Math.sqrt((AutoHelper.mGravity[0] * AutoHelper.mGravity[0]) + (AutoHelper.mGravity[2] * AutoHelper.mGravity[2]))));
                            if (Math.abs(((int) this.lastSlope) - ((int) d)) >= 1 || Math.abs(((int) this.lastRoll) - ((int) degrees)) >= 1) {
                                this.lastRoll = degrees;
                                this.lastSlope = d;
                                CarLocationInfo carLocationInfo = new CarLocationInfo();
                                carLocationInfo.rollValid = true;
                                carLocationInfo.slopeValid = true;
                                carLocationInfo.rollValue = (float) degrees;
                                carLocationInfo.slopeValue = (float) d;
                                AndroidProtocolExe.sendCarLocationInfo(carLocationInfo);
                                return;
                            }
                            return;
                        }
                        if (sensorEvent.sensor.getType() == 15) {
                            float[] unused2 = AutoHelper.mGravity = sensorEvent.values;
                            SensorManager.getRotationMatrixFromVector(this.RVALUE, sensorEvent.values);
                            SensorManager.getOrientation(this.RVALUE, this.orientation);
                            double degrees2 = Math.toDegrees(this.orientation[1]);
                            float degrees3 = (float) Math.toDegrees(this.orientation[2]);
                            float f = (float) degrees2;
                            double d2 = degrees3;
                            if (Math.abs(this.lastSlope - d2) > 1.5d || Math.abs(this.lastRoll - f) > 1.5d) {
                                this.lastRoll = f;
                                this.lastSlope = d2;
                                CarLocationInfo carLocationInfo2 = new CarLocationInfo();
                                carLocationInfo2.rollValid = true;
                                carLocationInfo2.slopeValid = true;
                                carLocationInfo2.rollValue = f;
                                carLocationInfo2.slopeValue = degrees3;
                                AndroidProtocolExe.sendCarLocationInfo(carLocationInfo2);
                            }
                        }
                    }
                }, sensorManager.getDefaultSensor(iArr[i]), 3);
            }
        }
    }
}
