package com;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ToggleButton;
import com.alibaba.wireless.security.SecExceptionCode;
import com.autonavi.amapauto.jni.AndroidAudioControl;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.extscreen.ExtScreenNative;
import com.autonavi.extscreen.dto.PresentationConfig;
import com.autonavi.extscreen.dto.ViewModeInfo;
import com.autonavi.indoor.constant.MessageCode;
import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class AutoUtils {
    private static final String TAG = "com.AutoUtils";
    public static int downPointX;
    public static int downPointY;
    public static long lastClickTime;
    public static long lastDialogTime;
    public static AutoConfig autoSetting = new AutoConfig();
    public static boolean autoConfigInited = false;
    public static boolean isPresentationCreated = false;

    public static void e(String str, String str2, String str3, Throwable th, Object... objArr) {
    }

    public static void init(Context context) {
        ThreeShotReceiver threeShotReceiver = new ThreeShotReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.adayo.threescreenshot.left");
        intentFilter.addAction("com.adayo.threescreenshot.right");
        intentFilter.addAction("android.media.VOLUME_CHANGED_ACTION");
        context.registerReceiver(threeShotReceiver, intentFilter);
    }

    public static void setMuteStatus(Context context, boolean z) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.autonavi.amapauto", "com.autonavi.amapauto.adapter.internal.AmapAutoBroadcastReceiver"));
        intent.setAction("AUTONAVI_STANDARD_BROADCAST_RECV");
        intent.putExtra(StandardProtocolKey.KEY_TYPE, 10047);
        intent.putExtra(StandardProtocolKey.EXTRA_MUTE, z ? 1 : 0);
        context.sendBroadcast(intent);
    }

    public static ViewModeInfo createViewModeInfo(int i, int i2, int i3, int i4, int i5, int i6, int i7) {
        ViewModeInfo viewModeInfo = new ViewModeInfo();
        viewModeInfo.mode = i;
        viewModeInfo.surfaceLeft = i2;
        viewModeInfo.surfaceTop = i3;
        viewModeInfo.surfaceWidth = i4;
        viewModeInfo.surfaceHeight = i5;
        viewModeInfo.viewLeft = i6;
        viewModeInfo.viewTop = i7;
        return viewModeInfo;
    }

    public static PresentationConfig createPresentationConfig(int i) {
        PresentationConfig presentationConfig = new PresentationConfig();
        presentationConfig.eglAlphaSize = 8;
        presentationConfig.createSurfaceWhenInit = 1;
        presentationConfig.deviceId = i;
        presentationConfig.viewModeInfoList = new LinkedList();
        if (i == 1001) {
            presentationConfig.width = 1920;
            presentationConfig.height = MessageCode.MSG_LBS_UNKNOWN_ERROR;
            presentationConfig.pluginName = "InstrumentPannelLarge";
        } else if (i == 1002) {
            presentationConfig.width = 1920;
            presentationConfig.height = MessageCode.MSG_LBS_UNKNOWN_ERROR;
            presentationConfig.pluginName = "InstrumentPannelSmall";
        } else if (i == 1003) {
            presentationConfig.width = 580;
            presentationConfig.height = 600;
            presentationConfig.pluginName = "Widget";
            presentationConfig.removeSurface = 1;
        }
        return presentationConfig;
    }

    public static int dp2px(Context context, float f) {
        return (int) TypedValue.applyDimension(1, f, context.getResources().getDisplayMetrics());
    }

    public static ViewGroup createEnableView(Context context, String str, boolean z, CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        int dp2px = dp2px(context, 180.0f);
        int dp2px2 = dp2px(context, 48.0f);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setLayoutParams(new LinearLayout.LayoutParams(-2, dp2px2));
        linearLayout.setOrientation(0);
        TextView textView = new TextView(context);
        textView.setText(str);
        textView.setMinWidth(dp2px);
        linearLayout.addView(textView);
        ToggleButton toggleButton = new ToggleButton(context);
        linearLayout.addView(toggleButton);
        toggleButton.setChecked(z);
        toggleButton.setOnCheckedChangeListener(onCheckedChangeListener);
        return linearLayout;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public interface TextChangedListener extends TextWatcher {
        @Override // android.text.TextWatcher
        default void afterTextChanged(Editable editable) {
        }

        @Override // android.text.TextWatcher
        default void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        void onTextChanged(CharSequence charSequence);

        @Override // android.text.TextWatcher
        default void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            if (charSequence.length() < 1) {
                return;
            }
            try {
                onTextChanged(charSequence);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ViewGroup createNumberView(Context context, String str, int i, TextChangedListener textChangedListener) {
        int dp2px = dp2px(context, 180.0f);
        int dp2px2 = dp2px(context, 48.0f);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setLayoutParams(new LinearLayout.LayoutParams(-2, dp2px2));
        linearLayout.setOrientation(0);
        TextView textView = new TextView(context);
        textView.setText(str);
        textView.setMinWidth(dp2px);
        linearLayout.addView(textView);
        EditText editText = new EditText(context);
        editText.setMaxHeight(dp2px2);
        editText.setText(String.valueOf(i));
        editText.setInputType(2);
        linearLayout.addView(editText);
        editText.addTextChangedListener(textChangedListener);
        return linearLayout;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class AutoConfig {
        int audioChannel;
        boolean autoStart = true;
        boolean autoHide = false;
        boolean showStatusBar = true;
        boolean showNavi = false;
        int startDelay = 3;
        int hideDelay = 3;

        AutoConfig() {
            this.audioChannel = AutoHelper.isAdayo() ? 11 : 4;
        }

        public String toString() {
            return "{\"autoStart\":" + this.autoStart + ", \"autoHide\":" + this.autoHide + ", \"showStatusBar\":" + this.showStatusBar + ", \"startDelay\":" + this.startDelay + ", \"showNavi\":" + this.showNavi + ", \"hideDelay\":" + this.hideDelay + ", \"audioChannel\":" + this.audioChannel + '}';
        }
    }

    public static void initAutoSettings(Context context) {
        if (autoConfigInited) {
            return;
        }
        try {
            String str = context.getFilesDir().getAbsolutePath() + File.separator + "auto_config.json";
            if (!CommonUtil.isFileExist(str)) {
                autoConfigInited = true;
                return;
            }
            JSONObject jSONObject = new JSONObject(CommonUtil.file2String(str));
            AutoConfig autoConfig = autoSetting;
            autoConfig.autoStart = jSONObject.optBoolean("autoStart", autoConfig.autoStart);
            AutoConfig autoConfig2 = autoSetting;
            autoConfig2.autoHide = jSONObject.optBoolean("autoHide", autoConfig2.autoHide);
            AutoConfig autoConfig3 = autoSetting;
            autoConfig3.showStatusBar = jSONObject.optBoolean("showStatusBar", autoConfig3.showStatusBar);
            AutoConfig autoConfig4 = autoSetting;
            autoConfig4.showNavi = jSONObject.optBoolean("showNavi", autoConfig4.showNavi);
            AutoConfig autoConfig5 = autoSetting;
            autoConfig5.startDelay = jSONObject.optInt("startDelay", autoConfig5.startDelay);
            AutoConfig autoConfig6 = autoSetting;
            autoConfig6.hideDelay = jSONObject.optInt("hideDelay", autoConfig6.hideDelay);
            AutoConfig autoConfig7 = autoSetting;
            autoConfig7.audioChannel = jSONObject.optInt("audioChannel", autoConfig7.audioChannel);
            autoConfigInited = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveAutoSettings(Context context) {
        try {
            CommonUtil.string2file(autoSetting.toString(), context.getFilesDir().getAbsolutePath() + File.separator + "auto_config.json");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void openAutoConfigDialog(final View view) {
        final Context context = view.getContext();
        initAutoSettings(context);
        final AtomicLong atomicLong = new AtomicLong(autoSetting.toString().hashCode());
        LinearLayout linearLayout = new LinearLayout(context);
        LinearLayout linearLayout2 = new LinearLayout(context);
        LinearLayout linearLayout3 = new LinearLayout(context);
        linearLayout2.setOrientation(1);
        linearLayout3.setOrientation(1);
        linearLayout.addView(linearLayout2, new LinearLayout.LayoutParams(0, -2, 1.0f));
        linearLayout.addView(linearLayout3, new LinearLayout.LayoutParams(0, -2, 1.0f));
        int dp2px = dp2px(context, 8.0f);
        linearLayout.setPadding(dp2px, dp2px, dp2px, dp2px);
        linearLayout.setOrientation(0);
        linearLayout.setMinimumWidth(dp2px(context, 640.0f));
        linearLayout2.addView(createEnableView(context, "开机自启", autoSetting.autoStart, new CompoundButton.OnCheckedChangeListener() { // from class: com.AutoUtils$$ExternalSyntheticLambda0
            @Override // android.widget.CompoundButton.OnCheckedChangeListener
            public final void onCheckedChanged(CompoundButton compoundButton, boolean z) {
                AutoUtils.autoSetting.autoStart = z;
            }
        }));
        linearLayout3.addView(createNumberView(context, "延迟启动秒数(0-15)", autoSetting.startDelay, new TextChangedListener() { // from class: com.AutoUtils$$ExternalSyntheticLambda1
            @Override // com.AutoUtils.TextChangedListener
            public final void onTextChanged(CharSequence charSequence) {
                AutoUtils.autoSetting.startDelay = Integer.parseInt(charSequence.toString());
            }
        }));
        linearLayout2.addView(createEnableView(context, "自启后返回桌面", autoSetting.autoHide, new CompoundButton.OnCheckedChangeListener() { // from class: com.AutoUtils$$ExternalSyntheticLambda2
            @Override // android.widget.CompoundButton.OnCheckedChangeListener
            public final void onCheckedChanged(CompoundButton compoundButton, boolean z) {
                AutoUtils.autoSetting.autoHide = z;
            }
        }));
        linearLayout3.addView(createNumberView(context, "延迟返回秒数(0-15)", autoSetting.hideDelay, new TextChangedListener() { // from class: com.AutoUtils$$ExternalSyntheticLambda3
            @Override // com.AutoUtils.TextChangedListener
            public final void onTextChanged(CharSequence charSequence) {
                AutoUtils.autoSetting.hideDelay = Integer.parseInt(charSequence.toString());
            }
        }));
        linearLayout2.addView(createEnableView(context, "显示状态栏", autoSetting.showStatusBar, new CompoundButton.OnCheckedChangeListener() { // from class: com.AutoUtils$$ExternalSyntheticLambda4
            @Override // android.widget.CompoundButton.OnCheckedChangeListener
            public final void onCheckedChanged(CompoundButton compoundButton, boolean z) {
                AutoUtils.lambda$openAutoConfigDialog$4(view, compoundButton, z);
            }
        }));
        linearLayout2.addView(createEnableView(context, "显示侧边键", autoSetting.showNavi, new CompoundButton.OnCheckedChangeListener() { // from class: com.AutoUtils$$ExternalSyntheticLambda5
            @Override // android.widget.CompoundButton.OnCheckedChangeListener
            public final void onCheckedChanged(CompoundButton compoundButton, boolean z) {
                AutoUtils.lambda$openAutoConfigDialog$5(view, compoundButton, z);
            }
        }));
        linearLayout3.addView(createNumberView(context, "声道设置(0-30)", autoSetting.audioChannel, new TextChangedListener() { // from class: com.AutoUtils$$ExternalSyntheticLambda6
            @Override // com.AutoUtils.TextChangedListener
            public final void onTextChanged(CharSequence charSequence) {
                AutoUtils.lambda$openAutoConfigDialog$6(charSequence);
            }
        }));
        Button button = new Button(context);
        button.setText("恢复默认");
        button.setOnClickListener(new View.OnClickListener() { // from class: com.AutoUtils$$ExternalSyntheticLambda7
            @Override // android.view.View.OnClickListener
            public final void onClick(View view2) {
                AutoUtils.lambda$openAutoConfigDialog$7(atomicLong, r2, view, context, view2);
            }
        });
        linearLayout2.addView(button);
        AlertDialog create = new AlertDialog.Builder(context).setView(linearLayout).setOnDismissListener(new DialogInterface.OnDismissListener() { // from class: com.AutoUtils$$ExternalSyntheticLambda8
            @Override // android.content.DialogInterface.OnDismissListener
            public final void onDismiss(DialogInterface dialogInterface) {
                AutoUtils.lambda$openAutoConfigDialog$8(atomicLong, context, dialogInterface);
            }
        }).create();
        final Dialog[] dialogArr = {create};
        create.show();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static /* synthetic */ void lambda$openAutoConfigDialog$4(View view, CompoundButton compoundButton, boolean z) {
        autoSetting.showStatusBar = z;
        AutoHelper.onLoadUISurface(AutoHelper.uiSurfaceView.get(), true);
        AutoHelper.enterImmersiveMode(((Activity) view.getContext()).getWindow(), AutoHelper.isNightMode);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static /* synthetic */ void lambda$openAutoConfigDialog$5(View view, CompoundButton compoundButton, boolean z) {
        autoSetting.showNavi = z;
        AutoHelper.onLoadUISurface(AutoHelper.uiSurfaceView.get(), true);
        AutoHelper.enterImmersiveMode(((Activity) view.getContext()).getWindow(), AutoHelper.isNightMode);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static /* synthetic */ void lambda$openAutoConfigDialog$6(CharSequence charSequence) {
        autoSetting.audioChannel = Integer.parseInt(charSequence.toString());
        AndroidAudioControl.setStreamType(autoSetting.audioChannel);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static /* synthetic */ void lambda$openAutoConfigDialog$7(AtomicLong atomicLong, Dialog[] dialogArr, View view, Context context, View view2) {
        autoSetting = new AutoConfig();
        atomicLong.set(r6.toString().hashCode());
        dialogArr[0].dismiss();
        openAutoConfigDialog(view);
        CommonUtil.deleteFile(new File(context.getFilesDir().getAbsolutePath() + File.separator + "auto_config.json"));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static /* synthetic */ void lambda$openAutoConfigDialog$8(AtomicLong atomicLong, Context context, DialogInterface dialogInterface) {
        if (autoSetting.toString().hashCode() != atomicLong.get()) {
            saveAutoSettings(context);
        }
    }

    public static boolean onTouchEvent(View view, MotionEvent motionEvent) {
        if (motionEvent.getPointerCount() > 1 || motionEvent.getAction() == 0 || motionEvent.getAction() == 2) {
            AutoHelper.ignoreUpdateImageFlag = true;
            AutoHelper.ignoreUpdateImageTime = System.currentTimeMillis();
        } else {
            AutoHelper.ignoreUpdateImageFlag = false;
        }
        if (motionEvent.getPointerCount() == 5 && motionEvent.getActionMasked() == 5) {
            if (System.currentTimeMillis() - lastClickTime < 1000) {
                openAutoConfigDialog(view);
            }
            lastClickTime = System.currentTimeMillis();
        }
        if (motionEvent.getPointerCount() > 1) {
            return false;
        }
        if (motionEvent.getAction() == 0) {
            downPointX = (int) motionEvent.getX();
            downPointY = (int) motionEvent.getY();
        }
        if (downPointX > 96 || downPointY < 64 || Math.max(motionEvent.getY(), downPointY) > 592.0f) {
            return false;
        }
        if (motionEvent.getAction() == 1) {
            if (motionEvent.getEventTime() - motionEvent.getDownTime() < 350 && motionEvent.getX() - downPointX > 32.0f && Math.abs(motionEvent.getY() - downPointY) / (Math.abs(motionEvent.getX() - downPointX) + 1.0f) < 3.0f) {
                Context context = (Context) (AutoHelper.activityContext.get() == null ? AutoHelper.applicationContext : AutoHelper.activityContext).get();
                if (context != null) {
                    startLauncher(context);
                    return true;
                }
            }
            if (motionEvent.getX() - downPointX < 32.0f) {
                return false;
            }
        }
        return downPointX < 36;
    }

    private static /* synthetic */ void lambda$onTouchEvent$9(DialogInterface dialogInterface, int i) {
        AndroidAudioControl.setStreamType(i);
        dialogInterface.cancel();
    }

    public static void startLauncher(Context context) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        intent.setFlags(268435456);
        context.startActivity(intent);
    }

    public static void createExternalScreenHelper() {
        if (isPresentationCreated) {
            return;
        }
        isPresentationCreated = true;
        ExtScreenNative.createExternalScreen2(createPresentationConfig(1001));
        ExtScreenNative.createExternalScreen2(createPresentationConfig(1002));
        ExtScreenNative.createExternalScreen2(createPresentationConfig(1003));
    }

    public static void checkConfig(PresentationConfig presentationConfig) {
        if (AutoHelper.isMobile()) {
            if (presentationConfig.deviceId == 1001) {
                presentationConfig.renderType = 1;
                presentationConfig.removeSurface = 0;
                presentationConfig.isSeparateRender = true;
                presentationConfig.viewModeInfoList = new LinkedList();
                if (AutoHelper.isMobile()) {
                    presentationConfig.viewModeInfoList.add(createViewModeInfo(1, 0, 0, 1280, MessageCode.MSG_LBS_UNKNOWN_ERROR, 0, 0));
                } else {
                    presentationConfig.viewModeInfoList.add(createViewModeInfo(1, 110, 60, SecExceptionCode.SEC_ERROR_AVMP_SAFETOKEN, 551, 0, 0));
                }
                presentationConfig.viewModeInfoList.add(createViewModeInfo(2, 110, 60, SecExceptionCode.SEC_ERROR_AVMP_SAFETOKEN, 551, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(3, 710, 174, SecExceptionCode.SEC_ERROR_DYN_STORE, SecExceptionCode.SEC_ERROR_DYN_ENC, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(4, 1307, 174, SecExceptionCode.SEC_ERROR_DYN_STORE, SecExceptionCode.SEC_ERROR_DYN_ENC, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(5, 710, 174, SecExceptionCode.SEC_ERROR_DYN_STORE, SecExceptionCode.SEC_ERROR_DYN_ENC, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(6, 1307, 174, SecExceptionCode.SEC_ERROR_DYN_STORE, SecExceptionCode.SEC_ERROR_DYN_ENC, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(7, 158, 120, 480, 282, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(8, 158, 120, 480, 282, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(9, 738, 181, 444, 350, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(10, 738, 181, 444, 350, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(11, 0, 0, 1920, MessageCode.MSG_LBS_UNKNOWN_ERROR, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(12, 0, 0, 1920, MessageCode.MSG_LBS_UNKNOWN_ERROR, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(13, 120, 164, MessageCode.MSG_BLE_NO_SCAN, 450, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(14, 120, 164, MessageCode.MSG_BLE_NO_SCAN, 450, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(15, SecExceptionCode.SEC_ERROR_INIT_STRONG_DEPEND_ERROR, 75, 1660, 549, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(16, SecExceptionCode.SEC_ERROR_INIT_STRONG_DEPEND_ERROR, 75, 1660, 549, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(17, 556, 161, 808, 463, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(18, 556, 161, 808, 463, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(19, 78, 83, 594, 594, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(20, 78, 83, 594, 594, 0, 0));
                return;
            }
            if (presentationConfig.deviceId == 1002) {
                presentationConfig.renderType = 1;
                presentationConfig.removeSurface = 0;
                presentationConfig.isSeparateRender = true;
                presentationConfig.viewModeInfoList.add(createViewModeInfo(1, 710, 174, SecExceptionCode.SEC_ERROR_DYN_STORE, SecExceptionCode.SEC_ERROR_DYN_ENC, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(2, 1307, 174, SecExceptionCode.SEC_ERROR_DYN_STORE, SecExceptionCode.SEC_ERROR_DYN_ENC, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(3, 710, 174, SecExceptionCode.SEC_ERROR_DYN_STORE, SecExceptionCode.SEC_ERROR_DYN_ENC, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(4, 1307, 174, SecExceptionCode.SEC_ERROR_DYN_STORE, SecExceptionCode.SEC_ERROR_DYN_ENC, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(5, 738, 181, 444, 350, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(6, 738, 181, 444, 350, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(7, 1280, 120, 480, 282, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(8, 1280, 120, 480, 282, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(9, 1294, 164, MessageCode.MSG_BLE_NO_SCAN, 450, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(10, 1294, 164, MessageCode.MSG_BLE_NO_SCAN, 450, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(11, 1248, 83, 594, 594, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(12, 1248, 83, 594, 594, 0, 0));
                return;
            }
            if (presentationConfig.deviceId == 1003) {
                presentationConfig.renderType = 2;
                presentationConfig.removeSurface = 1;
                presentationConfig.isSeparateRender = false;
                if (AutoHelper.isMobile()) {
                    presentationConfig.viewModeInfoList.add(createViewModeInfo(1, 0, 0, 1170, 600, 0, 0));
                } else {
                    presentationConfig.viewModeInfoList.add(createViewModeInfo(1, 0, 0, 580, 600, 0, 0));
                }
                presentationConfig.viewModeInfoList.add(createViewModeInfo(2, 0, 0, 1170, 600, 0, 0));
                presentationConfig.viewModeInfoList.add(createViewModeInfo(3, 0, 0, 1170, 295, 0, 0));
            }
        }
    }
}
