package com.alibaba.android.ark;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/* loaded from: classes.dex */
public enum AIMConvType {
    CONV_TYPE_UNKNOW(-1),
    CONV_TYPE_SINGLE(1),
    CONV_TYPE_GROUP(2);

    public static final Map<Integer, AIMConvType> sValueToEnumMap = new HashMap();
    public final int value;

    static {
        Iterator it = EnumSet.allOf(AIMConvType.class).iterator();
        while (it.hasNext()) {
            AIMConvType aIMConvType = (AIMConvType) it.next();
            sValueToEnumMap.put(Integer.valueOf(aIMConvType.value), aIMConvType);
        }
    }

    AIMConvType(int i) {
        this.value = i;
    }

    public static AIMConvType forValue(int i) {
        return sValueToEnumMap.get(Integer.valueOf(i));
    }

    public int getValue() {
        return this.value;
    }
}
