package com.alibaba.android.ark;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/* loaded from: classes.dex */
public enum AIMMsgRecallType {
    RECALL_TYPE_UNKNOWN(-1),
    RECALL_TYPE_SENDER(0),
    RECALL_TYPE_GROUP_OWNER(1),
    RECALL_TYPE_SYSTEM(2),
    RECALL_TYPE_SECURITY(3),
    RECALL_TYPE_ADMIN(4),
    RECALL_TYPE_CUSTOM(101);

    public static final Map<Integer, AIMMsgRecallType> sValueToEnumMap = new HashMap();
    public final int value;

    static {
        Iterator it = EnumSet.allOf(AIMMsgRecallType.class).iterator();
        while (it.hasNext()) {
            AIMMsgRecallType aIMMsgRecallType = (AIMMsgRecallType) it.next();
            sValueToEnumMap.put(Integer.valueOf(aIMMsgRecallType.value), aIMMsgRecallType);
        }
    }

    AIMMsgRecallType(int i) {
        this.value = i;
    }

    public static AIMMsgRecallType forValue(int i) {
        return sValueToEnumMap.get(Integer.valueOf(i));
    }

    public int getValue() {
        return this.value;
    }
}
