package com.alibaba.android.ark;

import java.util.concurrent.atomic.AtomicBoolean;

/* loaded from: classes.dex */
public abstract class AIMPushAckStatus {

    /* loaded from: classes.dex */
    public static final class CppProxy extends AIMPushAckStatus {
        public static final /* synthetic */ boolean $assertionsDisabled = false;
        public final AtomicBoolean destroyed = new AtomicBoolean(false);
        public final long nativeRef;

        public CppProxy(long j) {
            if (j != 0) {
                this.nativeRef = j;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void AckExceptionNative(long j);

        private native void AckInvalidNative(long j);

        private native void AckStatusNative(long j, int i);

        private native void AckSuccessNative(long j);

        private native void nativeDestroy(long j);

        @Override // com.alibaba.android.ark.AIMPushAckStatus
        public void AckException() {
            AckExceptionNative(this.nativeRef);
        }

        @Override // com.alibaba.android.ark.AIMPushAckStatus
        public void AckInvalid() {
            AckInvalidNative(this.nativeRef);
        }

        @Override // com.alibaba.android.ark.AIMPushAckStatus
        public void AckStatus(int i) {
            AckStatusNative(this.nativeRef, i);
        }

        @Override // com.alibaba.android.ark.AIMPushAckStatus
        public void AckSuccess() {
            AckSuccessNative(this.nativeRef);
        }

        public void djinniPrivateDestroy() {
            if (this.destroyed.getAndSet(true)) {
                return;
            }
            nativeDestroy(this.nativeRef);
        }

        public void finalize() throws Throwable {
            djinniPrivateDestroy();
            super.finalize();
        }
    }

    public abstract void AckException();

    public abstract void AckInvalid();

    public abstract void AckStatus(int i);

    public abstract void AckSuccess();
}
