package com.alibaba.android.ark;

import java.util.concurrent.atomic.AtomicBoolean;

/* loaded from: classes.dex */
public abstract class AIMSearchService {

    /* loaded from: classes.dex */
    public static final class CppProxy extends AIMSearchService {
        public static final /* synthetic */ boolean $assertionsDisabled = false;
        public final AtomicBoolean destroyed = new AtomicBoolean(false);
        public final long nativeRef;

        public CppProxy(long j) {
            if (j != 0) {
                this.nativeRef = j;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void SearchChatContentNative(long j, AIMSearchChatContentParams aIMSearchChatContentParams, AIMSearchChatContentListener aIMSearchChatContentListener);

        private native void SearchConversationByContentNative(long j, AIMSearchChatContentParams aIMSearchChatContentParams, AIMSearchConvByContentListener aIMSearchConvByContentListener);

        private native void SearchGroupByNameNative(long j, AIMSearchGroupParams aIMSearchGroupParams, AIMSearchGroupByNameListener aIMSearchGroupByNameListener);

        private native void nativeDestroy(long j);

        @Override // com.alibaba.android.ark.AIMSearchService
        public void SearchChatContent(AIMSearchChatContentParams aIMSearchChatContentParams, AIMSearchChatContentListener aIMSearchChatContentListener) {
            SearchChatContentNative(this.nativeRef, aIMSearchChatContentParams, aIMSearchChatContentListener);
        }

        @Override // com.alibaba.android.ark.AIMSearchService
        public void SearchConversationByContent(AIMSearchChatContentParams aIMSearchChatContentParams, AIMSearchConvByContentListener aIMSearchConvByContentListener) {
            SearchConversationByContentNative(this.nativeRef, aIMSearchChatContentParams, aIMSearchConvByContentListener);
        }

        @Override // com.alibaba.android.ark.AIMSearchService
        public void SearchGroupByName(AIMSearchGroupParams aIMSearchGroupParams, AIMSearchGroupByNameListener aIMSearchGroupByNameListener) {
            SearchGroupByNameNative(this.nativeRef, aIMSearchGroupParams, aIMSearchGroupByNameListener);
        }

        public void djinniPrivateDestroy() {
            if (this.destroyed.getAndSet(true)) {
                return;
            }
            nativeDestroy(this.nativeRef);
        }

        public void finalize() throws Throwable {
            djinniPrivateDestroy();
            super.finalize();
        }
    }

    public abstract void SearchChatContent(AIMSearchChatContentParams aIMSearchChatContentParams, AIMSearchChatContentListener aIMSearchChatContentListener);

    public abstract void SearchConversationByContent(AIMSearchChatContentParams aIMSearchChatContentParams, AIMSearchConvByContentListener aIMSearchConvByContentListener);

    public abstract void SearchGroupByName(AIMSearchGroupParams aIMSearchGroupParams, AIMSearchGroupByNameListener aIMSearchGroupByNameListener);
}
