package com.alibaba.android.ark;

import java.util.concurrent.atomic.AtomicBoolean;

/* loaded from: classes.dex */
public abstract class AIMUtService {

    /* loaded from: classes.dex */
    public static final class CppProxy extends AIMUtService {
        public static final /* synthetic */ boolean $assertionsDisabled = false;
        public final AtomicBoolean destroyed = new AtomicBoolean(false);
        public final long nativeRef;

        public CppProxy(long j) {
            if (j != 0) {
                this.nativeRef = j;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native boolean AddListenerNative(long j, AIMUtListener aIMUtListener);

        private native void RemoveAllListenersNative(long j);

        private native boolean RemoveListenerNative(long j, AIMUtListener aIMUtListener);

        private native void nativeDestroy(long j);

        @Override // com.alibaba.android.ark.AIMUtService
        public boolean AddListener(AIMUtListener aIMUtListener) {
            return AddListenerNative(this.nativeRef, aIMUtListener);
        }

        @Override // com.alibaba.android.ark.AIMUtService
        public void RemoveAllListeners() {
            RemoveAllListenersNative(this.nativeRef);
        }

        @Override // com.alibaba.android.ark.AIMUtService
        public boolean RemoveListener(AIMUtListener aIMUtListener) {
            return RemoveListenerNative(this.nativeRef, aIMUtListener);
        }

        public void djinniPrivateDestroy() {
            if (this.destroyed.getAndSet(true)) {
                return;
            }
            nativeDestroy(this.nativeRef);
        }

        public void finalize() throws Throwable {
            djinniPrivateDestroy();
            super.finalize();
        }
    }

    public abstract boolean AddListener(AIMUtListener aIMUtListener);

    public abstract void RemoveAllListeners();

    public abstract boolean RemoveListener(AIMUtListener aIMUtListener);
}
