package com.alibaba.android.ark;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/* loaded from: classes.dex */
public abstract class DPSAuthHandler {

    /* loaded from: classes.dex */
    public static final class CppProxy extends DPSAuthHandler {
        public static final /* synthetic */ boolean $assertionsDisabled = false;
        public final AtomicBoolean destroyed = new AtomicBoolean(false);
        public final long nativeRef;

        public CppProxy(long j) {
            if (j != 0) {
                this.nativeRef = j;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native AIMAuthListener OnGetAuthListenerNative(long j);

        private native HashMap<String, String> OnGetRegHeaderNative(long j);

        private native void nativeDestroy(long j);

        @Override // com.alibaba.android.ark.DPSAuthHandler
        public AIMAuthListener OnGetAuthListener() {
            return OnGetAuthListenerNative(this.nativeRef);
        }

        @Override // com.alibaba.android.ark.DPSAuthHandler
        public HashMap<String, String> OnGetRegHeader() {
            return OnGetRegHeaderNative(this.nativeRef);
        }

        public void djinniPrivateDestroy() {
            if (this.destroyed.getAndSet(true)) {
                return;
            }
            nativeDestroy(this.nativeRef);
        }

        public void finalize() throws Throwable {
            djinniPrivateDestroy();
            super.finalize();
        }
    }

    public abstract AIMAuthListener OnGetAuthListener();

    public abstract HashMap<String, String> OnGetRegHeader();
}
