package com.alibaba.android.ark;

import java.util.concurrent.atomic.AtomicBoolean;

/* loaded from: classes.dex */
public abstract class DPSModuleInfo {

    /* loaded from: classes.dex */
    public static final class CppProxy extends DPSModuleInfo {
        public static final /* synthetic */ boolean $assertionsDisabled = false;
        public final AtomicBoolean destroyed = new AtomicBoolean(false);
        public final long nativeRef;

        public CppProxy(long j) {
            if (j != 0) {
                this.nativeRef = j;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native DPSModuleEventHandler GetModuleEventHandlerNative(long j);

        private native String GetModuleNameNative(long j);

        private native void nativeDestroy(long j);

        @Override // com.alibaba.android.ark.DPSModuleInfo
        public DPSModuleEventHandler GetModuleEventHandler() {
            return GetModuleEventHandlerNative(this.nativeRef);
        }

        @Override // com.alibaba.android.ark.DPSModuleInfo
        public String GetModuleName() {
            return GetModuleNameNative(this.nativeRef);
        }

        public void djinniPrivateDestroy() {
            if (this.destroyed.getAndSet(true)) {
                return;
            }
            nativeDestroy(this.nativeRef);
        }

        public void finalize() throws Throwable {
            djinniPrivateDestroy();
            super.finalize();
        }
    }

    public abstract DPSModuleEventHandler GetModuleEventHandler();

    public abstract String GetModuleName();
}
