package com.alibaba.android.ark;

import java.util.concurrent.atomic.AtomicBoolean;

/* loaded from: classes.dex */
public abstract class DPSServiceProvider {

    /* loaded from: classes.dex */
    public static final class CppProxy extends DPSServiceProvider {
        public static final /* synthetic */ boolean $assertionsDisabled = false;
        public final AtomicBoolean destroyed = new AtomicBoolean(false);
        public final long nativeRef;

        public CppProxy(long j) {
            if (j != 0) {
                this.nativeRef = j;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native AIMRpcService GetRpcServiceNative(long j);

        private native AIMSyncService GetSyncServiceNative(long j);

        private native void nativeDestroy(long j);

        @Override // com.alibaba.android.ark.DPSServiceProvider
        public AIMRpcService GetRpcService() {
            return GetRpcServiceNative(this.nativeRef);
        }

        @Override // com.alibaba.android.ark.DPSServiceProvider
        public AIMSyncService GetSyncService() {
            return GetSyncServiceNative(this.nativeRef);
        }

        public void djinniPrivateDestroy() {
            if (this.destroyed.getAndSet(true)) {
                return;
            }
            nativeDestroy(this.nativeRef);
        }

        public void finalize() throws Throwable {
            djinniPrivateDestroy();
            super.finalize();
        }
    }

    public abstract AIMRpcService GetRpcService();

    public abstract AIMSyncService GetSyncService();
}
