package com.amap.location.b.f;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.SystemClock;
import com.amap.location.b.c.l;
import com.amap.location.common.f.j;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/* compiled from: WifiUtil.java */
/* loaded from: classes.dex */
public class i {
    public static void a(List<l> list, List<ScanResult> list2) {
        list.clear();
        if (list2 != null) {
            List<ScanResult> a = a(b(list2));
            int size = a.size();
            if (size > 40) {
                size = 40;
            }
            for (int i = 0; i < size; i++) {
                ScanResult scanResult = a.get(i);
                if (scanResult != null) {
                    l lVar = new l();
                    lVar.a = j.a(scanResult.BSSID);
                    lVar.b = (short) scanResult.level;
                    String str = scanResult.SSID;
                    lVar.c = str != null ? str.substring(0, Math.min(32, str.length())) : "";
                    lVar.f = (short) scanResult.frequency;
                    if (Build.VERSION.SDK_INT >= 17) {
                        lVar.e = scanResult.timestamp / 1000;
                        short elapsedRealtime = (short) ((SystemClock.elapsedRealtime() - lVar.e) / 1000);
                        lVar.d = elapsedRealtime;
                        if (elapsedRealtime < 0) {
                            lVar.d = (short) 0;
                        }
                    }
                    list.add(lVar);
                }
            }
        }
    }

    public static List<ScanResult> b(List<ScanResult> list) {
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); i++) {
            ScanResult scanResult = list.get(i);
            hashMap.put(Integer.valueOf(scanResult.level), scanResult);
        }
        arrayList.addAll(hashMap.values());
        return arrayList;
    }

    public static boolean a(List<ScanResult> list, List<ScanResult> list2, double d) {
        if (list == null || list2 == null) {
            return false;
        }
        int size = list.size();
        int size2 = list2.size();
        int i = size + size2;
        if (size <= size2) {
            list2 = list;
            list = list2;
        }
        HashMap hashMap = new HashMap(list.size());
        Iterator<ScanResult> it = list.iterator();
        while (it.hasNext()) {
            String str = it.next().BSSID;
            if (str != null) {
                hashMap.put(str, 1);
            }
        }
        Iterator<ScanResult> it2 = list2.iterator();
        int i2 = 0;
        while (it2.hasNext()) {
            String str2 = it2.next().BSSID;
            if (str2 != null && ((Integer) hashMap.get(str2)) != null) {
                i2++;
            }
        }
        double d2 = i2;
        Double.isNaN(d2);
        double d3 = d2 * 2.0d;
        double d4 = i;
        Double.isNaN(d4);
        return d3 >= d4 * d;
    }

    public static List<ScanResult> a(List<ScanResult> list) {
        Collections.sort(list, new Comparator<ScanResult>() { // from class: com.amap.location.b.f.i.1
            @Override // java.util.Comparator
            /* renamed from: a, reason: merged with bridge method [inline-methods] */
            public int compare(ScanResult scanResult, ScanResult scanResult2) {
                return defpackage.a.a(scanResult2.level, scanResult.level);
            }
        });
        return list;
    }

    public static boolean a(Context context) {
        return j.a(context) == 1;
    }

    public static boolean a(WifiManager wifiManager) {
        if (wifiManager == null) {
            return false;
        }
        try {
            if (wifiManager.isWifiEnabled()) {
                return true;
            }
            if (Build.VERSION.SDK_INT >= 18) {
                return wifiManager.isScanAlwaysAvailable();
            }
            return false;
        } catch (SecurityException e) {
            com.amap.location.common.e.a.a(e);
            return false;
        } catch (Exception e2) {
            com.amap.location.common.e.a.a(e2);
            return false;
        }
    }
}
