package com.amap.location.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.amap.location.common.f.j;
import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;

/* compiled from: DeviceInfo.java */
/* loaded from: classes.dex */
public class a {
    public static InterfaceC0012a a;
    public static b b;
    public static c c;
    public static volatile String d;
    public static volatile String e;
    public static volatile String f;
    public static volatile String g;
    public static volatile String h;
    public static volatile String i;
    public static volatile String j;
    public static volatile boolean k;

    /* compiled from: DeviceInfo.java */
    /* renamed from: com.amap.location.common.a$a, reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public interface InterfaceC0012a {
        String a();
    }

    /* compiled from: DeviceInfo.java */
    /* loaded from: classes.dex */
    public interface b {
        String a();
    }

    /* compiled from: DeviceInfo.java */
    /* loaded from: classes.dex */
    public interface c {
        String a(Context context);
    }

    public static String a(Context context) {
        if (d == null && k) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager) context.getApplicationContext().getSystemService(StandardProtocolKey.PHONE);
                if (Build.VERSION.SDK_INT >= 26) {
                    d = telephonyManager.getImei();
                } else {
                    d = telephonyManager.getDeviceId();
                }
                if (d == null) {
                    d = "";
                }
            } catch (Throwable unused) {
            }
            if (d == null && Build.VERSION.SDK_INT > 28) {
                d = "";
            }
        }
        return d == null ? "" : d;
    }

    public static String b(Context context) {
        if (e == null) {
            try {
                if (k) {
                    SharedPreferences sharedPreferences = context.getSharedPreferences("sp_common", 0);
                    String b2 = com.amap.location.common.f.a.b(sharedPreferences.getString(LocationParams.PARA_COMMON_TID, null));
                    if (TextUtils.isEmpty(b2) && c != null) {
                        String a2 = c.a(context);
                        if (!TextUtils.isEmpty(a2)) {
                            sharedPreferences.edit().putString(LocationParams.PARA_COMMON_TID, com.amap.location.common.f.a.a(a2)).apply();
                            e = a2;
                        } else {
                            e = "";
                        }
                    } else {
                        e = b2;
                    }
                }
            } catch (Throwable unused) {
            }
        }
        return e == null ? "" : e;
    }

    public static void c(String str) {
        if (TextUtils.isEmpty(str)) {
            return;
        }
        f = str;
    }

    public static String d(Context context) {
        if (h == null && Build.VERSION.SDK_INT <= 28) {
            try {
                if (k) {
                    h = ((TelephonyManager) context.getApplicationContext().getSystemService(StandardProtocolKey.PHONE)).getSubscriberId();
                    if (h == null) {
                        h = "";
                    }
                }
            } catch (SecurityException | Exception unused) {
            }
        }
        return h == null ? "" : h;
    }

    public static int e() {
        return Build.VERSION.SDK_INT;
    }

    public static String f() {
        if (i == null && k) {
            try {
                i = Build.VERSION.SDK_INT >= 26 ? Build.getSerial() : Build.SERIAL;
            } catch (SecurityException unused) {
            }
            if ((i == null || i.equalsIgnoreCase("unknown")) && Build.VERSION.SDK_INT > 28) {
                i = "";
            }
        }
        return i == null ? "" : i;
    }

    public static String g() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            if (networkInterfaces != null) {
                for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
                    if (networkInterface.getName().equalsIgnoreCase("wlan0")) {
                        byte[] hardwareAddress = Build.VERSION.SDK_INT >= 9 ? networkInterface.getHardwareAddress() : null;
                        if (hardwareAddress == null) {
                            return "";
                        }
                        StringBuilder sb = new StringBuilder();
                        for (byte b2 : hardwareAddress) {
                            sb.append(String.format("%02X:", Byte.valueOf(b2)));
                        }
                        if (sb.length() > 0) {
                            sb.deleteCharAt(sb.length() - 1);
                        }
                        return sb.toString();
                    }
                }
            }
        } catch (Throwable th) {
            com.amap.location.common.e.a.a(th);
        }
        return "";
    }

    public static long e(Context context) {
        return j.a(f(context));
    }

    public static String c(Context context) {
        if (TextUtils.isEmpty(f)) {
            try {
                f = com.amap.location.common.f.a.b(context.getSharedPreferences("sp_common", 0).getString(LocationParams.PARA_COMMON_ADIU, null));
            } catch (Exception unused) {
            }
        }
        return f;
    }

    public static String f(Context context) {
        WifiInfo connectionInfo;
        if (!k) {
            return "";
        }
        if (TextUtils.isEmpty(j)) {
            try {
                WifiManager wifiManager = (WifiManager) context.getSystemService("wifi");
                if (wifiManager != null && (connectionInfo = wifiManager.getConnectionInfo()) != null) {
                    String macAddress = connectionInfo.getMacAddress();
                    if (Build.VERSION.SDK_INT >= 23 && macAddress != null && macAddress.equals("02:00:00:00:00:00")) {
                        macAddress = g();
                    }
                    if (macAddress != null && macAddress.length() > 0) {
                        String replace = macAddress.replace(":", "");
                        if (replace != null && replace.length() > 0) {
                            j = replace;
                        }
                        return replace;
                    }
                }
            } catch (SecurityException | Exception unused) {
            }
            return "";
        }
        return j;
    }

    public static String c() {
        String str = Build.MODEL;
        return str == null ? "" : str;
    }

    public static String d() {
        String str = Build.MANUFACTURER;
        return str == null ? "" : str;
    }

    public static void a(String str) {
        if (TextUtils.isEmpty(str)) {
            return;
        }
        d = str;
    }

    public static void b(String str) {
        if (TextUtils.isEmpty(str)) {
            return;
        }
        g = str;
    }

    public static void a(Context context, String str) {
        if (TextUtils.isEmpty(str) || str.equals(e)) {
            return;
        }
        e = str;
        if (context != null) {
            try {
                context.getSharedPreferences("sp_common", 0).edit().putString(LocationParams.PARA_COMMON_TID, com.amap.location.common.f.a.a(str)).apply();
            } catch (Exception unused) {
            }
        }
    }

    public static String b() {
        if (TextUtils.isEmpty(f)) {
            try {
                if (a != null) {
                    f = a.a();
                }
            } catch (Exception unused) {
            }
        }
        return f == null ? "" : f;
    }

    public static String a() {
        if (TextUtils.isEmpty(g)) {
            try {
                if (b != null) {
                    g = b.a();
                }
            } catch (Exception unused) {
            }
        }
        return g == null ? "" : g;
    }

    public static void b(Context context, String str) {
        if (TextUtils.isEmpty(str)) {
            return;
        }
        try {
            context.getSharedPreferences("sp_common", 0).edit().putString(LocationParams.PARA_COMMON_ADIU, com.amap.location.common.f.a.a(str)).apply();
        } catch (Exception unused) {
        }
        f = str;
    }
}
