package com.amap.location.common.model;

import android.text.TextUtils;
import com.amap.location.common.f.j;
import com.autonavi.amapauto.user.UserPhone;
import java.util.Locale;

/* loaded from: classes.dex */
public class CellState {
    public static final int I_CDMA_T = 2;
    public static final int I_DEF_CGI_T = 0;
    public static final int I_GSM_T = 1;
    public static final int I_LTE_T = 3;
    public static final int I_NR_T = 6;
    public static final int I_TDSCDMA = 5;
    public static final int I_WCDMA_T = 4;
    public int arfcn;
    public int bid;

    @Deprecated
    public short cellAge;
    public int cid;
    public int lac;

    @Deprecated
    public long lastUpdateTimeMills;
    public long lastUpdateUtcMills;
    public int latitude;
    public int longitude;
    public int mcc;
    public int mnc;
    public long nci;
    public boolean newapi;
    public int newpci;
    public int nid;
    public short pci;
    public boolean registered;
    public int sid;
    public int signalStrength;
    public int timingAdvance;
    public int type;

    public CellState(int i, boolean z) {
        this.type = 0;
        this.mcc = 0;
        this.mnc = 0;
        this.lac = 0;
        this.cid = 0;
        this.sid = 0;
        this.nid = 0;
        this.bid = 0;
        this.signalStrength = 99;
        this.cellAge = (short) 0;
        this.lastUpdateTimeMills = 0L;
        this.lastUpdateUtcMills = 0L;
        this.newapi = true;
        this.pci = Short.MAX_VALUE;
        this.newpci = 65535;
        this.arfcn = 0;
        this.timingAdvance = Integer.MAX_VALUE;
        this.nci = 0L;
        this.type = i;
        this.registered = z;
    }

    public String getKey() {
        String keyWithOutInterface = getKeyWithOutInterface();
        if (TextUtils.isEmpty(keyWithOutInterface)) {
            return "";
        }
        return (this.newapi ? 1 : 0) + UserPhone.SPECIAL_LETTER + keyWithOutInterface;
    }

    public String getKeyWithOutInterface() {
        int i = this.type;
        if (i != 1) {
            if (i == 2) {
                return this.type + UserPhone.SPECIAL_LETTER + this.sid + UserPhone.SPECIAL_LETTER + this.nid + UserPhone.SPECIAL_LETTER + this.bid;
            }
            if (i != 3 && i != 4) {
                if (i != 6) {
                    return "";
                }
                return this.type + UserPhone.SPECIAL_LETTER + this.mcc + UserPhone.SPECIAL_LETTER + this.mnc + UserPhone.SPECIAL_LETTER + this.lac + UserPhone.SPECIAL_LETTER + this.nci + UserPhone.SPECIAL_LETTER + this.newpci + UserPhone.SPECIAL_LETTER + this.arfcn;
            }
        }
        return this.type + UserPhone.SPECIAL_LETTER + this.mcc + UserPhone.SPECIAL_LETTER + this.mnc + UserPhone.SPECIAL_LETTER + this.lac + UserPhone.SPECIAL_LETTER + this.cid + UserPhone.SPECIAL_LETTER + this.newpci + UserPhone.SPECIAL_LETTER + this.arfcn;
    }

    public boolean isValid() {
        int i = this.type;
        if (i != 1) {
            if (i == 2) {
                return j.a(this.sid, this.nid, this.bid);
            }
            if (i != 3 && i != 4) {
                if (i != 6) {
                    return false;
                }
                return j.a(this.mcc, this.mnc, this.lac, this.nci);
            }
        }
        return j.a(this.mcc, this.mnc, this.lac, this.cid);
    }

    public String toString() {
        int i = this.type;
        if (i == 1) {
            return String.format(Locale.CHINA, "[type=GSM, mcc=%d, mnc=%d, lac=%d, cid=%d, sig=%d, age=%d, reg=%b, new=%b, arfcn=%d, timingAdvance=%d]", Integer.valueOf(this.mcc), Integer.valueOf(this.mnc), Integer.valueOf(this.lac), Integer.valueOf(this.cid), Integer.valueOf(this.signalStrength), Short.valueOf(this.cellAge), Boolean.valueOf(this.registered), Boolean.valueOf(this.newapi), Integer.valueOf(this.arfcn), Integer.valueOf(this.timingAdvance));
        }
        if (i == 2) {
            return String.format(Locale.CHINA, "[type=CDMA, mcc=%d, mnc=%d, sid=%d, nid=%d, bid=%d, sig=%d, age=%d, reg=%b, new=%b]", Integer.valueOf(this.mcc), Integer.valueOf(this.mnc), Integer.valueOf(this.sid), Integer.valueOf(this.nid), Integer.valueOf(this.bid), Integer.valueOf(this.signalStrength), Short.valueOf(this.cellAge), Boolean.valueOf(this.registered), Boolean.valueOf(this.newapi));
        }
        if (i == 3) {
            return String.format(Locale.CHINA, "[type=LTE, mcc=%d, mnc=%d, lac=%d, cid=%d, sig=%d, age=%d, reg=%b, new=%b, pci=%d, arfcn=%d, timingAdvance=%d]", Integer.valueOf(this.mcc), Integer.valueOf(this.mnc), Integer.valueOf(this.lac), Integer.valueOf(this.cid), Integer.valueOf(this.signalStrength), Short.valueOf(this.cellAge), Boolean.valueOf(this.registered), Boolean.valueOf(this.newapi), Short.valueOf(this.pci), Integer.valueOf(this.arfcn), Integer.valueOf(this.timingAdvance));
        }
        if (i != 4) {
            return i != 6 ? "unknown" : String.format(Locale.CHINA, "[type=NR, mcc=%d, mnc=%d, lac=%d, nci=%d, sig=%d, age=%d, reg=%b, new=%b, psc=%d, arfcn=%d, timingAdvance=%d]", Integer.valueOf(this.mcc), Integer.valueOf(this.mnc), Integer.valueOf(this.lac), Long.valueOf(this.nci), Integer.valueOf(this.signalStrength), Short.valueOf(this.cellAge), Boolean.valueOf(this.registered), Boolean.valueOf(this.newapi), Short.valueOf(this.pci), Integer.valueOf(this.arfcn), Integer.valueOf(this.timingAdvance));
        }
        return String.format(Locale.CHINA, "[type=WCDMA, mcc=%d, mnc=%d, lac=%d, cid=%d, sig=%d, age=%d, reg=%b, new=%b, psc=%d, arfcn=%d, timingAdvance=%d]", Integer.valueOf(this.mcc), Integer.valueOf(this.mnc), Integer.valueOf(this.lac), Integer.valueOf(this.cid), Integer.valueOf(this.signalStrength), Short.valueOf(this.cellAge), Boolean.valueOf(this.registered), Boolean.valueOf(this.newapi), Short.valueOf(this.pci), Integer.valueOf(this.arfcn), Integer.valueOf(this.timingAdvance));
    }

    /* renamed from: clone, reason: merged with bridge method [inline-methods] */
    public CellState m0clone() {
        CellState cellState = new CellState(this.type, this.registered, this.newapi);
        cellState.mcc = this.mcc;
        cellState.mnc = this.mnc;
        cellState.lac = this.lac;
        cellState.cid = this.cid;
        cellState.sid = this.sid;
        cellState.nid = this.nid;
        cellState.bid = this.bid;
        cellState.signalStrength = this.signalStrength;
        cellState.latitude = this.latitude;
        cellState.longitude = this.longitude;
        cellState.cellAge = this.cellAge;
        cellState.lastUpdateTimeMills = this.lastUpdateTimeMills;
        cellState.lastUpdateUtcMills = this.lastUpdateUtcMills;
        cellState.pci = this.pci;
        cellState.newpci = this.newpci;
        cellState.arfcn = this.arfcn;
        cellState.timingAdvance = this.timingAdvance;
        cellState.nci = this.nci;
        return cellState;
    }

    public CellState(int i, boolean z, boolean z2) {
        this.type = 0;
        this.mcc = 0;
        this.mnc = 0;
        this.lac = 0;
        this.cid = 0;
        this.sid = 0;
        this.nid = 0;
        this.bid = 0;
        this.signalStrength = 99;
        this.cellAge = (short) 0;
        this.lastUpdateTimeMills = 0L;
        this.lastUpdateUtcMills = 0L;
        this.newapi = true;
        this.pci = Short.MAX_VALUE;
        this.newpci = 65535;
        this.arfcn = 0;
        this.timingAdvance = Integer.MAX_VALUE;
        this.nci = 0L;
        this.type = i;
        this.registered = z;
        this.newapi = z2;
    }
}
