package com.amap.location.common.model;

import android.os.SystemClock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/* loaded from: classes.dex */
public class CellStatus {
    public static final int MASK_CDMA_CELL_TYPE = 2;
    public static final int MASK_GSM_CELL_TYPE = 1;
    public static final int MASK_NEW_VERSION_INDICATOR = 4;
    public static final int MASK_OPERATOR_INDICATOR = 8;
    public static final int MAX_HISTORY_CELLS = 3;
    public CellState mainCell;
    public CellState mainCell2;
    public String networkOperator;
    public long updateTime;
    public int cellType = 0;
    public List<CellState> neighbors = Collections.emptyList();
    public List<CellState> cellStateList2 = Collections.emptyList();
    public final List<HistoryCell> mHistoryCells = new ArrayList(3);

    /* loaded from: classes.dex */
    public static class HistoryCell {
        public int bid;
        public int cid;
        public int lac;
        public long lastUpdateTimeMills;
        public long nci;
        public int nid;
        public int rssi;
        public int sid;
        public int type;

        public HistoryCell() {
            this.type = 0;
            this.rssi = 0;
            this.lac = 0;
            this.cid = 0;
            this.sid = 0;
            this.nid = 0;
            this.bid = 0;
            this.nci = 0L;
            this.lastUpdateTimeMills = 0L;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HistoryCell)) {
                return false;
            }
            HistoryCell historyCell = (HistoryCell) obj;
            return this.type == historyCell.type && this.lac == historyCell.lac && this.cid == historyCell.cid && this.nid == historyCell.nid && this.bid == historyCell.bid && this.sid == historyCell.sid && this.nci == historyCell.nci;
        }

        public String toString() {
            return String.format(Locale.CHINA, "[type=%d,rssi=%d,lac=%d, cid=%d,sid=%d,nid=%d, bid=%d, nci=%d, time=%d]", Integer.valueOf(this.type), Integer.valueOf(this.rssi), Integer.valueOf(this.lac), Integer.valueOf(this.cid), Integer.valueOf(this.sid), Integer.valueOf(this.nid), Integer.valueOf(this.bid), Long.valueOf(this.nci), Long.valueOf(this.lastUpdateTimeMills));
        }

        /* renamed from: clone, reason: merged with bridge method [inline-methods] */
        public HistoryCell m2clone() {
            HistoryCell historyCell = new HistoryCell();
            historyCell.type = this.type;
            historyCell.rssi = this.rssi;
            historyCell.lac = this.lac;
            historyCell.cid = this.cid;
            historyCell.sid = this.sid;
            historyCell.nid = this.nid;
            historyCell.bid = this.bid;
            historyCell.nci = this.nci;
            historyCell.lastUpdateTimeMills = this.lastUpdateTimeMills;
            return historyCell;
        }

        public HistoryCell(CellState cellState) {
            this.type = 0;
            this.rssi = 0;
            this.lac = 0;
            this.cid = 0;
            this.sid = 0;
            this.nid = 0;
            this.bid = 0;
            this.nci = 0L;
            this.lastUpdateTimeMills = 0L;
            this.type = cellState.type;
            this.rssi = cellState.signalStrength;
            this.lac = cellState.lac;
            this.cid = cellState.cid;
            this.sid = cellState.sid;
            this.nid = cellState.nid;
            this.bid = cellState.bid;
            this.nci = cellState.nci;
            long j = cellState.lastUpdateTimeMills;
            if (j <= 0) {
                this.lastUpdateTimeMills = SystemClock.elapsedRealtime();
            } else {
                this.lastUpdateTimeMills = j;
            }
        }
    }

    private String toStr(boolean z) {
        StringBuilder sb = new StringBuilder();
        sb.append("CellStatus:[");
        sb.append("updateTime=" + this.updateTime + ",");
        sb.append("cellType=" + this.cellType + ",");
        sb.append("networkOperator=" + this.networkOperator + ",");
        if (this.mainCell != null) {
            sb.append("mainCell=" + this.mainCell.toString() + ",");
        } else {
            sb.append("mainCell=null ,");
        }
        if (this.mainCell2 != null) {
            sb.append("mainCell2=" + this.mainCell2.toString() + ",");
        } else {
            sb.append("mainCell2=null ,");
        }
        List<CellState> list = this.neighbors;
        if (list != null && list.size() > 0) {
            ArrayList arrayList = new ArrayList();
            if (this.neighbors.size() <= 5) {
                arrayList.addAll(this.neighbors);
                sb.append("neighbors=" + arrayList.toString());
            } else if (z) {
                arrayList.addAll(this.neighbors.subList(0, 5));
                sb.append("neighbors=" + arrayList.toString());
            } else {
                arrayList.addAll(this.neighbors);
                sb.append("neighbors=" + arrayList.toString());
            }
        } else {
            sb.append("neighbors=null");
        }
        sb.append(";");
        List<CellState> list2 = this.cellStateList2;
        if (list2 != null && list2.size() > 0) {
            ArrayList arrayList2 = new ArrayList();
            if (this.cellStateList2.size() <= 5) {
                arrayList2.addAll(this.cellStateList2);
                sb.append("cellStateList2=" + arrayList2.toString());
            } else if (z) {
                arrayList2.addAll(this.cellStateList2.subList(0, 5));
                sb.append("cellStateList2=" + arrayList2.toString());
            } else {
                arrayList2.addAll(this.cellStateList2);
                sb.append("cellStateList2=" + arrayList2.toString());
            }
        } else {
            sb.append("cellStateList2=null");
        }
        sb.append("]");
        StringBuilder sb2 = new StringBuilder(" [HistoryCell:");
        int size = this.mHistoryCells.size();
        for (int i = 0; i < size; i++) {
            sb2.append(i);
            sb2.append(":");
            sb2.append(this.mHistoryCells.get(i).toString());
            sb2.append(" ");
        }
        sb2.append("]");
        return sb.toString() + sb2.toString();
    }

    public void addHistoryCell(List<HistoryCell> list) {
        if (list == null || list.size() <= 0) {
            return;
        }
        this.mHistoryCells.clear();
        this.mHistoryCells.addAll(list);
    }

    public List<HistoryCell> getHistoryCells() {
        return this.mHistoryCells;
    }

    public String toString() {
        return toStr(false);
    }

    public String toStringSimple() {
        return toStr(true);
    }

    /* renamed from: clone, reason: merged with bridge method [inline-methods] */
    public CellStatus m1clone() {
        CellStatus cellStatus = new CellStatus();
        cellStatus.updateTime = this.updateTime;
        cellStatus.cellType = this.cellType;
        cellStatus.networkOperator = this.networkOperator;
        CellState cellState = this.mainCell;
        if (cellState != null) {
            cellStatus.mainCell = cellState.m0clone();
        }
        CellState cellState2 = this.mainCell2;
        if (cellState2 != null) {
            cellStatus.mainCell2 = cellState2.m0clone();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.neighbors);
        cellStatus.neighbors = arrayList;
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(this.cellStateList2);
        cellStatus.cellStateList2 = arrayList2;
        Iterator<HistoryCell> it = this.mHistoryCells.iterator();
        while (it.hasNext()) {
            cellStatus.mHistoryCells.add(it.next().m2clone());
        }
        return cellStatus;
    }
}
