package com.amap.location.d;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import com.amap.api.service.IndoorLocationProvider;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.indoor.constant.Configuration;
import com.autonavi.indoor.entity.LocationResult;
import com.autonavi.indoor.onlinelocation.OnlineLocator;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MapUtils;
import com.autonavi.indooroutdoordetectorsdk.BuildingLocationResult;
import com.autonavi.indooroutdoordetectorsdk.IndoorOutdoorDetector;

/* compiled from: IndoorLocationManager.java */
/* loaded from: classes.dex */
public class c {
    public String b;
    public com.amap.location.d.b c;
    public Configuration.Builder d;
    public Configuration e;
    public Configuration f;
    public b g;
    public C0016c h;
    public Handler i;
    public a j;
    public int a = 3;
    public boolean k = true;
    public IndoorOutdoorDetector.DetectListener l = new IndoorOutdoorDetector.DetectListener() { // from class: com.amap.location.d.c.2
        @Override // com.autonavi.indooroutdoordetectorsdk.IndoorOutdoorDetector.DetectListener
        public void detectorStatus(boolean z, String str, int i, BuildingLocationResult buildingLocationResult) {
            com.amap.location.common.e.a.b("locindoor", "indoor status：" + z);
            c.this.g.a((long) (IndoorOutdoorDetector.getInstance().getN1() * 1000));
            c.this.h.a((long) (IndoorOutdoorDetector.getInstance().getN2() * 1000));
            if (z) {
                c.this.b = str;
            }
            c.this.i.obtainMessage(2, z ? 0 : 3, i).sendToTarget();
        }
    };

    /* compiled from: IndoorLocationManager.java */
    /* loaded from: classes.dex */
    public interface a {
        String a(String str);

        byte[] a(byte[] bArr);
    }

    /* compiled from: IndoorLocationManager.java */
    /* loaded from: classes.dex */
    public class b extends com.amap.location.d.a {
        public b(Handler handler) {
            super(handler);
        }

        @Override // java.lang.Runnable
        public void run() {
            com.amap.location.common.e.a.b("locindoor", "indoor n1：" + this.a);
            if (this.a) {
                c.this.h.a();
                c.this.i.obtainMessage(2, 1, 0).sendToTarget();
            }
        }
    }

    /* compiled from: IndoorLocationManager.java */
    /* renamed from: com.amap.location.d.c$c, reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0016c extends com.amap.location.d.a {
        public C0016c(Handler handler) {
            super(handler);
        }

        @Override // java.lang.Runnable
        public void run() {
            com.amap.location.common.e.a.b("locindoor", "indoor n2：" + this.a);
            if (this.a) {
                IndoorOutdoorDetector.getInstance().setIndoorOutdoorState(-1);
            }
        }
    }

    /* compiled from: IndoorLocationManager.java */
    /* loaded from: classes.dex */
    public class d extends Handler {
        public boolean b;
        public Handler c;

        public d(Looper looper) {
            super(looper);
            this.c = new Handler(getLooper()) { // from class: com.amap.location.d.c.d.2
                @Override // android.os.Handler
                public void handleMessage(Message message) {
                    if (message.what == 208 && c.this.k && message.obj != null) {
                        if (c.this.a == 1) {
                            c.this.i.obtainMessage(2, 2, 0).sendToTarget();
                        }
                        c.this.g.a();
                        c.this.h.b();
                        LocationResult locationResult = (LocationResult) message.obj;
                        Location location = new Location(IndoorLocationProvider.NAME);
                        location.setLatitude(locationResult.y);
                        location.setLongitude(locationResult.x);
                        double[] dArr = new double[1];
                        double[] dArr2 = new double[1];
                        if (com.amap.location.common.f.c.b(locationResult.y, locationResult.x, dArr, dArr2)) {
                            location.setLatitude(dArr[0]);
                            location.setLongitude(dArr2[0]);
                        }
                        location.setAccuracy(locationResult.r);
                        location.setBearing(locationResult.a);
                        location.setTime(System.currentTimeMillis());
                        if (Build.VERSION.SDK_INT >= 17) {
                            location.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
                        }
                        Bundle bundle = new Bundle();
                        bundle.putString(StandardProtocolKey.POIID, TextUtils.isEmpty(locationResult.bid) ? c.this.b : locationResult.bid);
                        bundle.putString("floor", Integer.toString(locationResult.z));
                        bundle.putString("coord", "GCJ02");
                        bundle.putDouble("idrGcjLat", locationResult.y);
                        bundle.putDouble("idrGcjLon", locationResult.x);
                        bundle.putInt("idrLocType", 0);
                        bundle.putString("flpProvider", IndoorLocationProvider.NAME);
                        bundle.putString("srcProvider", IndoorLocationProvider.NAME);
                        location.setExtras(bundle);
                        d.this.obtainMessage(3, location).sendToTarget();
                    }
                }
            };
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            int i = message.what;
            if (i == 0) {
                if (this.b) {
                    return;
                }
                if (c.this.e == null) {
                    c cVar = c.this;
                    cVar.e = cVar.d.build();
                }
                IndoorOutdoorDetector.getInstance().initDetect(c.this.e);
                IndoorOutdoorDetector.getInstance().registerListener(c.this.l);
                this.b = true;
                return;
            }
            if (i == 1) {
                if (this.b) {
                    a();
                    IndoorOutdoorDetector.getInstance().unregisterListener(c.this.l);
                    this.b = false;
                    c.this.a = 3;
                    return;
                }
                return;
            }
            if (i != 2) {
                if (i != 3) {
                    return;
                }
                Location location = (Location) message.obj;
                if (c.this.c != null) {
                    c.this.c.a(location);
                    return;
                }
                return;
            }
            c.this.a = message.arg1;
            if (c.this.c != null) {
                c.this.c.a(c.this.a);
            }
            if (c.this.a != 0) {
                if (c.this.a == 3) {
                    a();
                    return;
                }
                return;
            }
            a(message.arg2);
        }

        private void a(int i) {
            if (OnlineLocator.getInstance().isInited()) {
                a();
            }
            c.this.g.a();
            c.this.h.b();
            try {
                c.this.d.setLocationProvider(i == 2 ? Configuration.LocationProvider.BLE : Configuration.LocationProvider.WIFI);
                c.this.f = c.this.d.build();
                OnlineLocator.getInstance().init(c.this.b, c.this.f, new Handler(getLooper()) { // from class: com.amap.location.d.c.d.1
                    @Override // android.os.Handler
                    public void handleMessage(Message message) {
                        if (message.what == 203) {
                            try {
                                com.amap.location.common.e.a.b("locindoor", "req indoor");
                                OnlineLocator.getInstance().requestLocationUpdates(d.this.c);
                            } catch (Exception unused) {
                            }
                        }
                    }
                });
            } catch (Exception unused) {
            }
        }

        private void a() {
            if (OnlineLocator.getInstance().isInited()) {
                try {
                    OnlineLocator.getInstance().removeUpdates(this.c);
                    OnlineLocator.getInstance().destroy();
                } catch (Exception unused) {
                }
            }
            c.this.g.b();
            c.this.h.b();
        }
    }

    static {
        L.sDebug = false;
    }

    public c(Context context, com.amap.location.d.b bVar, String str, String str2, a aVar, Looper looper, boolean z) {
        this.c = bVar;
        d dVar = new d(looper == null ? Looper.getMainLooper() : looper);
        this.i = dVar;
        this.g = new b(dVar);
        this.h = new C0016c(this.i);
        this.g.a(IndoorOutdoorDetector.getInstance().getN1() * 1000);
        this.h.a(IndoorOutdoorDetector.getInstance().getN2() * 1000);
        Configuration.Builder builder = new Configuration.Builder(context);
        this.d = builder;
        builder.setAOSParam(str, null);
        this.d.setServer(Configuration.ServerType.SERVER_AOS, str2);
        this.d.setReportInterval(1000);
        if (z) {
            this.d.setPDRProvider(Configuration.PDRProvider.STEPANGLE);
        }
        this.j = aVar;
        MapUtils.setAosEncryptorImpl(new MapUtils.AosEncryptor() { // from class: com.amap.location.d.c.1
            @Override // com.autonavi.indoor.util.MapUtils.AosEncryptor
            public String amapEncode(String str3) {
                if (c.this.j != null) {
                    return c.this.j.a(str3);
                }
                return null;
            }

            @Override // com.autonavi.indoor.util.MapUtils.AosEncryptor
            public byte[] amapEncode(byte[] bArr) {
                if (c.this.j != null) {
                    return c.this.j.a(bArr);
                }
                return null;
            }
        });
    }

    public int c() {
        return this.a;
    }

    public void b() {
        this.i.sendEmptyMessage(1);
        com.amap.location.common.e.a.b("locindoor", "remove ioddtector");
    }

    private void b(Location location) {
        com.amap.location.d.b bVar = this.c;
        if (bVar != null) {
            bVar.a(location);
        }
    }

    public void a(String str) {
        this.d.setAOSParam(str, null);
        Configuration configuration = this.e;
        if (configuration != null) {
            configuration.setAOSParam(str);
        }
        Configuration configuration2 = this.f;
        if (configuration2 != null) {
            configuration2.setAOSParam(str);
        }
    }

    public void a() {
        this.i.sendEmptyMessage(0);
        com.amap.location.common.e.a.b("locindoor", "req ioddtector");
    }

    public void a(Location location) {
        int i = this.a;
        if (i == 3) {
            if (location != null) {
                IndoorOutdoorDetector.getInstance().setOutdoorLocation(true, location.getLongitude(), location.getLatitude());
                return;
            }
            return;
        }
        if (i != 1 || location == null) {
            return;
        }
        Bundle extras = location.getExtras();
        if (extras != null) {
            if (IndoorLocationProvider.NAME.equals(extras.getString("flpProvider"))) {
                return;
            }
        } else {
            extras = new Bundle();
        }
        location.setProvider(IndoorLocationProvider.NAME);
        extras.putString("flpProvider", IndoorLocationProvider.NAME);
        extras.putInt("idrLocType", 0);
        double[] dArr = new double[1];
        double[] dArr2 = new double[1];
        if (com.amap.location.common.f.c.a(location.getLatitude(), location.getLongitude(), dArr, dArr2)) {
            extras.putString("coord", "GCJ02");
            extras.putDouble("idrGcjLat", dArr[0]);
            extras.putDouble("idrGcjLon", dArr2[0]);
        } else {
            extras.putString("coord", "WGS84");
            extras.putDouble("idrGcjLat", location.getLatitude());
            extras.putDouble("idrGcjLon", location.getLongitude());
        }
        location.setExtras(extras);
        b(location);
    }
}
