package com.amap.location.e.a;

import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.text.TextUtils;
import com.amap.location.common.b;
import com.amap.location.common.f.g;
import com.amap.location.common.model.AmapLoc;
import com.amap.location.common.model.CellState;
import com.amap.location.common.model.CellStatus;
import com.amap.location.common.model.FPS;
import com.amap.location.common.model.HisLocation;
import com.amap.location.common.model.WiFi;
import com.amap.location.common.model.WifiStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/* compiled from: HistoryLocationRecorder.java */
/* loaded from: classes.dex */
public class a {
    public File b;
    public Handler d;
    public boolean e;
    public LinkedList<HisLocation> a = new LinkedList<>();
    public boolean c = false;
    public Runnable f = new Runnable() { // from class: com.amap.location.e.a.a.1
        @Override // java.lang.Runnable
        public void run() {
            if (a.this.c) {
                return;
            }
            if (a.this.e) {
                a.this.d();
                a.this.e = false;
            }
            if (a.this.d != null) {
                a.this.d.postDelayed(a.this.f, 60000L);
            }
        }
    };

    public a(Context context, Handler handler) {
        this.d = handler;
        if (context != null && context.getFilesDir() != null) {
            try {
                this.b = new File(context.getFilesDir().getAbsolutePath(), "hisloc_" + b.e());
            } catch (Throwable th) {
                com.amap.location.common.e.a.a(th);
            }
        }
        c();
        Handler handler2 = this.d;
        if (handler2 != null) {
            handler2.removeCallbacks(this.f);
            this.d.postDelayed(this.f, 60000L);
        }
    }

    private void c() {
        StringBuilder sb = new StringBuilder("restore from：\n");
        Iterator<String> it = g.d(this.b).iterator();
        while (it.hasNext()) {
            String d = com.amap.location.common.f.a.d(it.next());
            if (d != null) {
                sb.append(d);
                sb.append("\n");
                HisLocation makeLocationByText = HisLocation.makeLocationByText(d);
                if (makeLocationByText != null) {
                    this.a.add(makeLocationByText);
                }
            }
        }
        com.amap.location.common.e.a.b("nlhisloc", sb.toString());
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void d() {
        StringBuilder sb = new StringBuilder();
        Iterator<HisLocation> it = this.a.iterator();
        while (it.hasNext()) {
            sb.append(com.amap.location.common.f.a.c(it.next().toString()) + "\n");
        }
        String sb2 = sb.toString();
        if (TextUtils.isEmpty(sb)) {
            return;
        }
        g.a(sb2, this.b, false);
    }

    public void b() {
        this.f.run();
        Handler handler = this.d;
        if (handler != null) {
            handler.removeCallbacks(this.f);
        }
        this.a.clear();
        this.c = true;
    }

    public void a() {
        Handler handler = this.d;
        if (handler != null) {
            handler.removeCallbacks(this.f);
        }
        this.f.run();
    }

    public void a(Location location) {
        HisLocation makeLocationByGpsLocation = HisLocation.makeLocationByGpsLocation(location);
        if (makeLocationByGpsLocation == null) {
            return;
        }
        int i = 0;
        Iterator<HisLocation> it = this.a.iterator();
        HisLocation hisLocation = null;
        HisLocation hisLocation2 = null;
        while (it.hasNext()) {
            HisLocation next = it.next();
            if (next.locType == 1) {
                if (hisLocation2 == null) {
                    hisLocation2 = next;
                }
                i++;
                hisLocation = next;
            }
        }
        if (hisLocation == null || makeLocationByGpsLocation.time - hisLocation.time >= com.amap.location.e.b.c * 1000 || makeLocationByGpsLocation.distanceTo(hisLocation) >= com.amap.location.e.b.b) {
            if (i >= com.amap.location.e.b.d) {
                this.a.remove(hisLocation2);
            }
            if (this.a.size() >= com.amap.location.e.b.a) {
                this.a.removeFirst();
            }
            this.a.add(makeLocationByGpsLocation);
            this.e = true;
        }
    }

    private boolean b(FPS fps) {
        if (fps == null) {
            return false;
        }
        HashSet hashSet = new HashSet();
        CellStatus cellStatus = fps.cellStatus;
        if (cellStatus != null) {
            CellState cellState = cellStatus.mainCell;
            if (cellState != null && cellState.isValid()) {
                hashSet.add(fps.cellStatus.mainCell.getKeyWithOutInterface());
            }
            List<CellState> list = fps.cellStatus.neighbors;
            if (list != null) {
                for (CellState cellState2 : list) {
                    if (cellState2.isValid()) {
                        hashSet.add(cellState2.getKeyWithOutInterface());
                    }
                }
            }
            List<CellState> list2 = fps.cellStatus.cellStateList2;
            if (list2 != null) {
                for (CellState cellState3 : list2) {
                    if (cellState3.isValid()) {
                        hashSet.add(cellState3.getKeyWithOutInterface());
                    }
                }
            }
            if (hashSet.size() >= com.amap.location.e.b.g) {
                hashSet.clear();
                return false;
            }
        }
        hashSet.clear();
        WifiStatus wifiStatus = fps.wifiStatus;
        if (wifiStatus != null) {
            if (wifiStatus.mainWifi != null) {
                hashSet.add(fps.wifiStatus.mainWifi.mac + "");
            }
            if (fps.wifiStatus.getWifiList() != null) {
                Iterator<WiFi> it = fps.wifiStatus.getWifiList().iterator();
                while (it.hasNext()) {
                    hashSet.add(it.next().mac + "");
                }
            }
        }
        if (hashSet.size() >= com.amap.location.e.b.f) {
            hashSet.clear();
            return false;
        }
        hashSet.clear();
        return true;
    }

    public void a(AmapLoc amapLoc) {
        HisLocation makeLocationByNetworkLocation = HisLocation.makeLocationByNetworkLocation(amapLoc);
        if (makeLocationByNetworkLocation != null && this.a.size() > 0) {
            if (makeLocationByNetworkLocation.locType == 2) {
                HisLocation last = this.a.getLast();
                if (last.lon == makeLocationByNetworkLocation.lon && last.lat == makeLocationByNetworkLocation.lat && last.radius == makeLocationByNetworkLocation.radius) {
                    return;
                }
                if (this.a.size() >= com.amap.location.e.b.a) {
                    this.a.removeFirst();
                }
                this.a.add(makeLocationByNetworkLocation);
                this.e = true;
                return;
            }
            if (this.a.contains(makeLocationByNetworkLocation)) {
                return;
            }
            if (this.a.size() >= com.amap.location.e.b.a) {
                this.a.removeFirst();
            }
            this.a.add(makeLocationByNetworkLocation);
            this.e = true;
        }
    }

    public List<HisLocation> a(FPS fps) {
        if (!b(fps)) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList arrayList = new ArrayList();
        Iterator<HisLocation> it = this.a.iterator();
        while (it.hasNext()) {
            HisLocation next = it.next();
            if (currentTimeMillis - next.time < com.amap.location.e.b.e * 1000) {
                arrayList.add(next);
            }
        }
        return arrayList;
    }
}
