package com.amap.location.e.d;

import android.annotation.TargetApi;
import android.os.Build;
import android.telephony.CellIdentityCdma;
import android.telephony.CellIdentityGsm;
import android.telephony.CellIdentityLte;
import android.telephony.CellIdentityNr;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoNr;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthNr;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import com.amap.location.common.f.j;
import com.amap.location.common.model.CellState;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/* compiled from: DataConversion.java */
/* loaded from: classes.dex */
public class b {
    public static int a(int i) {
        return (i * 2) - 113;
    }

    /* JADX WARN: Removed duplicated region for block: B:13:0x0041  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static java.util.List<com.amap.location.common.model.CellState> a(android.telephony.CellLocation r8, java.util.List<android.telephony.NeighboringCellInfo> r9, java.lang.String r10, java.lang.Object r11) {
        /*
            if (r8 == 0) goto L76
            int[] r10 = a(r10)
            r0 = 0
            r1 = r10[r0]
            r2 = 1
            r10 = r10[r2]
            r3 = 0
            java.util.ArrayList r4 = new java.util.ArrayList
            r4.<init>()
            boolean r5 = r8 instanceof android.telephony.gsm.GsmCellLocation
            if (r5 == 0) goto L22
            android.telephony.gsm.GsmCellLocation r8 = (android.telephony.gsm.GsmCellLocation) r8
            com.amap.location.common.model.CellState r3 = a(r1, r10, r8)
            if (r3 == 0) goto L33
            r4.add(r3)
            goto L33
        L22:
            boolean r5 = r8 instanceof android.telephony.cdma.CdmaCellLocation
            if (r5 == 0) goto L33
            android.telephony.cdma.CdmaCellLocation r8 = (android.telephony.cdma.CdmaCellLocation) r8
            com.amap.location.common.model.CellState r3 = a(r1, r10, r8, r11)
            if (r3 == 0) goto L31
            r4.add(r3)
        L31:
            r8 = 0
            goto L34
        L33:
            r8 = 1
        L34:
            if (r3 == 0) goto L75
            if (r8 == 0) goto L75
            if (r9 == 0) goto L75
            int r8 = r9.size()
            r11 = 0
        L3f:
            if (r11 >= r8) goto L75
            java.lang.Object r3 = r9.get(r11)
            android.telephony.NeighboringCellInfo r3 = (android.telephony.NeighboringCellInfo) r3
            if (r3 != 0) goto L4a
            goto L72
        L4a:
            int r5 = r3.getLac()
            int r6 = r3.getCid()
            boolean r7 = a(r5, r6)
            if (r7 == 0) goto L72
            com.amap.location.common.model.CellState r7 = new com.amap.location.common.model.CellState
            r7.<init>(r2, r0, r0)
            r7.mcc = r1
            r7.mnc = r10
            r7.lac = r5
            r7.cid = r6
            int r3 = r3.getRssi()
            int r3 = a(r3)
            r7.signalStrength = r3
            r4.add(r7)
        L72:
            int r11 = r11 + 1
            goto L3f
        L75:
            return r4
        L76:
            java.util.List r8 = java.util.Collections.emptyList()
            return r8
        */
        throw new UnsupportedOperationException("Method not decompiled: com.amap.location.e.d.b.a(android.telephony.CellLocation, java.util.List, java.lang.String, java.lang.Object):java.util.List");
    }

    public static CellState a(int i, int i2, GsmCellLocation gsmCellLocation) {
        int lac = gsmCellLocation.getLac();
        int cid = gsmCellLocation.getCid();
        if (!a(lac, cid)) {
            return null;
        }
        CellState cellState = new CellState(1, true, false);
        cellState.mcc = i;
        cellState.mnc = i2;
        cellState.lac = lac;
        cellState.cid = cid;
        return cellState;
    }

    public static CellState a(int i, int i2, CdmaCellLocation cdmaCellLocation, Object obj) {
        int systemId = cdmaCellLocation.getSystemId();
        int networkId = cdmaCellLocation.getNetworkId();
        int baseStationId = cdmaCellLocation.getBaseStationId();
        if (!a(systemId, networkId, baseStationId)) {
            if (obj != null) {
                try {
                    Field declaredField = cdmaCellLocation.getClass().getDeclaredField("mGsmCellLoc");
                    if (!declaredField.isAccessible()) {
                        declaredField.setAccessible(true);
                    }
                    return a(i, i2, (GsmCellLocation) declaredField.get(cdmaCellLocation));
                } catch (Throwable th) {
                    com.amap.location.common.e.a.a(th);
                }
            }
            return null;
        }
        CellState cellState = new CellState(2, true, false);
        cellState.mcc = i;
        cellState.mnc = i2;
        cellState.sid = systemId;
        cellState.nid = networkId;
        cellState.bid = baseStationId;
        cellState.latitude = cdmaCellLocation.getBaseStationLatitude();
        cellState.longitude = cdmaCellLocation.getBaseStationLongitude();
        return cellState;
    }

    @TargetApi(18)
    public static List<CellState> a(List<CellInfo> list, String str, com.amap.location.e.c.b bVar) {
        CellState cellState;
        char c;
        if (list != null) {
            int size = list.size();
            ArrayList arrayList = new ArrayList();
            CellState cellState2 = null;
            char c2 = 0;
            for (int i = 0; i < size; i++) {
                CellInfo cellInfo = list.get(i);
                if (cellInfo != null) {
                    boolean isRegistered = cellInfo.isRegistered();
                    if (cellInfo instanceof CellInfoGsm) {
                        cellState = a((CellInfoGsm) cellInfo, isRegistered);
                        c = 4;
                    } else if (cellInfo instanceof CellInfoLte) {
                        cellState = a((CellInfoLte) cellInfo, isRegistered);
                        c = 3;
                    } else if (cellInfo instanceof CellInfoWcdma) {
                        cellState = a((CellInfoWcdma) cellInfo, isRegistered);
                        c = 2;
                    } else if (cellInfo instanceof CellInfoCdma) {
                        cellState = a((CellInfoCdma) cellInfo, str, isRegistered);
                        c = 1;
                    } else if (Build.VERSION.SDK_INT < 29 || !(cellInfo instanceof CellInfoNr)) {
                        cellState = null;
                        c = 0;
                    } else {
                        cellState = a((CellInfoNr) cellInfo, str, isRegistered);
                        c = 6;
                    }
                    if (cellState != null) {
                        if (!isRegistered) {
                            arrayList.add(cellState);
                        } else if (c2 < c) {
                            if (cellState2 != null) {
                                arrayList.add(cellState2);
                            }
                            cellState2 = cellState;
                            c2 = c;
                        } else {
                            arrayList.add(cellState);
                        }
                    }
                }
            }
            if (cellState2 != null) {
                arrayList.add(0, cellState2);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    @TargetApi(17)
    public static CellState a(CellInfoGsm cellInfoGsm, boolean z) {
        CellIdentityGsm cellIdentity = cellInfoGsm.getCellIdentity();
        int lac = cellIdentity.getLac();
        int cid = cellIdentity.getCid();
        int bsic = Build.VERSION.SDK_INT >= 24 ? cellIdentity.getBsic() : -1;
        if (!a(lac, cid) && !j.f(bsic)) {
            return null;
        }
        CellState cellState = new CellState(1, z);
        cellState.mcc = cellIdentity.getMcc();
        cellState.mnc = cellIdentity.getMnc();
        cellState.lac = lac;
        cellState.cid = cid;
        cellState.signalStrength = cellInfoGsm.getCellSignalStrength().getDbm();
        int i = 32767;
        if (bsic >= 0 && bsic <= 32767) {
            i = bsic;
        }
        cellState.pci = (short) i;
        if (Build.VERSION.SDK_INT >= 24) {
            cellState.arfcn = cellIdentity.getArfcn();
            cellState.newpci = bsic;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            cellState.timingAdvance = cellInfoGsm.getCellSignalStrength().getTimingAdvance();
        }
        return cellState;
    }

    @TargetApi(18)
    public static CellState a(CellInfoWcdma cellInfoWcdma, boolean z) {
        CellIdentityWcdma cellIdentity = cellInfoWcdma.getCellIdentity();
        int lac = cellIdentity.getLac();
        int cid = cellIdentity.getCid();
        int psc = cellIdentity.getPsc();
        if (!a(lac, cid) && !j.f(psc)) {
            return null;
        }
        CellState cellState = new CellState(4, z);
        cellState.mcc = cellIdentity.getMcc();
        cellState.mnc = cellIdentity.getMnc();
        cellState.lac = lac;
        cellState.cid = cid;
        int i = 32767;
        if (psc >= 0 && psc <= 32767) {
            i = psc;
        }
        cellState.pci = (short) i;
        cellState.signalStrength = cellInfoWcdma.getCellSignalStrength().getDbm();
        if (!a(lac, cid)) {
            cellState.lastUpdateUtcMills = -1L;
        }
        cellState.newpci = psc;
        if (Build.VERSION.SDK_INT >= 24) {
            cellState.arfcn = cellIdentity.getUarfcn();
        }
        return cellState;
    }

    @TargetApi(17)
    public static CellState a(CellInfoLte cellInfoLte, boolean z) {
        CellIdentityLte cellIdentity = cellInfoLte.getCellIdentity();
        int tac = cellIdentity.getTac();
        int ci = cellIdentity.getCi();
        int pci = cellIdentity.getPci();
        if (!a(tac, ci) && !j.f(pci)) {
            return null;
        }
        CellState cellState = new CellState(3, z);
        cellState.mcc = cellIdentity.getMcc();
        cellState.mnc = cellIdentity.getMnc();
        cellState.lac = tac;
        cellState.cid = ci;
        int i = 32767;
        if (pci >= 0 && pci <= 32767) {
            i = pci;
        }
        cellState.pci = (short) i;
        cellState.signalStrength = cellInfoLte.getCellSignalStrength().getDbm();
        if (!a(tac, ci)) {
            cellState.lastUpdateUtcMills = -1L;
        }
        cellState.newpci = pci;
        if (Build.VERSION.SDK_INT >= 24) {
            cellState.arfcn = cellIdentity.getEarfcn();
        }
        if (Build.VERSION.SDK_INT >= 17) {
            cellState.timingAdvance = cellInfoLte.getCellSignalStrength().getTimingAdvance();
        }
        return cellState;
    }

    @TargetApi(17)
    public static CellState a(CellInfoCdma cellInfoCdma, String str, boolean z) {
        CellIdentityCdma cellIdentity = cellInfoCdma.getCellIdentity();
        int systemId = cellIdentity.getSystemId();
        int networkId = cellIdentity.getNetworkId();
        int basestationId = cellIdentity.getBasestationId();
        if (!a(systemId, networkId, basestationId)) {
            return null;
        }
        CellState cellState = new CellState(2, z);
        int[] a = a(str);
        cellState.mcc = a[0];
        cellState.mnc = a[1];
        cellState.sid = systemId;
        cellState.nid = networkId;
        cellState.bid = basestationId;
        cellState.latitude = cellIdentity.getLatitude();
        cellState.longitude = cellIdentity.getLongitude();
        cellState.signalStrength = cellInfoCdma.getCellSignalStrength().getCdmaDbm();
        return cellState;
    }

    public static CellState a(CellInfoNr cellInfoNr, String str, boolean z) {
        CellState cellState = null;
        if (Build.VERSION.SDK_INT >= 29) {
            CellIdentityNr cellIdentityNr = (CellIdentityNr) cellInfoNr.getCellIdentity();
            int tac = cellIdentityNr.getTac();
            int pci = cellIdentityNr.getPci();
            long nci = cellIdentityNr.getNci();
            if (!a(tac, nci) && !j.f(pci)) {
                return null;
            }
            cellState = new CellState(6, z);
            cellState.mcc = TextUtils.isEmpty(cellIdentityNr.getMccString()) ? 65535 : Integer.parseInt(cellIdentityNr.getMccString());
            cellState.mnc = TextUtils.isEmpty(cellIdentityNr.getMncString()) ? 65535 : Integer.parseInt(cellIdentityNr.getMncString());
            cellState.lac = tac;
            cellState.nci = nci;
            cellState.cid = (int) nci;
            cellState.newpci = pci;
            cellState.arfcn = cellIdentityNr.getNrarfcn();
            cellState.signalStrength = ((CellSignalStrengthNr) cellInfoNr.getCellSignalStrength()).getDbm();
        }
        return cellState;
    }

    public static int[] a(String str) {
        int[] iArr = {65535, 65535};
        if (TextUtils.isEmpty(str)) {
            return iArr;
        }
        try {
            iArr[0] = Integer.parseInt(str.substring(0, 3));
            iArr[1] = Integer.parseInt(str.substring(3));
        } catch (Exception unused) {
            iArr[0] = 65535;
            iArr[1] = 65535;
        }
        if (iArr[0] == 0 && iArr[1] == 0) {
            iArr[0] = 65535;
            iArr[1] = 65535;
        }
        return iArr;
    }

    public static boolean a(int i, int i2) {
        return j.a(i) && j.b(i2);
    }

    public static boolean a(int i, long j) {
        return j.a(i) && j.b(j);
    }

    public static boolean a(int i, int i2, int i3) {
        return j.a(i, i2, i3);
    }
}
