package com.amap.location.e.d;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.os.Build;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.CellLocation;
import android.telephony.NeighboringCellInfo;
import android.telephony.SignalStrength;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import com.amap.location.common.f.j;
import com.amap.location.common.model.CellState;
import com.amap.location.common.model.CellStatus;
import com.amap.location.common.model.FPS;
import com.amap.location.common.model.WiFi;
import com.amap.location.common.model.WifiStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/* compiled from: NLUtils.java */
/* loaded from: classes.dex */
public class e {
    public static a a = new a();

    /* compiled from: NLUtils.java */
    /* loaded from: classes.dex */
    public static class a implements Comparator<CellState> {
        public a() {
        }

        @Override // java.util.Comparator
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public int compare(CellState cellState, CellState cellState2) {
            return defpackage.a.a(cellState.cid, cellState2.cid);
        }
    }

    public static boolean a(Context context) {
        int i;
        ContentResolver contentResolver = context.getContentResolver();
        try {
            if (Build.VERSION.SDK_INT >= 17) {
                i = Settings.Global.getInt(contentResolver, "airplane_mode_on", 0);
            } else {
                i = Settings.System.getInt(contentResolver, "airplane_mode_on", 0);
            }
            return i != 0;
        } catch (SecurityException e) {
            com.amap.location.common.e.a.a(e);
            return false;
        } catch (Throwable th) {
            com.amap.location.common.e.a.a(th);
            return false;
        }
    }

    public static boolean b(Context context) {
        com.amap.location.g.d.a a2 = com.amap.location.g.d.a.a(context);
        boolean g = a2.g();
        if (g || Build.VERSION.SDK_INT < 18 || !a2.d()) {
            return g;
        }
        return true;
    }

    public static boolean c(Context context) {
        PowerManager powerManager = (PowerManager) context.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 20) {
            return powerManager.isInteractive();
        }
        return powerManager.isScreenOn();
    }

    public static boolean d(Context context) {
        return com.amap.location.g.d.a.a(context).g() && !(j.a(context) == 0);
    }

    public static Class<?> b() {
        int a2 = a();
        try {
            return ClassLoader.getSystemClassLoader().loadClass(a2 != 0 ? a2 != 1 ? a2 != 2 ? null : "android.telephony.TelephonyManager2" : "android.telephony.MSimTelephonyManager" : "android.telephony.TelephonyManager");
        } catch (Exception e) {
            com.amap.location.common.e.a.a(e);
            return null;
        }
    }

    public static int a() {
        int i;
        try {
            Class.forName("android.telephony.MSimTelephonyManager");
            i = 1;
        } catch (Throwable unused) {
            i = 0;
        }
        if (i != 0) {
            return i;
        }
        try {
            Class.forName("android.telephony.TelephonyManager2");
            return 2;
        } catch (Throwable unused2) {
            return i;
        }
    }

    public static CellStatus a(Context context, com.amap.location.g.a.a aVar, Object obj, com.amap.location.e.c.b bVar, CellLocation cellLocation, FPS fps) {
        int i;
        String e = aVar.e();
        List<CellState> emptyList = Collections.emptyList();
        if (cellLocation == null) {
            try {
                cellLocation = a(context, aVar);
                if (cellLocation == null) {
                    cellLocation = a(obj);
                }
            } catch (SecurityException e2) {
                com.amap.location.common.e.a.a(e2);
            } catch (Exception e3) {
                com.amap.location.common.e.a.a(e3);
            }
        }
        List<NeighboringCellInfo> list = null;
        if (cellLocation != null && (cellLocation instanceof GsmCellLocation)) {
            list = aVar.f();
        }
        emptyList = b.a(cellLocation, list, e, obj);
        CellStatus cellStatus = new CellStatus();
        if (!TextUtils.isEmpty(e)) {
            cellStatus.networkOperator = e;
            cellStatus.cellType |= 8;
        }
        if (emptyList.size() > 0) {
            CellState cellState = emptyList.get(0);
            if (cellState.registered) {
                CellState cellState2 = fps.cellStatus.mainCell;
                if (cellState2 != null && (i = cellState2.signalStrength) != 99) {
                    cellState.signalStrength = i;
                }
                cellStatus.mainCell = cellState;
                emptyList.remove(0);
                int i2 = cellState.type;
                if (i2 == 1) {
                    cellStatus.cellType |= 1;
                } else if (i2 == 2) {
                    cellStatus.cellType |= 2;
                }
            }
            cellStatus.neighbors = emptyList;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            List<CellState> emptyList2 = Collections.emptyList();
            try {
                emptyList2 = b.a(aVar.b(), e, bVar);
            } catch (SecurityException e4) {
                com.amap.location.common.e.a.a(e4);
            } catch (Exception e5) {
                com.amap.location.common.e.a.a(e5);
            }
            if (emptyList2.size() > 0) {
                cellStatus.cellType |= 4;
                CellState cellState3 = emptyList2.get(0);
                if (cellState3.registered) {
                    cellStatus.mainCell2 = cellState3;
                }
                cellStatus.cellStateList2 = emptyList2;
            }
        }
        a(cellStatus);
        cellStatus.updateTime = SystemClock.elapsedRealtime();
        List<CellState> list2 = cellStatus.neighbors;
        if (list2 != null && list2.size() > 0) {
            Collections.sort(cellStatus.neighbors, a);
        }
        List<CellState> list3 = cellStatus.cellStateList2;
        if (list3 != null && list3.size() > 0) {
            Collections.sort(cellStatus.cellStateList2, a);
        }
        ArrayList arrayList = new ArrayList();
        CellState cellState4 = cellStatus.mainCell;
        if (cellState4 != null) {
            arrayList.add(cellState4);
        }
        List<CellState> list4 = cellStatus.neighbors;
        if (list4 != null) {
            arrayList.addAll(list4);
        }
        List<CellState> list5 = cellStatus.cellStateList2;
        if (list5 != null) {
            arrayList.addAll(list5);
        }
        bVar.a((List) arrayList);
        return cellStatus;
    }

    /* JADX WARN: Removed duplicated region for block: B:32:0x0092 A[PHI: r0
  0x0092: PHI (r0v4 android.telephony.CellLocation) = (r0v3 android.telephony.CellLocation), (r0v5 android.telephony.CellLocation), (r0v12 android.telephony.CellLocation) binds: [B:50:0x008a, B:31:0x008f, B:52:0x0080] A[DONT_GENERATE, DONT_INLINE], RETURN] */
    /* JADX WARN: Removed duplicated region for block: B:35:0x0059 A[RETURN] */
    /* JADX WARN: Removed duplicated region for block: B:36:0x005a A[EXC_TOP_SPLITTER, SYNTHETIC] */
    /* JADX WARN: Removed duplicated region for block: B:53:0x0082 A[RETURN] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static android.telephony.CellLocation a(android.content.Context r7, com.amap.location.g.a.a r8) {
        /*
            r0 = 0
            android.telephony.CellLocation r0 = r8.a()     // Catch: java.lang.Throwable -> L89 java.lang.SecurityException -> L8e
            boolean r8 = a(r0)     // Catch: java.lang.Throwable -> L89 java.lang.SecurityException -> L8e
            if (r8 == 0) goto Lc
            return r0
        Lc:
            java.lang.String r8 = "phone"
            java.lang.Object r7 = r7.getSystemService(r8)     // Catch: java.lang.Throwable -> L89 java.lang.SecurityException -> L8e
            android.telephony.TelephonyManager r7 = (android.telephony.TelephonyManager) r7     // Catch: java.lang.Throwable -> L89 java.lang.SecurityException -> L8e
            r8 = 0
            java.lang.String r1 = "getAllCellInfo"
            java.lang.Object[] r2 = new java.lang.Object[r8]     // Catch: java.lang.Exception -> L24 java.lang.Throwable -> L89
            java.lang.Object r1 = com.amap.location.g.c.a.a(r7, r1, r2)     // Catch: java.lang.Exception -> L24 java.lang.Throwable -> L89
            java.util.List r1 = (java.util.List) r1     // Catch: java.lang.Exception -> L24 java.lang.Throwable -> L89
            android.telephony.CellLocation r0 = a(r1)     // Catch: java.lang.Exception -> L24 java.lang.Throwable -> L89
            goto L28
        L24:
            r1 = move-exception
            com.amap.location.common.e.a.a(r1)     // Catch: java.lang.Throwable -> L89 java.lang.SecurityException -> L8e
        L28:
            boolean r1 = a(r0)     // Catch: java.lang.Throwable -> L89 java.lang.SecurityException -> L8e
            if (r1 == 0) goto L2f
            return r0
        L2f:
            r1 = 100516(0x188a4, float:1.40853E-40)
            r2 = 1
            java.lang.String r3 = "getCellLocationExt"
            java.lang.Object[] r4 = new java.lang.Object[r2]     // Catch: java.lang.Exception -> L4b java.lang.Throwable -> L89
            java.lang.Integer r5 = java.lang.Integer.valueOf(r2)     // Catch: java.lang.Exception -> L4b java.lang.Throwable -> L89
            r4[r8] = r5     // Catch: java.lang.Exception -> L4b java.lang.Throwable -> L89
            java.lang.Object r3 = com.amap.location.g.c.a.a(r7, r3, r4)     // Catch: java.lang.Exception -> L4b java.lang.Throwable -> L89
            if (r3 == 0) goto L53
            android.telephony.CellLocation r3 = (android.telephony.CellLocation) r3     // Catch: java.lang.Exception -> L4b java.lang.Throwable -> L89
            com.amap.location.uptunnel.UpTunnel.addCount(r1)     // Catch: java.lang.Exception -> L49 java.lang.Throwable -> L83
            goto L52
        L49:
            r0 = move-exception
            goto L4f
        L4b:
            r3 = move-exception
            r6 = r3
            r3 = r0
            r0 = r6
        L4f:
            com.amap.location.common.e.a.a(r0)     // Catch: java.lang.Throwable -> L83 java.lang.SecurityException -> L86
        L52:
            r0 = r3
        L53:
            boolean r3 = a(r0)     // Catch: java.lang.Throwable -> L89 java.lang.SecurityException -> L8e
            if (r3 == 0) goto L5a
            return r0
        L5a:
            java.lang.String r3 = "getCellLocationGemini"
            java.lang.Object[] r4 = new java.lang.Object[r2]     // Catch: java.lang.Exception -> L78 java.lang.Throwable -> L89
            java.lang.Integer r2 = java.lang.Integer.valueOf(r2)     // Catch: java.lang.Exception -> L78 java.lang.Throwable -> L89
            r4[r8] = r2     // Catch: java.lang.Exception -> L78 java.lang.Throwable -> L89
            java.lang.Object r7 = com.amap.location.g.c.a.a(r7, r3, r4)     // Catch: java.lang.Exception -> L78 java.lang.Throwable -> L89
            if (r7 == 0) goto L7c
            android.telephony.CellLocation r7 = (android.telephony.CellLocation) r7     // Catch: java.lang.Exception -> L78 java.lang.Throwable -> L89
            com.amap.location.uptunnel.UpTunnel.addCount(r1)     // Catch: java.lang.Throwable -> L71 java.lang.Exception -> L75
            r0 = r7
            goto L7c
        L71:
            r8 = move-exception
            r0 = r7
            r7 = r8
            goto L8a
        L75:
            r8 = move-exception
            r0 = r7
            goto L79
        L78:
            r8 = move-exception
        L79:
            com.amap.location.common.e.a.a(r8)     // Catch: java.lang.Throwable -> L89 java.lang.SecurityException -> L8e
        L7c:
            boolean r7 = a(r0)     // Catch: java.lang.Throwable -> L89 java.lang.SecurityException -> L8e
            if (r7 == 0) goto L92
            return r0
        L83:
            r7 = move-exception
            r0 = r3
            goto L8a
        L86:
            r7 = move-exception
            r0 = r3
            goto L8f
        L89:
            r7 = move-exception
        L8a:
            com.amap.location.common.e.a.a(r7)
            goto L92
        L8e:
            r7 = move-exception
        L8f:
            com.amap.location.common.e.a.a(r7)
        L92:
            return r0
        */
        throw new UnsupportedOperationException("Method not decompiled: com.amap.location.e.d.e.a(android.content.Context, com.amap.location.g.a.a):android.telephony.CellLocation");
    }

    public static boolean a(CellLocation cellLocation) {
        if (cellLocation == null) {
            return false;
        }
        if (cellLocation instanceof GsmCellLocation) {
            GsmCellLocation gsmCellLocation = (GsmCellLocation) cellLocation;
            return b.a(gsmCellLocation.getLac(), gsmCellLocation.getCid());
        }
        if (!(cellLocation instanceof CdmaCellLocation)) {
            return false;
        }
        CdmaCellLocation cdmaCellLocation = (CdmaCellLocation) cellLocation;
        return b.a(cdmaCellLocation.getSystemId(), cdmaCellLocation.getNetworkId(), cdmaCellLocation.getBaseStationId());
    }

    public static CellLocation a(Object obj) {
        Object obj2;
        List list;
        if (obj == null) {
            return null;
        }
        try {
            Class<?> b = b();
            if (b.isInstance(obj)) {
                Object cast = b.cast(obj);
                try {
                    obj2 = com.amap.location.g.c.a.a(cast, "getCellLocation", new Object[0]);
                } catch (Exception e) {
                    com.amap.location.common.e.a.a(e);
                    obj2 = null;
                }
                if (obj2 == null) {
                    try {
                        obj2 = com.amap.location.g.c.a.a(cast, "getCellLocation", 1);
                    } catch (Exception e2) {
                        com.amap.location.common.e.a.a(e2);
                    }
                }
                if (obj2 == null) {
                    try {
                        obj2 = com.amap.location.g.c.a.a(cast, "getCellLocationGemini", 1);
                    } catch (Exception e3) {
                        com.amap.location.common.e.a.a(e3);
                    }
                }
                if (obj2 == null) {
                    try {
                        list = (List) com.amap.location.g.c.a.a(cast, "getAllCellInfo", new Object[0]);
                    } catch (Exception e4) {
                        com.amap.location.common.e.a.a(e4);
                        list = null;
                    }
                    obj2 = a((List<?>) list);
                }
            } else {
                obj2 = null;
            }
            if (obj2 != null) {
                return (CellLocation) obj2;
            }
            return null;
        } catch (Throwable th) {
            com.amap.location.common.e.a.a(th);
            return null;
        }
    }

    public static CellLocation a(List<?> list) {
        Object cast;
        int b;
        int b2;
        GsmCellLocation gsmCellLocation;
        if (list == null || list.isEmpty()) {
            return null;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        int i = 0;
        GsmCellLocation gsmCellLocation2 = null;
        CdmaCellLocation cdmaCellLocation = null;
        char c = 0;
        while (true) {
            if (i >= list.size()) {
                break;
            }
            Object obj = list.get(i);
            if (obj != null) {
                try {
                    Class<?> loadClass = systemClassLoader.loadClass("android.telephony.CellInfoGsm");
                    Class<?> loadClass2 = systemClassLoader.loadClass("android.telephony.CellInfoWcdma");
                    Class<?> loadClass3 = systemClassLoader.loadClass("android.telephony.CellInfoLte");
                    Class<?> loadClass4 = systemClassLoader.loadClass("android.telephony.CellInfoCdma");
                    if (loadClass.isInstance(obj)) {
                        c = 1;
                    } else if (loadClass2.isInstance(obj)) {
                        c = 2;
                    } else if (loadClass3.isInstance(obj)) {
                        c = 3;
                    } else {
                        c = loadClass4.isInstance(obj) ? (char) 4 : (char) 0;
                    }
                    if (c > 0) {
                        if (c == 1) {
                            cast = loadClass.cast(obj);
                        } else if (c == 2) {
                            cast = loadClass2.cast(obj);
                        } else if (c == 3) {
                            cast = loadClass3.cast(obj);
                        } else {
                            cast = c == 4 ? loadClass4.cast(obj) : null;
                        }
                        Object a2 = com.amap.location.g.c.a.a(cast, "getCellIdentity", new Object[0]);
                        if (a2 != null) {
                            if (c == 4) {
                                CdmaCellLocation cdmaCellLocation2 = new CdmaCellLocation();
                                try {
                                    cdmaCellLocation2.setCellLocationData(com.amap.location.g.c.a.b(a2, "getBasestationId", new Object[0]), com.amap.location.g.c.a.b(a2, "getLatitude", new Object[0]), com.amap.location.g.c.a.b(a2, "getLongitude", new Object[0]), com.amap.location.g.c.a.b(a2, "getSystemId", new Object[0]), com.amap.location.g.c.a.b(a2, "getNetworkId", new Object[0]));
                                    cdmaCellLocation = cdmaCellLocation2;
                                    break;
                                } catch (Exception e) {
                                    e = e;
                                    cdmaCellLocation = cdmaCellLocation2;
                                    com.amap.location.common.e.a.a(e);
                                    i++;
                                }
                            } else if (c == 3) {
                                int b3 = com.amap.location.g.c.a.b(a2, "getTac", new Object[0]);
                                int b4 = com.amap.location.g.c.a.b(a2, "getCi", new Object[0]);
                                GsmCellLocation gsmCellLocation3 = new GsmCellLocation();
                                try {
                                    gsmCellLocation3.setLacAndCid(b3, b4);
                                    gsmCellLocation2 = gsmCellLocation3;
                                    break;
                                } catch (Exception e2) {
                                    e = e2;
                                    gsmCellLocation2 = gsmCellLocation3;
                                    com.amap.location.common.e.a.a(e);
                                    i++;
                                }
                            } else {
                                try {
                                    b = com.amap.location.g.c.a.b(a2, "getLac", new Object[0]);
                                    b2 = com.amap.location.g.c.a.b(a2, "getCid", new Object[0]);
                                    gsmCellLocation = new GsmCellLocation();
                                } catch (Exception e3) {
                                    e = e3;
                                }
                                try {
                                    gsmCellLocation.setLacAndCid(b, b2);
                                    gsmCellLocation2 = gsmCellLocation;
                                    break;
                                } catch (Exception e4) {
                                    e = e4;
                                    gsmCellLocation2 = gsmCellLocation;
                                    com.amap.location.common.e.a.a(e);
                                    i++;
                                }
                            }
                        }
                    }
                } catch (Exception e5) {
                    e = e5;
                }
            }
            i++;
        }
        return c == 4 ? cdmaCellLocation : gsmCellLocation2;
    }

    public static void a(CellStatus cellStatus) {
        int size;
        CellState cellState = cellStatus.mainCell;
        if (cellState == null || cellState.type == 2 || cellState.mcc != 65535 || cellState.mnc != 65535 || (size = cellStatus.cellStateList2.size()) <= 0) {
            return;
        }
        for (int i = 0; i < size; i++) {
            CellState cellState2 = cellStatus.cellStateList2.get(i);
            if (cellState2.type != 2) {
                int i2 = cellState2.lac;
                CellState cellState3 = cellStatus.mainCell;
                if (i2 == cellState3.lac && cellState2.cid == cellState3.cid) {
                    cellState3.mcc = cellState2.mcc;
                    cellState3.mnc = cellState2.mnc;
                    return;
                }
            }
        }
    }

    public static boolean a(FPS fps) {
        CellStatus cellStatus = fps.cellStatus;
        if (cellStatus.mainCell != null || cellStatus.mainCell2 != null || fps.wifiStatus.numWiFis() >= 2) {
            return true;
        }
        WifiStatus wifiStatus = fps.wifiStatus;
        WiFi wiFi = wifiStatus.mainWifi;
        if (wiFi != null && wiFi.mac > 0 && wifiStatus.numWiFis() == 1) {
            WifiStatus wifiStatus2 = fps.wifiStatus;
            if (wifiStatus2.mainWifi.mac != wifiStatus2.getWiFi(0).mac) {
                return true;
            }
        }
        return false;
    }

    public static void a(WifiStatus wifiStatus, WifiInfo wifiInfo, Context context) {
        if (wifiInfo != null) {
            int frequency = Build.VERSION.SDK_INT >= 21 ? wifiInfo.getFrequency() : 0;
            long a2 = j.a(wifiInfo.getBSSID());
            if (a2 != 0 && d(context)) {
                wifiStatus.mainWifi = new WiFi(a2, wifiInfo.getSSID(), wifiInfo.getRssi(), frequency, SystemClock.elapsedRealtime(), true);
                return;
            } else {
                wifiStatus.mainWifi = null;
                return;
            }
        }
        wifiStatus.mainWifi = null;
    }

    public static int a(SignalStrength signalStrength, com.amap.location.g.a.a aVar, int i) {
        if (i != 1) {
            if (i == 2) {
                return signalStrength.getCdmaDbm();
            }
            return 99;
        }
        if (aVar != null && aVar.c() == 13) {
            try {
                return ((Integer) SignalStrength.class.getDeclaredMethod("getLteDbm", new Class[0]).invoke(signalStrength, new Object[0])).intValue();
            } catch (Exception e) {
                com.amap.location.common.e.a.a(e);
                return 99;
            }
        }
        return b.a(signalStrength.getGsmSignalStrength());
    }
}
