package com.amap.location.e;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.location.LocationManager;
import android.net.wifi.ScanResult;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import com.amap.location.common.f.j;
import com.amap.location.common.model.AmapLoc;
import com.amap.location.common.model.CellState;
import com.amap.location.common.model.CellStatus;
import com.amap.location.common.model.FPS;
import com.amap.location.common.model.WiFi;
import com.amap.location.common.model.WifiStatus;
import com.amap.location.g.d.a;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/* compiled from: LocationContext.java */
/* loaded from: classes.dex */
public class g {
    public com.amap.location.e.c.b B;
    public com.amap.location.e.c.c C;
    public com.amap.location.e.d.d D;
    public TelephonyManager E;
    public com.amap.location.e.c a;
    public Context b;
    public h c;
    public boolean d;
    public boolean i;
    public boolean j;
    public boolean k;
    public boolean l;
    public com.amap.location.e.d.a m;
    public com.amap.location.g.a.a n;
    public LocationManager o;
    public Object p;
    public com.amap.location.g.d.a q;
    public a r;
    public c s;
    public d t;
    public b u;
    public long v;
    public long w;
    public long x;
    public long y;
    public long z;
    public FPS e = new FPS();
    public final List<CellStatus.HistoryCell> f = new ArrayList(3);
    public boolean g = true;
    public boolean h = true;
    public ReentrantReadWriteLock A = new ReentrantReadWriteLock();
    public Runnable F = new Runnable() { // from class: com.amap.location.e.g.1
        @Override // java.lang.Runnable
        public void run() {
            g.this.a(20);
        }
    };
    public Runnable G = new Runnable() { // from class: com.amap.location.e.g.2
        @Override // java.lang.Runnable
        @SuppressLint({"MissingPermission"})
        public void run() {
            if (Build.VERSION.SDK_INT >= 29) {
                try {
                    g.this.E.requestCellInfoUpdate(com.amap.location.e.d.f.a().b(), new TelephonyManager.CellInfoCallback() { // from class: com.amap.location.e.g.2.1
                        @Override // android.telephony.TelephonyManager.CellInfoCallback
                        public void onCellInfo(List<CellInfo> list) {
                        }
                    });
                } catch (Throwable th) {
                    com.amap.location.common.e.a.a("nlcontext", th);
                }
            }
        }
    };
    public ContentObserver H = new ContentObserver(new Handler()) { // from class: com.amap.location.e.g.3
        @Override // android.database.ContentObserver
        public void onChange(boolean z) {
            g.this.a(12, com.amap.location.e.d.e.b(g.this.b) ? 1 : 0);
        }
    };

    /* compiled from: LocationContext.java */
    /* loaded from: classes.dex */
    public final class a extends BroadcastReceiver {
        public a() {
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (context == null || intent == null) {
                return;
            }
            String action = intent.getAction();
            char c = 65535;
            switch (action.hashCode()) {
                case -2128145023:
                    if (action.equals("android.intent.action.SCREEN_OFF")) {
                        c = 0;
                        break;
                    }
                    break;
                case -1875733435:
                    if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                        c = 3;
                        break;
                    }
                    break;
                case -1454123155:
                    if (action.equals("android.intent.action.SCREEN_ON")) {
                        c = 1;
                        break;
                    }
                    break;
                case -1184851779:
                    if (action.equals("android.location.PROVIDERS_CHANGED")) {
                        c = 5;
                        break;
                    }
                    break;
                case -1076576821:
                    if (action.equals("android.intent.action.AIRPLANE_MODE")) {
                        c = 2;
                        break;
                    }
                    break;
                case -343630553:
                    if (action.equals("android.net.wifi.STATE_CHANGE")) {
                        c = 4;
                        break;
                    }
                    break;
            }
            if (c == 0) {
                g.this.a(30, 0);
                return;
            }
            if (c == 1) {
                g.this.a(30, 1);
                return;
            }
            if (c == 2) {
                g.this.a(13, !com.amap.location.e.d.e.a(g.this.b) ? 1 : 0);
                return;
            }
            if (c != 3) {
                if (c == 4) {
                    g.this.a(16);
                    return;
                } else {
                    if (c != 5) {
                        return;
                    }
                    g.this.a(17);
                    return;
                }
            }
            int intExtra = intent.getIntExtra("wifi_state", 4);
            if (intExtra == 3 || intExtra == 1) {
                g.this.a(12, com.amap.location.e.d.e.b(g.this.b) ? 1 : 0);
            }
        }
    }

    /* compiled from: LocationContext.java */
    /* loaded from: classes.dex */
    public final class b extends Handler {
        public b(Looper looper) {
            super(looper);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            int i = message.what;
            if (i == 1) {
                g.this.b(message.arg1, message.arg2 == 1);
                return;
            }
            if (i == 20) {
                g.this.h();
                return;
            }
            if (i == 30) {
                g.this.c(message.arg1 != 0);
                return;
            }
            switch (i) {
                case 10:
                    g.this.a((List<ScanResult>) message.obj);
                    return;
                case 11:
                    g.this.a(message.arg1 == 1 ? (CellLocation) message.obj : null);
                    return;
                case 12:
                    g.this.a(message.arg1 != 0);
                    return;
                case 13:
                    g.this.b(message.arg1 != 0);
                    return;
                default:
                    switch (i) {
                        case 15:
                            g.this.a((SignalStrength) message.obj);
                            return;
                        case 16:
                            g.this.o();
                            return;
                        case 17:
                            boolean z = g.this.l;
                            g gVar = g.this;
                            gVar.l = gVar.s();
                            if (!g.this.l || z) {
                                return;
                            }
                            g.this.w = 0L;
                            g.this.y = 0L;
                            return;
                        default:
                            return;
                    }
            }
        }
    }

    /* compiled from: LocationContext.java */
    /* loaded from: classes.dex */
    public final class c extends PhoneStateListener {
        public c() {
        }

        @Override // android.telephony.PhoneStateListener
        public void onCellInfoChanged(List<CellInfo> list) {
            g.this.a(11);
        }

        @Override // android.telephony.PhoneStateListener
        public void onCellLocationChanged(CellLocation cellLocation) {
            g.this.a(11, 1, 0, cellLocation);
        }

        @Override // android.telephony.PhoneStateListener
        public void onDataConnectionStateChanged(int i) {
            g.this.a(11);
        }

        @Override // android.telephony.PhoneStateListener
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            if (signalStrength == null || g.this.e.cellStatus.mainCell == null) {
                return;
            }
            if (SystemClock.elapsedRealtime() - g.this.e.cellStatus.updateTime >= 1000 || g.this.e.cellStatus.mainCell.signalStrength == 99) {
                g.this.a(15, 0, 0, signalStrength);
            }
        }
    }

    /* compiled from: LocationContext.java */
    /* loaded from: classes.dex */
    public final class d implements a.InterfaceC0034a {
        public d() {
        }

        @Override // com.amap.location.g.d.a.InterfaceC0034a
        public void a() {
            try {
                g.this.a(10, 0, 0, g.this.q.b());
            } catch (SecurityException | Exception unused) {
            }
        }
    }

    public g(Context context, com.amap.location.e.c cVar, Looper looper, com.amap.location.e.d dVar) {
        this.b = context;
        this.a = cVar;
        a(context, looper);
        a(looper);
        this.c = h.a(context, looper, dVar, cVar);
        this.E = (TelephonyManager) context.getSystemService(StandardProtocolKey.PHONE);
    }

    private void i() {
        if (!l() && this.h) {
            q();
            j();
        } else {
            j();
        }
    }

    private void j() {
        if (!a(this.z, this.a.l.d())) {
            if (this.g) {
                a((CellLocation) null);
            } else {
                com.amap.location.common.e.a.c("nlcontext", "cell not fresh and disable");
                this.e.cellStatus = new CellStatus();
            }
        }
        t();
        a(this.e);
    }

    private void k() {
        this.j = false;
        g();
    }

    private boolean l() {
        if (this.j) {
            return false;
        }
        return a(this.w, (long) e(m())) || (SystemClock.elapsedRealtime() - this.y < ((long) this.a.l.g()) && this.y > 0);
    }

    private boolean m() {
        WiFi wiFi = this.e.wifiStatus.mainWifi;
        return wiFi != null && wiFi.mac > 0;
    }

    private List<ScanResult> n() {
        com.amap.location.g.d.a aVar = this.q;
        if (aVar == null) {
            return null;
        }
        try {
            return aVar.b();
        } catch (SecurityException e) {
            com.amap.location.common.e.a.a(e);
            return null;
        } catch (Exception e2) {
            com.amap.location.common.e.a.a(e2);
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void o() {
        com.amap.location.e.d.e.a(this.e.wifiStatus, this.q.c(), this.b);
        WiFi wiFi = this.e.wifiStatus.mainWifi;
        if (wiFi != null) {
            this.C.a((com.amap.location.e.c.c) wiFi);
        }
    }

    private void p() {
        if (SystemClock.elapsedRealtime() - this.y > this.a.l.m() && this.y > 0) {
            com.amap.location.common.e.a.b("nlcontext", "scan timeout and clear history");
            a(this.e.wifiStatus);
        } else {
            q();
        }
    }

    private void q() {
        List<ScanResult> n = n();
        if (n != null && n.size() != 0) {
            this.e.wifiStatus.updateTime = SystemClock.elapsedRealtime();
            WifiStatus wifiStatus = this.e.wifiStatus;
            wifiStatus.setWifiList(wifiStatus.scanResultList2WifiList(n));
            ArrayList arrayList = new ArrayList();
            WiFi wiFi = this.e.wifiStatus.mainWifi;
            if (wiFi != null) {
                arrayList.add(wiFi);
            }
            if (this.e.wifiStatus.getWifiList() != null) {
                arrayList.addAll(this.e.wifiStatus.getWifiList());
            }
            this.C.a((List) arrayList);
        } else {
            a(this.e.wifiStatus);
        }
        com.amap.location.common.e.a.b("nlcontext", "read wifi:" + SystemClock.elapsedRealtime() + ",size:" + this.e.wifiStatus.getWifiList());
    }

    private void r() {
        g();
        this.j = true;
        f();
        this.q.a(this.t, 0L);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public boolean s() {
        boolean z = true;
        try {
            boolean isProviderEnabled = this.o.isProviderEnabled("gps");
            boolean isProviderEnabled2 = this.o.isProviderEnabled("network");
            if (!isProviderEnabled && !isProviderEnabled2) {
                z = false;
            }
            com.amap.location.common.e.a.b("nlcontext", "loc mode: gps-" + isProviderEnabled + ",network-" + isProviderEnabled2);
        } catch (Exception e) {
            com.amap.location.common.e.a.a(e);
        }
        return z;
    }

    private void t() {
        synchronized (this.f) {
            if (this.e.cellStatus.mainCell != null) {
                j.a(new CellStatus.HistoryCell(this.e.cellStatus.mainCell), this.f, 3);
            }
            if (this.e.cellStatus.mainCell2 != null) {
                j.a(new CellStatus.HistoryCell(this.e.cellStatus.mainCell2), this.f, 3);
            }
            this.e.cellStatus.addHistoryCell(this.f);
        }
    }

    public void a(AmapLoc amapLoc) {
    }

    private void e() {
        try {
            int a2 = com.amap.location.e.d.e.a();
            if (a2 == 0) {
                this.p = a(this.b, "phone2");
            } else if (a2 == 1) {
                this.p = a(this.b, "phone_msim");
            } else if (a2 == 2) {
                this.p = a(this.b, "phone2");
            }
        } catch (Throwable th) {
            com.amap.location.common.e.a.a(th);
        }
    }

    private void f() {
        this.m.a(this.a.l.l());
    }

    private void g() {
        this.m.a();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void h() {
        com.amap.location.common.e.a.b("nlcontext", "wifi sc timeout:" + this.j);
        g();
        if (this.j) {
            this.j = false;
            p();
            d(true);
        }
    }

    public void c() {
        this.i = false;
        this.j = false;
        this.B.b();
        this.C.b();
        this.c.c();
        g();
        com.amap.location.common.e.a.b("nlcontext", "remove");
    }

    public void d() {
        this.i = false;
        this.j = false;
        this.f.clear();
        this.m.b();
        c(Looper.myLooper());
        this.u.removeCallbacks(this.G);
        this.A.writeLock().lock();
        b bVar = this.u;
        this.u = null;
        this.A.writeLock().unlock();
        if (bVar != null) {
            bVar.removeCallbacksAndMessages(null);
        }
        this.c.d();
        this.B.c();
        this.C.c();
        com.amap.location.common.e.a.b("nlcontext", "destory");
    }

    public void b() {
        this.c.b();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void b(int i, boolean z) {
        this.d = z;
        this.B.a();
        this.C.a();
        if (!this.i) {
            this.i = true;
            if (i == 1) {
                i();
                return;
            } else {
                if (i == 0) {
                    d(false);
                    return;
                }
                return;
            }
        }
        com.amap.location.common.e.a.b("nlcontext", "req failed as on request");
    }

    private int e(boolean z) {
        if (z) {
            return this.a.l.f();
        }
        return this.a.l.e();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void c(boolean z) {
        this.k = z;
    }

    private void c(Looper looper) {
        this.q.a(this.t);
        try {
            this.b.unregisterReceiver(this.r);
            this.n.a(this.s, 0, 0L, looper);
        } catch (SecurityException e) {
            com.amap.location.common.e.a.a(e);
        } catch (Throwable th) {
            com.amap.location.common.e.a.a(th);
        }
        try {
            this.b.getContentResolver().unregisterContentObserver(this.H);
        } catch (Exception unused) {
        }
    }

    public void a() {
        this.c.a();
    }

    private void a(Context context, Looper looper) {
        this.n = com.amap.location.g.a.a.a(context);
        this.o = (LocationManager) context.getSystemService("location");
        e();
        com.amap.location.g.d.a a2 = com.amap.location.g.d.a.a(context);
        this.q = a2;
        this.D = new com.amap.location.e.d.d(a2);
        this.u = new b(looper);
        try {
            this.g = !com.amap.location.e.d.e.a(this.b);
            this.h = com.amap.location.e.d.e.b(this.b);
            this.k = com.amap.location.e.d.e.c(this.b);
        } catch (Exception unused) {
        }
        this.i = false;
        this.j = false;
        this.l = s();
        this.B = new com.amap.location.e.c.b(context, "cellage", this.u);
        this.C = new com.amap.location.e.c.c(context, "wifiage", this.u);
        o();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void b(boolean z) {
        com.amap.location.common.e.a.b("nlcontext", "cell enable:" + z);
        this.g = z;
    }

    private void b(Looper looper) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.AIRPLANE_MODE");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.net.wifi.STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        intentFilter.addAction("android.location.PROVIDERS_CHANGED");
        try {
            this.b.registerReceiver(this.r, intentFilter);
        } catch (Throwable unused) {
        }
        this.q.a(this.t, looper);
        try {
            this.n.a(this.s, 1360, 0L, looper);
        } catch (SecurityException e) {
            com.amap.location.common.e.a.a(e);
        } catch (Exception e2) {
            com.amap.location.common.e.a.a(e2);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.b.getContentResolver().registerContentObserver(Settings.Global.getUriFor("wifi_scan_always_enabled"), false, this.H);
        } else {
            this.b.getContentResolver().registerContentObserver(Settings.System.getUriFor("wifi_scan_always_enabled"), false, this.H);
        }
    }

    private void d(boolean z) {
        if (this.i) {
            if (l()) {
                com.amap.location.common.e.a.b("nlcontext", "wifipre-ok");
                j();
                return;
            }
            if (z) {
                com.amap.location.common.e.a.b("nlcontext", "wifipre-notok,scan timeout");
                j();
                return;
            }
            if (!this.h) {
                com.amap.location.common.e.a.b("nlcontext", "wifipre-notok, closed");
                this.e.wifiStatus = new WifiStatus();
                j();
                return;
            }
            if (!this.j) {
                if (this.a.l.t() && (this.k || this.a.l.k())) {
                    long elapsedRealtime = SystemClock.elapsedRealtime();
                    com.amap.location.common.e.a.b("nlcontext", "wifipre-notok,need scan:" + (elapsedRealtime - this.w));
                    this.v = elapsedRealtime;
                    this.w = elapsedRealtime;
                    r();
                    return;
                }
                com.amap.location.common.e.a.b("nlcontext", "wifipre-notok,forbid scan");
                q();
                j();
                return;
            }
            com.amap.location.common.e.a.b("nlcontext", "wifipre-onscan");
            return;
        }
        com.amap.location.common.e.a.b("nlcontext", "wifipre-onreuqest");
    }

    private Object a(Context context, String str) {
        if (context == null) {
            return null;
        }
        try {
            return context.getApplicationContext().getSystemService(str);
        } catch (Throwable unused) {
            return null;
        }
    }

    public void a(int i, boolean z) {
        a(1, i, z ? 1 : 0, null);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(List<ScanResult> list) {
        boolean z;
        long elapsedRealtime = SystemClock.elapsedRealtime();
        this.y = elapsedRealtime;
        if (list != null && list.size() != 0) {
            WifiStatus wifiStatus = this.e.wifiStatus;
            wifiStatus.setWifiList(wifiStatus.scanResultList2WifiList(list));
            this.e.wifiStatus.updateTime = elapsedRealtime;
            z = true;
        } else {
            a(this.e.wifiStatus);
            if (elapsedRealtime - this.x > 60000) {
                o();
                this.x = elapsedRealtime;
            }
            z = false;
        }
        ArrayList arrayList = new ArrayList();
        WiFi wiFi = this.e.wifiStatus.mainWifi;
        if (wiFi != null) {
            arrayList.add(wiFi);
        }
        if (this.e.wifiStatus.getWifiList() != null) {
            arrayList.addAll(this.e.wifiStatus.getWifiList());
        }
        this.C.a((List) arrayList);
        if (this.j) {
            g();
            this.j = false;
            d(!z);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(boolean z) {
        com.amap.location.common.e.a.b("nlcontext", "wifi enable:" + z);
        if (this.h) {
            this.h = z;
            if (z) {
                return;
            }
            d(false);
            return;
        }
        this.h = z;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(CellLocation cellLocation) {
        com.amap.location.common.e.a.b("nlcontext", "update cell:" + SystemClock.elapsedRealtime() + ",enable:" + this.g);
        if (this.g) {
            CellStatus a2 = com.amap.location.e.d.e.a(this.b, this.n, this.p, this.B, cellLocation, this.e);
            this.z = SystemClock.elapsedRealtime();
            int d2 = this.a.l.d();
            if (Build.VERSION.SDK_INT >= 29) {
                int i = d2 - 5000;
                long j = i > 0 ? i : 5000L;
                this.u.removeCallbacks(this.G);
                this.u.postDelayed(this.G, j);
            }
            if (!a(this.e.cellStatus.updateTime, d2) || this.e.cellStatus.mainCell == null || a2.mainCell != null) {
                this.e.cellStatus = a2;
            }
        } else {
            this.e.cellStatus = new CellStatus();
        }
        t();
    }

    private void a(FPS fps) {
        k();
        this.i = false;
        this.c.a(fps, this.d);
        this.d = false;
    }

    private boolean a(long j, long j2) {
        return j > 0 && Math.abs(SystemClock.elapsedRealtime() - j) <= j2;
    }

    private void a(WifiStatus wifiStatus) {
        wifiStatus.updateTime = -3600000L;
        wifiStatus.setWifiList(Collections.emptyList());
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(SignalStrength signalStrength) {
        CellStatus cellStatus = this.e.cellStatus;
        CellState cellState = cellStatus.mainCell;
        if (cellState != null) {
            int a2 = com.amap.location.e.d.e.a(signalStrength, this.n, cellState.type);
            if (a2 != 99) {
                cellStatus.mainCell.signalStrength = a2;
            }
            cellStatus.updateTime = SystemClock.elapsedRealtime();
        }
    }

    private void a(Looper looper) {
        this.m = new com.amap.location.e.d.a(looper, this.F);
        this.r = new a();
        this.s = new c();
        this.t = new d();
        b(looper);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(int i) {
        this.A.readLock().lock();
        try {
            if (this.u != null) {
                this.u.obtainMessage(i).sendToTarget();
            }
        } finally {
            this.A.readLock().unlock();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(int i, int i2) {
        this.A.readLock().lock();
        try {
            if (this.u != null) {
                this.u.obtainMessage(i, i2, 0).sendToTarget();
            }
        } finally {
            this.A.readLock().unlock();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(int i, int i2, int i3, Object obj) {
        this.A.readLock().lock();
        try {
            if (this.u != null) {
                this.u.obtainMessage(i, i2, i3, obj).sendToTarget();
            }
        } finally {
            this.A.readLock().unlock();
        }
    }
}
