package com.amap.location.g.b.a.a;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.GnssNavigationMessage;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/* compiled from: GnssNavigationMessageManager.java */
/* loaded from: classes.dex */
public class b extends GnssNavigationMessage.Callback {
    public com.amap.location.g.b.a.d.a b;
    public Context c;
    public final List<a> a = new CopyOnWriteArrayList();
    public C0024b d = new C0024b(this);

    /* compiled from: GnssNavigationMessageManager.java */
    /* renamed from: com.amap.location.g.b.a.a.b$b, reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public class C0024b extends BroadcastReceiver {
        public GnssNavigationMessage.Callback b;

        public C0024b(GnssNavigationMessage.Callback callback) {
            this.b = callback;
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            Bundle extras;
            if ((Build.VERSION.SDK_INT < 29 || (extras = intent.getExtras()) == null || "gps".equals(extras.getString("android.location.extra.PROVIDER_NAME"))) && com.amap.location.g.b.a.a(context).a("gps")) {
                synchronized (b.this.a) {
                    if (b.this.a.size() > 0) {
                        try {
                            b.this.b.b(this.b);
                            b.this.b.a(this.b);
                        } catch (SecurityException unused) {
                            com.amap.location.common.e.a.c("gnssnavigationmessage", "GpsProvidersChangedReceiver error");
                        }
                    }
                }
            }
        }
    }

    public b(com.amap.location.g.b.a.d.a aVar, Context context) {
        this.b = aVar;
        this.c = context;
    }

    @Override // android.location.GnssNavigationMessage.Callback
    public void onGnssNavigationMessageReceived(GnssNavigationMessage gnssNavigationMessage) {
        synchronized (this.a) {
            Iterator<a> it = this.a.iterator();
            while (it.hasNext()) {
                it.next().a(1, gnssNavigationMessage);
            }
        }
    }

    @Override // android.location.GnssNavigationMessage.Callback
    public void onStatusChanged(int i) {
        synchronized (this.a) {
            Iterator<a> it = this.a.iterator();
            while (it.hasNext()) {
                it.next().a(2, Integer.valueOf(i));
            }
        }
    }

    /* compiled from: GnssNavigationMessageManager.java */
    /* loaded from: classes.dex */
    public static class a {
        public GnssNavigationMessage.Callback a;
        public Handler b;

        /* compiled from: GnssNavigationMessageManager.java */
        /* renamed from: com.amap.location.g.b.a.a.b$a$a, reason: collision with other inner class name */
        /* loaded from: classes.dex */
        public static class HandlerC0023a extends Handler {
            public GnssNavigationMessage.Callback a;

            public HandlerC0023a(GnssNavigationMessage.Callback callback, Looper looper) {
                super(looper);
                this.a = callback;
            }

            @Override // android.os.Handler
            public void handleMessage(Message message) {
                int i = message.what;
                if (i == 1) {
                    this.a.onGnssNavigationMessageReceived((GnssNavigationMessage) message.obj);
                } else {
                    if (i != 2) {
                        return;
                    }
                    this.a.onStatusChanged(((Integer) message.obj).intValue());
                }
            }
        }

        public a(GnssNavigationMessage.Callback callback, Looper looper) {
            this.a = callback;
            this.b = new HandlerC0023a(this.a, looper == null ? Looper.getMainLooper() : looper);
        }

        public boolean a(GnssNavigationMessage.Callback callback, Looper looper) {
            if (looper == null) {
                looper = Looper.getMainLooper();
            }
            return this.a == callback && this.b.getLooper() == looper;
        }

        public void a(int i, Object obj) {
            Message obtainMessage = this.b.obtainMessage();
            obtainMessage.what = i;
            obtainMessage.obj = obj;
            obtainMessage.sendToTarget();
        }
    }

    private a b(GnssNavigationMessage.Callback callback) {
        for (a aVar : this.a) {
            if (aVar.a == callback) {
                return aVar;
            }
        }
        return null;
    }

    public boolean a(GnssNavigationMessage.Callback callback, Looper looper) {
        if (callback == null) {
            return false;
        }
        synchronized (this.a) {
            a b = b(callback);
            if (b != null) {
                return b.a(callback, looper);
            }
            a aVar = new a(callback, looper);
            this.a.add(aVar);
            if (this.a.size() != 1) {
                return true;
            }
            boolean a2 = this.b.a(this);
            if (!a2) {
                this.a.remove(aVar);
            } else {
                try {
                    this.c.registerReceiver(this.d, new IntentFilter("android.location.PROVIDERS_CHANGED"));
                } catch (Exception e) {
                    com.amap.location.common.e.a.a("gnssnavigationmessage", "", e);
                }
            }
            return a2;
        }
    }

    public void a(GnssNavigationMessage.Callback callback) {
        if (callback == null) {
            return;
        }
        synchronized (this.a) {
            a b = b(callback);
            if (b != null) {
                boolean remove = this.a.remove(b);
                if (this.a.size() == 0 && remove) {
                    this.b.b(this);
                    try {
                        this.c.unregisterReceiver(this.d);
                    } catch (Exception e) {
                        com.amap.location.common.e.a.a("gnssnavigationmessage", "", e);
                    }
                }
            }
        }
    }
}
