package com.amap.location.g.b.a.b;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.location.LocationListener;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/* compiled from: GpsLocationManager.java */
/* loaded from: classes.dex */
public class a {
    public C0025a a;
    public C0025a b;

    /* compiled from: GpsLocationManager.java */
    /* renamed from: com.amap.location.g.b.a.b.a$a, reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0025a implements LocationListener {
        public com.amap.location.g.b.a.d.a a;
        public String b;
        public Context c;
        public C0026a d = new C0026a(this);
        public final List<b> e = new ArrayList();
        public long f = Long.MAX_VALUE;
        public float g = Float.MAX_VALUE;
        public Location h;

        /* compiled from: GpsLocationManager.java */
        /* renamed from: com.amap.location.g.b.a.b.a$a$a, reason: collision with other inner class name */
        /* loaded from: classes.dex */
        public class C0026a extends BroadcastReceiver {
            public LocationListener b;

            public C0026a(LocationListener locationListener) {
                this.b = locationListener;
            }

            @Override // android.content.BroadcastReceiver
            public void onReceive(Context context, Intent intent) {
                Bundle extras;
                if ((Build.VERSION.SDK_INT < 29 || (extras = intent.getExtras()) == null || "gps".equals(extras.getString("android.location.extra.PROVIDER_NAME"))) && com.amap.location.g.b.a.a(context).a("gps")) {
                    synchronized (C0025a.this.e) {
                        if (C0025a.this.e.size() > 0) {
                            C0025a.this.a.a(this.b);
                            C0025a.this.a.a(C0025a.this.b, C0025a.this.f, C0025a.this.g, this.b, Looper.getMainLooper());
                        }
                    }
                }
            }
        }

        public C0025a(String str, com.amap.location.g.b.a.d.a aVar, Context context) {
            this.a = aVar;
            this.b = str;
            this.c = context;
        }

        @Override // android.location.LocationListener
        public void onLocationChanged(Location location) {
            if (location == null) {
                return;
            }
            float f = Float.MAX_VALUE;
            try {
                if (this.h != null) {
                    f = Math.abs(location.distanceTo(this.h));
                }
            } catch (Exception unused) {
                com.amap.location.common.e.a.c("gpsmager", "location distanceTo error");
            }
            synchronized (this.e) {
                Iterator<b> it = this.e.iterator();
                while (it.hasNext()) {
                    it.next().a(location, f);
                }
            }
            this.h = location;
        }

        @Override // android.location.LocationListener
        public void onProviderDisabled(String str) {
            synchronized (this.e) {
                Iterator<b> it = this.e.iterator();
                while (it.hasNext()) {
                    it.next().a(str, false);
                }
            }
        }

        @Override // android.location.LocationListener
        public void onProviderEnabled(String str) {
            synchronized (this.e) {
                Iterator<b> it = this.e.iterator();
                while (it.hasNext()) {
                    it.next().a(str, true);
                }
            }
        }

        @Override // android.location.LocationListener
        public void onStatusChanged(String str, int i, Bundle bundle) {
            synchronized (this.e) {
                Iterator<b> it = this.e.iterator();
                while (it.hasNext()) {
                    it.next().a(str, i, bundle);
                }
            }
        }

        public void a(long j, float f, LocationListener locationListener, Looper looper) {
            synchronized (this.e) {
                for (b bVar : this.e) {
                    if (bVar.a == locationListener) {
                        if (bVar.b != j || bVar.c != f) {
                            bVar.b = j;
                            bVar.c = f;
                            a();
                        }
                        return;
                    }
                }
                if (this.e.size() == 0) {
                    try {
                        this.c.registerReceiver(this.d, new IntentFilter("android.location.PROVIDERS_CHANGED"));
                    } catch (Exception e) {
                        com.amap.location.common.e.a.a(e);
                    }
                }
                this.e.add(new b(locationListener, j, f, looper));
                a();
            }
        }

        public void a(LocationListener locationListener) {
            synchronized (this.e) {
                boolean z = false;
                Iterator<b> it = this.e.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        break;
                    }
                    b next = it.next();
                    if (next.a == locationListener) {
                        this.e.remove(next);
                        a();
                        z = true;
                        break;
                    }
                }
                if (this.e.size() == 0 && z) {
                    try {
                        this.c.unregisterReceiver(this.d);
                    } catch (Exception e) {
                        com.amap.location.common.e.a.a(e);
                    }
                }
            }
        }

        private void a() {
            float f = Float.MAX_VALUE;
            long j = Long.MAX_VALUE;
            if (this.e.isEmpty()) {
                this.a.a(this);
                this.h = null;
                this.f = Long.MAX_VALUE;
                this.g = Float.MAX_VALUE;
                return;
            }
            for (b bVar : this.e) {
                j = Math.min(j, bVar.b);
                f = Math.min(f, bVar.c);
            }
            if (this.f == j && this.g == f) {
                return;
            }
            this.f = j;
            this.g = f;
            this.a.a(this);
            this.a.a(this.b, this.f, this.g, this, Looper.getMainLooper());
        }
    }

    public a(com.amap.location.g.b.a.d.a aVar, Context context) {
        this.a = new C0025a("gps", aVar, context);
        this.b = new C0025a("passive", aVar, context);
    }

    public void a(String str, long j, float f, LocationListener locationListener, Looper looper) {
        if (locationListener == null) {
            return;
        }
        C0025a c0025a = null;
        if ("gps".equals(str)) {
            c0025a = this.a;
        } else if ("passive".equals(str)) {
            c0025a = this.b;
        }
        C0025a c0025a2 = c0025a;
        if (c0025a2 != null) {
            c0025a2.a(j, f, locationListener, looper);
        }
    }

    public void a(LocationListener locationListener) {
        if (locationListener == null) {
            return;
        }
        this.a.a(locationListener);
        this.b.a(locationListener);
    }

    public LocationListener a() {
        return this.a;
    }
}
