package com.amap.location.g.b.a.d;

import android.content.Context;
import android.location.GnssMeasurementsEvent;
import android.location.GnssNavigationMessage;
import android.location.GnssStatus;
import android.location.GpsStatus;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.OnNmeaMessageListener;
import android.os.Build;
import android.os.Looper;
import java.util.List;

/* compiled from: SystemGpsProvider.java */
/* loaded from: classes.dex */
public class b implements a {
    public LocationManager a;
    public volatile boolean b = false;

    public b(Context context) {
        this.a = (LocationManager) context.getSystemService("location");
    }

    @Override // com.amap.location.g.b.a.d.a
    public void a(String str, long j, float f, LocationListener locationListener, Looper looper) {
        try {
            if (this.a != null) {
                this.a.requestLocationUpdates(str, j, f, locationListener, looper);
                this.b = true;
            }
        } catch (SecurityException unused) {
            com.amap.location.common.e.a.c("sysgps", "req gps error");
        } catch (Exception e) {
            com.amap.location.common.e.a.c("sysgps", "req gps error: " + e.toString());
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public void b(GnssStatus.Callback callback) {
        LocationManager locationManager = this.a;
        if (locationManager == null || Build.VERSION.SDK_INT < 24) {
            return;
        }
        locationManager.unregisterGnssStatusCallback(callback);
    }

    @Override // com.amap.location.g.b.a.d.a
    public void b(GpsStatus.Listener listener) {
        LocationManager locationManager = this.a;
        if (locationManager != null) {
            locationManager.removeGpsStatusListener(listener);
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public void a(LocationListener locationListener) {
        LocationManager locationManager = this.a;
        if (locationManager != null) {
            try {
                locationManager.removeUpdates(locationListener);
                this.b = false;
            } catch (Exception unused) {
                com.amap.location.common.e.a.c("sysgps", "remove gps error");
            }
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public boolean b() {
        return this.b;
    }

    @Override // com.amap.location.g.b.a.d.a
    public void b(GnssMeasurementsEvent.Callback callback) {
        LocationManager locationManager = this.a;
        if (locationManager == null || Build.VERSION.SDK_INT < 24) {
            return;
        }
        locationManager.unregisterGnssMeasurementsCallback(callback);
    }

    @Override // com.amap.location.g.b.a.d.a
    public boolean a(GpsStatus.NmeaListener nmeaListener, Looper looper) {
        LocationManager locationManager = this.a;
        if (locationManager == null) {
            return false;
        }
        try {
            return locationManager.addNmeaListener(nmeaListener);
        } catch (SecurityException unused) {
            com.amap.location.common.e.a.c("sysgps", "addNmeaListener error");
            return false;
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public void b(GnssNavigationMessage.Callback callback) {
        LocationManager locationManager = this.a;
        if (locationManager == null || Build.VERSION.SDK_INT < 24) {
            return;
        }
        locationManager.unregisterGnssNavigationMessageCallback(callback);
    }

    @Override // com.amap.location.g.b.a.d.a
    public void a(GpsStatus.NmeaListener nmeaListener) {
        LocationManager locationManager = this.a;
        if (locationManager != null) {
            locationManager.removeNmeaListener(nmeaListener);
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public boolean a(OnNmeaMessageListener onNmeaMessageListener, Looper looper) {
        LocationManager locationManager = this.a;
        if (locationManager == null) {
            return false;
        }
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                return locationManager.addNmeaListener(onNmeaMessageListener);
            }
            return false;
        } catch (SecurityException unused) {
            com.amap.location.common.e.a.c("sysgps", "rm nmea error");
            return false;
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public void a(OnNmeaMessageListener onNmeaMessageListener) {
        LocationManager locationManager;
        if (Build.VERSION.SDK_INT < 24 || (locationManager = this.a) == null) {
            return;
        }
        locationManager.removeNmeaListener(onNmeaMessageListener);
    }

    @Override // com.amap.location.g.b.a.d.a
    public boolean a(GnssStatus.Callback callback) {
        LocationManager locationManager = this.a;
        if (locationManager != null && Build.VERSION.SDK_INT >= 24) {
            try {
                return locationManager.registerGnssStatusCallback(callback);
            } catch (SecurityException unused) {
                com.amap.location.common.e.a.c("sysgps", "regist gnss callback error");
            }
        }
        return false;
    }

    @Override // com.amap.location.g.b.a.d.a
    public boolean a(GpsStatus.Listener listener) {
        LocationManager locationManager = this.a;
        if (locationManager == null) {
            return false;
        }
        try {
            return locationManager.addGpsStatusListener(listener);
        } catch (SecurityException unused) {
            com.amap.location.common.e.a.c("sysgps", "add gps status error");
            return false;
        } catch (Exception e) {
            com.amap.location.common.e.a.a("sysgps", "", e);
            return false;
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public boolean a(String str) {
        LocationManager locationManager = this.a;
        if (locationManager == null) {
            return false;
        }
        try {
            return locationManager.isProviderEnabled(str);
        } catch (Exception e) {
            com.amap.location.common.e.a.a("sysgps", "", e);
            return false;
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public GpsStatus a(GpsStatus gpsStatus) {
        LocationManager locationManager = this.a;
        if (locationManager == null) {
            return null;
        }
        try {
            return locationManager.getGpsStatus(gpsStatus);
        } catch (SecurityException unused) {
            com.amap.location.common.e.a.c("sysgps", "getGpsStatus error");
            return null;
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public List<String> a() {
        LocationManager locationManager = this.a;
        if (locationManager == null) {
            return null;
        }
        return locationManager.getAllProviders();
    }

    @Override // com.amap.location.g.b.a.d.a
    public boolean a(GnssMeasurementsEvent.Callback callback) {
        LocationManager locationManager = this.a;
        if (locationManager == null) {
            return false;
        }
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                return locationManager.registerGnssMeasurementsCallback(callback);
            }
            return false;
        } catch (SecurityException unused) {
            com.amap.location.common.e.a.c("sysgps", "rm gnssMeasurement error");
            return false;
        }
    }

    @Override // com.amap.location.g.b.a.d.a
    public boolean a(GnssNavigationMessage.Callback callback) {
        LocationManager locationManager = this.a;
        if (locationManager == null) {
            return false;
        }
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                return locationManager.registerGnssNavigationMessageCallback(callback);
            }
            return false;
        } catch (SecurityException unused) {
            com.amap.location.common.e.a.c("sysgps", "rm gnssNavigationMessage error");
            return false;
        }
    }
}
