package com.amap.location.g.b.a.e;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.GnssStatus;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/* compiled from: GnssStatusManager.java */
/* loaded from: classes.dex */
public class a extends GnssStatus.Callback {
    public com.amap.location.g.b.a.d.a b;
    public Context c;
    public final List<C0029a> a = new CopyOnWriteArrayList();
    public b d = new b(this);

    /* compiled from: GnssStatusManager.java */
    /* loaded from: classes.dex */
    public class b extends BroadcastReceiver {
        public GnssStatus.Callback b;

        public b(GnssStatus.Callback callback) {
            this.b = callback;
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            Bundle extras;
            if ((Build.VERSION.SDK_INT < 29 || (extras = intent.getExtras()) == null || "gps".equals(extras.getString("android.location.extra.PROVIDER_NAME"))) && com.amap.location.g.b.a.a(context).a("gps")) {
                synchronized (a.this.a) {
                    if (a.this.a.size() > 0) {
                        try {
                            a.this.b.b(this.b);
                            a.this.b.a(this.b);
                        } catch (SecurityException unused) {
                            com.amap.location.common.e.a.c("gnstmgr", "GpsProvidersChangedReceiver error");
                        }
                    }
                }
            }
        }
    }

    public a(com.amap.location.g.b.a.d.a aVar, Context context) {
        this.b = aVar;
        this.c = context;
    }

    @Override // android.location.GnssStatus.Callback
    public void onFirstFix(int i) {
        synchronized (this.a) {
            Iterator<C0029a> it = this.a.iterator();
            while (it.hasNext()) {
                it.next().a(3, Integer.valueOf(i));
            }
        }
    }

    @Override // android.location.GnssStatus.Callback
    public void onSatelliteStatusChanged(GnssStatus gnssStatus) {
        synchronized (this.a) {
            Iterator<C0029a> it = this.a.iterator();
            while (it.hasNext()) {
                it.next().a(4, gnssStatus);
            }
        }
    }

    @Override // android.location.GnssStatus.Callback
    public void onStarted() {
        synchronized (this.a) {
            Iterator<C0029a> it = this.a.iterator();
            while (it.hasNext()) {
                it.next().a(1, (Object) null);
            }
        }
    }

    @Override // android.location.GnssStatus.Callback
    public void onStopped() {
        synchronized (this.a) {
            Iterator<C0029a> it = this.a.iterator();
            while (it.hasNext()) {
                it.next().a(2, (Object) null);
            }
        }
    }

    /* compiled from: GnssStatusManager.java */
    /* renamed from: com.amap.location.g.b.a.e.a$a, reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0029a {
        public GnssStatus.Callback a;
        public Handler b;

        /* compiled from: GnssStatusManager.java */
        /* renamed from: com.amap.location.g.b.a.e.a$a$a, reason: collision with other inner class name */
        /* loaded from: classes.dex */
        public static class HandlerC0030a extends Handler {
            public GnssStatus.Callback a;

            public HandlerC0030a(GnssStatus.Callback callback, Looper looper) {
                super(looper);
                this.a = callback;
            }

            @Override // android.os.Handler
            public void handleMessage(Message message) {
                int i = message.what;
                if (i == 1) {
                    this.a.onStarted();
                    return;
                }
                if (i == 2) {
                    this.a.onStopped();
                } else if (i == 3) {
                    this.a.onFirstFix(((Integer) message.obj).intValue());
                } else {
                    if (i != 4) {
                        return;
                    }
                    this.a.onSatelliteStatusChanged((GnssStatus) message.obj);
                }
            }
        }

        public C0029a(GnssStatus.Callback callback, Looper looper) {
            this.a = callback;
            this.b = new HandlerC0030a(this.a, looper == null ? Looper.getMainLooper() : looper);
        }

        public boolean a(GnssStatus.Callback callback, Looper looper) {
            if (looper == null) {
                looper = Looper.getMainLooper();
            }
            return this.a == callback && this.b.getLooper() == looper;
        }

        public void a(int i, Object obj) {
            Message obtainMessage = this.b.obtainMessage();
            obtainMessage.what = i;
            obtainMessage.obj = obj;
            obtainMessage.sendToTarget();
        }
    }

    private C0029a b(GnssStatus.Callback callback) {
        for (C0029a c0029a : this.a) {
            if (c0029a.a == callback) {
                return c0029a;
            }
        }
        return null;
    }

    public boolean a(GnssStatus.Callback callback, Looper looper) {
        if (callback == null) {
            return false;
        }
        synchronized (this.a) {
            C0029a b2 = b(callback);
            if (b2 != null) {
                return b2.a(callback, looper);
            }
            C0029a c0029a = new C0029a(callback, looper);
            this.a.add(c0029a);
            if (this.a.size() != 1) {
                return true;
            }
            boolean a = this.b.a(this);
            if (!a) {
                this.a.remove(c0029a);
            } else {
                try {
                    this.c.registerReceiver(this.d, new IntentFilter("android.location.PROVIDERS_CHANGED"));
                } catch (Exception e) {
                    com.amap.location.common.e.a.a("gnstmgr", "", e);
                }
            }
            return a;
        }
    }

    public void a(GnssStatus.Callback callback) {
        if (callback == null) {
            return;
        }
        synchronized (this.a) {
            C0029a b2 = b(callback);
            if (b2 != null) {
                boolean remove = this.a.remove(b2);
                if (this.a.size() == 0 && remove) {
                    this.b.b(this);
                    try {
                        this.c.unregisterReceiver(this.d);
                    } catch (Exception e) {
                        com.amap.location.common.e.a.a("gnstmgr", "", e);
                    }
                }
            }
        }
    }
}
