package com.amap.location.icecream;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.GnssStatus;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.OnNmeaMessageListener;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.os.Looper;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import com.amap.location.icecream.interfaces.IIcecreamBaseLib;
import com.amap.location.security.Core;
import com.amap.location.uptunnel.UpTunnel;
import defpackage.al0;
import defpackage.pk0;
import defpackage.wk0;
import defpackage.zk0;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

/* compiled from: IcecreamBaseLibImpl.java */
/* loaded from: classes.dex */
public class a implements IIcecreamBaseLib {
    public static IIcecreamBaseLib.ICommon a;
    public static IIcecreamBaseLib.IUptunnel b;
    public static IIcecreamBaseLib.ICore c;
    public static IIcecreamBaseLib.ISignal d;
    public static IIcecreamBaseLib.INetWork e;
    public static IIcecreamBaseLib.IAmapBroadcastDispatcher f;
    public static IIcecreamBaseLib.IAmapLocationDispatcher g;
    public static IIcecreamBaseLib.IAmapParamDispatcher h;
    public static Context i;
    public static volatile a j;

    /* compiled from: IcecreamBaseLibImpl.java */
    /* renamed from: com.amap.location.icecream.a$a, reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0036a implements IIcecreamBaseLib.IAmapBroadcastDispatcher {
        public List<IIcecreamBaseLib.IAmapBroadcastListener> a;

        public C0036a() {
            this.a = new ArrayList();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapBroadcastDispatcher
        public void addListener(IIcecreamBaseLib.IAmapBroadcastListener iAmapBroadcastListener) {
            if (iAmapBroadcastListener == null) {
                return;
            }
            synchronized (this.a) {
                this.a.add(iAmapBroadcastListener);
            }
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapBroadcastDispatcher
        public int getListenerCountByAction(int i) {
            int i2;
            synchronized (this.a) {
                i2 = 0;
                for (IIcecreamBaseLib.IAmapBroadcastListener iAmapBroadcastListener : this.a) {
                    if (iAmapBroadcastListener != null && iAmapBroadcastListener.getAction() == i) {
                        i2++;
                    }
                }
            }
            return i2;
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapBroadcastDispatcher
        public void handleMessage(int i, long j, long j2, Object obj) {
            synchronized (this.a) {
                for (IIcecreamBaseLib.IAmapBroadcastListener iAmapBroadcastListener : this.a) {
                    if (iAmapBroadcastListener != null && iAmapBroadcastListener.getAction() == i) {
                        iAmapBroadcastListener.handleMessage(i, j, j2, obj);
                    }
                }
            }
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapBroadcastDispatcher
        public void removeListener(IIcecreamBaseLib.IAmapBroadcastListener iAmapBroadcastListener) {
            if (iAmapBroadcastListener == null) {
                return;
            }
            synchronized (this.a) {
                this.a.remove(iAmapBroadcastListener);
            }
        }
    }

    /* compiled from: IcecreamBaseLibImpl.java */
    /* loaded from: classes.dex */
    public static class b implements IIcecreamBaseLib.IAmapLocationDispatcher {
        public List<LocationListener> a;

        public b() {
            this.a = new ArrayList();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapLocationDispatcher
        public void addLocationListener(LocationListener locationListener) {
            if (locationListener == null) {
                return;
            }
            synchronized (this.a) {
                this.a.add(locationListener);
            }
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapLocationDispatcher
        public void onLocationChanged(Location location) {
            synchronized (this.a) {
                Iterator<LocationListener> it = this.a.iterator();
                while (it.hasNext()) {
                    it.next().onLocationChanged(location);
                }
            }
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapLocationDispatcher
        public void removeLocationListener(LocationListener locationListener) {
            if (locationListener == null) {
                return;
            }
            synchronized (this.a) {
                this.a.remove(locationListener);
            }
        }
    }

    /* compiled from: IcecreamBaseLibImpl.java */
    /* loaded from: classes.dex */
    public static class c implements IIcecreamBaseLib.IAmapParamDispatcher {
        public List<IIcecreamBaseLib.IAmapParamListener> a;

        public c() {
            this.a = new ArrayList();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapParamDispatcher
        public void addParamListener(IIcecreamBaseLib.IAmapParamListener iAmapParamListener) {
            if (iAmapParamListener == null) {
                return;
            }
            synchronized (this.a) {
                this.a.add(iAmapParamListener);
            }
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapParamDispatcher
        public void onParamChanged(String str) {
            synchronized (this.a) {
                Iterator<IIcecreamBaseLib.IAmapParamListener> it = this.a.iterator();
                while (it.hasNext()) {
                    it.next().onParamChanged(str);
                }
            }
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IAmapParamDispatcher
        public void removeParamListener(IIcecreamBaseLib.IAmapParamListener iAmapParamListener) {
            if (iAmapParamListener == null) {
                return;
            }
            synchronized (this.a) {
                this.a.remove(iAmapParamListener);
            }
        }
    }

    /* compiled from: IcecreamBaseLibImpl.java */
    /* loaded from: classes.dex */
    public static class d implements IIcecreamBaseLib.ICommon {
        public d() {
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public void e(String str, String str2) {
            com.amap.location.common.e.a.a(str, str2);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public String getAdiu(Context context) {
            return com.amap.location.common.a.b();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public String getImei(Context context) {
            return com.amap.location.common.a.a(context);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public String getManufacturer() {
            return com.amap.location.common.a.d();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public String getModel() {
            return com.amap.location.common.a.c();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public String getTid(Context context) {
            return com.amap.location.common.a.b(context);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public void i(String str, String str2) {
            com.amap.location.common.e.a.a(str, str2);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public String logEncode(String str) {
            return com.amap.location.common.e.a.a(str);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public String longToMac(long j) {
            return com.amap.location.common.f.j.a(j);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public long macToLong(String str) {
            return com.amap.location.common.f.j.a(str);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public void trace(String str, String str2) {
            com.amap.location.common.e.a.b(str, str2);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public void e(String str, String str2, boolean z) {
            com.amap.location.common.e.a.a(str, str2);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICommon
        public void i(String str, String str2, boolean z) {
            com.amap.location.common.e.a.a(str, str2);
        }
    }

    /* compiled from: IcecreamBaseLibImpl.java */
    /* loaded from: classes.dex */
    public static class e implements IIcecreamBaseLib.ICore {
        public e() {
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICore
        public String saos(String str, String str2, String str3) {
            return Core.saos(str, str2, str3);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ICore
        public byte[] xxt(byte[] bArr, int i) {
            return Core.xxt(bArr, i);
        }
    }

    /* compiled from: IcecreamBaseLibImpl.java */
    /* loaded from: classes.dex */
    public static class f implements IIcecreamBaseLib.INetWork {
        public f() {
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.INetWork
        public byte[] doHttpGet(String str, HashMap<String, String> hashMap) {
            try {
                pk0 pk0Var = new pk0();
                wk0 wk0Var = new wk0();
                wk0Var.setUrl(str);
                if (hashMap != null) {
                    for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                        if (entry != null && entry.getKey() != null) {
                            wk0Var.addHeader(entry.getKey(), entry.getValue());
                        }
                    }
                }
                al0 al0Var = (al0) pk0Var.a(wk0Var, al0.class);
                if (al0Var != null) {
                    return al0Var.getResponseBodyData();
                }
            } catch (Throwable unused) {
            }
            return null;
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.INetWork
        public byte[] doHttpPost(String str, HashMap<String, String> hashMap, byte[] bArr) {
            try {
                pk0 pk0Var = new pk0();
                zk0 zk0Var = new zk0();
                zk0Var.setUrl(str);
                if (hashMap != null) {
                    for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                        if (entry != null && entry.getKey() != null) {
                            zk0Var.addHeader(entry.getKey(), entry.getValue());
                        }
                    }
                }
                zk0Var.setBody(bArr);
                al0 al0Var = (al0) pk0Var.a(zk0Var, al0.class);
                if (al0Var != null) {
                    return al0Var.getResponseBodyData();
                }
            } catch (Throwable unused) {
            }
            return null;
        }
    }

    /* compiled from: IcecreamBaseLibImpl.java */
    /* loaded from: classes.dex */
    public static class g implements IIcecreamBaseLib.ISignal {
        public g() {
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        @SuppressLint({"MissingPermission"})
        public boolean addGpsStatusListener(GpsStatus.Listener listener, Looper looper) {
            return com.amap.location.g.b.a.a(a.i).a(listener, looper);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        @SuppressLint({"MissingPermission"})
        public boolean addNmeaListener(GpsStatus.NmeaListener nmeaListener, Looper looper) {
            return false;
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public boolean addNmeaListener(OnNmeaMessageListener onNmeaMessageListener) {
            Context context = a.i;
            if (context == null) {
                return false;
            }
            try {
                return ((LocationManager) context.getSystemService("location")).addNmeaListener(onNmeaMessageListener);
            } catch (SecurityException unused) {
                return false;
            }
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public boolean enableWifiAlwaysScan(Context context) {
            return com.amap.location.g.d.a.a(a.i).b(context);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        @SuppressLint({"MissingPermission"})
        public List<CellInfo> getAllCellInfo() {
            return com.amap.location.g.a.a.a(a.i).b();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public List<String> getAllProviders() {
            return com.amap.location.g.b.a.a(a.i).a();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        @SuppressLint({"MissingPermission"})
        public CellLocation getCellLocation() {
            return com.amap.location.g.a.a.a(a.i).a();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public WifiInfo getConnectionInfo() {
            return com.amap.location.g.d.a.a(a.i).c();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public GpsStatus getGpsStatus(GpsStatus gpsStatus) {
            return com.amap.location.g.b.a.a(a.i).a(gpsStatus);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        @SuppressLint({"MissingPermission"})
        public List<NeighboringCellInfo> getNeighboringCellInfo() {
            return com.amap.location.g.a.a.a(a.i).f();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public String getNetworkOperator() {
            return com.amap.location.g.a.a.a(a.i).e();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public int getNetworkType() {
            return com.amap.location.g.a.a.a(a.i).c();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public int getPhoneType() {
            return com.amap.location.g.a.a.a(a.i).d();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public List<ScanResult> getScanResults() {
            return com.amap.location.g.d.a.a(a.i).b();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public int getWifiState() {
            return com.amap.location.g.d.a.a(a.i).e();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public boolean isProviderEnabled(String str) {
            return com.amap.location.g.b.a.a(a.i).a(str);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public boolean isScanAlwaysAvailable() {
            return com.amap.location.g.d.a.a(a.i).d();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public boolean isWifiEnabled() {
            return com.amap.location.g.d.a.a(a.i).g();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public void listen(PhoneStateListener phoneStateListener, int i, long j, Looper looper) {
            com.amap.location.g.a.a.a(a.i).a(phoneStateListener, i, j, looper);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        @SuppressLint({"MissingPermission"})
        public boolean registerGnssStatusCallback(GnssStatus.Callback callback, Looper looper) {
            return com.amap.location.g.b.a.a(a.i).a(callback, looper);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public void removeGpsStatusListener(GpsStatus.Listener listener) {
            com.amap.location.g.b.a.a(a.i).a(listener);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public void removeNmeaListener(GpsStatus.NmeaListener nmeaListener) {
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public void removeNmeaListener(OnNmeaMessageListener onNmeaMessageListener) {
            Context context = a.i;
            if (context != null) {
                ((LocationManager) context.getSystemService("location")).removeNmeaListener(onNmeaMessageListener);
            }
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public void removeUpdates(LocationListener locationListener) {
            com.amap.location.g.b.a.a(a.i).a(locationListener);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        @SuppressLint({"MissingPermission"})
        public void requestLocationUpdates(String str, long j, float f, LocationListener locationListener, Looper looper) {
            com.amap.location.g.b.a.a(a.i).a(str, j, f, locationListener, looper);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public boolean startScan() {
            return com.amap.location.g.d.a.a(a.i).a();
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.ISignal
        public void unregisterGnssStatusCallback(GnssStatus.Callback callback) {
            com.amap.location.g.b.a.a(a.i).a(callback);
        }
    }

    /* compiled from: IcecreamBaseLibImpl.java */
    /* loaded from: classes.dex */
    public static class h implements IIcecreamBaseLib.IUptunnel {
        public h() {
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IUptunnel
        public void addCount(int i) {
            UpTunnel.addCount(i);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IUptunnel
        public void execCMD(JSONObject jSONObject) {
            UpTunnel.execCMD(jSONObject);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IUptunnel
        public long getTableSize(int i) {
            return UpTunnel.getTableSize(i);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IUptunnel
        public void reportBlockData(int i, byte[] bArr) {
            UpTunnel.reportBlockData(i, bArr);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IUptunnel
        public void reportEvent(int i, byte[] bArr) {
            UpTunnel.reportEvent(i, bArr);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IUptunnel
        public void reportKeyLog(int i, byte[] bArr) {
            UpTunnel.reportKeyLog(i, bArr);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IUptunnel
        public void reportLog(int i, String str) {
            UpTunnel.reportLog(i, str);
        }

        @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib.IUptunnel
        public void execCMD(JSONArray jSONArray) {
            UpTunnel.execCMD(jSONArray);
        }
    }

    public a(Context context) {
        i = context;
        a = new d();
        b = new h();
        c = new e();
        d = new g();
        e = new f();
        f = new C0036a();
        g = new b();
        h = new c();
    }

    public static a a(Context context) {
        if (j == null) {
            synchronized (a.class) {
                if (j == null) {
                    j = new a(context);
                }
            }
        }
        return j;
    }

    @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib
    public IIcecreamBaseLib.IAmapBroadcastDispatcher getAmapBroadcastInstance() {
        return f;
    }

    @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib
    public IIcecreamBaseLib.IAmapLocationDispatcher getAmapLocationInstance() {
        return g;
    }

    @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib
    public IIcecreamBaseLib.IAmapParamDispatcher getAmapParamInstance() {
        return h;
    }

    @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib
    public IIcecreamBaseLib.ICommon getCommonInstance() {
        return a;
    }

    @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib
    public IIcecreamBaseLib.ICore getCoreInstance() {
        return c;
    }

    @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib
    public IIcecreamBaseLib.INetWork getNetWorkInstance() {
        return e;
    }

    @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib
    public IIcecreamBaseLib.ISignal getSignalInstance() {
        return d;
    }

    @Override // com.amap.location.icecream.interfaces.IIcecreamBaseLib
    public IIcecreamBaseLib.IUptunnel getUptunnelInstance() {
        return b;
    }
}
