package com.amap.location.offline.b;

import android.content.Context;
import com.amap.location.common.model.AmapLoc;
import com.amap.location.common.model.CellState;
import com.amap.location.common.model.CellStatus;
import com.amap.location.common.model.FPS;
import com.amap.location.common.model.WiFi;
import com.amap.location.common.model.WifiStatus;
import com.amap.location.offline.b.b.d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/* compiled from: OfflineCore.java */
/* loaded from: classes.dex */
public class a {
    public static int c;
    public Context a;
    public com.amap.location.offline.c b;
    public com.amap.location.offline.b.c.a d;
    public C0038a e = new C0038a();
    public int f = 0;
    public com.amap.location.offline.a g;

    /* compiled from: OfflineCore.java */
    /* renamed from: com.amap.location.offline.b.a$a, reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0038a implements Comparator<WiFi> {
        public C0038a() {
        }

        @Override // java.util.Comparator
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public int compare(WiFi wiFi, WiFi wiFi2) {
            return defpackage.a.a(wiFi2.rssi, wiFi.rssi);
        }
    }

    public a(Context context, com.amap.location.offline.c cVar, com.amap.location.offline.a aVar) {
        this.a = context;
        this.b = cVar;
        this.g = aVar;
        this.d = new com.amap.location.offline.b.c.a(context, cVar, aVar);
    }

    public void a() {
        this.d.a();
    }

    public void b() {
        this.d.b();
    }

    public void a(com.amap.location.offline.c cVar) {
        this.d.a(cVar);
    }

    public AmapLoc a(FPS fps, int i, boolean z) {
        try {
            com.amap.location.offline.b.a.a a = a(fps.cellStatus);
            com.amap.location.offline.b.a.c a2 = a(fps.wifiStatus);
            AmapLoc a3 = !z ? b.a(a, a2, i) : null;
            com.amap.location.common.e.a.b("offcore", "locoff:" + com.amap.location.common.e.a.a(a(fps, a3, a2, a, i, z)));
            c.a(this.a, a);
            c.a(this.a, a2);
            com.amap.location.offline.c.a.a().a(this.a, a);
            boolean z2 = true;
            int i2 = this.f + 1;
            this.f = i2;
            if (i2 > 20) {
                d.a(this.a).b();
                this.f = 0;
            }
            if (i <= 0) {
                z2 = false;
            }
            return a(z2, a3);
        } catch (Throwable th) {
            com.amap.location.common.e.a.a(th);
            return null;
        }
    }

    public void a(FPS fps, AmapLoc amapLoc, String str) {
        if (amapLoc == null || this.g == null || amapLoc.getAccuracy() > this.g.m()) {
            return;
        }
        c.a(this.a, this.b, a(fps.cellStatus), a(fps.wifiStatus), amapLoc, str);
    }

    private com.amap.location.offline.b.a.a a(CellStatus cellStatus) {
        String a = com.amap.location.offline.e.a.a(cellStatus);
        return d.a(this.a).a(a, com.amap.location.offline.e.a.a(a));
    }

    private com.amap.location.offline.b.a.c a(WifiStatus wifiStatus) {
        com.amap.location.offline.b.a.c cVar = new com.amap.location.offline.b.a.c();
        d.a(this.a).a(a(wifiStatus, cVar), cVar);
        return cVar;
    }

    private String a(WifiStatus wifiStatus, com.amap.location.offline.b.a.c cVar) {
        StringBuilder sb = new StringBuilder();
        if (wifiStatus != null && wifiStatus.numWiFis() > 0) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            for (WiFi wiFi : wifiStatus.getWifiList()) {
                int currentTimeMillis = (int) ((System.currentTimeMillis() - wiFi.lastUpdateUtcMills) / 1000);
                if (currentTimeMillis < com.amap.location.offline.d.a().g()) {
                    arrayList.add(wiFi);
                }
                arrayList2.add(Integer.valueOf(currentTimeMillis));
            }
            String str = "wifi age:" + arrayList2.toString();
            boolean z = true;
            if (c < 5 && arrayList2.size() > 0) {
                c++;
                com.amap.location.offline.d.a.a(100233, str.getBytes());
            }
            Collections.sort(arrayList, this.e);
            int min = Math.min(arrayList.size(), 30);
            cVar.a = min;
            for (int i = 0; i < min; i++) {
                WiFi wiFi2 = (WiFi) arrayList.get(i);
                long a = com.amap.location.offline.e.a.a(wiFi2.mac);
                if (a != -1) {
                    if (z) {
                        z = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(a);
                    com.amap.location.offline.b.a.b bVar = new com.amap.location.offline.b.a.b();
                    bVar.a = a;
                    bVar.b = wiFi2.mac;
                    bVar.c = wiFi2.rssi;
                    cVar.b.put(Long.valueOf(a), bVar);
                }
            }
        }
        return sb.toString();
    }

    private AmapLoc a(boolean z, AmapLoc amapLoc) {
        if (amapLoc == null) {
            return null;
        }
        if (z && AmapLoc.TYPE_OFFLINE_CELL.equals(amapLoc.getType())) {
            com.amap.location.offline.d.a.a(100507);
            return null;
        }
        if (z) {
            com.amap.location.offline.d.a.a(100035);
        } else {
            com.amap.location.offline.d.a.a(100036);
        }
        return amapLoc;
    }

    private String a(FPS fps, AmapLoc amapLoc, com.amap.location.offline.b.a.c cVar, com.amap.location.offline.b.a.a aVar, int i, boolean z) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(System.currentTimeMillis());
            sb.append(";");
            sb.append(i);
            sb.append(";");
            sb.append(z);
            sb.append(";");
            sb.append("{");
            if (fps.cellStatus.cellStateList2 != null) {
                for (CellState cellState : fps.cellStatus.cellStateList2) {
                    if (cellState.registered) {
                        sb.append(cellState.toString());
                    }
                }
            }
            sb.append("};");
            sb.append(com.amap.location.offline.e.b.a(amapLoc));
            sb.append(";");
            sb.append(cVar.b.toString());
            sb.append(";");
            sb.append(aVar.toString());
            return sb.toString();
        } catch (Exception e) {
            com.amap.location.common.e.a.a(e);
            return "";
        }
    }
}
