package com.amap.location.offline.e;

import android.text.TextUtils;
import com.amap.location.common.f.j;
import com.amap.location.common.model.CellState;
import com.amap.location.common.model.CellStatus;
import com.amap.location.offline.d;
import com.amap.location.security.Core;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/* compiled from: EncryptUtil.java */
/* loaded from: classes.dex */
public class a {
    public static int a;
    public static C0041a b = new C0041a();

    /* compiled from: EncryptUtil.java */
    /* renamed from: com.amap.location.offline.e.a$a, reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0041a implements Comparator<CellState> {
        public C0041a() {
        }

        @Override // java.util.Comparator
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public int compare(CellState cellState, CellState cellState2) {
            int i = (cellState2.lastUpdateUtcMills > cellState.lastUpdateUtcMills ? 1 : (cellState2.lastUpdateUtcMills == cellState.lastUpdateUtcMills ? 0 : -1));
            if (i == 0) {
                i = defpackage.a.a(a.c(cellState2.signalStrength), a.c(cellState.signalStrength));
            }
            return i == 0 ? defpackage.a.a(a.d(cellState2.type), a.d(cellState.type)) : i;
        }
    }

    public static int c(int i) {
        if (i == 99) {
            return -999;
        }
        return i;
    }

    public static int d(int i) {
        if (i == 1) {
            return 2;
        }
        if (i == 2) {
            return 1;
        }
        if (i == 3) {
            return 4;
        }
        if (i != 4) {
            return i;
        }
        return 3;
    }

    public static String a(CellStatus cellStatus) {
        if (cellStatus == null) {
            return "";
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (CellState cellState : cellStatus.cellStateList2) {
            if (cellState.registered && cellState.type != 6) {
                int currentTimeMillis = (int) ((System.currentTimeMillis() - cellState.lastUpdateUtcMills) / 1000);
                if (currentTimeMillis < d.a().f() && a(cellState)) {
                    arrayList.add(cellState);
                }
                arrayList2.add(Integer.valueOf(currentTimeMillis));
            }
        }
        String str = "cell age:" + arrayList2.toString();
        if (a < 5 && arrayList2.size() > 0) {
            a++;
            com.amap.location.offline.d.a.a(100233, str.getBytes());
        }
        CellState cellState2 = null;
        if (arrayList.size() > 0) {
            Collections.sort(arrayList, b);
            cellState2 = (CellState) arrayList.get(0);
        }
        if (cellState2 == null) {
            return "";
        }
        if (cellState2.type == 2 && j.a(cellState2.sid, cellState2.nid, cellState2.bid)) {
            return cellState2.sid + ":" + cellState2.nid + ":" + cellState2.bid;
        }
        if (cellState2.type == 0 || !j.a(cellState2.mcc, cellState2.mnc, cellState2.lac, cellState2.cid)) {
            return "";
        }
        return cellState2.mcc + ":" + cellState2.mnc + ":" + cellState2.lac + ":" + cellState2.cid;
    }

    public static boolean a(CellState cellState) {
        if (cellState == null) {
            return false;
        }
        if (cellState.type == 2 && j.a(cellState.sid, cellState.nid, cellState.bid)) {
            return true;
        }
        return cellState.type != 0 && j.a(cellState.mcc, cellState.mnc, cellState.lac, cellState.cid);
    }

    public static long a(String str) {
        if (!TextUtils.isEmpty(str)) {
            try {
                return Core.encMac(str);
            } catch (Throwable th) {
                com.amap.location.common.e.a.a(th);
            }
        }
        return -1L;
    }

    public static long a(long j) {
        try {
            return Core.encMac(j.a(j));
        } catch (Throwable th) {
            com.amap.location.common.e.a.a(th);
            return -1L;
        }
    }
}
