package com.amap.location.protocol.e;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import com.alibaba.wireless.security.SecExceptionCode;
import com.amap.location.common.f.j;
import com.amap.location.common.model.AmapLoc;
import com.amap.location.common.model.CellState;
import com.amap.location.common.model.CellStatus;
import com.amap.location.common.model.FPS;
import com.amap.location.common.model.HisLocation;
import com.amap.location.common.model.WiFi;
import com.amap.location.common.model.WifiStatus;
import defpackage.be0;
import defpackage.ee0;
import defpackage.ge0;
import defpackage.gf0;
import defpackage.ie0;
import defpackage.me0;
import defpackage.nd0;
import defpackage.ne0;
import defpackage.od0;
import defpackage.pd0;
import defpackage.pe0;
import defpackage.se0;
import defpackage.td0;
import defpackage.ud0;
import defpackage.we0;
import defpackage.wg0;
import defpackage.yd0;
import defpackage.zd0;
import defpackage.ze0;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/* compiled from: NewRequestDataBuilder.java */
/* loaded from: classes.dex */
public class c {
    public static byte[] a;
    public static a b = new a();

    /* compiled from: NewRequestDataBuilder.java */
    /* loaded from: classes.dex */
    public static class a implements Comparator<WiFi> {
        public a() {
        }

        @Override // java.util.Comparator
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public int compare(WiFi wiFi, WiFi wiFi2) {
            return defpackage.a.a(wiFi2.rssi, wiFi.rssi);
        }
    }

    public static byte a(int i, int i2) {
        if (i > 127 || i < -128) {
            i = i2;
        }
        return (byte) i;
    }

    public static int a(int i) {
        if (i < 0) {
            return 0;
        }
        if (i > 65535) {
            return 65535;
        }
        return i;
    }

    public static gf0 a(Context context, nd0 nd0Var, FPS fps, byte[] bArr, List<HisLocation> list, String str, String str2, String str3, boolean z, boolean z2, boolean z3, int i, boolean z4) {
        try {
            we0 we0Var = new we0();
            we0Var.b(z);
            we0Var.c(z2);
            we0Var.a(false);
            we0Var.d(false);
            nd0Var.a(we0Var);
            nd0Var.r(com.amap.location.protocol.b.a.b);
            nd0Var.g(com.amap.location.protocol.b.a.c);
            nd0Var.f(com.amap.location.protocol.b.a.d);
            nd0Var.p(null);
            nd0Var.h(b.a());
            nd0Var.l(b.b());
            nd0Var.m(null);
            String a2 = b.a(context);
            if (!TextUtils.isEmpty(str)) {
                a2 = a2 + "*" + str;
            }
            nd0Var.b(a2);
            nd0Var.d(com.amap.location.common.a.a(context));
            nd0Var.e(com.amap.location.common.a.d(context));
            try {
                String f = com.amap.location.common.a.f(context);
                if (!TextUtils.isEmpty(f)) {
                    me0 me0Var = new me0();
                    me0Var.a(f);
                    nd0Var.a(me0Var);
                }
            } catch (Exception e) {
                com.amap.location.common.e.a.a(e);
            }
            nd0Var.o(com.amap.location.protocol.b.a.e);
            nd0Var.c(com.amap.location.protocol.b.a.f);
            nd0Var.s(str2);
            nd0Var.a(com.amap.location.common.a.b());
            nd0Var.i(b.b(context));
            nd0Var.a(ie0.a((byte) b.c()));
            nd0Var.a(yd0.None);
            b(nd0Var, fps);
            a(nd0Var, fps);
            a(nd0Var, com.amap.location.protocol.a.a.a().a(i));
            nd0Var.n(null);
            ud0 ud0Var = new ud0();
            if (a != null) {
                ud0Var.a(a);
                nd0Var.a(ud0Var);
            } else {
                nd0Var.a((ud0) null);
            }
            nd0Var.a(new od0());
            td0 td0Var = new td0();
            String b2 = z4 ? com.amap.location.protocol.a.a.a().b() : null;
            if (!TextUtils.isEmpty(b2)) {
                td0Var.a(b2.getBytes());
                nd0Var.a(td0Var);
            } else {
                nd0Var.a((td0) null);
            }
            if (z3) {
                nd0Var.a(bArr);
            } else {
                nd0Var.a((byte[]) null);
            }
            c(nd0Var, fps);
            nd0Var.q(com.amap.location.common.a.f());
            b(nd0Var, list);
            nd0Var.k(com.amap.location.common.a.a());
        } catch (Exception unused) {
        }
        return nd0Var.f0();
    }

    public static void b(nd0 nd0Var, FPS fps) {
        int min;
        try {
            CellStatus cellStatus = fps.cellStatus;
            long currentTimeMillis = System.currentTimeMillis();
            long j = 1000;
            int i = 99;
            if (cellStatus != null && cellStatus.cellType != 0) {
                byte a2 = a(cellStatus.cellType, 0);
                if ((a2 & 1) != 0) {
                    zd0 zd0Var = new zd0();
                    zd0Var.d(cellStatus.mainCell.mcc);
                    zd0Var.e(cellStatus.mainCell.mnc);
                    zd0Var.c(cellStatus.mainCell.lac);
                    zd0Var.b(cellStatus.mainCell.cid);
                    zd0Var.a(a(cellStatus.mainCell.signalStrength, 99));
                    zd0Var.a(cellStatus.mainCell.lastUpdateUtcMills < 0 ? 0 : (int) ((currentTimeMillis - cellStatus.mainCell.lastUpdateUtcMills) / 1000));
                    nd0Var.a(zd0Var);
                    if (cellStatus.neighbors != null && cellStatus.neighbors.size() > 0) {
                        int min2 = Math.min(SecExceptionCode.SEC_ERROR_INIT_PLUGIN_UPDATED_ERROR, cellStatus.neighbors.size());
                        be0 be0Var = new be0();
                        Iterator<CellState> it = cellStatus.neighbors.iterator();
                        int i2 = 0;
                        while (it.hasNext() && i2 < min2) {
                            CellState next = it.next();
                            be0.a aVar = new be0.a();
                            aVar.b(next.cid);
                            aVar.c(next.lac);
                            aVar.a(a(next.signalStrength, i));
                            int i3 = min2;
                            aVar.a(next.lastUpdateUtcMills < 0 ? 0 : (int) ((currentTimeMillis - next.lastUpdateUtcMills) / 1000));
                            be0Var.add(aVar);
                            i2++;
                            min2 = i3;
                            i = 99;
                        }
                        nd0Var.a(be0Var);
                    }
                } else if ((a2 & 2) != 0) {
                    pd0 pd0Var = new pd0();
                    pd0Var.a(cellStatus.mainCell.bid);
                    pd0Var.c(cellStatus.mainCell.latitude);
                    pd0Var.d(cellStatus.mainCell.longitude);
                    pd0Var.e(cellStatus.mainCell.mcc);
                    pd0Var.f(cellStatus.mainCell.nid);
                    pd0Var.g(cellStatus.mainCell.sid);
                    pd0Var.a(a(cellStatus.mainCell.signalStrength, 99));
                    pd0Var.b(cellStatus.mainCell.lastUpdateUtcMills < 0 ? 0 : (int) ((currentTimeMillis - cellStatus.mainCell.lastUpdateUtcMills) / 1000));
                    nd0Var.a(pd0Var);
                }
            }
            if (cellStatus != null && cellStatus.networkOperator != null && (cellStatus.cellType & 8) != 0) {
                nd0Var.j(cellStatus.networkOperator);
            }
            if (cellStatus == null || (cellStatus.cellType & 4) == 0 || (min = Math.min(SecExceptionCode.SEC_ERROR_INIT_PLUGIN_UPDATED_ERROR, cellStatus.cellStateList2.size())) <= 0) {
                return;
            }
            se0 se0Var = new se0();
            int i4 = 0;
            while (i4 < min) {
                CellState cellState = cellStatus.cellStateList2.get(i4);
                int i5 = cellState.type;
                boolean z = cellState.registered;
                int i6 = cellState.lastUpdateUtcMills < 0 ? 0 : (int) ((currentTimeMillis - cellState.lastUpdateUtcMills) / j);
                int i7 = cellState.type;
                if (i7 == 1) {
                    se0.c cVar = new se0.c();
                    cVar.a(cellState.registered);
                    cVar.a(i6);
                    cVar.b(cellState.cid);
                    cVar.c(cellState.lac);
                    cVar.d(cellState.mcc);
                    cVar.e(cellState.mnc);
                    cVar.a(a(cellState.signalStrength, 99));
                    cVar.g(cellState.newpci);
                    cVar.f(cellState.arfcn);
                    cVar.h(cellState.timingAdvance);
                    se0Var.add(cVar);
                } else if (i7 == 2) {
                    se0.b bVar = new se0.b();
                    bVar.a(cellState.registered);
                    bVar.e(cellState.mcc);
                    bVar.g(cellState.sid);
                    bVar.f(cellState.nid);
                    bVar.a(cellState.bid);
                    bVar.b(i6);
                    bVar.a(a(cellState.signalStrength, 99));
                    bVar.c(cellState.latitude);
                    bVar.d(cellState.longitude);
                    se0Var.add(bVar);
                } else if (i7 == 3) {
                    se0.d dVar = new se0.d();
                    dVar.a(cellState.registered);
                    dVar.e(cellState.mcc);
                    dVar.f(cellState.mnc);
                    dVar.d(cellState.lac);
                    dVar.c(cellState.cid);
                    dVar.b(i6);
                    dVar.a(a(cellState.signalStrength, 99));
                    dVar.g(cellState.newpci);
                    dVar.a(cellState.arfcn);
                    dVar.h(cellState.timingAdvance);
                    se0Var.add(dVar);
                } else if (i7 == 4) {
                    se0.f fVar = new se0.f();
                    fVar.a(cellState.registered);
                    fVar.e(cellState.mcc);
                    fVar.f(cellState.mnc);
                    fVar.d(cellState.lac);
                    fVar.c(cellState.cid);
                    fVar.b(i6);
                    fVar.a(a(cellState.signalStrength, 99));
                    fVar.g(cellState.newpci);
                    fVar.a(cellState.arfcn);
                    fVar.h(cellState.timingAdvance);
                    se0Var.add(fVar);
                } else if (i7 == 6) {
                    se0.e eVar = new se0.e();
                    eVar.a(cellState.registered);
                    eVar.d(cellState.mcc);
                    eVar.e(cellState.mnc);
                    eVar.b(i6);
                    eVar.a(cellState.nci);
                    eVar.c(cellState.lac);
                    eVar.a(a(cellState.signalStrength, 99));
                    eVar.f(cellState.newpci);
                    eVar.a(cellState.arfcn);
                    eVar.g(cellState.timingAdvance);
                    se0Var.add(eVar);
                }
                i4++;
                j = 1000;
            }
            nd0Var.a(se0Var);
        } catch (Exception unused) {
        }
    }

    public static void c(nd0 nd0Var, FPS fps) {
        try {
            List<CellStatus.HistoryCell> historyCells = fps.cellStatus.getHistoryCells();
            int min = Math.min(SecExceptionCode.SEC_ERROR_INIT_PLUGIN_UPDATED_ERROR, historyCells.size());
            if (min > 0) {
                ge0 ge0Var = new ge0();
                for (int i = 0; i < min; i++) {
                    CellStatus.HistoryCell historyCell = historyCells.get(i);
                    byte b2 = (byte) historyCell.type;
                    if (b2 >= 1 && b2 <= 6 && b2 != 5) {
                        int elapsedRealtime = (int) ((SystemClock.elapsedRealtime() - historyCell.lastUpdateTimeMills) / 1000);
                        int i2 = historyCell.type;
                        if (i2 == 1) {
                            ge0.b bVar = new ge0.b();
                            bVar.a(false);
                            bVar.c(historyCell.lac);
                            bVar.b(historyCell.cid);
                            bVar.a(elapsedRealtime);
                            ge0Var.add(bVar);
                        } else if (i2 == 2) {
                            ge0.a aVar = new ge0.a();
                            aVar.a(false);
                            aVar.d(historyCell.sid);
                            aVar.c(historyCell.nid);
                            aVar.a(historyCell.bid);
                            aVar.b(elapsedRealtime);
                            ge0Var.add(aVar);
                        } else if (i2 == 3) {
                            ge0.c cVar = new ge0.c();
                            cVar.a(false);
                            cVar.c(historyCell.lac);
                            cVar.b(historyCell.cid);
                            cVar.a(elapsedRealtime);
                            ge0Var.add(cVar);
                        } else if (i2 == 4) {
                            ge0.e eVar = new ge0.e();
                            eVar.a(false);
                            eVar.c(historyCell.lac);
                            eVar.b(historyCell.cid);
                            eVar.a(elapsedRealtime);
                            ge0Var.add(eVar);
                        } else if (i2 == 6) {
                            ge0.d dVar = new ge0.d();
                            dVar.a(false);
                            dVar.b(historyCell.lac);
                            dVar.a(historyCell.nci);
                            dVar.a(elapsedRealtime);
                            ge0Var.add(dVar);
                        }
                    }
                }
                nd0Var.a(ge0Var);
            }
        } catch (Exception unused) {
        }
    }

    public static void a(nd0 nd0Var, FPS fps) {
        try {
            long currentTimeMillis = System.currentTimeMillis();
            WifiStatus wifiStatus = fps.wifiStatus;
            long j = (wifiStatus == null || wifiStatus.mainWifi == null) ? 0L : wifiStatus.mainWifi.mac;
            if (j != 0) {
                ne0 ne0Var = new ne0();
                me0 me0Var = new me0();
                me0Var.a(j.a(j));
                ne0Var.a(me0Var);
                ne0Var.a(a(wifiStatus.mainWifi.rssi, -113));
                ne0Var.a(wifiStatus.mainWifi.ssid);
                ne0Var.a((int) ((currentTimeMillis - wifiStatus.mainWifi.lastUpdateUtcMills) / 1000));
                nd0Var.a(ne0Var);
            }
            if (wifiStatus == null || wifiStatus.getWifiList() == null || wifiStatus.getWifiList().size() <= 0) {
                return;
            }
            List<WiFi> wifiList = wifiStatus.getWifiList();
            Collections.sort(wifiList, b);
            int min = Math.min(25, wifiList.size());
            if (min > 0) {
                pe0 pe0Var = new pe0();
                for (int i = 0; i < min; i++) {
                    WiFi wiFi = wifiList.get(i);
                    pe0.a aVar = new pe0.a();
                    aVar.a(new me0(j.a(wiFi.mac)));
                    aVar.a((int) ((currentTimeMillis - wiFi.lastUpdateUtcMills) / 1000));
                    aVar.a((short) wiFi.frequency);
                    aVar.a(a(wiFi.rssi, -113));
                    aVar.a(a(wiFi.ssid, true, i));
                    pe0Var.add(aVar);
                }
                pe0Var.a((int) ((SystemClock.elapsedRealtime() - fps.wifiStatus.updateTime) / 1000));
                nd0Var.a(pe0Var);
            }
        } catch (Exception unused) {
        }
    }

    public static void a(nd0 nd0Var, List<AmapLoc> list) {
        if (list != null) {
            try {
                long currentTimeMillis = System.currentTimeMillis();
                int min = Math.min(SecExceptionCode.SEC_ERROR_INIT_PLUGIN_UPDATED_ERROR, list.size());
                if (min > 0) {
                    ze0 ze0Var = new ze0();
                    for (int i = 0; i < min; i++) {
                        AmapLoc amapLoc = list.get(i);
                        ze0.a aVar = new ze0.a();
                        aVar.b(amapLoc.getLon());
                        aVar.a(amapLoc.getLat());
                        aVar.a((short) a(Math.round(amapLoc.getAccuracy())));
                        aVar.a(wg0.a(amapLoc.getRetype()));
                        aVar.b((short) a((int) ((currentTimeMillis - amapLoc.getTime()) / 1000)));
                        ze0Var.add(aVar);
                    }
                    nd0Var.a(ze0Var);
                }
            } catch (Exception unused) {
            }
        }
    }

    public static String a(String str, boolean z, int i) {
        if (TextUtils.isEmpty(str)) {
            return "unkwn";
        }
        if (z) {
            String replace = str.replace("*", ".");
            try {
                return replace.getBytes("UTF-8").length >= 32 ? String.valueOf(i) : replace;
            } catch (Exception unused) {
                return String.valueOf(i);
            }
        }
        return String.valueOf(i);
    }

    public static void b(nd0 nd0Var, List<HisLocation> list) {
        if (list != null) {
            try {
                if (list.size() > 0) {
                    long currentTimeMillis = System.currentTimeMillis();
                    int min = Math.min(SecExceptionCode.SEC_ERROR_INIT_PLUGIN_UPDATED_ERROR, list.size());
                    ee0 ee0Var = new ee0();
                    for (int i = 0; i < min; i++) {
                        ee0.a aVar = new ee0.a();
                        HisLocation hisLocation = list.get(i);
                        aVar.a((int) ((currentTimeMillis - hisLocation.time) / 1000));
                        double d = hisLocation.lon;
                        double doubleValue = HisLocation.INT_LATLNG.doubleValue();
                        Double.isNaN(d);
                        aVar.b(d / doubleValue);
                        double d2 = hisLocation.lat;
                        double doubleValue2 = HisLocation.INT_LATLNG.doubleValue();
                        Double.isNaN(d2);
                        aVar.a(d2 / doubleValue2);
                        aVar.b(hisLocation.radius);
                        aVar.a(new ee0.a.C0065a(hisLocation.locType, hisLocation.retype, hisLocation.subretype));
                        ee0Var.add(aVar);
                    }
                    nd0Var.a(ee0Var);
                }
            } catch (Exception unused) {
            }
        }
    }
}
