package com.amap.location.sdk.c;

import com.amap.location.common.network.HttpRequest;
import com.amap.location.common.network.HttpResponse;
import com.amap.location.common.network.HttpResponseStream;
import com.amap.location.common.network.IAsyncHttpClient;
import defpackage.al0;
import defpackage.cl0;
import defpackage.dl0;
import defpackage.fl0;
import defpackage.pk0;
import defpackage.wk0;
import defpackage.xk0;
import defpackage.zk0;
import java.util.Map;

/* compiled from: NetworkWrapper.java */
/* loaded from: classes.dex */
public class c implements IAsyncHttpClient {
    public static volatile IAsyncHttpClient a;
    public static Object b = new Object();
    public pk0 c;

    /* compiled from: NetworkWrapper.java */
    /* loaded from: classes.dex */
    public class a implements dl0<al0> {
        public HttpRequest b;
        public IAsyncHttpClient.IAsyncHttpCallback c;

        public a(HttpRequest httpRequest, IAsyncHttpClient.IAsyncHttpCallback iAsyncHttpCallback) {
            this.b = httpRequest;
            this.c = iAsyncHttpCallback;
        }

        @Override // defpackage.dl0
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public void onSuccess(al0 al0Var) {
            IAsyncHttpClient.IAsyncHttpCallback iAsyncHttpCallback = this.c;
            if (iAsyncHttpCallback != null) {
                iAsyncHttpCallback.onResponse(c.this.a(al0Var), this.b);
            }
        }

        @Override // defpackage.dl0
        public void onFailure(xk0 xk0Var, fl0 fl0Var) {
            IAsyncHttpClient.IAsyncHttpCallback iAsyncHttpCallback = this.c;
            if (iAsyncHttpCallback != null) {
                iAsyncHttpCallback.onResponse(null, this.b);
            }
        }
    }

    public c() {
        pk0 pk0Var = new pk0();
        this.c = pk0Var;
        pk0Var.a(5);
    }

    private wk0 b(HttpRequest httpRequest) {
        if (httpRequest == null || httpRequest.url == null) {
            return null;
        }
        wk0 wk0Var = new wk0();
        Map<String, String> map = httpRequest.headers;
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry != null) {
                    wk0Var.addHeader(entry.getKey(), entry.getValue());
                }
            }
        }
        wk0Var.setUrl(httpRequest.url);
        wk0Var.setTimeout(httpRequest.timeout);
        return wk0Var;
    }

    @Override // com.amap.location.common.network.IAsyncHttpClient
    public void cancelRequest(HttpRequest httpRequest) {
        zk0 a2;
        if (this.c == null || (a2 = a(httpRequest)) == null) {
            return;
        }
        this.c.a(a2);
    }

    @Override // com.amap.location.common.network.IHttpClient
    public HttpResponseStream get(HttpRequest httpRequest) {
        wk0 b2;
        if (this.c == null || (b2 = b(httpRequest)) == null) {
            return null;
        }
        return a((cl0) this.c.a(b2, cl0.class));
    }

    @Override // com.amap.location.common.network.IHttpClient
    public HttpResponse post(HttpRequest httpRequest) {
        zk0 a2;
        if (this.c == null || (a2 = a(httpRequest)) == null) {
            return null;
        }
        return a((al0) this.c.a(a2, al0.class));
    }

    @Override // com.amap.location.common.network.IAsyncHttpClient
    public void postAsync(HttpRequest httpRequest, IAsyncHttpClient.IAsyncHttpCallback iAsyncHttpCallback) {
        zk0 a2;
        if (this.c == null || (a2 = a(httpRequest)) == null) {
            return;
        }
        this.c.a(a2, new a(httpRequest, iAsyncHttpCallback));
    }

    public static IAsyncHttpClient a() {
        if (a == null) {
            synchronized (b) {
                if (a == null) {
                    a = new c();
                }
            }
        }
        return a;
    }

    public static void a(IAsyncHttpClient iAsyncHttpClient) {
        synchronized (b) {
            if (iAsyncHttpClient != null) {
                a = iAsyncHttpClient;
            }
        }
    }

    private zk0 a(HttpRequest httpRequest) {
        if (httpRequest == null || httpRequest.url == null || httpRequest.body == null) {
            return null;
        }
        zk0 zk0Var = new zk0();
        Map<String, String> map = httpRequest.headers;
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry != null) {
                    zk0Var.addHeader(entry.getKey(), entry.getValue());
                }
            }
        }
        zk0Var.setBody(httpRequest.body);
        zk0Var.setUrl(httpRequest.url);
        zk0Var.setTimeout(httpRequest.timeout);
        return zk0Var;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public HttpResponse a(al0 al0Var) {
        if (al0Var == null) {
            return null;
        }
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.statusCode = al0Var.getStatusCode();
        httpResponse.headers = al0Var.getHeaders();
        httpResponse.body = al0Var.getResult();
        return httpResponse;
    }

    private HttpResponseStream a(cl0 cl0Var) {
        if (cl0Var == null) {
            return null;
        }
        HttpResponseStream httpResponseStream = new HttpResponseStream();
        httpResponseStream.statusCode = cl0Var.getStatusCode();
        httpResponseStream.headers = cl0Var.getHeaders();
        httpResponseStream.body = cl0Var.getBodyInputStream();
        return httpResponseStream;
    }
}
