package com.amap.location.sdk.fusion;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import com.amap.api.service.AMapService;
import com.amap.location.sdk.fusion.ILocationCallback;
import com.amap.location.sdk.fusion.ILocationService;
import com.amap.location.sdk.fusion.IStatusCallback;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

/* compiled from: LocationServiceProxy.java */
/* loaded from: classes.dex */
public class c implements com.amap.location.sdk.fusion.a {
    public IBinder c;
    public ILocationService d;
    public a e;
    public LocationStatusListener f;
    public Context g;
    public Handler h;
    public List<Long> a = new LinkedList();
    public AtomicBoolean b = new AtomicBoolean(true);
    public Runnable i = new Runnable() { // from class: com.amap.location.sdk.fusion.c.1
        @Override // java.lang.Runnable
        public void run() {
            if (c.this.a()) {
                if (c.this.c != null && c.this.c.isBinderAlive()) {
                    try {
                        if (c.this.c.pingBinder()) {
                            c.this.h.postDelayed(c.this.i, 10000L);
                        } else {
                            c.this.a((Exception) null, 4);
                        }
                        return;
                    } catch (Exception e) {
                        c.this.a(e, 3);
                        return;
                    }
                }
                com.amap.location.common.e.a.c("mainserviceproxy", "pingBinderRunnable fail");
                c.this.a((Exception) null, 4);
            }
        }
    };
    public ILocationCallback j = new ILocationCallback.Stub() { // from class: com.amap.location.sdk.fusion.c.2
        @Override // com.amap.location.sdk.fusion.ILocationCallback
        public void a(final Location location) throws RemoteException {
            c.this.h.post(new Runnable() { // from class: com.amap.location.sdk.fusion.c.2.1
                @Override // java.lang.Runnable
                public void run() {
                    c.this.e.a(location);
                }
            });
            c.this.h.removeCallbacks(c.this.i);
            c.this.h.postDelayed(c.this.i, 10000L);
        }

        @Override // com.amap.location.sdk.fusion.ILocationCallback
        public void b(final String str) throws RemoteException {
            c.this.h.post(new Runnable() { // from class: com.amap.location.sdk.fusion.c.2.4
                @Override // java.lang.Runnable
                public void run() {
                    c.this.e.b(str);
                }
            });
            c.this.h.removeCallbacks(c.this.i);
            c.this.h.postDelayed(c.this.i, 10000L);
        }

        @Override // com.amap.location.sdk.fusion.ILocationCallback
        public void a(final String str, final int i, final Bundle bundle) throws RemoteException {
            c.this.h.post(new Runnable() { // from class: com.amap.location.sdk.fusion.c.2.2
                @Override // java.lang.Runnable
                public void run() {
                    c.this.e.a(str, i, bundle);
                }
            });
            c.this.h.removeCallbacks(c.this.i);
            c.this.h.postDelayed(c.this.i, 10000L);
        }

        @Override // com.amap.location.sdk.fusion.ILocationCallback
        public void a(final String str) throws RemoteException {
            c.this.h.post(new Runnable() { // from class: com.amap.location.sdk.fusion.c.2.3
                @Override // java.lang.Runnable
                public void run() {
                    c.this.e.a(str);
                }
            });
            c.this.h.removeCallbacks(c.this.i);
            c.this.h.postDelayed(c.this.i, 10000L);
        }
    };
    public IStatusCallback k = new IStatusCallback.Stub() { // from class: com.amap.location.sdk.fusion.c.3
        @Override // com.amap.location.sdk.fusion.IStatusCallback
        public void a(final String str, final long j, final long j2, final Bundle bundle) throws RemoteException {
            c.this.h.post(new Runnable() { // from class: com.amap.location.sdk.fusion.c.3.1
                @Override // java.lang.Runnable
                public void run() {
                    try {
                        LocationStatusListener locationStatusListener = c.this.f;
                        if (locationStatusListener != null) {
                            locationStatusListener.onStatusChanged(str, j, j2, bundle);
                        }
                    } catch (Throwable unused) {
                    }
                }
            });
        }
    };
    public ServiceConnection l = new ServiceConnection() { // from class: com.amap.location.sdk.fusion.c.4
        @Override // android.content.ServiceConnection
        public void onServiceConnected(ComponentName componentName, final IBinder iBinder) {
            if (!c.this.b.get()) {
                try {
                    c.this.g.unbindService(this);
                    return;
                } catch (Exception e) {
                    com.amap.location.common.e.a.c("mainserviceproxy", "unbind error:" + e.toString());
                    return;
                }
            }
            c.this.h.post(new Runnable() { // from class: com.amap.location.sdk.fusion.c.4.1
                @Override // java.lang.Runnable
                public void run() {
                    c.this.c = iBinder;
                    c.this.d = ILocationService.Stub.a(iBinder);
                    try {
                        iBinder.linkToDeath(c.this.m, 0);
                    } catch (RemoteException unused) {
                    }
                    c.this.e.a();
                }
            });
            c.this.h.removeCallbacks(c.this.i);
            c.this.h.postDelayed(c.this.i, 10000L);
        }

        @Override // android.content.ServiceConnection
        public void onServiceDisconnected(ComponentName componentName) {
            c.this.h.post(new Runnable() { // from class: com.amap.location.sdk.fusion.c.4.2
                @Override // java.lang.Runnable
                public void run() {
                    c.this.c = null;
                    c.this.a((Exception) null, 1);
                }
            });
        }
    };
    public IBinder.DeathRecipient m = new IBinder.DeathRecipient() { // from class: com.amap.location.sdk.fusion.c.5
        @Override // android.os.IBinder.DeathRecipient
        public void binderDied() {
            c.this.h.post(new Runnable() { // from class: com.amap.location.sdk.fusion.c.5.1
                @Override // java.lang.Runnable
                public void run() {
                    c.this.a((Exception) null, 2);
                }
            });
        }
    };

    /* compiled from: LocationServiceProxy.java */
    /* loaded from: classes.dex */
    public interface a {
        void a();

        void a(int i);

        void a(Location location);

        void a(String str);

        void a(String str, int i, Bundle bundle);

        void b(String str);
    }

    public c(Context context, a aVar, Looper looper) {
        this.g = context;
        this.e = aVar;
        this.h = new Handler(looper);
        a(context);
        this.h.postDelayed(this.i, 10000L);
    }

    @Override // com.amap.location.sdk.fusion.a
    public void b() {
        try {
            this.d.a(this.j);
        } catch (Exception e) {
            a(e, 3);
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public int c() {
        try {
            return this.d.a();
        } catch (Exception e) {
            a(e, 3);
            return 0;
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public void d() {
        if (a()) {
            b();
            try {
                this.d.b();
            } catch (Exception e) {
                a(e, 3);
            }
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public void a(int i, long j, float f, boolean z) {
        try {
            this.d.a(i, j, f, z, this.j);
        } catch (Exception e) {
            a(e, 3);
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public void a(JSONObject jSONObject) {
        try {
            this.d.a(jSONObject.toString());
        } catch (Exception e) {
            a(e, 3);
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public void a(String str, int i, int i2, String str2) {
        try {
            this.d.a(str, i, i2, str2);
        } catch (Exception e) {
            a(e, 3);
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public void a(LocationStatusListener locationStatusListener) {
        this.f = locationStatusListener;
        try {
            this.d.a(this.k);
        } catch (Exception e) {
            a(e, 3);
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public String a(String str) {
        try {
            return this.d.b(str);
        } catch (Exception e) {
            a(e, 3);
            return null;
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public void a(ILocationAosProvider iLocationAosProvider) {
        try {
            this.d.a(iLocationAosProvider);
        } catch (Exception unused) {
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public void a(long j, double d, double d2, double d3, int i) {
        try {
            this.d.a(j, d, d2, d3, i);
        } catch (Exception e) {
            a(e, 3);
        }
    }

    @Override // com.amap.location.sdk.fusion.a
    public boolean a() {
        return this.d != null;
    }

    private void a(Context context) {
        com.amap.location.common.e.a.b("mainserviceproxy", "bind times:" + this.a.size());
        Intent intent = new Intent(context, (Class<?>) AMapService.class);
        intent.putExtra("foreground", true);
        intent.setPackage(context.getPackageName());
        try {
            if (context.bindService(intent, this.l, 1)) {
                return;
            }
            com.amap.location.common.e.a.c("mainserviceproxy", "bind error");
        } catch (Exception e) {
            com.amap.location.common.e.a.c("mainserviceproxy", "bind error:" + e.toString());
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(Exception exc, int i) {
        if (this.d != null) {
            this.d = null;
            this.e.a(i);
            this.h.removeCallbacks(this.i);
        }
        if (exc != null) {
            com.amap.location.common.e.a.a(exc);
        }
    }
}
