package com.amap.location.sdk.g;

import android.content.Context;
import android.location.GnssClock;
import android.location.GnssMeasurement;
import android.location.GnssMeasurementsEvent;
import android.location.Location;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import com.amap.location.common.f.h;
import com.amap.location.sdk.g.a.g;
import com.google.flatbuffers.FlatBufferBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.json.JSONObject;

/* compiled from: GnssDisturbDetector.java */
/* loaded from: classes.dex */
public class a {
    public static boolean a = false;
    public static int b = 30000;
    public static int c = 20;
    public static double d = 0.0d;
    public static double e = 2.0d;
    public static double f = 70.0d;
    public static double g;
    public Handler h;
    public GnssMeasurementsEvent.Callback i;
    public Location l;
    public long m;
    public com.amap.location.g.b.a q;
    public boolean j = false;
    public boolean k = false;
    public long n = 0;
    public long o = 0;
    public volatile boolean p = false;

    public a(Context context, Looper looper) {
        this.q = com.amap.location.g.b.a.a(context);
        this.h = new Handler(looper);
        if (Build.VERSION.SDK_INT >= 26) {
            this.i = new GnssMeasurementsEvent.Callback() { // from class: com.amap.location.sdk.g.a.1
                @Override // android.location.GnssMeasurementsEvent.Callback
                public void onGnssMeasurementsReceived(GnssMeasurementsEvent gnssMeasurementsEvent) {
                    a.this.a(gnssMeasurementsEvent);
                }
            };
        }
    }

    private synchronized void b() {
        a();
        this.k = true;
    }

    public static void a(JSONObject jSONObject) {
        if (jSONObject != null) {
            try {
                a = jSONObject.optBoolean("enable", a);
                b = Math.min(Math.max(jSONObject.optInt("mindt", b), 1000), 300000);
                c = Math.min(Math.max(jSONObject.optInt("maxcn", c), 1), 1000);
                d = jSONObject.optDouble("param1", d);
                e = jSONObject.optDouble("param2", e);
                f = jSONObject.optDouble("param3", f);
                g = jSONObject.optDouble("param4", g);
            } catch (Throwable th) {
                com.amap.location.common.e.a.a(th);
            }
        }
    }

    public synchronized void a(Location location) {
        this.l = location;
        this.m = System.currentTimeMillis();
        if (a && !this.k && !this.j) {
            try {
                this.p = false;
                if (Build.VERSION.SDK_INT >= 26) {
                    this.q.a(this.i, this.h.getLooper());
                }
            } catch (SecurityException e2) {
                com.amap.location.common.e.a.a(e2);
            }
        }
        this.j = true;
    }

    public synchronized void a() {
        if (a && !this.k && this.j && Build.VERSION.SDK_INT >= 26) {
            this.q.a(this.i);
        }
        this.p = false;
        this.j = false;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(GnssMeasurementsEvent gnssMeasurementsEvent) {
        if (!this.j || gnssMeasurementsEvent == null || Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (!a) {
            b();
            return;
        }
        if (this.o >= c) {
            b();
            return;
        }
        if (!this.p) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            if (elapsedRealtime - this.n < b) {
                return;
            }
            Collection<GnssMeasurement> measurements = gnssMeasurementsEvent.getMeasurements();
            this.n = elapsedRealtime;
            Iterator<GnssMeasurement> it = measurements.iterator();
            while (true) {
                if (!it.hasNext()) {
                    break;
                }
                GnssMeasurement next = it.next();
                if (next != null && next.hasAutomaticGainControlLevelDb()) {
                    if (next.getAutomaticGainControlLevelDb() < d && ((next.getCn0DbHz() * e) - next.getAutomaticGainControlLevelDb()) - f > g) {
                        this.p = true;
                        break;
                    }
                }
            }
            if (this.p) {
                a(gnssMeasurementsEvent.getMeasurements(), gnssMeasurementsEvent.getClock());
                return;
            }
            return;
        }
        a(gnssMeasurementsEvent.getMeasurements(), gnssMeasurementsEvent.getClock());
    }

    private void a(Collection<GnssMeasurement> collection, GnssClock gnssClock) {
        try {
            FlatBufferBuilder flatBufferBuilder = new FlatBufferBuilder();
            int a2 = a(flatBufferBuilder);
            int a3 = a(flatBufferBuilder, collection);
            int a4 = a(flatBufferBuilder, gnssClock);
            com.amap.location.sdk.g.a.d.a(flatBufferBuilder);
            com.amap.location.sdk.g.a.d.a(flatBufferBuilder, System.currentTimeMillis());
            if (a2 > 0) {
                com.amap.location.sdk.g.a.d.a(flatBufferBuilder, a2);
            }
            if (a3 > 0) {
                com.amap.location.sdk.g.a.d.b(flatBufferBuilder, a3);
            }
            if (a4 > 0) {
                com.amap.location.sdk.g.a.d.c(flatBufferBuilder, a4);
            }
            flatBufferBuilder.finish(com.amap.location.sdk.g.a.d.b(flatBufferBuilder));
            String encodeToString = Base64.encodeToString(h.a(flatBufferBuilder.sizedByteArray()), 2);
            if (TextUtils.isEmpty(encodeToString)) {
                return;
            }
            this.o++;
            com.amap.location.sdk.c.a.d.a(100088, encodeToString.getBytes());
        } catch (Exception e2) {
            com.amap.location.common.e.a.a(e2);
        }
    }

    private int a(FlatBufferBuilder flatBufferBuilder) {
        Location location = this.l;
        if (location != null) {
            return g.a(flatBufferBuilder, location.getTime(), this.l.getLatitude(), this.l.getLongitude(), this.l.getAccuracy(), this.l.getSpeed(), this.l.getBearing(), this.l.getAltitude(), this.m);
        }
        return -1;
    }

    private int a(FlatBufferBuilder flatBufferBuilder, Collection<GnssMeasurement> collection) {
        FlatBufferBuilder flatBufferBuilder2 = flatBufferBuilder;
        if (Build.VERSION.SDK_INT < 26 || collection == null) {
            return -1;
        }
        ArrayList arrayList = new ArrayList();
        for (GnssMeasurement gnssMeasurement : collection) {
            if (gnssMeasurement != null) {
                arrayList.add(gnssMeasurement);
            }
        }
        int size = arrayList.size();
        if (size == 0) {
            return -1;
        }
        int[] iArr = new int[size];
        int i = 0;
        while (i < size) {
            GnssMeasurement gnssMeasurement2 = (GnssMeasurement) arrayList.get(i);
            int createString = flatBufferBuilder2.createString("null");
            int i2 = i;
            int[] iArr2 = iArr;
            iArr2[i2] = com.amap.location.sdk.g.a.e.a(flatBufferBuilder, gnssMeasurement2.describeContents(), gnssMeasurement2.getAccumulatedDeltaRangeMeters(), gnssMeasurement2.getAccumulatedDeltaRangeState(), gnssMeasurement2.getAccumulatedDeltaRangeUncertaintyMeters(), gnssMeasurement2.hasAutomaticGainControlLevelDb() ? gnssMeasurement2.getAutomaticGainControlLevelDb() : -9999.0d, gnssMeasurement2.hasCarrierCycles() ? gnssMeasurement2.getCarrierCycles() : -9999L, gnssMeasurement2.hasCarrierFrequencyHz() ? gnssMeasurement2.getCarrierFrequencyHz() : -9999.0f, gnssMeasurement2.hasCarrierPhase() ? gnssMeasurement2.getCarrierPhase() : -9999.0d, gnssMeasurement2.hasCarrierPhaseUncertainty() ? gnssMeasurement2.getCarrierPhaseUncertainty() : -9999.0d, gnssMeasurement2.getCn0DbHz(), createString, gnssMeasurement2.getConstellationType(), gnssMeasurement2.getMultipathIndicator(), gnssMeasurement2.getPseudorangeRateMetersPerSecond(), gnssMeasurement2.getPseudorangeRateUncertaintyMetersPerSecond(), gnssMeasurement2.getReceivedSvTimeNanos(), gnssMeasurement2.getReceivedSvTimeUncertaintyNanos(), gnssMeasurement2.hasSnrInDb() ? gnssMeasurement2.getSnrInDb() : -9999.0d, gnssMeasurement2.getState(), gnssMeasurement2.getSvid(), gnssMeasurement2.getTimeOffsetNanos());
            i = i2 + 1;
            flatBufferBuilder2 = flatBufferBuilder;
            iArr = iArr2;
            size = size;
            arrayList = arrayList;
        }
        return com.amap.location.sdk.g.a.d.a(flatBufferBuilder2, iArr);
    }

    private int a(FlatBufferBuilder flatBufferBuilder, GnssClock gnssClock) {
        if (Build.VERSION.SDK_INT < 26 || gnssClock == null) {
            return -1;
        }
        return com.amap.location.sdk.g.a.c.a(flatBufferBuilder, gnssClock.describeContents(), gnssClock.hasBiasNanos() ? gnssClock.getBiasNanos() : -9999.0d, gnssClock.hasBiasUncertaintyNanos() ? gnssClock.getBiasUncertaintyNanos() : -9999.0d, gnssClock.hasDriftNanosPerSecond() ? gnssClock.getDriftNanosPerSecond() : -9999.0d, gnssClock.hasDriftUncertaintyNanosPerSecond() ? gnssClock.getDriftUncertaintyNanosPerSecond() : -9999.0d, gnssClock.hasFullBiasNanos() ? gnssClock.getFullBiasNanos() : -9999L, gnssClock.getHardwareClockDiscontinuityCount(), gnssClock.hasLeapSecond() ? gnssClock.getLeapSecond() : -9999, gnssClock.getTimeNanos(), gnssClock.hasTimeUncertaintyNanos() ? gnssClock.getTimeUncertaintyNanos() : -9999.0d);
    }
}
