package com.amap.location.sdk.g;

import android.content.Context;
import android.location.GnssClock;
import android.location.GnssMeasurement;
import android.location.GnssMeasurementsEvent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import java.util.Collection;
import java.util.List;
import org.json.JSONObject;

/* compiled from: GnssLossDetector.java */
/* loaded from: classes.dex */
public class c {
    public static int a = 20;
    public static int b = 10000;
    public static int c = 60000;
    public static boolean d;
    public Handler e;
    public com.amap.location.g.b.a f;
    public GnssMeasurementsEvent.Callback h;
    public boolean g = false;
    public long i = 0;
    public long j = 0;
    public long k = 0;
    public long l = 0;
    public long m = 0;
    public int n = 0;
    public Runnable o = new Runnable() { // from class: com.amap.location.sdk.g.c.2
        @Override // java.lang.Runnable
        public void run() {
            c.this.a();
        }
    };
    public com.amap.location.g.b.d p = new com.amap.location.g.b.d() { // from class: com.amap.location.sdk.g.c.3
        @Override // com.amap.location.g.b.d
        public void onFirstFix(int i) {
        }

        @Override // com.amap.location.g.b.d
        public void onGpsStatusListener(int i, int i2, float f, List<com.amap.location.g.b.c> list) {
            c.this.a(i, i2, f, list);
        }

        @Override // com.amap.location.g.b.d
        public void onStarted() {
        }

        @Override // com.amap.location.g.b.d
        public void onStopped() {
        }
    };

    public c(Context context, Looper looper) {
        this.e = new Handler(looper);
        this.f = com.amap.location.g.b.a.a(context);
        if (Build.VERSION.SDK_INT >= 26) {
            this.h = new GnssMeasurementsEvent.Callback() { // from class: com.amap.location.sdk.g.c.1
                @Override // android.location.GnssMeasurementsEvent.Callback
                public void onGnssMeasurementsReceived(GnssMeasurementsEvent gnssMeasurementsEvent) {
                    c.this.a(gnssMeasurementsEvent);
                }
            };
        }
    }

    private int b(int i) {
        if (i < 0 || i > 8) {
            return 8;
        }
        return i;
    }

    public static void a(JSONObject jSONObject) {
        if (jSONObject != null) {
            try {
                d = jSONObject.optBoolean("enable", d);
                a = jSONObject.optInt("gpc", a);
                b = jSONObject.optInt("gpit", b);
                c = jSONObject.optInt("gst", c);
            } catch (Throwable th) {
                com.amap.location.common.e.a.a(th);
            }
        }
    }

    public synchronized void a(int i) {
        if (!this.g) {
            if (this.i == 0) {
                this.i = System.currentTimeMillis();
            }
            boolean a2 = this.f.a("gps");
            StringBuilder sb = new StringBuilder();
            sb.append("gnss gpsloss info :");
            sb.append(a2 ? 1 : 0);
            sb.append(",");
            sb.append(((System.currentTimeMillis() - this.i) / 1000) + 10);
            sb.append(",");
            sb.append(i);
            com.amap.location.common.e.a.b("gnssloss", sb.toString());
            if (!a2) {
                com.amap.location.common.e.a.b("gnssloss", "gps close");
                return;
            }
            try {
                this.f.a(this.p, this.e.getLooper());
                if (d && Build.VERSION.SDK_INT >= 26) {
                    this.f.a(this.h, this.e.getLooper());
                }
            } catch (SecurityException e) {
                com.amap.location.common.e.a.a(e);
            }
            this.n = 0;
            this.k = 0L;
            this.j = 0L;
            this.l = 0L;
            this.e.removeCallbacks(this.o);
            this.e.postDelayed(this.o, 600000L);
            if (f.a().e()) {
                f.a().d();
                this.m = System.currentTimeMillis();
            }
        }
        this.g = true;
    }

    public synchronized void a() {
        if (this.g) {
            this.e.removeCallbacks(this.o);
            try {
                this.f.a(this.p);
            } catch (SecurityException e) {
                com.amap.location.common.e.a.a(e);
            }
            if (d && Build.VERSION.SDK_INT >= 26) {
                this.f.a(this.h);
            }
            com.amap.location.common.e.a.b("gnssloss", "gnss gpsloss stop");
        }
        this.g = false;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(int i, int i2, float f, List<com.amap.location.g.b.c> list) {
        if (list == null) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.l <= b) {
            return;
        }
        this.l = currentTimeMillis;
        try {
            int[] iArr = new int[9];
            int i3 = 0;
            int i4 = 0;
            int i5 = 0;
            int i6 = 0;
            int i7 = 0;
            for (com.amap.location.g.b.c cVar : list) {
                if (cVar != null) {
                    if (cVar.c() > 0.0f) {
                        i3++;
                        int b2 = b(cVar.f());
                        iArr[b2] = iArr[b2] + 1;
                        if (cVar.c() > 20.0f) {
                            i4++;
                        }
                    }
                    if (cVar.d() > 0.0f) {
                        i5++;
                    }
                    if (cVar.g()) {
                        i6++;
                    }
                    if (cVar.h()) {
                        i7++;
                    }
                }
            }
            if (currentTimeMillis - this.m > 120000) {
                e.a().a(1, i2, i, f);
                f.a().d();
                this.m = currentTimeMillis;
            }
            a(i2, i3, f, i4, i5, i6, i7, iArr);
        } catch (Exception e) {
            com.amap.location.common.e.a.c("gnssloss", "Satellites error" + e.toString());
        }
    }

    private void a(int i, int i2, float f, int i3, int i4, int i5, int i6, int[] iArr) {
        StringBuilder sb = new StringBuilder();
        sb.append("statellites:{");
        sb.append(i);
        sb.append(",");
        sb.append(i2);
        sb.append(",");
        sb.append(f);
        sb.append(",");
        sb.append(i3);
        sb.append(",");
        sb.append(i4);
        sb.append(",");
        sb.append(i5);
        sb.append(",");
        sb.append(i6);
        sb.append(",");
        sb.append("[");
        if (iArr != null) {
            for (int i7 : iArr) {
                sb.append(i7);
                sb.append(",");
            }
        } else {
            sb.append("unkown");
        }
        sb.append("]}");
        com.amap.location.common.e.a.b("gnssloss", sb.toString());
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(GnssMeasurementsEvent gnssMeasurementsEvent) {
        int i;
        int i2;
        int i3;
        if (Build.VERSION.SDK_INT < 26 || gnssMeasurementsEvent == null) {
            return;
        }
        try {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - this.j <= b) {
                return;
            }
            boolean a2 = a(currentTimeMillis);
            this.j = currentTimeMillis;
            int[] iArr = new int[9];
            StringBuilder sb = new StringBuilder();
            Collection<GnssMeasurement> measurements = gnssMeasurementsEvent.getMeasurements();
            if (measurements != null) {
                i = 0;
                i2 = 0;
                i3 = 0;
                for (GnssMeasurement gnssMeasurement : measurements) {
                    if (gnssMeasurement != null) {
                        i++;
                        int b2 = b(gnssMeasurement.getConstellationType());
                        iArr[b2] = iArr[b2] + 1;
                        if (gnssMeasurement.getReceivedSvTimeNanos() > 0) {
                            i2++;
                        }
                        int state = gnssMeasurement.getState();
                        if ((state & 8) > 0 || (state & 128) > 0) {
                            i3++;
                            if (a2) {
                                sb.append("[");
                                sb.append(gnssMeasurement.getConstellationType());
                                sb.append(",");
                                sb.append(gnssMeasurement.getSvid());
                                sb.append(",");
                                sb.append(gnssMeasurement.getReceivedSvTimeNanos());
                                sb.append(",");
                                sb.append(gnssMeasurement.getPseudorangeRateMetersPerSecond());
                                sb.append(",");
                                sb.append(gnssMeasurement.getCn0DbHz());
                                sb.append(",");
                                sb.append(gnssMeasurement.hasAutomaticGainControlLevelDb() ? gnssMeasurement.getAutomaticGainControlLevelDb() : -9999.0d);
                                sb.append(",");
                                sb.append(gnssMeasurement.hasCarrierFrequencyHz() ? gnssMeasurement.getCarrierFrequencyHz() : -9999.0f);
                                sb.append(",");
                                sb.append(gnssMeasurement.getTimeOffsetNanos());
                                sb.append(",");
                                sb.append(gnssMeasurement.getState());
                                sb.append("],");
                            }
                        }
                    }
                }
            } else {
                i = 0;
                i2 = 0;
                i3 = 0;
            }
            StringBuilder sb2 = new StringBuilder();
            sb2.append("gnss:{");
            sb2.append(i);
            sb2.append(",[");
            for (int i4 = 0; i4 < 9; i4++) {
                sb2.append(iArr[i4]);
                sb2.append(",");
            }
            sb2.append("],");
            sb2.append(i2);
            sb2.append(",");
            sb2.append(i3);
            sb2.append(",");
            if (a2) {
                sb2.append("{");
                sb2.append(sb.toString());
                sb2.append("},");
                GnssClock clock = gnssMeasurementsEvent.getClock();
                sb2.append("[");
                if (clock != null) {
                    sb2.append(clock.hasFullBiasNanos() ? clock.getFullBiasNanos() : -9999L);
                    sb2.append(",");
                    sb2.append(clock.getTimeNanos());
                    sb2.append(",");
                    sb2.append(clock.hasBiasNanos() ? clock.getBiasNanos() : -9999.0d);
                }
                sb2.append("]");
                this.n++;
            }
            sb2.append("}");
            com.amap.location.common.e.a.b("gnssloss", sb2.toString());
        } catch (Exception e) {
            com.amap.location.common.e.a.c("gnssloss", "trans gnss measurements error" + e.toString());
        }
    }

    private boolean a(long j) {
        if (this.n > a || j - this.k <= c) {
            return false;
        }
        this.k = j;
        return true;
    }
}
