package com.amap.location.sdk.h.b;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.amap.location.common.model.AmapLoc;
import com.amap.location.security.Core;
import java.util.List;
import org.json.JSONObject;

/* compiled from: GpsLocationProvider.java */
/* loaded from: classes.dex */
public class e extends c {
    public Context b;
    public com.amap.location.g.b.a c;
    public Looper d;
    public long[] e;
    public long[] f;
    public volatile long g;
    public volatile long h;
    public volatile long i;
    public volatile long j;
    public int k;
    public volatile Location l;
    public long m;
    public float n;
    public long o;
    public volatile boolean p;
    public boolean q;
    public boolean r;
    public Handler s;
    public boolean t;
    public boolean u;
    public LocationListener v;
    public Runnable w;
    public LocationListener x;

    public e(Context context, com.amap.location.sdk.h.a aVar, Looper looper, boolean z) {
        super(aVar);
        this.e = new long[5];
        this.f = new long[5];
        this.k = 0;
        this.m = 1000L;
        this.n = 0.0f;
        this.o = SystemClock.elapsedRealtime();
        this.p = false;
        this.q = false;
        this.r = false;
        this.t = false;
        this.u = false;
        this.v = new LocationListener() { // from class: com.amap.location.sdk.h.b.e.1
            @Override // android.location.LocationListener
            public void onLocationChanged(Location location) {
                e.this.r = true;
                e.this.s.removeCallbacks(e.this.w);
                e.this.s.postDelayed(e.this.w, 2000L);
                e.this.b(location);
            }

            @Override // android.location.LocationListener
            public void onProviderDisabled(String str) {
            }

            @Override // android.location.LocationListener
            public void onProviderEnabled(String str) {
            }

            @Override // android.location.LocationListener
            public void onStatusChanged(String str, int i, Bundle bundle) {
            }
        };
        this.w = new Runnable() { // from class: com.amap.location.sdk.h.b.e.2
            @Override // java.lang.Runnable
            public void run() {
                e.this.r = false;
            }
        };
        this.x = new LocationListener() { // from class: com.amap.location.sdk.h.b.e.3
            @Override // android.location.LocationListener
            public void onLocationChanged(Location location) {
                if (e.this.r) {
                    return;
                }
                e.this.b(location);
            }

            @Override // android.location.LocationListener
            public void onProviderDisabled(String str) {
                e.this.a.onProviderDisabled(str);
            }

            @Override // android.location.LocationListener
            public void onProviderEnabled(String str) {
                e.this.a.onProviderEnabled(str);
            }

            @Override // android.location.LocationListener
            public void onStatusChanged(String str, int i, Bundle bundle) {
                e.this.a.onStatusChanged(str, i, bundle);
            }
        };
        this.b = context;
        this.d = looper;
        this.u = z;
        this.s = new Handler(this.d);
        this.c = com.amap.location.g.b.a.a(context);
    }

    private void e() {
        this.g = System.currentTimeMillis();
        this.h = 0L;
        this.i = 0L;
        this.j = 0L;
        int i = 0;
        this.k = 0;
        this.l = null;
        int i2 = 0;
        while (true) {
            long[] jArr = this.e;
            if (i2 >= jArr.length) {
                break;
            }
            jArr[i2] = 0;
            i2++;
        }
        while (true) {
            long[] jArr2 = this.f;
            if (i >= jArr2.length) {
                return;
            }
            jArr2[i] = 0;
            i++;
        }
    }

    public void a(JSONObject jSONObject) {
    }

    public boolean d() {
        return this.c.b();
    }

    public String b() {
        float accuracy;
        StringBuilder sb = new StringBuilder();
        boolean a = this.c.a("gps");
        long j = this.g / 1000;
        Location location = this.l;
        String str = "0";
        String str2 = "0";
        if (location != null) {
            try {
                str = Core.ce(location.getLongitude(), 1);
                str2 = Core.ce(location.getLatitude(), 2);
            } catch (Exception unused) {
            }
            accuracy = location.getAccuracy();
        } else {
            accuracy = 0.0f;
        }
        sb.append("gps:");
        sb.append(a ? 1 : 0);
        sb.append(",");
        sb.append(j);
        sb.append(",");
        if (this.h != 0) {
            sb.append((this.h / 1000) - j);
            sb.append(",");
        } else {
            sb.append("0,");
        }
        if (this.j != 0) {
            sb.append((this.j / 1000) - j);
            sb.append(",");
        } else {
            sb.append("0,");
        }
        if (this.i != 0) {
            sb.append((this.i / 1000) - j);
            sb.append(",");
            sb.append(str);
            sb.append(",");
            sb.append(str2);
            sb.append(",");
            sb.append(accuracy);
            sb.append(",");
        }
        synchronized (this.x) {
            for (int i = 0; i < 5; i++) {
                sb.append(this.e[i] / 1000);
                sb.append(",");
                sb.append(this.f[i] / 1000);
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public boolean c() {
        return this.p;
    }

    public void a(long j, float f) {
        this.m = j;
        this.n = f;
        if (!com.amap.location.sdk.i.g.a(this.b, "android.permission.ACCESS_FINE_LOCATION")) {
            com.amap.location.common.e.a.b("gpsloc", "no permission");
            return;
        }
        try {
            e();
            List<String> a = this.c.a();
            if (a != null) {
                if (a.contains("gps")) {
                    this.p = true;
                    this.c.a("gps", j, f, this.x, this.d);
                    if (com.amap.location.sdk.i.h.b(this.b)) {
                        com.amap.location.sdk.c.a.d.a(115, "{\"listn\":1}".getBytes());
                    } else {
                        com.amap.location.sdk.c.a.d.a(114, "{\"listn\":1}".getBytes());
                    }
                } else {
                    com.amap.location.common.e.a.c("gpsloc", "no gps provider");
                }
            } else {
                com.amap.location.common.e.a.c("gpsloc", "no gps providerS");
            }
        } catch (Exception e) {
            com.amap.location.common.e.a.c("gpsloc", "gps request error:" + Log.getStackTraceString(e));
        }
    }

    public void a() {
        if (this.g > 0) {
            this.h = System.currentTimeMillis();
        }
        this.p = false;
        this.c.a(this.x);
        if (com.amap.location.sdk.i.h.b(this.b)) {
            com.amap.location.sdk.c.a.d.a(115, "{\"listn\":2}".getBytes());
        } else {
            com.amap.location.sdk.c.a.d.a(114, "{\"listn\":2}".getBytes());
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void b(Location location) {
        if (location == null) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (this.j == 0) {
            this.j = currentTimeMillis;
        }
        if (this.i > 0 && currentTimeMillis - this.i > 30000) {
            synchronized (this.x) {
                this.e[this.k] = this.i - this.g;
                this.f[this.k] = currentTimeMillis - this.g;
            }
            int i = this.k + 1;
            this.k = i;
            if (i >= 5) {
                this.k = 0;
            }
        }
        Bundle extras = location.getExtras();
        if (extras == null) {
            extras = new Bundle();
        }
        try {
            extras.putFloat("optimizedAccuracy", location.getAccuracy());
            extras.putString("retype", "0");
        } catch (Exception unused) {
        }
        location.setExtras(extras);
        if (AmapLoc.isLocationCorrect(location)) {
            com.amap.location.protocol.a.a.a().a(location);
        }
        this.l = location;
        this.i = currentTimeMillis;
        a(location);
    }
}
