package com.amap.location.sdk.h.b;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import com.amap.location.common.model.AmapLoc;
import com.amap.location.common.model.FPS;
import com.amap.location.sdk.BuildConfig;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import org.json.JSONObject;

/* compiled from: NetworkLocationProvider.java */
/* loaded from: classes.dex */
public class f extends c {
    public com.amap.location.e.c b;
    public Context c;
    public com.amap.location.e.f d;
    public com.amap.location.c.a e;
    public boolean f;
    public boolean g;
    public boolean h;
    public boolean i;
    public long j;
    public a k;
    public long l;
    public boolean m;
    public AmapLoc n;
    public com.amap.location.e.a o;

    /* compiled from: NetworkLocationProvider.java */
    /* loaded from: classes.dex */
    public interface a {
        void a(AmapLoc amapLoc);
    }

    public f(Context context, com.amap.location.sdk.h.a aVar, JSONObject jSONObject, boolean z) {
        super(aVar);
        this.e = new com.amap.location.c.a();
        this.l = -1L;
        this.m = false;
        this.n = null;
        this.o = new com.amap.location.e.a() { // from class: com.amap.location.sdk.h.b.f.1
            @Override // com.amap.location.e.a
            public void a(AmapLoc amapLoc, FPS fps) {
                if (f.this.i) {
                    f.this.j = System.currentTimeMillis();
                    return;
                }
                if (amapLoc == null || !amapLoc.isLocationCorrect()) {
                    a aVar2 = f.this.k;
                    if (aVar2 != null) {
                        aVar2.a(amapLoc);
                    }
                    f.this.a("null");
                    return;
                }
                boolean z2 = false;
                String type = amapLoc.getType();
                if (!f.this.m) {
                    int locType = AmapLoc.getLocType(amapLoc);
                    long time = amapLoc.getTime();
                    AmapLoc a2 = f.this.e.a(amapLoc);
                    if (a2 != null && a2.getTime() != time) {
                        com.amap.location.common.e.a.b("netloc", "[filter]" + com.amap.location.common.e.b.a(amapLoc));
                        a2.setIsLast(true);
                        com.amap.location.sdk.c.a.d.a(100231);
                        z2 = true;
                    }
                    if (a2 == null) {
                        if (locType == 1) {
                            com.amap.location.sdk.c.a.d.a(108);
                        } else if (locType == 2) {
                            com.amap.location.sdk.c.a.d.a(100042);
                            com.amap.location.sdk.c.a.d.a(107);
                        } else if (locType == 3) {
                            com.amap.location.sdk.c.a.d.a(100048);
                            com.amap.location.sdk.c.a.d.a(107);
                        } else if (locType == 4) {
                            com.amap.location.sdk.c.a.d.a(100044);
                        }
                        com.amap.location.common.e.a.c("netloc", "filter netloc and return null");
                        f.this.a("filtered");
                        return;
                    }
                    amapLoc = a2;
                }
                f.this.a(f.b(amapLoc, z2));
                if (!f.this.a(amapLoc)) {
                    com.amap.location.sdk.c.a.d.a(100004, com.amap.location.sdk.c.a.c.a(amapLoc));
                }
                f.this.n = amapLoc;
                f.this.a(type);
            }
        };
        this.c = context;
        com.amap.location.e.c cVar = new com.amap.location.e.c();
        this.b = cVar;
        cVar.b = com.amap.location.common.b.c();
        this.b.c = com.amap.location.common.b.d();
        this.b.a = com.amap.location.common.b.a() == 0 ? "AmapSS_v2.0_R131029" : com.amap.location.common.b.e();
        com.amap.location.e.c cVar2 = this.b;
        cVar2.d = BuildConfig.VERSION_NAME;
        cVar2.e = com.amap.location.sdk.c.a.d();
        if (com.amap.location.common.b.a() == 0 || com.amap.location.common.b.a() == 3) {
            this.b.m = h.a(jSONObject);
        }
        this.b.o = h.a(context);
        this.b.l = new i(z);
        com.amap.location.e.c cVar3 = this.b;
        cVar3.i = false;
        cVar3.j = false;
        h.a(jSONObject, cVar3.n, (i) cVar3.l);
        if (com.amap.location.common.b.a() == 6) {
            this.b.p = com.amap.location.sdk.c.c.a();
        }
        this.d = new com.amap.location.e.f(this.b);
    }

    public boolean e() {
        return this.i;
    }

    public void f() {
        this.f = false;
        this.d.a();
    }

    private void d(boolean z) {
        ((i) this.b.l).f(z);
    }

    public void c(boolean z) {
        this.b.j = z;
    }

    public void b(JSONObject jSONObject) {
        ((i) this.b.l).a(jSONObject);
    }

    public boolean c() {
        return this.f && this.g;
    }

    public boolean d() {
        return this.h;
    }

    public void b(boolean z) {
        this.b.i = false;
    }

    public void a(int i, boolean z) {
        if (!this.f) {
            this.d.a(this.c);
            this.f = true;
        }
        if (z) {
            this.l = SystemClock.elapsedRealtime();
        }
        this.g = true;
        this.h = false;
        this.i = false;
        d(false);
        this.d.a(i, this.o, z);
    }

    public String b() {
        try {
            return this.d.c();
        } catch (Exception e) {
            com.amap.location.common.e.a.a(e);
            return "";
        }
    }

    public static Location b(AmapLoc amapLoc, boolean z) {
        Location location = new Location("network");
        location.setLatitude(amapLoc.getLat());
        location.setLongitude(amapLoc.getLon());
        location.setAccuracy(amapLoc.getAccuracy());
        location.setTime(System.currentTimeMillis());
        if (Build.VERSION.SDK_INT >= 17) {
            location.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
        }
        String poiid = amapLoc.getPoiid();
        String floor = amapLoc.getFloor();
        String str = "" + amapLoc.getRetype();
        String poiname = amapLoc.getPoiname();
        String desc = amapLoc.getDesc();
        String country = amapLoc.getCountry();
        String citycode = amapLoc.getCitycode();
        String adcode = amapLoc.getAdcode();
        String province = amapLoc.getProvince();
        String city = amapLoc.getCity();
        String district = amapLoc.getDistrict();
        String road = amapLoc.getRoad();
        String street = amapLoc.getStreet();
        int scenarioConfidence = amapLoc.getScenarioConfidence();
        String subType = amapLoc.getSubType();
        boolean isLast = amapLoc.getIsLast();
        int coord = amapLoc.getCoord();
        if (AmapLoc.getLocType(amapLoc) == 1) {
            com.amap.location.sdk.g.f.a().a(str, scenarioConfidence);
        }
        Bundle bundle = new Bundle();
        bundle.putString("retype", str);
        bundle.putString("type", "" + amapLoc.getType());
        bundle.putInt("locType", AmapLoc.getLocType(amapLoc));
        bundle.putString(StandardProtocolKey.POIID, poiid);
        bundle.putString("floor", floor);
        bundle.putString("poiname", poiname);
        bundle.putString("desc", desc);
        bundle.putString("citycode", citycode);
        bundle.putString("adcode", adcode);
        bundle.putString("country", country);
        bundle.putString("province", province);
        bundle.putString("city", city);
        bundle.putString("district", district);
        bundle.putString("road", road);
        bundle.putString("street", street);
        bundle.putFloat("optimizedAccuracy", amapLoc.getAccuracy());
        bundle.putInt("scenarioConfidence", scenarioConfidence);
        if (!TextUtils.isEmpty(subType)) {
            bundle.putString("subtype", subType);
        }
        bundle.putBoolean("isLast", isLast);
        bundle.putBoolean("isFilter", z);
        if (coord == 0) {
            bundle.putString("coord", "WGS84");
        } else if (coord == 1) {
            bundle.putString("coord", "GCJ02");
        }
        if (!TextUtils.isEmpty(amapLoc.getServerTraceId())) {
            bundle.putString("serverTraceId", amapLoc.getServerTraceId());
        }
        location.setExtras(bundle);
        return location;
    }

    public void a(int i, boolean z, boolean z2) {
        if (!z2 || System.currentTimeMillis() - this.j >= i) {
            a(i, z);
            this.h = true;
            this.i = z2;
            d(z2);
            com.amap.location.common.e.a.b("netloc", "request-noreport:" + i);
        }
    }

    public void a() {
        this.l = -1L;
        this.g = false;
        this.h = false;
        this.i = false;
        d(false);
        this.d.b();
    }

    public void a(JSONObject jSONObject) {
        this.b.b = com.amap.location.common.b.c();
        this.b.c = com.amap.location.common.b.d();
        com.amap.location.e.c cVar = this.b;
        h.a(jSONObject, cVar.n, (i) cVar.l);
        if (com.amap.location.common.b.a() == 0 || com.amap.location.common.b.a() == 3) {
            this.d.a(h.a(jSONObject));
        }
        this.d.a(h.a(this.c));
    }

    public void a(boolean z) {
        this.m = z;
        ((i) this.b.l).b(z);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(String str) {
        if (this.l >= 0) {
            long elapsedRealtime = SystemClock.elapsedRealtime() - this.l;
            this.l = -1L;
            String str2 = str + "," + elapsedRealtime;
            com.amap.location.sdk.c.a.d.a(100032, str2.getBytes());
            com.amap.location.common.e.a.b("netloc", "first loc success:" + str2);
        }
    }

    public void a(a aVar) {
        this.k = aVar;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public boolean a(AmapLoc amapLoc) {
        AmapLoc amapLoc2 = this.n;
        if (amapLoc2 == null || amapLoc == null) {
            return false;
        }
        return ((int) (amapLoc2.getLat() * 1.0E7d)) == ((int) (amapLoc.getLat() * 1.0E7d)) && ((int) (this.n.getLon() * 1.0E7d)) == ((int) (amapLoc.getLon() * 1.0E7d));
    }
}
