package com.amap.location.sdk.i;

import android.location.Location;
import android.os.Bundle;
import com.amap.api.service.IndoorLocationProvider;
import com.amap.location.common.model.AmapLoc;

/* compiled from: LocationJumpStatisticsUtil.java */
/* loaded from: classes.dex */
public class e {
    public static volatile e c;
    public static Object d = new Object();
    public Location a;
    public Location b;

    public static e a() {
        if (c == null) {
            synchronized (d) {
                if (c == null) {
                    c = new e();
                }
            }
        }
        return c;
    }

    private int b(Location location) {
        if (location == null) {
            return 0;
        }
        String provider = location.getProvider();
        if (IndoorLocationProvider.NAME.equals(provider)) {
            return 6;
        }
        if ("gps".equals(provider)) {
            return 5;
        }
        if ("network".equals(provider)) {
            try {
                Bundle extras = location.getExtras();
                if (extras == null) {
                    return 0;
                }
                String string = extras.getString("type", "0");
                if (AmapLoc.TYPE_NEW.equals(string)) {
                    return 1;
                }
                if (AmapLoc.TYPE_CACHE.equals(string)) {
                    return 3;
                }
                if (!AmapLoc.TYPE_OFFLINE_CELL.equals(string)) {
                    if (!AmapLoc.TYPE_OFFLINE_WIFI.equals(string)) {
                        return 0;
                    }
                }
                return 4;
            } catch (Exception e) {
                com.amap.location.common.e.a.c("locJumpStatisticsUtil", "extra error " + e);
                return 0;
            }
        }
        com.amap.location.common.e.a.c("locJumpStatisticsUtil", "unknow type " + provider);
        return 0;
    }

    public synchronized void a(Location location) {
        if (this.a == null) {
            this.a = location;
            return;
        }
        Location location2 = this.b != null ? this.b : this.a;
        if (b(location2, location)) {
            location2.setTime(location.getTime());
            return;
        }
        if (this.b != null) {
            if (a(this.a, this.b, location)) {
                a(b(this.b));
                a(b(this.b), b(location));
                this.a = location;
                this.b = null;
                return;
            }
            this.a = this.b;
            this.b = null;
        }
        if (a(this.a, location)) {
            this.b = location;
            a(b(this.a), b(location));
        } else {
            this.a = location;
        }
    }

    private boolean b(Location location, Location location2) {
        if (location == null || location2 == null) {
            return false;
        }
        return ((int) (location.getLatitude() * 1.0E7d)) == ((int) (location2.getLatitude() * 1.0E7d)) && ((int) (location.getLongitude() * 1.0E7d)) == ((int) (location2.getLongitude() * 1.0E7d));
    }

    private boolean a(Location location, Location location2) {
        long time = (location2.getTime() - location.getTime()) / 1000;
        if (time > 15 || time <= 0) {
            return false;
        }
        double a = c.a(location.getLongitude(), location.getLatitude(), location2.getLongitude(), location2.getLatitude()) * 3.6d;
        double d2 = time;
        Double.isNaN(d2);
        return a / d2 >= 1200.0d;
    }

    private boolean a(Location location, Location location2, Location location3) {
        return c.a(location.getLongitude(), location.getLatitude(), location2.getLongitude(), location2.getLatitude()) >= 1000.0d && c.a(location2.getLongitude(), location2.getLatitude(), location3.getLongitude(), location3.getLatitude()) >= 1000.0d && b.a(location, location2, location3) <= 10.0d;
    }

    private void a(int i, int i2) {
        if (i == 0 || i2 == 0) {
            return;
        }
        com.amap.location.sdk.c.a.d.a(((i - 1) * 6) + (i2 - 1) + 100120);
    }

    private void a(int i) {
        switch (i) {
            case 1:
                com.amap.location.sdk.c.a.d.a(100200);
                return;
            case 2:
                com.amap.location.sdk.c.a.d.a(100201);
                return;
            case 3:
                com.amap.location.sdk.c.a.d.a(100202);
                return;
            case 4:
                com.amap.location.sdk.c.a.d.a(100203);
                return;
            case 5:
                com.amap.location.sdk.c.a.d.a(100204);
                return;
            case 6:
                com.amap.location.sdk.c.a.d.a(100205);
                return;
            default:
                return;
        }
    }
}
