package com.amap.location.sdk.i;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

/* compiled from: UploadX509TrustManager.java */
/* loaded from: classes.dex */
public class j implements X509TrustManager {
    public boolean a;
    public File b;
    public final Object c = new Object();
    public CertificateFactory d;
    public Set<X509Certificate> e;

    public j(boolean z, File file) {
        this.a = false;
        this.a = z;
        if (z) {
            this.b = file;
            try {
                this.d = CertificateFactory.getInstance("X.509");
                this.e = a();
            } catch (CertificateException unused) {
                com.amap.location.common.e.a.d("CA", "Failed to obtain X.509 CertificateFactory");
            }
        }
    }

    private Set<X509Certificate> a() {
        synchronized (this.c) {
            if (this.e != null) {
                return this.e;
            }
            HashSet hashSet = new HashSet();
            if (this.b.isDirectory()) {
                for (String str : this.b.list()) {
                    X509Certificate a = a(str);
                    if (a != null) {
                        hashSet.add(a);
                    }
                }
            }
            this.e = hashSet;
            return hashSet;
        }
    }

    private X509TrustManager b() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore) null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length == 1 && (trustManagers[0] instanceof X509TrustManager)) {
                return (X509TrustManager) trustManagers[0];
            }
            com.amap.location.common.e.a.d("CA", "Unexpected default trust managers:" + Arrays.toString(trustManagers));
            return null;
        } catch (GeneralSecurityException e) {
            com.amap.location.common.e.a.d("CA", "Unexpected exception" + e.getMessage());
            return null;
        }
    }

    @Override // javax.net.ssl.X509TrustManager
    public void checkClientTrusted(X509Certificate[] x509CertificateArr, String str) throws CertificateException {
    }

    @Override // javax.net.ssl.X509TrustManager
    public void checkServerTrusted(X509Certificate[] x509CertificateArr, String str) throws CertificateException {
        if (this.a) {
            for (X509Certificate x509Certificate : x509CertificateArr) {
                Iterator<X509Certificate> it = this.e.iterator();
                while (it.hasNext()) {
                    try {
                        x509Certificate.verify(it.next().getPublicKey());
                        return;
                    } catch (Exception e) {
                        com.amap.location.common.e.a.d("CA", "Failed to verify with message" + e.getMessage());
                    }
                }
            }
            com.amap.location.common.e.a.d("CA", "Failed to verify with custom certs");
            X509TrustManager b = b();
            if (b != null) {
                b.checkServerTrusted(x509CertificateArr, str);
                return;
            }
            throw new CertificateException();
        }
    }

    @Override // javax.net.ssl.X509TrustManager
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    /* JADX WARN: Not initialized variable reg: 1, insn: 0x004f: MOVE (r0 I:??[OBJECT, ARRAY]) = (r1 I:??[OBJECT, ARRAY]), block:B:17:0x004f */
    private X509Certificate a(String str) {
        BufferedInputStream bufferedInputStream;
        Closeable closeable;
        Closeable closeable2 = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(this.b, str)));
                try {
                    X509Certificate x509Certificate = (X509Certificate) this.d.generateCertificate(bufferedInputStream);
                    com.amap.location.common.f.i.a((Closeable) bufferedInputStream);
                    return x509Certificate;
                } catch (IOException e) {
                    e = e;
                    com.amap.location.common.e.a.d("CA", "Failed to read certificate from " + str + "exception :" + e.getMessage());
                    com.amap.location.common.f.i.a((Closeable) bufferedInputStream);
                    return null;
                } catch (CertificateException e2) {
                    e = e2;
                    com.amap.location.common.e.a.d("CA", "Failed to read certificate from " + str + "exception :" + e.getMessage());
                    com.amap.location.common.f.i.a((Closeable) bufferedInputStream);
                    return null;
                }
            } catch (IOException e3) {
                e = e3;
                bufferedInputStream = null;
                com.amap.location.common.e.a.d("CA", "Failed to read certificate from " + str + "exception :" + e.getMessage());
                com.amap.location.common.f.i.a((Closeable) bufferedInputStream);
                return null;
            } catch (CertificateException e4) {
                e = e4;
                bufferedInputStream = null;
                com.amap.location.common.e.a.d("CA", "Failed to read certificate from " + str + "exception :" + e.getMessage());
                com.amap.location.common.f.i.a((Closeable) bufferedInputStream);
                return null;
            } catch (Throwable th) {
                th = th;
                com.amap.location.common.f.i.a(closeable2);
                throw th;
            }
        } catch (Throwable th2) {
            th = th2;
            closeable2 = closeable;
            com.amap.location.common.f.i.a(closeable2);
            throw th;
        }
    }
}
