package com.amap.location.uptunnel;

import android.content.Context;
import com.amap.location.uptunnel.a.a;
import com.amap.location.uptunnel.a.b;
import com.amap.location.uptunnel.core.c;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class UpTunnel {
    public static final int MAX_DATA_SIZE = 400000;
    public static final String TAG = "UpTunnel";
    public static final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();
    public static c mUpTunnelManager = null;
    public static boolean sUseHttps = true;
    public static boolean sUseTestNet;

    public static void addCount(int i) {
        try {
            mLock.readLock().lock();
            if (mUpTunnelManager != null) {
                mUpTunnelManager.a(i);
            }
        } finally {
            mLock.readLock().unlock();
        }
    }

    public static void destroy() {
        try {
            mLock.writeLock().lock();
            if (mUpTunnelManager != null) {
                mUpTunnelManager.a();
                mUpTunnelManager = null;
            }
        } finally {
            mLock.writeLock().unlock();
        }
    }

    public static void execCMD(JSONObject jSONObject) {
        a a;
        if (jSONObject != null) {
            try {
                if (jSONObject.length() == 0) {
                    return;
                }
                try {
                    mLock.readLock().lock();
                    if (mUpTunnelManager != null && (a = b.a(jSONObject)) != null) {
                        mUpTunnelManager.a(a);
                    }
                } catch (Exception e) {
                    com.amap.location.common.e.a.a(e);
                }
            } finally {
                mLock.readLock().unlock();
            }
        }
    }

    public static long getTableSize(int i) {
        try {
            mLock.writeLock().lock();
            if (mUpTunnelManager != null) {
                return mUpTunnelManager.b(i);
            }
            mLock.writeLock().unlock();
            return -1L;
        } finally {
            mLock.writeLock().unlock();
        }
    }

    public static void init(Context context, ConfigContainer configContainer) {
        try {
            mLock.writeLock().lock();
            if (mUpTunnelManager == null) {
                mUpTunnelManager = new c(context.getApplicationContext(), configContainer);
            }
        } finally {
            mLock.writeLock().unlock();
        }
    }

    public static void reportBlockData(int i, byte[] bArr) {
        if (bArr == null || bArr.length == 0 || bArr.length >= 400000) {
            return;
        }
        try {
            mLock.readLock().lock();
            if (mUpTunnelManager != null) {
                mUpTunnelManager.b(i, bArr);
            }
        } finally {
            mLock.readLock().unlock();
        }
    }

    public static void reportEvent(int i, byte[] bArr) {
        if (bArr == null || bArr.length == 0 || bArr.length >= 400000) {
            return;
        }
        try {
            mLock.readLock().lock();
            if (mUpTunnelManager != null) {
                mUpTunnelManager.a(i, bArr);
            }
        } finally {
            mLock.readLock().unlock();
        }
    }

    public static void reportKeyLog(int i, byte[] bArr) {
        if (bArr == null || bArr.length == 0 || bArr.length >= 400000) {
            return;
        }
        try {
            mLock.readLock().lock();
            if (mUpTunnelManager != null) {
                mUpTunnelManager.c(i, bArr);
            }
        } finally {
            mLock.readLock().unlock();
        }
    }

    public static void reportLog(int i, String str) {
        if (str == null || str.length() == 0 || str.length() * 2 >= 400000) {
            return;
        }
        try {
            mLock.readLock().lock();
            if (mUpTunnelManager != null) {
                mUpTunnelManager.a(i, str);
            }
        } finally {
            mLock.readLock().unlock();
        }
    }

    public static void execCMD(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return;
        }
        int length = jSONArray.length();
        for (int i = 0; i < length; i++) {
            try {
                execCMD(jSONArray.optJSONObject(i));
            } catch (Exception e) {
                com.amap.location.common.e.a.a(e);
                return;
            }
        }
    }
}
