package com.autonavi.amapauto;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import defpackage.aa0;
import defpackage.ee;
import defpackage.jp;
import defpackage.nq;
import defpackage.ps;
import defpackage.qs;
import defpackage.u90;

/* loaded from: classes.dex */
public class MapSurfaceView extends SurfaceView implements SurfaceHolder.Callback {
    public static final String TAG = "MapSurfaceView";
    public static int surfaceHeight = -1;
    public static int surfaceWidth = -1;
    public int mDisplayId;

    public MapSurfaceView(Context context) {
        super(context);
        this.mDisplayId = 0;
        initView();
    }

    public static int getMapSurfaceDpi(int i) {
        aa0.a(TAG, "getMapSurfaceDpi screenId:{?}", Integer.valueOf(i));
        if (i == 0) {
            int c = (int) u90.c(ee.A().f());
            aa0.a(TAG, "getMapSurfaceDpi:{?}", Integer.valueOf(c));
            return c;
        }
        if (qs.e().a().get(Integer.valueOf(i)) != null) {
            int i2 = qs.e().a().get(Integer.valueOf(i)).dpi;
            aa0.a(TAG, "getMapSurfaceDpi:{?}", Integer.valueOf(i2));
            return i2;
        }
        ps b = qs.e().b(i);
        if (b == null) {
            return 0;
        }
        aa0.a(TAG, "getMapSurfaceDpi:{?}", Integer.valueOf(b.f().h));
        return b.f().h;
    }

    public static int getMapSurfaceHeight(int i) {
        aa0.a(TAG, "getMapSurfaceHeight screenId:{?}", Integer.valueOf(i));
        if (i == 0) {
            aa0.a(TAG, "getMapSurfaceHeight :{?}", Integer.valueOf(surfaceHeight));
            return surfaceHeight;
        }
        if (qs.e().a().get(Integer.valueOf(i)) != null) {
            int i2 = qs.e().a().get(Integer.valueOf(i)).height;
            aa0.a(TAG, "getMapSurfaceHeight :{?}", Integer.valueOf(i2));
            return i2;
        }
        ps b = qs.e().b(i);
        if (b == null) {
            return 0;
        }
        aa0.a(TAG, "getMapSurfaceHeight:{?}", Integer.valueOf(b.f().g));
        return b.f().g;
    }

    public static int getMapSurfaceWidth(int i) {
        aa0.a(TAG, "getMapSurfaceWidth screenId:{?}", Integer.valueOf(i));
        if (i == 0) {
            aa0.a(TAG, "getMapSurfaceWidth:{?}", Integer.valueOf(surfaceWidth));
            return surfaceWidth;
        }
        if (qs.e().a().get(Integer.valueOf(i)) != null) {
            int i2 = qs.e().a().get(Integer.valueOf(i)).width;
            aa0.a(TAG, "getMapSurfaceWidth:{?}", Integer.valueOf(i2));
            return i2;
        }
        ps b = qs.e().b(i);
        if (b == null) {
            return 0;
        }
        aa0.a(TAG, "getMapSurfaceWidth:{?}", Integer.valueOf(b.f().f));
        return b.f().f;
    }

    private void initView() {
        SurfaceHolder holder = getHolder();
        holder.addCallback(this);
        if (jp.I().l(10050)) {
            holder.setFormat(-2);
        }
    }

    public static native void nativeSurfaceCreated(int i, int i2, Surface surface);

    public static native void nativeSurfaceDestroyed(int i, Surface surface);

    public static native void nativeSurfaceRedrawNeeded(int i, Surface surface);

    public static native void nativesurfaceChanged(int i, Surface surface, int i2, int i3, int i4);

    public int getDisplayId() {
        return this.mDisplayId;
    }

    @Override // android.view.SurfaceHolder.Callback
    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        aa0.a(TAG, "surfaceChanged getWidth:{?} getHeight:{?} ", Integer.valueOf(getWidth()), Integer.valueOf(getHeight()));
        Log.e(TAG, "surfaceChanged getWidth: " + getWidth() + " getHeight: " + getHeight());
        nq.e().b(2);
        surfaceWidth = getWidth();
        surfaceHeight = getHeight();
        nativesurfaceChanged(this.mDisplayId, surfaceHolder.getSurface(), i, i2, i3);
    }

    @Override // android.view.SurfaceHolder.Callback
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        aa0.a(TAG, "surfaceCreated getWidth:{?} getHeight:{?} ", Integer.valueOf(getWidth()), Integer.valueOf(getHeight()));
        Log.e(TAG, "surfaceCreated getWidth: " + getWidth() + " getHeight: " + getHeight());
        nq.e().b(1);
        surfaceWidth = getWidth();
        surfaceHeight = getHeight();
        nativeSurfaceCreated(this.mDisplayId, 1, surfaceHolder.getSurface());
    }

    @Override // android.view.SurfaceHolder.Callback
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        aa0.a(TAG, "surfaceDestroyed", new Object[0]);
        Log.e(TAG, "surfaceDestroyed");
        nq.e().b(3);
        surfaceWidth = -1;
        surfaceHeight = -1;
        nativeSurfaceDestroyed(this.mDisplayId, surfaceHolder.getSurface());
    }

    public MapSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mDisplayId = 0;
        initView();
    }

    public MapSurfaceView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.mDisplayId = 0;
        initView();
    }
}
