package com.autonavi.amapauto.alink;

import android.os.Build;
import com.autonavi.amapauto.alink.data.EventReceivedData;
import com.autonavi.amapauto.alink.data.ServerData;
import com.autonavi.amapauto.alink.data.ServiceNameData;
import com.autonavi.amapauto.jni.protocol.AndroidProtocolExe;
import defpackage.aa0;
import defpackage.oq;
import java.util.List;

/* loaded from: classes.dex */
public class AlinkClientManager {
    public static final String TAG = "AlinkClientManager";
    public IAlinkClient iAlinkClient;
    public boolean isInited;
    public IAlinkEventListener mAlinkEventListener;
    public IAlinkSencorListener mAlinkSencorListener;
    public IAlinkAVListener mAlinkVideoListener;
    public H264Decoder mH264Decoder;

    /* loaded from: classes.dex */
    public static class SingletonHolder {
        public static final AlinkClientManager INSTANCE = new AlinkClientManager();
    }

    public static final AlinkClientManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private void releaseDecoderHandler() {
        H264Decoder h264Decoder = this.mH264Decoder;
        if (h264Decoder != null) {
            h264Decoder.setAlinkAVListener(null);
            if (Build.VERSION.SDK_INT >= 21) {
                this.mH264Decoder.uninitDecoder();
            }
            this.mH264Decoder = null;
        }
    }

    public static void showToast(String str) {
    }

    public IAlinkClient getAlinkClient() {
        aa0.a(TAG, "getAlinkClient:{?}", this.iAlinkClient);
        return this.iAlinkClient;
    }

    public void initAlinkClient() {
        aa0.a(TAG, "initAlinkClient, isInited:{?}", Boolean.valueOf(this.isInited));
        showToast("初始化Alink服务");
        boolean a = oq.i().a(oq.C, false);
        aa0.a(TAG, "channel startup isSupportAlink={?}", Boolean.valueOf(a));
        if (a) {
            try {
                this.iAlinkClient = (IAlinkClient) Class.forName("com.autonavi.amapauto.business.SDKAlinkClientImpl").newInstance();
            } catch (Exception e) {
                aa0.a(TAG, "[initAlinkClient]", e, new Object[0]);
            } catch (NoClassDefFoundError e2) {
                aa0.a(TAG, "[initAlinkClient NoClassDefFoundError]", e2, new Object[0]);
            }
        }
        this.iAlinkClient.init();
        this.isInited = true;
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.mH264Decoder == null) {
                this.mH264Decoder = new H264Decoder();
            }
            this.mH264Decoder.initDecoder(0, 0);
        }
    }

    public void notifyProjectionStatus(int i) {
        aa0.a(TAG, "projectionResponseStatus:{?}", Integer.valueOf(i));
        showToast("接收Alink通知状态变化：" + i);
        AlinkNative.notifyState(i);
    }

    public int onAVDataReceived(byte[] bArr, int i, int i2, boolean z) {
        H264Decoder h264Decoder;
        aa0.a(TAG, "onAVDataReceived size{?}", Integer.valueOf(i));
        if (this.mAlinkVideoListener != null && (h264Decoder = this.mH264Decoder) != null && Build.VERSION.SDK_INT >= 21) {
            h264Decoder.addVideoBuffer(bArr, i, i2, z);
        }
        return 1;
    }

    public int onEventReceived(EventReceivedData eventReceivedData) {
        IAlinkEventListener iAlinkEventListener = this.mAlinkEventListener;
        if (iAlinkEventListener != null) {
            iAlinkEventListener.onEventReceived(eventReceivedData);
        }
        if (eventReceivedData != null) {
            aa0.a(TAG, "onEventReceived receivedData:{?}", eventReceivedData.toJsonString());
            int i = eventReceivedData.event;
            if (i == 0) {
                IAlinkAVListener iAlinkAVListener = this.mAlinkVideoListener;
                if (iAlinkAVListener != null) {
                    iAlinkAVListener.notifyCameraState(eventReceivedData.status);
                }
                if (eventReceivedData.status == 0) {
                    showToast("接收Alink返回wrapper连接成功");
                    AlinkNative.nativeNotifyRunningState(3);
                    AndroidProtocolExe.nativeCameraStatusNotify(0, 1);
                } else {
                    AlinkNative.nativeNotifyRunningState(4);
                    AndroidProtocolExe.nativeCameraStatusNotify(0, 0);
                }
            } else if (i != 1) {
                if (i == 11) {
                    ServiceNameData serviceNameData = eventReceivedData.names;
                    AlinkNative.onEventReceived(serviceNameData);
                    if (serviceNameData == null) {
                        showToast("接收Alink返回探索数据为空");
                        aa0.a(TAG, "serviceNameData is null", new Object[0]);
                    } else {
                        List<ServerData> list = serviceNameData.servers;
                        if (list != null && !list.isEmpty()) {
                            showToast("接收Alink返回探索数据个数：" + list.size());
                            aa0.a(TAG, "List<ServerData> size:{?}", Integer.valueOf(list.size()));
                        } else {
                            showToast("接收Alink返回探索数据为空");
                            aa0.a(TAG, "List<ServerData> is null", new Object[0]);
                        }
                    }
                }
            } else if (eventReceivedData.status == 0) {
                showToast("接收Alink返回video连接成功");
                AlinkNative.nativeNotifyRunningState(5);
            } else {
                AlinkNative.nativeNotifyRunningState(6);
            }
        }
        return 1;
    }

    public int onSensorDataReceived(int i, long j, double[] dArr, int i2) {
        IAlinkSencorListener iAlinkSencorListener = this.mAlinkSencorListener;
        if (iAlinkSencorListener == null) {
            return 1;
        }
        int onSensorDataReceived = iAlinkSencorListener.onSensorDataReceived(i, j, dArr, i2);
        aa0.a(TAG, "onSensorDataReceived IAlinkSencorListener result{?}", Integer.valueOf(onSensorDataReceived));
        return onSensorDataReceived;
    }

    public void registerEventListener(IAlinkEventListener iAlinkEventListener) {
        this.mAlinkEventListener = iAlinkEventListener;
    }

    public void registerSensorListener(IAlinkSencorListener iAlinkSencorListener) {
        this.mAlinkSencorListener = iAlinkSencorListener;
    }

    public void registerVideoListener(IAlinkAVListener iAlinkAVListener) {
        aa0.a(TAG, "registerVideoListener:{?}", this.mAlinkVideoListener);
        this.mAlinkVideoListener = iAlinkAVListener;
        H264Decoder h264Decoder = this.mH264Decoder;
        if (h264Decoder != null) {
            h264Decoder.setAlinkAVListener(iAlinkAVListener);
        }
    }

    public void uninit() {
        aa0.a(TAG, "uninit, isInited:{?}", Boolean.valueOf(this.isInited));
        this.iAlinkClient.uninit();
        this.isInited = false;
        this.mAlinkEventListener = null;
        this.mAlinkVideoListener = null;
        this.mAlinkSencorListener = null;
        releaseDecoderHandler();
        this.iAlinkClient = new EmptyAlientClientImpl();
    }

    public AlinkClientManager() {
        this.iAlinkClient = new EmptyAlientClientImpl();
        this.isInited = false;
    }
}
