package com.autonavi.amapauto.alink;

import com.autonavi.amapauto.alink.data.ServiceNameData;
import com.autonavi.amapauto.utils.FileUtils;
import defpackage.aa0;
import defpackage.da0;
import java.io.File;

/* loaded from: classes.dex */
public class AlinkNative {
    public static final String ALINK_LOG_DIRNAME = "Alink";
    public static int mAlinkState = 1;

    public static void asyncProbe(String str) {
        aa0.a("AlinkNative", "asyncProbe serviceType = {?}", str);
        AlinkClientManager.getInstance().getAlinkClient().asyncProbe(str);
    }

    public static boolean createDirPath(String str) {
        File file = new File(str);
        boolean z = false;
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            File file2 = new File(file.getAbsolutePath() + System.currentTimeMillis());
            file.renameTo(file2);
            if (file2.delete()) {
                FileUtils.createFile(file, false);
                z = true;
            }
            return z;
        }
        FileUtils.createFile(file, false);
        return true;
    }

    public static String getAlinkLogPath() {
        return da0.c() + ALINK_LOG_DIRNAME;
    }

    public static int getAlinkState() {
        return mAlinkState;
    }

    public static native void nativeNotifyRunningState(int i);

    public static void notifyState(int i) {
        mAlinkState = i;
        nativeNotifyRunningState(i);
    }

    public static native int onEventReceived(ServiceNameData serviceNameData);

    public static void sendCommandToAlink(int i) {
        aa0.a("AlinkNative", "sendCommandToAlink command = {?}", Integer.valueOf(i));
        if (i == 0) {
            AlinkClientManager.getInstance().initAlinkClient();
            return;
        }
        if (i == 1) {
            AlinkClientManager.getInstance().getAlinkClient().updateProjectionStatus(0);
            return;
        }
        if (i == 2) {
            AlinkClientManager.getInstance().getAlinkClient().updateProjectionStatus(1);
            return;
        }
        if (i == 3) {
            AlinkClientManager.getInstance().uninit();
        } else if (i == 4) {
            AlinkClientManager.getInstance().getAlinkClient().connectCamera();
        } else {
            if (i != 5) {
                return;
            }
            AlinkClientManager.getInstance().getAlinkClient().disConnectCamera();
        }
    }

    public static void sendConnect(String str, boolean z) {
        aa0.a("AlinkNative", "sendConnect deviceId={?},isConnect={?}", str, Boolean.valueOf(z));
        AlinkClientManager.getInstance().getAlinkClient().sendConnect(str, z);
    }

    public static void startWithWifiP2P(String str) {
        aa0.a("AlinkNative", "startWithWifiP2P macAddress={?}", str);
        AlinkClientManager.getInstance().getAlinkClient().startWithWifiP2P(str);
    }
}
