package com.autonavi.amapauto.alink;

import android.annotation.SuppressLint;
import android.media.Image;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Build;
import android.view.Surface;
import defpackage.aa0;
import defpackage.ab0;
import defpackage.bb0;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/* loaded from: classes.dex */
public class H264Decoder {
    public static final String DECODER_H264 = "video/avc";
    public static final int MSG_DECODE = 136;
    public static final String TAG = "DecoderHandler";
    public volatile boolean mAddFrameOpen;
    public IAlinkAVListener mAvListener;
    public MediaCodec.BufferInfo mBufferinfo;
    public final Condition mCondition;
    public MediaCodec mDecoder;
    public InputDecoderRunnable mInputDecoderRunnable;
    public volatile boolean mInputStart;
    public final Lock mLock;
    public OutputDecoderRunnable mOutputDecoderRunnable;
    public volatile boolean mOutputStart;
    public volatile boolean mUninitDecoder;
    public int videoWidth = 854;
    public int videoHeight = 480;
    public LinkedList<VideoFrame> mVideoFrames = new LinkedList<>();

    /* loaded from: classes.dex */
    public static class HandlerParam {
        public boolean marker;
        public int size;
        public byte[] srcBuffer;
        public int timeStamp;
    }

    /* loaded from: classes.dex */
    public class InputDecoderRunnable implements Runnable {
        public InputDecoderRunnable() {
        }

        @Override // java.lang.Runnable
        public void run() {
            int dequeueInputBuffer;
            aa0.a(H264Decoder.TAG, "InputDecoderRunnable mInputStart:{?} ", Boolean.valueOf(H264Decoder.this.mInputStart));
            while (H264Decoder.this.mInputStart) {
                if (Build.VERSION.SDK_INT >= 16) {
                    aa0.a(H264Decoder.TAG, "start onInputBufferAvailable: mVideoFrames.size()=" + H264Decoder.this.mVideoFrames.size(), new Object[0]);
                    if (H264Decoder.this.mVideoFrames.size() < 1) {
                        H264Decoder.this.mLock.lock();
                        try {
                            try {
                                H264Decoder.this.mCondition.await();
                            } catch (InterruptedException e) {
                                aa0.a(H264Decoder.TAG, "InputDecoderRunnable mCondition.await Exception : ", e, new Object[0]);
                            }
                        } finally {
                            H264Decoder.this.mLock.unlock();
                        }
                    }
                    aa0.a(H264Decoder.TAG, "onInputBufferAvailable: mVideoFrames.size()=" + H264Decoder.this.mVideoFrames.size(), new Object[0]);
                    try {
                        dequeueInputBuffer = H264Decoder.this.mDecoder.dequeueInputBuffer(-1L);
                    } catch (Exception e2) {
                        aa0.a(H264Decoder.TAG, "InputDecoderRunnable  Exception : ", e2, new Object[0]);
                    }
                    if (dequeueInputBuffer >= 0) {
                        aa0.a(H264Decoder.TAG, "before queueInputBuffer", new Object[0]);
                        synchronized (H264Decoder.this.mVideoFrames) {
                            if (H264Decoder.this.mVideoFrames.size() > 0) {
                                VideoFrame videoFrame = (VideoFrame) H264Decoder.this.mVideoFrames.pollFirst();
                                ByteBuffer byteBuffer = H264Decoder.this.mDecoder.getInputBuffers()[dequeueInputBuffer];
                                if (byteBuffer != null) {
                                    byteBuffer.clear();
                                    if (videoFrame != null) {
                                        byteBuffer.put(videoFrame.data, 0, videoFrame.data.length);
                                        H264Decoder.this.mDecoder.queueInputBuffer(dequeueInputBuffer, 0, videoFrame.data.length, System.currentTimeMillis(), 0);
                                    } else {
                                        aa0.a(H264Decoder.TAG, "frame is null!", new Object[0]);
                                    }
                                } else {
                                    aa0.a(H264Decoder.TAG, "inputBuffer is null!", new Object[0]);
                                }
                            }
                        }
                        if (!H264Decoder.this.mOutputStart && !H264Decoder.this.mUninitDecoder) {
                            H264Decoder.this.mOutputStart = true;
                            if (H264Decoder.this.mOutputDecoderRunnable == null) {
                                H264Decoder h264Decoder = H264Decoder.this;
                                h264Decoder.mOutputDecoderRunnable = new OutputDecoderRunnable();
                            }
                            bb0.a(ab0.DECODER_HANDLER_OUT).execute(H264Decoder.this.mOutputDecoderRunnable);
                        }
                    } else {
                        aa0.a(H264Decoder.TAG, "No input buffer and inputBufferIndex ={?}", Integer.valueOf(dequeueInputBuffer));
                        return;
                    }
                }
            }
        }
    }

    /* loaded from: classes.dex */
    public class OutputDecoderRunnable implements Runnable {
        public OutputDecoderRunnable() {
        }

        @Override // java.lang.Runnable
        @SuppressLint({"WrongConstant"})
        public void run() {
            aa0.a(H264Decoder.TAG, "OutputDecoderRunnable mOutputStart:{?} ", Boolean.valueOf(H264Decoder.this.mOutputStart));
            while (H264Decoder.this.mOutputStart) {
                H264Decoder.this.getDecodeData();
            }
        }
    }

    /* loaded from: classes.dex */
    public static class VideoFrame {
        public byte[] data;
        public int videoSize;

        public VideoFrame() {
        }
    }

    public H264Decoder() {
        ReentrantLock reentrantLock = new ReentrantLock();
        this.mLock = reentrantLock;
        this.mCondition = reentrantLock.newCondition();
        this.mInputStart = true;
        this.mOutputStart = false;
        this.mUninitDecoder = false;
        this.mAddFrameOpen = true;
    }

    /* JADX INFO: Access modifiers changed from: private */
    @SuppressLint({"WrongConstant"})
    public void getDecodeData() {
        try {
            if (this.mBufferinfo == null) {
                this.mBufferinfo = new MediaCodec.BufferInfo();
            }
            if (this.mDecoder == null) {
                aa0.a(TAG, "mDecoder is null!", new Object[0]);
                return;
            }
            int dequeueOutputBuffer = this.mDecoder.dequeueOutputBuffer(this.mBufferinfo, -1L);
            if (dequeueOutputBuffer >= 0) {
                aa0.a(TAG, "dequeueOutputBuffer indexOutputbuffer:{?} ", Integer.valueOf(dequeueOutputBuffer));
                if (dequeueOutputBuffer == -3) {
                    aa0.a(TAG, " buffer changed : " + dequeueOutputBuffer, new Object[0]);
                    return;
                }
                if (dequeueOutputBuffer == -2) {
                    aa0.a(TAG, " format changed : " + dequeueOutputBuffer, new Object[0]);
                    return;
                }
                if (dequeueOutputBuffer != -1) {
                    Image outputImage = this.mDecoder.getOutputImage(dequeueOutputBuffer);
                    if (outputImage != null) {
                        if (this.mAvListener != null) {
                            aa0.a(TAG, "dequeueOutputBuffer getFormat: " + outputImage.getFormat(), new Object[0]);
                            this.mAvListener.onAVDataReceived(outputImage);
                        }
                        outputImage.close();
                    }
                    this.mDecoder.releaseOutputBuffer(dequeueOutputBuffer, false);
                    return;
                }
                aa0.a(TAG, " try again later : " + dequeueOutputBuffer, new Object[0]);
            }
        } catch (Exception e) {
            aa0.a(TAG, "OutputDecoderRunnable  Exception : ", e, new Object[0]);
        }
    }

    public static int kmpMatch(byte[] bArr, int i, int i2) {
        byte[] bArr2 = {0, 0, 0, 1};
        int[] iArr = {0, 1, 2, 0};
        int i3 = 0;
        while (i < i2) {
            while (i3 > 0 && bArr[i] != bArr2[i3]) {
                i3 = iArr[i3 - 1];
            }
            if (bArr[i] == bArr2[i3] && (i3 = i3 + 1) == 4) {
                return i - (i3 - 1);
            }
            i++;
        }
        return -1;
    }

    @SuppressLint({"WrongConstant"})
    public void addVideoBuffer(byte[] bArr, int i, int i2, boolean z) {
        aa0.a(TAG, "decodeH264Loop start size={?},timeStamp={?}", Integer.valueOf(i), Integer.valueOf(i2));
        if (bArr == null || i == 0) {
            return;
        }
        if (!this.mAddFrameOpen) {
            aa0.a(TAG, "mAddFrameOpen is false", new Object[0]);
            return;
        }
        VideoFrame videoFrame = new VideoFrame();
        byte[] bArr2 = new byte[i];
        videoFrame.data = bArr2;
        System.arraycopy(bArr, 0, bArr2, 0, i);
        videoFrame.videoSize = i;
        synchronized (this.mVideoFrames) {
            this.mVideoFrames.addLast(videoFrame);
        }
        this.mLock.lock();
        try {
            this.mCondition.signal();
        } finally {
            this.mLock.unlock();
        }
    }

    public void initDecoder(int i, int i2) {
        aa0.a(TAG, "initDecoder", new Object[0]);
        try {
            this.mDecoder = MediaCodec.createDecoderByType(DECODER_H264);
        } catch (IOException e) {
            aa0.a(TAG, "initDecoder Exception : ", e, new Object[0]);
        }
        if (i > 0 && i2 > 0) {
            this.videoWidth = i;
            this.videoHeight = i2;
        }
        if (this.mDecoder == null) {
            aa0.a(TAG, "mDecoder is null!", new Object[0]);
            return;
        }
        MediaFormat createVideoFormat = MediaFormat.createVideoFormat(DECODER_H264, this.videoWidth, this.videoHeight);
        createVideoFormat.setInteger("bitrate-mode", 1);
        createVideoFormat.setInteger("complexity", 2);
        this.mDecoder.configure(createVideoFormat, (Surface) null, (MediaCrypto) null, 0);
        this.mDecoder.start();
        this.mInputStart = true;
        if (this.mInputDecoderRunnable == null) {
            this.mInputDecoderRunnable = new InputDecoderRunnable();
        }
        bb0.a(ab0.DECODER_HANDLER).execute(this.mInputDecoderRunnable);
    }

    public void setAlinkAVListener(IAlinkAVListener iAlinkAVListener) {
        this.mAvListener = iAlinkAVListener;
    }

    public void uninitDecoder() {
        aa0.a(TAG, "uninitDecoder", new Object[0]);
        this.mUninitDecoder = true;
        this.mInputStart = false;
        this.mOutputStart = false;
        this.mAddFrameOpen = false;
        bb0.b(ab0.DECODER_HANDLER);
        bb0.b(ab0.DECODER_HANDLER_OUT);
        MediaCodec mediaCodec = this.mDecoder;
        if (mediaCodec != null) {
            mediaCodec.stop();
            this.mDecoder.release();
        }
        LinkedList<VideoFrame> linkedList = this.mVideoFrames;
        if (linkedList != null) {
            synchronized (linkedList) {
                this.mVideoFrames.clear();
            }
        }
    }
}
