package com.autonavi.amapauto.alink.test;

import android.media.Image;
import com.autonavi.amapauto.alink.AlinkClientManager;
import com.autonavi.amapauto.alink.AlinkNative;
import com.autonavi.amapauto.alink.IAlinkAVListener;
import com.autonavi.amapauto.alink.IAlinkEventListener;
import com.autonavi.amapauto.alink.IAlinkSencorListener;
import com.autonavi.amapauto.alink.data.EventReceivedData;
import defpackage.aa0;
import defpackage.ee;
import defpackage.u90;

/* loaded from: classes.dex */
public class AlinkTest {
    public static final String TAG = "AlinkTest";
    public int codecHeight;
    public int codecWidth;
    public IAlinkAVListener iAlinkAVListener;
    public IAlinkEventListener iAlinkEventListener;
    public IAlinkSencorListener iAlinkSencorListener;

    /* loaded from: classes.dex */
    public static class SingletonHolder {
        public static final AlinkTest INSTANCE = new AlinkTest();
    }

    public static final AlinkTest getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void asyncProbe() {
        AlinkClientManager.getInstance().getAlinkClient().asyncProbe("*");
    }

    public void connectProjection(int i) {
        AlinkNative.sendConnect(i + "", false);
    }

    public void init() {
        aa0.a(TAG, "init", new Object[0]);
        AlinkClientManager.getInstance().initAlinkClient();
        AlinkClientManager.getInstance().registerSensorListener(this.iAlinkSencorListener);
        AlinkClientManager.getInstance().registerSensorListener(this.iAlinkSencorListener);
        AlinkClientManager.getInstance().registerEventListener(this.iAlinkEventListener);
    }

    public void openCamera(int i) {
        this.codecWidth = u90.d(ee.A().f()).j();
        this.codecHeight = u90.d(ee.A().f()).i();
        aa0.a(TAG, "openCamera serviceId:{?} codecWidth:{?} codecHeight:{?}", Integer.valueOf(i), Integer.valueOf(this.codecWidth), Integer.valueOf(this.codecHeight));
        AlinkClientManager.getInstance().getAlinkClient().openCamera(i, this.codecWidth, this.codecHeight);
    }

    public void startProjection() {
        AlinkClientManager.getInstance().getAlinkClient().updateProjectionStatus(0);
    }

    public AlinkTest() {
        this.iAlinkAVListener = new IAlinkAVListener() { // from class: com.autonavi.amapauto.alink.test.AlinkTest.1
            @Override // com.autonavi.amapauto.alink.IAlinkAVListener
            public int notifyCameraState(int i) {
                aa0.a(AlinkTest.TAG, "notifyCameraState status:{?}", Integer.valueOf(i));
                return 0;
            }

            @Override // com.autonavi.amapauto.alink.IAlinkAVListener
            public int onAVDataReceived(Image image) {
                aa0.a(AlinkTest.TAG, "onAVDataReceived", new Object[0]);
                return 0;
            }
        };
        this.iAlinkSencorListener = new IAlinkSencorListener() { // from class: com.autonavi.amapauto.alink.test.AlinkTest.2
            @Override // com.autonavi.amapauto.alink.IAlinkSencorListener
            public int onSensorDataReceived(int i, long j, double[] dArr, int i2) {
                aa0.a(AlinkTest.TAG, "onSensorDataReceived category:{?}", Integer.valueOf(i));
                return 0;
            }
        };
        this.iAlinkEventListener = new IAlinkEventListener() { // from class: com.autonavi.amapauto.alink.test.AlinkTest.3
            @Override // com.autonavi.amapauto.alink.IAlinkEventListener
            public void onEventReceived(EventReceivedData eventReceivedData) {
                aa0.a(AlinkTest.TAG, "onSensorDataReceived receivedData:{?}", eventReceivedData.toJsonString());
            }
        };
    }
}
