package com.autonavi.amapauto.ar.camera;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import androidx.annotation.Keep;
import com.autonavi.amapauto.ar.camera.model.ArCameraBaseInfo;
import com.autonavi.amapauto.ar.camera.model.ArPerfInfo;
import com.autonavi.amapauto.ar.camera.model.ImageInfo;
import com.autonavi.amapauto.socol.SocolNative;
import defpackage.aa0;
import defpackage.cf;
import defpackage.ef;
import defpackage.jp;
import defpackage.oq;
import defpackage.ze;
import java.util.ArrayList;
import java.util.Iterator;

@Keep
/* loaded from: classes.dex */
public class CameraManager {
    public static final int AR_STATE_STARTED = 1;
    public static final int AR_STATE_STOPED = 0;
    public static final int CAMERA_FACING_BACK = 1;
    public static final int CAMERA_FACING_EXTERNAL = 2;
    public static final int CAMERA_FACING_FRONT = 0;
    public static final String MODEL_P1 = "P1";
    public static final CameraManager ourInstance = new CameraManager();
    public ef cameraImpl;
    public ArCameraParam mCameraParam;
    public Handler mSocolDataHandler;
    public HandlerThread mSocolDataThread;
    public final String TAG = "CameraManager";
    public int mArState = 0;

    /* loaded from: classes.dex */
    public class a implements Runnable {
        public final /* synthetic */ ImageInfo a;

        public a(ImageInfo imageInfo) {
            this.a = imageInfo;
        }

        @Override // java.lang.Runnable
        public void run() {
            byte[] bArr;
            byte[] bArr2;
            byte[] bArr3 = null;
            if (this.a.data.size() > 0) {
                bArr = this.a.data.get(0) != null ? this.a.data.get(0).data : new byte[0];
            } else {
                bArr = null;
            }
            if (this.a.data.size() > 1) {
                bArr2 = this.a.data.get(1) != null ? this.a.data.get(1).data : new byte[0];
            } else {
                bArr2 = null;
            }
            if (this.a.data.size() > 2) {
                bArr3 = this.a.data.get(2) != null ? this.a.data.get(2).data : new byte[0];
            }
            ImageInfo imageInfo = this.a;
            SocolNative.dataTransmission(bArr, bArr2, bArr3, imageInfo.width, imageInfo.height, CameraManager.this.mCameraParam.format);
        }
    }

    public CameraManager() {
        try {
            aa0.a("CameraManager", "product:" + Build.PRODUCT + ", model:" + Build.MODEL + ", device:" + Build.DEVICE + ", brand:" + Build.BRAND, new Object[0]);
            boolean a2 = oq.i().a(oq.C, false);
            aa0.a("CameraManager", "isSupportAlink={?}", Boolean.valueOf(a2));
            if (a2) {
                aa0.a("CameraManager", "use AlinkCamera", new Object[0]);
                this.cameraImpl = new ze();
            } else if (Build.MODEL.equals(MODEL_P1)) {
                aa0.a("CameraManager", "use P1", new Object[0]);
                this.cameraImpl = new cf();
            } else {
                this.cameraImpl = jp.I().s();
            }
        } catch (Throwable th) {
            Log.i("CameraManager", Log.getStackTraceString(th));
        }
    }

    public static CameraManager getInstance() {
        return ourInstance;
    }

    public static void notifyArPerfInfo(ArPerfInfo arPerfInfo) {
    }

    public boolean closeCamera() {
        if (this.cameraImpl == null) {
            return false;
        }
        HandlerThread handlerThread = this.mSocolDataThread;
        if (handlerThread != null) {
            handlerThread.quit();
            this.mSocolDataThread = null;
            this.mSocolDataHandler = null;
        }
        return this.cameraImpl.closeCamera();
    }

    public ArCameraBaseInfo getArCameraBaseInfo() {
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            return efVar.a();
        }
        return null;
    }

    public ArPerfInfo getArPerfInfo() {
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            return efVar.f();
        }
        return null;
    }

    public int getArState() {
        return this.mArState;
    }

    public int getCameraSupportFormat(int[] iArr) {
        ArrayList<Integer> arrayList = new ArrayList<>();
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            efVar.a(arrayList);
        }
        int i = 0;
        if (arrayList.size() > 0 && iArr != null) {
            Iterator<Integer> it = arrayList.iterator();
            while (it.hasNext()) {
                int intValue = it.next().intValue();
                if (i < iArr.length) {
                    iArr[i] = intValue;
                    i++;
                }
            }
        }
        return i;
    }

    public boolean init(ArCameraParam arCameraParam) {
        aa0.a("CameraManager", "init:{?} ", arCameraParam);
        ef efVar = this.cameraImpl;
        if (efVar == null) {
            return false;
        }
        this.mCameraParam = arCameraParam;
        return efVar.a(arCameraParam);
    }

    public boolean isCameraOpened() {
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            return efVar.c();
        }
        return false;
    }

    public boolean openCamera(int i) {
        aa0.a("CameraManager", "openCamera", new Object[0]);
        if (this.cameraImpl == null) {
            return false;
        }
        if (this.mSocolDataThread == null) {
            HandlerThread handlerThread = new HandlerThread("SocolDataThread");
            this.mSocolDataThread = handlerThread;
            handlerThread.start();
        }
        if (this.mSocolDataHandler == null) {
            this.mSocolDataHandler = new Handler(this.mSocolDataThread.getLooper());
        }
        return this.cameraImpl.b(i);
    }

    public void releaseImageInfo() {
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            efVar.b();
        }
    }

    public ImageInfo requestCameraData() {
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            ImageInfo e = efVar.e();
            if (e != null) {
                Handler handler = this.mSocolDataHandler;
                if (handler != null) {
                    handler.post(new a(e));
                }
            } else {
                aa0.a("CameraManager", "imageInfo must not be null", new Object[0]);
            }
            return e;
        }
        aa0.a("CameraManager", "cameraImpl must not be null", new Object[0]);
        return new ImageInfo();
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            efVar.a(surfaceTexture);
        }
    }

    public void startAR() {
        this.mArState = 1;
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            efVar.a(1);
        }
        SocolNative.notifyArStateChange();
    }

    public void stopAR() {
        this.mArState = 0;
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            efVar.a(0);
        }
        SocolNative.notifyArStateChange();
    }

    public boolean unInit() {
        ef efVar = this.cameraImpl;
        if (efVar != null) {
            return efVar.d();
        }
        return false;
    }
}
