package com.autonavi.amapauto.ar.camera;

import android.util.Log;
import androidx.annotation.Keep;
import com.autonavi.amapauto.ar.camera.model.ArCameraBaseInfo;
import com.autonavi.amapauto.ar.camera.model.ArPerfInfo;
import com.autonavi.amapauto.ar.camera.model.ImageInfo;
import defpackage.aa0;

@Keep
/* loaded from: classes.dex */
public class CameraManagerNative {
    public static final String TAG = "CameraManagerNative";

    public static boolean closeCamera() {
        boolean z;
        try {
            aa0.a(TAG, "closeCamera begin: ", new Object[0]);
            z = CameraManager.getInstance().closeCamera();
            try {
                aa0.a(TAG, "closeCamera end isSuc =  " + z, new Object[0]);
            } catch (Exception e) {
                e = e;
                aa0.a(TAG, "closeCamera stack = {?}", Log.getStackTraceString(e));
                return z;
            }
        } catch (Exception e2) {
            e = e2;
            z = false;
        }
        return z;
    }

    public static ArCameraBaseInfo getArCameraBaseInfo() {
        aa0.a(TAG, "getArCameraBaseInfo", new Object[0]);
        try {
            return CameraManager.getInstance().getArCameraBaseInfo();
        } catch (Exception e) {
            aa0.a(TAG, "getArCameraBaseInfo stack = {?}", Log.getStackTraceString(e));
            return null;
        }
    }

    public static ArPerfInfo getArPerfInfo() {
        aa0.a(TAG, "getArPerfInfo", new Object[0]);
        try {
            return CameraManager.getInstance().getArPerfInfo();
        } catch (Exception e) {
            aa0.a(TAG, "getArPerfInfo stack = {?}", Log.getStackTraceString(e));
            return null;
        }
    }

    public static int getCameraSupportFormat(int[] iArr) {
        aa0.a(TAG, "getCameraSupportFormat", new Object[0]);
        try {
            return CameraManager.getInstance().getCameraSupportFormat(iArr);
        } catch (Exception e) {
            aa0.a(TAG, "getCameraSupportFormat stack = {?}", Log.getStackTraceString(e));
            return 0;
        }
    }

    public static boolean initArCamera(ArCameraParam arCameraParam) {
        boolean z;
        try {
            aa0.a(TAG, "init begin: " + arCameraParam.toString(), new Object[0]);
            z = CameraManager.getInstance().init(arCameraParam);
            try {
                aa0.a(TAG, "init end ret = " + z, new Object[0]);
            } catch (Exception e) {
                e = e;
                e.printStackTrace();
                aa0.a(TAG, "initArCamera: stack = {?}", Log.getStackTraceString(e));
                return z;
            }
        } catch (Exception e2) {
            e = e2;
            z = false;
        }
        return z;
    }

    public static boolean isCameraOpened() {
        boolean z;
        try {
            aa0.a(TAG, "isCameraOpened begin: ", new Object[0]);
            z = CameraManager.getInstance().isCameraOpened();
            try {
                aa0.a(TAG, "isCameraOpened end:isOpen =  " + z, new Object[0]);
            } catch (Exception e) {
                e = e;
                aa0.a(TAG, "isCameraOpened stack = {?}", Log.getStackTraceString(e));
                e.printStackTrace();
                return z;
            }
        } catch (Exception e2) {
            e = e2;
            z = false;
        }
        return z;
    }

    public static native void nativeNotifyArCameraBaseInfo(ArCameraBaseInfo arCameraBaseInfo);

    public static native void notifyCameraClosed();

    public static native void notifyCameraRestartBegin();

    public static native void notifyCameraRestartEnd();

    public static native void notifyPerfInfo(ArPerfInfo arPerfInfo);

    public static boolean openCamera(int i) {
        boolean z;
        try {
            aa0.a(TAG, "openCamera begin: ", new Object[0]);
            z = CameraManager.getInstance().openCamera(i);
            try {
                aa0.a(TAG, "openCamera end: isSuc = " + z, new Object[0]);
            } catch (Exception e) {
                e = e;
                aa0.a(TAG, "openCamera: stack = {?}", Log.getStackTraceString(e));
                return z;
            }
        } catch (Exception e2) {
            e = e2;
            z = false;
        }
        return z;
    }

    public static void releaseImageInfo() {
        aa0.a(TAG, "releaseImageInfo", new Object[0]);
        try {
            CameraManager.getInstance().releaseImageInfo();
        } catch (Exception e) {
            aa0.a(TAG, "releaseImageInfo stack = {?}", Log.getStackTraceString(e));
        }
    }

    public static ImageInfo requestCameraData() {
        aa0.a(TAG, "requestCamera begin:", new Object[0]);
        ImageInfo imageInfo = null;
        try {
            imageInfo = CameraManager.getInstance().requestCameraData();
            if (imageInfo != null) {
                aa0.a(TAG, "requestCamera end:cameraData =" + imageInfo, new Object[0]);
            } else {
                aa0.a(TAG, "requestCamera end, get null cameraData", new Object[0]);
            }
        } catch (Exception e) {
            aa0.a(TAG, "requestCameraData: stack = {?}", Log.getStackTraceString(e));
        }
        return imageInfo;
    }

    public static void startAR() {
        aa0.a(TAG, "startAR", new Object[0]);
        try {
            CameraManager.getInstance().startAR();
        } catch (Exception e) {
            aa0.a(TAG, "startAR stack = {?}", Log.getStackTraceString(e));
        }
    }

    public static void stopAR() {
        aa0.a(TAG, "stopAR", new Object[0]);
        try {
            CameraManager.getInstance().stopAR();
        } catch (Exception e) {
            aa0.a(TAG, "stopAR stack = {?}", Log.getStackTraceString(e));
        }
    }

    public static boolean unInit() {
        boolean z;
        try {
            aa0.a(TAG, "unInit begin: ", new Object[0]);
            z = CameraManager.getInstance().unInit();
            try {
                aa0.a(TAG, "unInit end isSuc = " + z, new Object[0]);
            } catch (Exception e) {
                e = e;
                aa0.a(TAG, "unInit stack = {?}", Log.getStackTraceString(e));
                return z;
            }
        } catch (Exception e2) {
            e = e2;
            z = false;
        }
        return z;
    }
}
